/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.javascript2.editor.doc.spi.DocParameter;
import org.netbeans.modules.javascript2.editor.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.editor.hints.Bundle;
import org.netbeans.modules.javascript2.editor.hints.IncorrectDocumentationRule;
import org.netbeans.modules.javascript2.editor.hints.JsAstRule;
import org.netbeans.modules.javascript2.editor.hints.JsHintsProvider;
import org.netbeans.modules.javascript2.editor.hints.UndocumentedParameterRule;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.model.impl.PathNodeVisitor;

public class JsFunctionDocumentationRule
extends JsAstRule {
    public static final String JSDOCUMENTATION_OPTION_HINTS = "jsdocumentation.option.hints";

    @Override
    void computeHints(JsHintsProvider.JsRuleContext context, List<Hint> hints, int offset, HintsProvider.HintsManager manager) {
        Map allHints = manager.getHints();
        List conventionHints = (List)allHints.get(JSDOCUMENTATION_OPTION_HINTS);
        Rule.AstRule undocumentedParameterRule = null;
        Rule.AstRule incorrectDocumentationRule = null;
        if (conventionHints != null) {
            for (Rule.AstRule astRule : conventionHints) {
                if (!manager.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                if (astRule instanceof UndocumentedParameterRule) {
                    undocumentedParameterRule = astRule;
                    continue;
                }
                if (!(astRule instanceof IncorrectDocumentationRule)) continue;
                incorrectDocumentationRule = astRule;
            }
        }
        JsFunctionDocumentationVisitor conventionVisitor = new JsFunctionDocumentationVisitor((Rule)undocumentedParameterRule, (Rule)incorrectDocumentationRule);
        conventionVisitor.process(context, hints);
    }

    @Override
    public boolean appliesTo(RuleContext context) {
        return context instanceof JsHintsProvider.JsRuleContext;
    }

    @Override
    public boolean showInTasklist() {
        return true;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    public Set<?> getKinds() {
        return Collections.singleton(JSDOCUMENTATION_OPTION_HINTS);
    }

    public String getId() {
        return "jsdocumentation.hint";
    }

    public String getDescription() {
        return Bundle.JsDocumentationHintDesc();
    }

    public String getDisplayName() {
        return Bundle.JsDocumentationHintDisplayName();
    }

    private static final class JsFunctionDocumentationVisitor
    extends PathNodeVisitor {
        private List<Hint> hints;
        private JsHintsProvider.JsRuleContext context;
        private final Rule undocumentedParameterRule;
        private final Rule incorrectDocumentationRule;

        private JsFunctionDocumentationVisitor(Rule undocumentedParameterRule, Rule incorrectDocumentationRule) {
            this.incorrectDocumentationRule = incorrectDocumentationRule;
            this.undocumentedParameterRule = undocumentedParameterRule;
        }

        public void process(JsHintsProvider.JsRuleContext context, List<Hint> hints) {
            this.hints = hints;
            this.context = context;
            FunctionNode root = context.getJsParserResult().getRoot();
            if (root != null) {
                context.getJsParserResult().getRoot().accept((NodeVisitor)this);
            }
        }

        @Override
        public Node enter(FunctionNode fn) {
            String superfluousParameters;
            JsDocumentationHolder docHolder = this.context.getJsParserResult().getDocumentationHolder();
            if (fn.getParent() == null || docHolder.getCommentForOffset(fn.getStart(), docHolder.getCommentBlocks()) == null) {
                return super.enter(fn);
            }
            List<DocParameter> docParameters = docHolder.getParameters((Node)fn);
            List funcParameters = fn.getParameters();
            String missingParameters = this.missingParameters(funcParameters, docParameters);
            if (!missingParameters.isEmpty()) {
                this.hints.add(new Hint(this.undocumentedParameterRule, Bundle.UndocumentedParameterRuleDisplayDescription(missingParameters), this.context.getJsParserResult().getSnapshot().getSource().getFileObject(), ModelUtils.documentOffsetRange(this.context.getJsParserResult(), fn.getIdent().getStart(), fn.getIdent().getFinish()), null, 600));
            }
            if (!(superfluousParameters = this.superfluousParameters(funcParameters, docParameters)).isEmpty()) {
                this.hints.add(new Hint(this.incorrectDocumentationRule, Bundle.IncorrectDocumentationRuleDisplayDescription(superfluousParameters), this.context.getJsParserResult().getSnapshot().getSource().getFileObject(), ModelUtils.documentOffsetRange(this.context.getJsParserResult(), fn.getIdent().getStart(), fn.getIdent().getFinish()), null, 600));
            }
            return super.enter(fn);
        }

        private String missingParameters(List<IdentNode> functionParams, List<DocParameter> documentationParams) {
            StringBuilder sb = new StringBuilder();
            String delimiter = "";
            for (IdentNode identNode : functionParams) {
                if (this.containFunctionParamName(documentationParams, identNode.getName())) continue;
                sb.append(delimiter).append(identNode.getName());
                delimiter = ", ";
            }
            return sb.toString();
        }

        private boolean containFunctionParamName(List<DocParameter> documentationParams, String functionParamName) {
            for (DocParameter docParameter : documentationParams) {
                if (docParameter.getParamName() == null || !docParameter.getParamName().getName().equals(functionParamName)) continue;
                return true;
            }
            return false;
        }

        private String superfluousParameters(List<IdentNode> functionParams, List<DocParameter> documentationParams) {
            StringBuilder sb = new StringBuilder();
            String delimiter = "";
            for (DocParameter docParameter : documentationParams) {
                if (docParameter.isOptional() || this.containDocParamName(functionParams, docParameter.getParamName().getName())) continue;
                sb.append(delimiter).append(docParameter.getParamName().getName());
                delimiter = ", ";
            }
            return sb.toString();
        }

        private boolean containDocParamName(List<IdentNode> functionParams, String documentationParamName) {
            for (IdentNode identNode : functionParams) {
                if (!identNode.getName().equals(documentationParamName)) continue;
                return true;
            }
            return false;
        }
    }
}

