/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.doc;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.javascript2.editor.JsCompletionItem;
import org.netbeans.modules.javascript2.editor.doc.JsDocumentationElement;
import org.netbeans.modules.javascript2.editor.doc.api.JsDocumentationSupport;
import org.netbeans.modules.javascript2.editor.doc.spi.AnnotationCompletionTag;
import org.netbeans.modules.javascript2.editor.doc.spi.AnnotationCompletionTagProvider;
import org.netbeans.modules.javascript2.editor.doc.spi.JsDocumentationProvider;
import org.openide.util.ImageUtilities;

public class JsDocumentationCodeCompletion {
    private static final String TAG_PREFIX = "@";

    public static void complete(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        if (request.prefix.startsWith(TAG_PREFIX)) {
            JsDocumentationCodeCompletion.completeAnnotation(request, resultList);
        }
    }

    private static void completeAnnotation(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        JsDocumentationProvider documentationProvider = JsDocumentationSupport.getDocumentationProvider(request.result);
        int orderingBase = 0;
        for (AnnotationCompletionTagProvider annotationCompletionTagProvider : documentationProvider.getAnnotationsProvider()) {
            ++orderingBase;
            for (AnnotationCompletionTag tag : annotationCompletionTagProvider.getAnnotations()) {
                if (!tag.getName().startsWith(request.prefix)) continue;
                resultList.add(new JsDocumentationCodeCompletionItem(request.anchor, tag, annotationCompletionTagProvider.getName(), orderingBase));
            }
        }
    }

    public static class JsDocumentationCodeCompletionItem
    implements CompletionProposal {
        private static final String ANNOTATION_ICON = "org/netbeans/modules/csl/source/resources/icons/annotation.png";
        private static final ImageIcon IMAGE_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/csl/source/resources/icons/annotation.png"));
        private final AnnotationCompletionTag tag;
        private final int anchorOffset;
        private final JsDocumentationElement elem;
        private final String providerName;
        private final int priority;

        public JsDocumentationCodeCompletionItem(int anchorOffset, AnnotationCompletionTag tag, String providerName, int priority) {
            this.tag = tag;
            this.anchorOffset = anchorOffset;
            this.providerName = providerName;
            this.priority = priority;
            this.elem = new JsDocumentationElement(tag.getName(), tag.getDocumentation());
        }

        public int getAnchorOffset() {
            return this.anchorOffset;
        }

        public ElementHandle getElement() {
            return this.elem;
        }

        public String getName() {
            return this.tag.getName();
        }

        public String getInsertPrefix() {
            return this.getName();
        }

        public String getSortText() {
            return this.priority + this.providerName + this.getName();
        }

        public int getSortPrioOverride() {
            return 0;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            this.tag.formatParameters(formatter);
            return formatter.getText();
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return this.providerName;
        }

        public ElementKind getKind() {
            return this.elem.getKind();
        }

        public ImageIcon getIcon() {
            return IMAGE_ICON;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isSmart() {
            return false;
        }

        public String getCustomInsertTemplate() {
            return this.tag.getInsertTemplate();
        }
    }
}

