/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.javascript2.editor.doc.spi.JsComment;
import org.netbeans.modules.javascript2.editor.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Model;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.impl.JsObjectImpl;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class JsSemanticAnalyzer
extends SemanticAnalyzer<JsParserResult> {
    public static final EnumSet<ColoringAttributes> UNUSED_OBJECT_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.CLASS);
    private boolean cancelled = false;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights = null;
    private static List<String> GLOBAL_TYPES = Arrays.asList("Array", "String", "Boolean", "Number", "undefined");

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void run(JsParserResult result, SchedulerEvent event) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        Map<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        Model model = result.getModel();
        JsObject global = model.getGlobalObject();
        highlights = this.count(result, global, highlights);
        this.semanticHighlights = highlights != null && highlights.size() > 0 ? highlights : null;
    }

    private Map<OffsetRange, Set<ColoringAttributes>> count(JsParserResult result, JsObject parent, Map<OffsetRange, Set<ColoringAttributes>> highlights) {
        for (JsObject jsObject : parent.getProperties().values()) {
            switch (jsObject.getJSKind()) {
                case CONSTRUCTOR: 
                case METHOD: 
                case FUNCTION: {
                    OffsetRange range;
                    if (jsObject.isDeclared() && !jsObject.isAnonymous() && !jsObject.getDeclarationName().getOffsetRange().isEmpty()) {
                        highlights.put(jsObject.getDeclarationName().getOffsetRange(), ColoringAttributes.METHOD_SET);
                    }
                    for (JsObject jsObject2 : ((JsFunction)jsObject).getParameters()) {
                        this.count(result, jsObject2, highlights);
                        if (this.hasSourceOccurences(result, jsObject2) || (range = jsObject2.getDeclarationName().getOffsetRange()).getStart() >= range.getEnd()) continue;
                        highlights.put(range, ColoringAttributes.UNUSED_SET);
                    }
                    break;
                }
                case PROPERTY_GETTER: 
                case PROPERTY_SETTER: {
                    Token<? extends JsTokenId> token;
                    int offset = jsObject.getDeclarationName().getOffsetRange().getStart();
                    TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(result.getSnapshot(), offset);
                    if (tokenSequence == null) break;
                    tokenSequence.move(offset);
                    if (tokenSequence.moveNext() && tokenSequence.movePrevious() && (token = LexUtilities.findPrevious(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.DOC_COMMENT))).id() == JsTokenId.IDENTIFIER && token.length() == 3) {
                        highlights.put(new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length()), ColoringAttributes.METHOD_SET);
                    }
                    highlights.put(jsObject.getDeclarationName().getOffsetRange(), ColoringAttributes.FIELD_SET);
                    break;
                }
                case OBJECT: 
                case OBJECT_LITERAL: {
                    if ("UNKNOWN".equals(jsObject.getName())) break;
                    if (parent.getParent() == null && !GLOBAL_TYPES.contains(jsObject.getName())) {
                        highlights.put(jsObject.getDeclarationName().getOffsetRange(), ColoringAttributes.GLOBAL_SET);
                        for (Occurrence occurence : jsObject.getOccurrences()) {
                            if (JsSemanticAnalyzer.isCommentOccurence(result, occurence)) continue;
                            highlights.put(occurence.getOffsetRange(), ColoringAttributes.GLOBAL_SET);
                        }
                        break;
                    }
                    if (!jsObject.isDeclared() || "prototype".equals(jsObject.getName()) || jsObject.isAnonymous()) break;
                    if ((jsObject.getOccurrences().isEmpty() || jsObject.getOccurrences().size() == 1 && jsObject.getOccurrences().get(0).getOffsetRange().equals((Object)jsObject.getDeclarationName().getOffsetRange())) && jsObject.getModifiers().contains(Modifier.PRIVATE)) {
                        highlights.put(jsObject.getDeclarationName().getOffsetRange(), UNUSED_OBJECT_SET);
                        break;
                    }
                    highlights.put(jsObject.getDeclarationName().getOffsetRange(), ColoringAttributes.CLASS_SET);
                    break;
                }
                case PROPERTY: {
                    if (!jsObject.isDeclared()) break;
                    highlights.put(jsObject.getDeclarationName().getOffsetRange(), ColoringAttributes.FIELD_SET);
                    for (Occurrence occurence : jsObject.getOccurrences()) {
                        if (JsSemanticAnalyzer.isCommentOccurence(result, occurence)) continue;
                        highlights.put(occurence.getOffsetRange(), ColoringAttributes.FIELD_SET);
                    }
                    break;
                }
                case FIELD: {
                    highlights.put(jsObject.getDeclarationName().getOffsetRange(), ColoringAttributes.FIELD_SET);
                    for (Occurrence occurence : jsObject.getOccurrences()) {
                        if (JsSemanticAnalyzer.isCommentOccurence(result, occurence)) continue;
                        highlights.put(occurence.getOffsetRange(), ColoringAttributes.FIELD_SET);
                    }
                    break;
                }
                case VARIABLE: {
                    OffsetRange range;
                    if (parent.getParent() == null && !GLOBAL_TYPES.contains(jsObject.getName())) {
                        highlights.put(jsObject.getDeclarationName().getOffsetRange(), ColoringAttributes.GLOBAL_SET);
                        for (Occurrence occurence : jsObject.getOccurrences()) {
                            if (JsSemanticAnalyzer.isCommentOccurence(result, occurence)) continue;
                            highlights.put(occurence.getOffsetRange(), ColoringAttributes.GLOBAL_SET);
                        }
                    } else {
                        if ((jsObject.getOccurrences().isEmpty() || jsObject.getOccurrences().size() == 1 && jsObject.getOccurrences().get(0).getOffsetRange().equals((Object)jsObject.getDeclarationName().getOffsetRange())) && !GLOBAL_TYPES.contains(jsObject.getName())) {
                            range = jsObject.getDeclarationName().getOffsetRange();
                            if (range.getStart() >= range.getEnd()) break;
                            highlights.put(jsObject.getDeclarationName().getOffsetRange(), ColoringAttributes.UNUSED_SET);
                            break;
                        }
                        if (!(jsObject instanceof JsObjectImpl) || "arguments".equals(jsObject.getName()) || jsObject.getOccurrences().size() > ((JsObjectImpl)jsObject).getCountOfAssignments()) break;
                        if (jsObject.getDeclarationName().getOffsetRange().getLength() > 0) {
                            highlights.put(jsObject.getDeclarationName().getOffsetRange(), ColoringAttributes.UNUSED_SET);
                        }
                        for (Occurrence occurence : jsObject.getOccurrences()) {
                            if (occurence.getOffsetRange().getLength() <= 0) continue;
                            highlights.put(occurence.getOffsetRange(), ColoringAttributes.UNUSED_SET);
                        }
                    }
                    break;
                }
            }
            if (this.isCancelled()) {
                highlights = null;
                break;
            }
            highlights = this.count(result, jsObject, highlights);
        }
        return highlights;
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    private boolean hasSourceOccurences(JsParserResult result, JsObject param) {
        if (param.getOccurrences().isEmpty()) {
            return false;
        }
        if (param.getOccurrences().size() == 1 && param.getOccurrences().get(0).getOffsetRange().equals((Object)param.getDeclarationName().getOffsetRange())) {
            return false;
        }
        int sourceOccurenceCount = 0;
        for (Occurrence occurrence : param.getOccurrences()) {
            if (!JsSemanticAnalyzer.isCommentOccurence(result, occurrence)) {
                ++sourceOccurenceCount;
            }
            if (sourceOccurenceCount <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean isCommentOccurence(JsParserResult result, Occurrence occurence) {
        for (JsComment jsComment : result.getDocumentationHolder().getCommentBlocks().values()) {
            if (!jsComment.getOffsetRange().containsInclusive(occurence.getOffsetRange().getStart())) continue;
            return true;
        }
        return false;
    }
}

