/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.lexer.LexUtilities;

public class JsKeystrokeHandler
implements KeystrokeHandler {
    public boolean beforeCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public boolean afterCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public boolean charBackspaced(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public int beforeBreak(Document doc, int caretOffset, JTextComponent target) throws BadLocationException {
        return -1;
    }

    public OffsetRange findMatching(Document doc, int caretOffset) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult info, int caretOffset) {
        return Collections.emptyList();
    }

    public int getNextWordOffset(final Document doc, final int offset, final boolean reverse) {
        final int[] ret = new int[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                ret[0] = JsKeystrokeHandler.getWordOffset(doc, offset, reverse);
            }
        });
        return ret[0];
    }

    private static int getWordOffset(Document doc, int offset, boolean reverse) {
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(doc, offset);
        if (ts == null) {
            return -1;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return -1;
        }
        if (reverse && ts.offset() == offset && !ts.movePrevious()) {
            return -1;
        }
        Token token = ts.token();
        if (token.id() == JsTokenId.WHITESPACE && (reverse && ts.offset() < offset || !reverse && ts.offset() > offset)) {
            return ts.offset();
        }
        if (token.id() == JsTokenId.IDENTIFIER) {
            String image = ((Object)token.text()).toString();
            int imageLength = image.length();
            int offsetInImage = offset - ts.offset();
            if (reverse) {
                return JsKeystrokeHandler.getPreviousIdentifierWordOffset(ts, image, imageLength, offsetInImage);
            }
            return JsKeystrokeHandler.getNextIdentifierWordOffset(ts, image, imageLength, offsetInImage);
        }
        return -1;
    }

    private static int getPreviousIdentifierWordOffset(TokenSequence<? extends JsTokenId> ts, String image, int imageLength, int offsetInImage) {
        if (--offsetInImage < 0) {
            return -1;
        }
        if (offsetInImage < imageLength && Character.isUpperCase(image.charAt(offsetInImage))) {
            for (int i = offsetInImage - 1; i >= 0; --i) {
                char charAtI = image.charAt(i);
                if (Character.isUpperCase(charAtI)) continue;
                return ts.offset() + i + 1;
            }
            return ts.offset();
        }
        for (int i = offsetInImage - 1; i >= 0; --i) {
            char charAtI = image.charAt(i);
            if (!Character.isUpperCase(charAtI)) continue;
            for (int j = i; j >= 0; --j) {
                char charAtJ = image.charAt(j);
                if (Character.isUpperCase(charAtJ)) continue;
                return ts.offset() + j + 1;
            }
            return ts.offset();
        }
        return ts.offset();
    }

    private static int getNextIdentifierWordOffset(TokenSequence<? extends JsTokenId> ts, String image, int imageLength, int offsetInImage) {
        char charAtI;
        int i;
        int start = offsetInImage + 1;
        if (offsetInImage < 0 || offsetInImage >= image.length()) {
            return -1;
        }
        if (Character.isUpperCase(image.charAt(offsetInImage))) {
            for (i = start; i < imageLength && Character.isUpperCase(charAtI = image.charAt(i)); ++i) {
                ++start;
            }
        }
        for (i = start; i < imageLength; ++i) {
            charAtI = image.charAt(i);
            if (!Character.isUpperCase(charAtI)) continue;
            return ts.offset() + i;
        }
        return -1;
    }
}

