/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.javascript2.editor.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.lexer.LexUtilities;
import org.netbeans.spi.editor.typinghooks.DeletedTextInterceptor;

public class JsDeletedTextInterceptor
implements DeletedTextInterceptor {
    private final Language<JsTokenId> language;
    private final boolean singleQuote;
    private final boolean comments;

    public JsDeletedTextInterceptor(Language<JsTokenId> language, boolean singleQuote, boolean comments) {
        this.language = language;
        this.singleQuote = singleQuote;
        this.comments = comments;
    }

    public void afterRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
    }

    public boolean beforeRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void cancelled(DeletedTextInterceptor.Context context) {
    }

    public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
        BaseDocument doc = (BaseDocument)context.getDocument();
        int dotPos = context.getOffset() - 1;
        char ch = context.getText().charAt(0);
        JTextComponent target = context.getComponent();
        switch (ch) {
            case ' ': {
                TokenSequence<? extends JsTokenId> ts;
                if (!this.comments || (ts = LexUtilities.getPositionedSequence((Document)doc, dotPos, this.language)) == null || ts.token().id() != JsTokenId.LINE_COMMENT || ts.offset() != dotPos - 2) break;
                doc.remove(dotPos - 2, 2);
                target.getCaret().setDot(dotPos - 2);
                return;
            }
            case '(': 
            case '[': 
            case '{': {
                char tokenAtDot = LexUtilities.getTokenChar((Document)doc, dotPos, this.language);
                if (!(tokenAtDot == ']' && LexUtilities.getTokenBalance((Document)doc, JsTokenId.BRACKET_LEFT_BRACKET, JsTokenId.BRACKET_RIGHT_BRACKET, dotPos, this.language) != 0 || tokenAtDot == ')' && LexUtilities.getTokenBalance((Document)doc, JsTokenId.BRACKET_LEFT_PAREN, JsTokenId.BRACKET_RIGHT_PAREN, dotPos, this.language) != 0) && (tokenAtDot != '}' || LexUtilities.getTokenBalance((Document)doc, JsTokenId.BRACKET_LEFT_CURLY, JsTokenId.BRACKET_RIGHT_CURLY, dotPos, this.language) == 0)) break;
                doc.remove(dotPos, 1);
                break;
            }
            case '/': {
                TokenSequence<? extends JsTokenId> ts;
                if (this.comments && (ts = LexUtilities.getPositionedSequence((Document)doc, dotPos, this.language)) != null && ts.token().id() == JsTokenId.REGEXP_BEGIN && ts.offset() == dotPos - 1) {
                    doc.remove(dotPos - 1, 1);
                    target.getCaret().setDot(dotPos - 1);
                    return;
                }
            }
            case '\'': {
                if (!this.singleQuote) break;
            }
            case '\"': {
                char[] match = doc.getChars(dotPos, 1);
                if (match == null || match[0] != ch) break;
                doc.remove(dotPos, 1);
                break;
            }
        }
    }

    public static class JsonFactory
    implements DeletedTextInterceptor.Factory {
        public DeletedTextInterceptor createDeletedTextInterceptor(MimePath mimePath) {
            return new JsDeletedTextInterceptor(JsTokenId.jsonLanguage(), false, false);
        }
    }

    public static class JsFactory
    implements DeletedTextInterceptor.Factory {
        public DeletedTextInterceptor createDeletedTextInterceptor(MimePath mimePath) {
            return new JsDeletedTextInterceptor(JsTokenId.javascriptLanguage(), true, true);
        }
    }
}

