/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.Bundle;
import org.netbeans.modules.javascript2.editor.JsKeyWords;
import org.netbeans.modules.javascript2.editor.index.IndexedElement;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

public class JsCompletionItem
implements CompletionProposal {
    protected final CompletionRequest request;
    private final ElementHandle element;

    JsCompletionItem(ElementHandle element, CompletionRequest request) {
        this.element = element;
        this.request = request;
    }

    public int getAnchorOffset() {
        return this.request.anchor;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.element.getName();
    }

    public String getSortText() {
        return this.getName();
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        formatter.appendText(this.getName());
        return formatter.getText();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        String location = null;
        location = this.element instanceof JsElement && ((JsElement)this.element).isPlatform() ? Bundle.JsCompletionItem_lbl_js_platform() : this.getFileNameURL();
        if (location == null) {
            return null;
        }
        formatter.reset();
        formatter.appendText(location);
        return formatter.getText();
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        Set emptyModifiers = Collections.emptySet();
        ElementHandle handle = this.getElement();
        return handle != null ? handle.getModifiers() : emptyModifiers;
    }

    public boolean isSmart() {
        return false;
    }

    public int getSortPrioOverride() {
        return 0;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    @CheckForNull
    public final String getFileNameURL() {
        ElementHandle elem = this.getElement();
        if (elem == null) {
            return null;
        }
        FileObject fo = elem.getFileObject();
        if (fo != null) {
            return fo.getNameExt();
        }
        return this.getName();
    }

    public static class Factory {
        public static JsCompletionItem create(JsElement object, CompletionRequest request) {
            JsCompletionItem result;
            switch (object.getJSKind()) {
                case CONSTRUCTOR: 
                case FUNCTION: 
                case METHOD: {
                    result = new JsFunctionCompletionItem(object, request);
                    break;
                }
                case PROPERTY: 
                case PROPERTY_GETTER: 
                case PROPERTY_SETTER: 
                case FIELD: 
                case VARIABLE: {
                    result = new JsPropertyCompletionItem(object, request);
                    break;
                }
                default: {
                    result = new JsCompletionItem(object, request);
                }
            }
            return result;
        }
    }

    public static class JsPropertyCompletionItem
    extends JsCompletionItem {
        JsPropertyCompletionItem(ElementHandle element, CompletionRequest request) {
            super(element, request);
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.appendText(this.getName());
            Collection<? extends TypeUsage> assignment = null;
            ElementHandle element = this.getElement();
            if (element instanceof JsObject) {
                JsObject jsObject = (JsObject)element;
                assignment = jsObject.getAssignmentForOffset(this.request.anchor);
            } else if (element instanceof IndexedElement) {
                IndexedElement iElement = (IndexedElement)element;
                assignment = iElement.getAssignments();
            }
            if (assignment != null && !assignment.isEmpty()) {
                Collection<TypeUsage> resolved = new ArrayList<TypeUsage>(assignment);
                if (!(resolved = ModelUtils.resolveTypes(resolved, this.request.result)).isEmpty()) {
                    formatter.type(true);
                    formatter.appendText(": ");
                    Iterator<TypeUsage> it = resolved.iterator();
                    while (it.hasNext()) {
                        formatter.appendText(it.next().getType());
                        if (!it.hasNext()) continue;
                        formatter.appendText("|");
                    }
                    formatter.type(false);
                }
            }
            return formatter.getText();
        }
    }

    static class KeywordItem
    extends JsCompletionItem {
        private static ImageIcon keywordIcon = null;
        private String keyword = null;

        public KeywordItem(String keyword, CompletionRequest request) {
            super(null, request);
            this.keyword = keyword;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            return null;
        }

        @Override
        public ImageIcon getIcon() {
            if (keywordIcon == null) {
                keywordIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/editor/resources/javascript.png"));
            }
            return keywordIcon;
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder builder = new StringBuilder();
            JsKeyWords.CompletionType type = JsKeyWords.KEYWORDS.get(this.getName());
            if (type == null) {
                return this.getName();
            }
            boolean appendSpace = true;
            Object name = null;
            switch (type) {
                case ENDS_WITH_SPACE: {
                    builder.append(this.getName());
                    builder.append(" ${cursor}");
                    break;
                }
                case CURSOR_INSIDE_BRACKETS: {
                    builder.append(this.getName());
                    builder.append("(${cursor})");
                    break;
                }
                case ENDS_WITH_CURLY_BRACKETS: {
                    builder.append(this.getName());
                    builder.append(" {${cursor}}");
                    break;
                }
                case ENDS_WITH_SEMICOLON: {
                    builder.append(this.getName());
                    CharSequence text = this.request.info.getSnapshot().getText();
                    int index = this.request.anchor + this.request.prefix.length();
                    if (index != text.length() && ';' == text.charAt(index)) break;
                    builder.append(";");
                    break;
                }
                case ENDS_WITH_COLON: {
                    builder.append(this.getName());
                    builder.append(" ${cursor}:");
                    break;
                }
                case ENDS_WITH_DOT: {
                    builder.append(this.getName());
                    builder.append(".${cursor}");
                    break;
                }
                default: {
                    assert (false) : type.toString();
                    break;
                }
            }
            return builder.toString();
        }
    }

    public static class JsFunctionCompletionItem
    extends JsCompletionItem {
        JsFunctionCompletionItem(ElementHandle element, CompletionRequest request) {
            super(element, request);
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.emphasis(true);
            formatter.appendText(this.getName());
            formatter.emphasis(false);
            formatter.appendText("(");
            this.appendParamsStr(formatter);
            formatter.appendText(")");
            this.appendReturnTypes(formatter);
            return formatter.getText();
        }

        private void appendParamsStr(HtmlFormatter formatter) {
            Collection<String> types;
            LinkedHashMap<Object, Object> allParameters = new LinkedHashMap();
            ElementHandle element = this.getElement();
            if (element instanceof JsFunction) {
                for (JsObject jsObject : ((JsFunction)element).getParameters()) {
                    types = new ArrayList();
                    for (TypeUsage typeUsage : jsObject.getAssignmentForOffset(jsObject.getOffset() + 1)) {
                        types.add(typeUsage.getType());
                    }
                    allParameters.put(jsObject.getName(), types);
                }
            } else if (element instanceof IndexedElement.FunctionIndexedElement) {
                allParameters = ((IndexedElement.FunctionIndexedElement)element).getParameters();
            }
            Iterator it = allParameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                formatter.parameters(true);
                formatter.appendText((String)entry.getKey());
                formatter.parameters(false);
                types = (Collection)entry.getValue();
                if (!types.isEmpty()) {
                    formatter.type(true);
                    formatter.appendText(": ");
                    Iterator itTypes = types.iterator();
                    while (itTypes.hasNext()) {
                        formatter.appendText((String)itTypes.next());
                        if (!itTypes.hasNext()) continue;
                        formatter.appendText("|");
                    }
                    formatter.type(false);
                }
                if (!it.hasNext()) continue;
                formatter.appendText(", ");
            }
        }

        private void appendReturnTypes(HtmlFormatter formatter) {
            ArrayList<String> returnTypes = new ArrayList<String>();
            ElementHandle element = this.getElement();
            if (element instanceof JsFunction) {
                for (TypeUsage typeUsage : ((JsFunction)element).getReturnTypes()) {
                    returnTypes.add(typeUsage.getType());
                }
            } else if (element instanceof IndexedElement.FunctionIndexedElement) {
                returnTypes.addAll(((IndexedElement.FunctionIndexedElement)element).getReturnTypes());
            }
            if (!returnTypes.isEmpty()) {
                formatter.appendText(": ");
                formatter.type(true);
                Iterator it = returnTypes.iterator();
                while (it.hasNext()) {
                    formatter.appendText((String)it.next());
                    if (!it.hasNext()) continue;
                    formatter.appendText("|");
                }
                formatter.type(false);
            }
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder template = new StringBuilder();
            template.append(this.getName());
            template.append("(${cursor})");
            return template.toString();
        }
    }

    public static class CompletionRequest {
        public int anchor;
        public JsParserResult result;
        public ParserResult info;
        public String prefix;
    }
}

