/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.CompletionContextFinder;
import org.netbeans.modules.javascript2.editor.JsCompletionItem;
import org.netbeans.modules.javascript2.editor.JsKeyWords;
import org.netbeans.modules.javascript2.editor.doc.JsDocumentationCodeCompletion;
import org.netbeans.modules.javascript2.editor.doc.JsDocumentationElement;
import org.netbeans.modules.javascript2.editor.index.IndexedElement;
import org.netbeans.modules.javascript2.editor.index.JsIndex;
import org.netbeans.modules.javascript2.editor.jquery.JQueryCodeCompletion;
import org.netbeans.modules.javascript2.editor.jquery.JQueryModel;
import org.netbeans.modules.javascript2.editor.lexer.JsDocumentationTokenId;
import org.netbeans.modules.javascript2.editor.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Model;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.model.impl.TypeUsageImpl;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

class JsCodeCompletion
implements CodeCompletionHandler {
    private static final Logger LOGGER = Logger.getLogger(JsCodeCompletion.class.getName());
    private boolean caseSensitive;
    private final JQueryCodeCompletion jqueryCC = new JQueryCodeCompletion();
    private static final List<String> WINDOW_EXPRESSION_CHAIN = Arrays.asList("window", "@pro");
    private int checkRecursion;

    JsCodeCompletion() {
    }

    public CodeCompletionResult complete(CodeCompletionContext ccContext) {
        ArrayList<CompletionProposal> resultList;
        String pref;
        CompletionContextFinder.CompletionContext context;
        long start;
        block31: {
            JsCompletionItem.CompletionRequest request;
            FileObject fileObject;
            int caretOffset;
            block30: {
                start = System.currentTimeMillis();
                BaseDocument doc = (BaseDocument)ccContext.getParserResult().getSnapshot().getSource().getDocument(false);
                if (doc == null) {
                    return CodeCompletionResult.NONE;
                }
                this.caseSensitive = ccContext.isCaseSensitive();
                ParserResult info = ccContext.getParserResult();
                caretOffset = ccContext.getCaretOffset();
                fileObject = ccContext.getParserResult().getSnapshot().getSource().getFileObject();
                JsParserResult jsParserResult = (JsParserResult)info;
                context = CompletionContextFinder.findCompletionContext(info, caretOffset);
                LOGGER.log(Level.FINE, String.format("CC context: %s", context.toString()));
                request = new JsCompletionItem.CompletionRequest();
                pref = this.getPrefix(info, caretOffset, true);
                pref = pref == null ? "" : pref;
                request.anchor = caretOffset - pref.length();
                request.result = jsParserResult;
                request.info = info;
                request.prefix = pref;
                resultList = new ArrayList<CompletionProposal>();
                if (ccContext.getQueryType() != CodeCompletionHandler.QueryType.ALL_COMPLETION) break block30;
                switch (context) {
                    case GLOBAL: {
                        Collection<IndexedElement> fromIndex = JsIndex.get(fileObject).getGlobalVar(request.prefix);
                        HashMap<String, IndexedElement> addedGlobal = new HashMap<String, IndexedElement>();
                        for (IndexedElement indexedElement : fromIndex) {
                            JsElement element = (JsElement)addedGlobal.get(indexedElement.getName());
                            if (element == null) {
                                if (indexedElement.isDeclared()) {
                                    resultList.add(JsCompletionItem.Factory.create(indexedElement, request));
                                }
                                addedGlobal.put(indexedElement.getName(), indexedElement);
                                continue;
                            }
                            if (element.isDeclared() || !indexedElement.isDeclared()) continue;
                            resultList.add(JsCompletionItem.Factory.create(indexedElement, request));
                            addedGlobal.put(indexedElement.getName(), indexedElement);
                        }
                        break block31;
                    }
                    case EXPRESSION: 
                    case OBJECT_MEMBERS: 
                    case OBJECT_PROPERTY: {
                        Collection<? extends IndexResult> indexResults = JsIndex.get(fileObject).query("bn", request.prefix, QuerySupport.Kind.PREFIX, JsIndex.TERMS_BASIC_INFO);
                        HashMap<String, IndexedElement> hashMap = new HashMap<String, IndexedElement>();
                        for (IndexResult indexResult : indexResults) {
                            IndexedElement indexElement = IndexedElement.create(indexResult);
                            JsElement element = (JsElement)hashMap.get(indexElement.getName());
                            if (element == null) {
                                if (indexElement.isDeclared()) {
                                    resultList.add(JsCompletionItem.Factory.create(indexElement, request));
                                }
                                hashMap.put(indexElement.getName(), indexElement);
                                continue;
                            }
                            if (element.isDeclared() || !indexElement.isDeclared()) continue;
                            resultList.add(JsCompletionItem.Factory.create(indexElement, request));
                            hashMap.put(indexElement.getName(), indexElement);
                        }
                        break;
                    }
                }
                break block31;
            }
            switch (context) {
                case GLOBAL: {
                    HashMap<String, JsElement> addedProperties = new HashMap<String, JsElement>();
                    Map<String, JsElement> results = this.getDomCompletionResults(request);
                    for (JsElement jsElement : results.values()) {
                        resultList.add(JsCompletionItem.Factory.create(jsElement, request));
                    }
                    addedProperties.putAll(results);
                    for (JsObject jsObject : this.getLibrariesGlobalObjects()) {
                        for (JsObject jsObject2 : jsObject.getProperties().values()) {
                            if (!this.startsWith(jsObject2.getName(), request.prefix)) continue;
                            if (jsObject2.isDeclared()) {
                                resultList.add(JsCompletionItem.Factory.create(jsObject2, request));
                            }
                            addedProperties.put(jsObject2.getName(), jsObject2);
                        }
                    }
                    for (JsObject jsObject : request.result.getModel().getVariables(caretOffset)) {
                        if (jsObject instanceof JsFunction && ((JsFunction)jsObject).isAnonymous() || !this.startsWith(jsObject.getName(), request.prefix)) continue;
                        JsElement element = (JsElement)addedProperties.get(jsObject.getName());
                        if (element == null) {
                            if (jsObject.isDeclared()) {
                                resultList.add(JsCompletionItem.Factory.create(jsObject, request));
                            }
                            addedProperties.put(jsObject.getName(), jsObject);
                            continue;
                        }
                        if (element.isDeclared() || !jsObject.isDeclared()) continue;
                        resultList.add(JsCompletionItem.Factory.create(jsObject, request));
                        addedProperties.put(jsObject.getName(), jsObject);
                    }
                    this.completeKeywords(request, resultList);
                    JsIndex jsIndex = JsIndex.get(fileObject);
                    Collection<IndexedElement> collection = jsIndex.getGlobalVar(request.prefix);
                    for (IndexedElement indexedElement : collection) {
                        if (!this.startsWith(indexedElement.getName(), request.prefix)) continue;
                        JsElement element = (JsElement)addedProperties.get(indexedElement.getName());
                        if (element == null) {
                            if (indexedElement.isDeclared()) {
                                resultList.add(JsCompletionItem.Factory.create(indexedElement, request));
                            }
                            addedProperties.put(indexedElement.getName(), indexedElement);
                            continue;
                        }
                        if (element.isDeclared() || !indexedElement.isDeclared()) continue;
                        resultList.add(JsCompletionItem.Factory.create(indexedElement, request));
                        addedProperties.put(indexedElement.getName(), indexedElement);
                    }
                    for (JsElement jsElement : addedProperties.values()) {
                        if (jsElement.isDeclared()) continue;
                        resultList.add(JsCompletionItem.Factory.create(jsElement, request));
                    }
                    break;
                }
                case EXPRESSION: {
                    this.completeKeywords(request, resultList);
                    this.completeExpression(request, resultList);
                    break;
                }
                case OBJECT_PROPERTY: {
                    this.completeObjectProperty(request, resultList);
                    break;
                }
                case OBJECT_MEMBERS: {
                    this.completeObjectMember(request, resultList);
                    break;
                }
                case DOCUMENTATION: {
                    JsDocumentationCodeCompletion.complete(request, resultList);
                    break;
                }
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Counting JS CC took {0}ms ", end - start);
        resultList.addAll(this.jqueryCC.complete(ccContext, context, pref));
        if (!resultList.isEmpty()) {
            return new DefaultCompletionResult(resultList, false);
        }
        return CodeCompletionResult.NONE;
    }

    public String document(ParserResult info, ElementHandle element) {
        String doc;
        JsObject jsObject;
        final StringBuilder documentation = new StringBuilder();
        if (element instanceof IndexedElement) {
            final IndexedElement indexedElement = (IndexedElement)element;
            FileObject nextFo = indexedElement.getFileObject();
            try {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)nextFo)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result parserResult = resultIterator.getParserResult();
                        if (parserResult instanceof JsParserResult) {
                            String doc;
                            JsParserResult jsInfo = (JsParserResult)parserResult;
                            String fqn = indexedElement.getFQN();
                            JsObject jsObjectGlobal = jsInfo.getModel().getGlobalObject();
                            JsObject property = ModelUtils.findJsObjectByName(jsObjectGlobal, fqn);
                            if (property != null && (doc = property.getDocumentation()) != null && !doc.isEmpty()) {
                                documentation.append(doc);
                            }
                        }
                        LOGGER.log(Level.INFO, "Not instance of JsParserResult: {0}", parserResult);
                    }
                });
            }
            catch (ParseException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        } else if (element instanceof JsObject && (jsObject = (JsObject)element).getDocumentation() != null) {
            documentation.append(jsObject.getDocumentation());
        }
        if (documentation.length() == 0 && (doc = this.jqueryCC.getHelpDocumentation(info, element)) != null && !doc.isEmpty()) {
            documentation.append(doc);
        }
        if (element instanceof JsDocumentationElement) {
            return ((JsDocumentationElement)element).getDocumentation();
        }
        if (documentation.length() == 0) {
            documentation.append(NbBundle.getMessage(JsCodeCompletion.class, (String)"MSG_DocNotAvailable"));
        }
        return documentation.toString();
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        Token token;
        String prefix = "";
        BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return null;
        }
        caretOffset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(info.getSnapshot(), caretOffset);
        if (ts == null) {
            return null;
        }
        ts.move(caretOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        if (ts.offset() == caretOffset) {
            ts.movePrevious();
        }
        if ((token = ts.token()) != null && token.id() != JsTokenId.EOL) {
            JsTokenId id = (JsTokenId)token.id();
            if (id == JsTokenId.STRING_END && ts.movePrevious()) {
                if (ts.token().id() == JsTokenId.STRING_BEGIN) {
                    return "";
                }
                ts.moveNext();
            }
            if (id == JsTokenId.STRING) {
                prefix = ((Object)token.text()).toString();
                if (upToOffset) {
                    int prefixIndex = JsCodeCompletion.getPrefixIndexFromSequence(prefix.substring(0, caretOffset - ts.offset()));
                    prefix = prefix.substring(prefixIndex, caretOffset - ts.offset());
                }
            }
            if (id == JsTokenId.IDENTIFIER || id.isKeyword()) {
                prefix = ((Object)token.text()).toString();
                if (upToOffset) {
                    prefix = prefix.substring(0, caretOffset - ts.offset());
                }
            }
            if (id == JsTokenId.DOC_COMMENT) {
                TokenSequence<? extends JsDocumentationTokenId> docTokenSeq = LexUtilities.getJsDocumentationTokenSequence(info.getSnapshot(), caretOffset);
                if (docTokenSeq == null) {
                    return null;
                }
                docTokenSeq.move(caretOffset);
                if (!docTokenSeq.moveNext() && !docTokenSeq.movePrevious()) {
                    return null;
                }
                if (docTokenSeq.token().id() == JsDocumentationTokenId.KEYWORD) {
                    prefix = ((Object)docTokenSeq.token().text()).toString();
                    if (upToOffset) {
                        prefix = prefix.substring(0, caretOffset - docTokenSeq.offset());
                    }
                } else {
                    docTokenSeq.movePrevious();
                    prefix = ((Object)docTokenSeq.token().text()).toString();
                }
            }
            if (id.isError()) {
                prefix = ((Object)token.text()).toString();
                if (upToOffset) {
                    prefix = prefix.substring(0, caretOffset - ts.offset());
                }
            }
        }
        LOGGER.log(Level.FINE, String.format("Prefix for cc: %s", prefix));
        return prefix;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        if (typedText.length() == 0) {
            return CodeCompletionHandler.QueryType.NONE;
        }
        int offset = component.getCaretPosition();
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(component.getDocument(), offset);
        if (ts != null) {
            int diff = ts.move(offset);
            TokenId currentTokenId = null;
            if (diff == 0 && ts.movePrevious() || ts.moveNext()) {
                currentTokenId = ts.token().id();
            }
            char lastChar = typedText.charAt(typedText.length() - 1);
            if (currentTokenId == JsTokenId.BLOCK_COMMENT || currentTokenId == JsTokenId.DOC_COMMENT || currentTokenId == JsTokenId.LINE_COMMENT) {
                if (lastChar == '@') {
                    return CodeCompletionHandler.QueryType.COMPLETION;
                }
            } else {
                switch (lastChar) {
                    case '.': {
                        return CodeCompletionHandler.QueryType.COMPLETION;
                    }
                }
                return CodeCompletionHandler.QueryType.NONE;
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return null;
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    private void completeExpression(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        HashMap<String, JsElement> foundObjects = new HashMap<String, JsElement>();
        FileObject fo = request.info.getSnapshot().getSource().getFileObject();
        foundObjects.putAll(this.getDomCompletionResults(request));
        JsIndex index = JsIndex.get(fo);
        Collection<IndexedElement> fromIndex = index.getGlobalVar(request.prefix);
        for (IndexedElement indexedElement : fromIndex) {
            JsElement object = (JsElement)foundObjects.get(indexedElement.getName());
            if (object == null) {
                foundObjects.put(indexedElement.getName(), indexedElement);
                continue;
            }
            if (!indexedElement.isDeclared()) continue;
            if (object.isDeclared()) {
                resultList.add(JsCompletionItem.Factory.create(indexedElement, request));
                continue;
            }
            foundObjects.put(indexedElement.getName(), indexedElement);
        }
        for (JsObject jsObject : this.getLibrariesGlobalObjects()) {
            for (JsObject jsObject2 : jsObject.getProperties().values()) {
                if (!this.startsWith(jsObject2.getName(), request.prefix)) continue;
                foundObjects.put(jsObject2.getName(), jsObject2);
            }
        }
        for (JsObject jsObject : request.result.getModel().getVariables(request.anchor)) {
            if (jsObject instanceof JsFunction && ((JsFunction)jsObject).isAnonymous() || !this.startsWith(jsObject.getName(), request.prefix)) continue;
            JsElement fobject = (JsElement)foundObjects.get(jsObject.getName());
            if (fobject == null) {
                if (jsObject.getName().equals(request.prefix) && jsObject.getDeclarationName().getOffsetRange().getStart() == request.anchor) continue;
                foundObjects.put(jsObject.getName(), jsObject);
                continue;
            }
            if (!jsObject.isDeclared()) continue;
            foundObjects.put(jsObject.getName(), jsObject);
        }
        for (JsElement jsElement : foundObjects.values()) {
            resultList.add(JsCompletionItem.Factory.create(jsElement, request));
        }
    }

    private void completeObjectProperty(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        List<String> expChain = this.resolveExpressionChain(request);
        HashMap<String, JsElement> results = this.getCompletionFromExpressionChain(request, expChain);
        for (JsElement element : results.values()) {
            resultList.add(JsCompletionItem.Factory.create(element, request));
        }
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, JsElement> getCompletionFromExpressionChain(JsCompletionItem.CompletionRequest request, List<String> expChain) {
        void var11_20;
        boolean bl;
        FileObject fo = request.info.getSnapshot().getSource().getFileObject();
        JsIndex jsIndex = JsIndex.get(fo);
        Collection<Object> resolveTypeFromExpression = new ArrayList<TypeUsage>();
        resolveTypeFromExpression.addAll(ModelUtils.resolveTypeFromExpression(request.result.getModel(), jsIndex, expChain, request.anchor));
        resolveTypeFromExpression = ModelUtils.resolveTypes(resolveTypeFromExpression, request.result);
        ArrayList<String> prototypeChain = new ArrayList<String>();
        for (TypeUsage typeUsage : resolveTypeFromExpression) {
            prototypeChain.addAll(ModelUtils.findPrototypeChain(typeUsage.getType(), jsIndex));
        }
        for (String string : prototypeChain) {
            resolveTypeFromExpression.add(new TypeUsageImpl(string));
        }
        HashMap<String, JsElement> addedProperties = new HashMap<String, JsElement>();
        boolean bl2 = false;
        ArrayList<JsObject> lastResolvedObjects = new ArrayList<JsObject>();
        for (TypeUsage typeUsage : resolveTypeFromExpression) {
            this.checkRecursion = 0;
            boolean bl3 = this.processTypeInModel(request, request.result.getModel(), typeUsage, lastResolvedObjects, expChain.get(1).equals("@pro"), jsIndex, addedProperties);
        }
        for (JsObject jsObject : lastResolvedObjects) {
            if (!bl && jsObject.getJSKind().isFunction()) {
                bl = true;
            }
            this.addObjectPropertiesToCC(jsObject, request, addedProperties);
            if (jsObject.isDeclared()) continue;
            this.addObjectPropertiesFromIndex(ModelUtils.createFQN(jsObject), jsIndex, request, addedProperties);
        }
        if (bl) {
            this.addObjectPropertiesFromIndex("Function", jsIndex, request, addedProperties);
        }
        this.addObjectPropertiesFromIndex("Object", jsIndex, request, addedProperties);
        StringBuilder fqn = new StringBuilder();
        int n = expChain.size() - 1;
        while (var11_20 > -1) {
            fqn.append(expChain.get((int)(--var11_20)));
            fqn.append('.');
            --var11_20;
        }
        fqn.append(request.prefix);
        Collection<? extends IndexResult> collection = jsIndex.query("fqn", fqn.toString(), QuerySupport.Kind.PREFIX, JsIndex.TERMS_BASIC_INFO);
        for (IndexResult indexResult : collection) {
            IndexedElement indexedElement = IndexedElement.create(indexResult);
            JsElement element = addedProperties.get(indexedElement.getName());
            if (!this.startsWith(indexedElement.getName(), request.prefix) || indexedElement.isAnonymous() || indexedElement.getFQN().indexOf(46, fqn.length()) != -1 || !indexedElement.getModifiers().contains(Modifier.PUBLIC) || element != null && (element.isDeclared() || !indexedElement.isDeclared())) continue;
            addedProperties.put(indexedElement.getName(), indexedElement);
        }
        return addedProperties;
    }

    private List<String> resolveExpressionChain(JsCompletionItem.CompletionRequest request) {
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(th, request.anchor);
        if (ts == null) {
            return Collections.emptyList();
        }
        int offset = request.info.getSnapshot().getEmbeddedOffset(request.anchor);
        ts.move(offset);
        if (ts.movePrevious() && (ts.moveNext() || ts.offset() + ts.token().length() == request.result.getSnapshot().getText().length())) {
            if (ts.token().id() != JsTokenId.OPERATOR_DOT) {
                ts.movePrevious();
            }
            Token token = ts.token();
            int parenBalancer = 0;
            boolean methodCall = false;
            boolean wasLastDot = false;
            ArrayList<String> exp = new ArrayList<String>();
            while (token.id() != JsTokenId.WHITESPACE && token.id() != JsTokenId.OPERATOR_SEMICOLON && token.id() != JsTokenId.BRACKET_RIGHT_CURLY && token.id() != JsTokenId.BRACKET_LEFT_CURLY && token.id() != JsTokenId.BRACKET_LEFT_PAREN && token.id() != JsTokenId.BLOCK_COMMENT && token.id() != JsTokenId.LINE_COMMENT && token.id() != JsTokenId.OPERATOR_ASSIGNMENT && token.id() != JsTokenId.OPERATOR_PLUS) {
                if (token.id() != JsTokenId.EOL) {
                    if (token.id() != JsTokenId.OPERATOR_DOT) {
                        if (token.id() == JsTokenId.BRACKET_RIGHT_PAREN) {
                            ++parenBalancer;
                            methodCall = true;
                            while (parenBalancer > 0 && ts.movePrevious()) {
                                token = ts.token();
                                if (token.id() == JsTokenId.BRACKET_RIGHT_PAREN) {
                                    ++parenBalancer;
                                    continue;
                                }
                                if (token.id() != JsTokenId.BRACKET_LEFT_PAREN) continue;
                                --parenBalancer;
                            }
                        } else {
                            exp.add(((Object)token.text()).toString());
                            if (!methodCall) {
                                exp.add("@pro");
                            } else {
                                exp.add("@mtd");
                                methodCall = false;
                            }
                            wasLastDot = false;
                        }
                    } else {
                        wasLastDot = true;
                    }
                } else if (!wasLastDot && ts.movePrevious() && (token = LexUtilities.findPrevious(ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT))).id() != JsTokenId.OPERATOR_DOT) break;
                if (!ts.movePrevious()) break;
                token = ts.token();
            }
            return exp;
        }
        return Collections.emptyList();
    }

    private void completeObjectMember(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        JsParserResult result = (JsParserResult)request.info;
        JsObject jsObject = (JsObject)((Object)ModelUtils.getDeclarationScope(result.getModel(), request.anchor));
        HashMap<String, JsElement> properties = new HashMap<String, JsElement>();
        if (jsObject.getJSKind() == JsElement.Kind.METHOD) {
            jsObject = jsObject.getParent();
        }
        this.completeObjectMembers(jsObject, request, properties);
        if (jsObject.getName().equals("prototype")) {
            this.completeObjectMembers(jsObject.getParent(), request, properties);
        }
        for (JsElement element : properties.values()) {
            if (element instanceof JsObject) {
                resultList.add(JsCompletionItem.Factory.create((JsObject)element, request));
                continue;
            }
            if (!(element instanceof IndexedElement)) continue;
            resultList.add(JsCompletionItem.Factory.create((IndexedElement)element, request));
        }
    }

    private void completeObjectMembers(JsObject jsObject, JsCompletionItem.CompletionRequest request, HashMap<String, JsElement> properties) {
        if (jsObject.getJSKind() == JsElement.Kind.OBJECT || jsObject.getJSKind() == JsElement.Kind.CONSTRUCTOR) {
            for (JsObject jsObject2 : jsObject.getProperties().values()) {
                JsElement element;
                if (jsObject2.getModifiers().contains(Modifier.PRIVATE) || !this.startsWith(jsObject2.getName(), request.prefix) || (element = properties.get(jsObject2.getName())) != null && (element.isDeclared() || !jsObject2.isDeclared())) continue;
                properties.put(jsObject2.getName(), jsObject2);
            }
        }
        String fqn = ModelUtils.createFQN(jsObject);
        FileObject fileObject = request.info.getSnapshot().getSource().getFileObject();
        Collection<IndexedElement> indexedProperties = JsIndex.get(fileObject).getProperties(fqn);
        for (IndexedElement indexedElement : indexedProperties) {
            JsElement element;
            if (!this.startsWith(indexedElement.getName(), request.prefix) || (element = properties.get(indexedElement.getName())) != null && (element.isDeclared() || !indexedElement.isDeclared())) continue;
            properties.put(indexedElement.getName(), indexedElement);
        }
    }

    private void completeKeywords(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        for (String keyword : JsKeyWords.KEYWORDS.keySet()) {
            if (!this.startsWith(keyword, request.prefix)) continue;
            resultList.add(new JsCompletionItem.KeywordItem(keyword, request));
        }
    }

    private boolean startsWith(String theString, String prefix) {
        if (prefix.length() == 0) {
            return true;
        }
        return this.caseSensitive ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private boolean processTypeInModel(JsCompletionItem.CompletionRequest request, Model model, TypeUsage type, List<JsObject> lastResolvedObjects, boolean prop, JsIndex index, HashMap<String, JsElement> addedProperties) {
        if (++this.checkRecursion > 10) {
            return false;
        }
        boolean isFunction = false;
        JsObject jsObject = ModelUtils.findJsObjectByName(model, type.getType());
        if (jsObject != null) {
            lastResolvedObjects.add(jsObject);
        }
        for (JsObject libGlobal : this.getLibrariesGlobalObjects()) {
            for (JsObject jsObject2 : libGlobal.getProperties().values()) {
                if (!jsObject2.getName().equals(type.getType())) continue;
                jsObject = jsObject2;
                lastResolvedObjects.add(jsObject);
                break;
            }
            if (jsObject == null) continue;
            break;
        }
        if (jsObject == null || !jsObject.isDeclared()) {
            boolean isObject = type.getType().equals("Object");
            if (prop && !isObject) {
                for (IndexResult indexResult : index.findFQN(type.getType())) {
                    JsElement.Kind kind = IndexedElement.Flag.getJsKind(Integer.parseInt(indexResult.getValue("flag")));
                    if (!kind.isFunction()) continue;
                    isFunction = true;
                }
            }
            if (!isObject) {
                this.addObjectPropertiesFromIndex(type.getType(), index, request, addedProperties);
            }
        } else if (jsObject.getDeclarationName() != null) {
            Collection<? extends TypeUsage> assignments = jsObject.getAssignmentForOffset(jsObject.getDeclarationName().getOffsetRange().getEnd());
            for (TypeUsage typeUsage : assignments) {
                boolean bl = this.processTypeInModel(request, model, typeUsage, lastResolvedObjects, prop, index, addedProperties);
                isFunction = isFunction ? true : bl;
            }
        }
        return isFunction;
    }

    private void addObjectPropertiesToCC(JsObject jsObject, JsCompletionItem.CompletionRequest request, Map<String, JsElement> addedProperties) {
        JsObject prototype;
        boolean filter = true;
        if (request.prefix == null || request.prefix.isEmpty()) {
            filter = false;
        }
        if ((prototype = jsObject.getProperty("prototype")) != null) {
            this.addObjectPropertiesToCC(prototype, request, addedProperties);
        }
        for (JsObject jsObject2 : jsObject.getProperties().values()) {
            JsElement element;
            String propertyName = jsObject2.getName();
            if (jsObject2 instanceof JsFunction && ((JsFunction)jsObject2).isAnonymous() || jsObject2.getModifiers().contains(Modifier.PRIVATE) || filter && !this.startsWith(propertyName, request.prefix) || jsObject2.getJSKind().isPropertyGetterSetter() || (element = addedProperties.get(propertyName)) != null && (element.isDeclared() || !jsObject.isDeclared())) continue;
            addedProperties.put(propertyName, jsObject2);
        }
    }

    private void addObjectPropertiesFromIndex(String fqn, JsIndex jsIndex, JsCompletionItem.CompletionRequest request, Map<String, JsElement> addedProperties) {
        JsElement element;
        Collection<IndexedElement> properties = jsIndex.getProperties(fqn);
        String prototypeFQN = null;
        for (IndexedElement indexedElement : properties) {
            element = addedProperties.get(indexedElement.getName());
            if (this.startsWith(indexedElement.getName(), request.prefix) && (element == null || !element.isDeclared() && indexedElement.isDeclared())) {
                addedProperties.put(indexedElement.getName(), indexedElement);
            }
            if (!"prototype".equals(indexedElement.getName())) continue;
            prototypeFQN = indexedElement.getFQN();
        }
        if (prototypeFQN != null) {
            properties = jsIndex.getProperties(prototypeFQN);
            for (IndexedElement indexedElement : properties) {
                element = addedProperties.get(indexedElement.getName());
                if (!this.startsWith(indexedElement.getName(), request.prefix) || element != null && (element.isDeclared() || !indexedElement.isDeclared())) continue;
                addedProperties.put(indexedElement.getName(), indexedElement);
            }
        }
    }

    private Collection<JsObject> getLibrariesGlobalObjects() {
        ArrayList<JsObject> result = new ArrayList<JsObject>();
        JsObject libGlobal = JQueryModel.getGlobalObject();
        if (libGlobal != null) {
            result.add(libGlobal);
        }
        return result;
    }

    private Map<String, JsElement> getDomCompletionResults(JsCompletionItem.CompletionRequest request) {
        HashMap<String, JsElement> result = new HashMap<String, JsElement>(1);
        result.putAll(this.getCompletionFromExpressionChain(request, WINDOW_EXPRESSION_CHAIN));
        return result;
    }

    private static int getPrefixIndexFromSequence(String prefix) {
        int spaceIndex = prefix.lastIndexOf(" ") + 1;
        int dotIndex = prefix.lastIndexOf(".");
        int hashIndex = prefix.lastIndexOf("#");
        return Math.max(0, Math.max(hashIndex, Math.max(dotIndex, spaceIndex)));
    }
}

