/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.Arrays;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.lexer.LexUtilities;

public class CompletionContextFinder {
    private static final List<JsTokenId> WHITESPACES_TOKENS = Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL);
    private static final List<JsTokenId> CHANGE_CONTEXT_TOKENS = Arrays.asList(JsTokenId.OPERATOR_SEMICOLON, JsTokenId.BRACKET_LEFT_CURLY, JsTokenId.BRACKET_RIGHT_CURLY);
    private static final List<Object[]> OBJECT_PROPERTY_TOKENCHAINS = Arrays.asList({JsTokenId.OPERATOR_DOT}, {JsTokenId.OPERATOR_DOT, JsTokenId.IDENTIFIER});
    private static final List<Object[]> OBJECT_THIS_TOKENCHAINS = Arrays.asList({JsTokenId.KEYWORD_THIS, JsTokenId.OPERATOR_DOT}, {JsTokenId.KEYWORD_THIS, JsTokenId.OPERATOR_DOT, JsTokenId.IDENTIFIER});

    @NonNull
    static CompletionContext findCompletionContext(ParserResult info, int caretOffset) {
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return CompletionContext.NONE;
        }
        TokenSequence ts = th.tokenSequence(JsTokenId.javascriptLanguage());
        if (ts == null) {
            return CompletionContext.NONE;
        }
        int offset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return CompletionContext.NONE;
        }
        Token<? extends JsTokenId> token = ts.token();
        JsTokenId tokenId = (JsTokenId)token.id();
        if (CompletionContextFinder.acceptTokenChains(ts, OBJECT_THIS_TOKENCHAINS, true)) {
            return CompletionContext.OBJECT_MEMBERS;
        }
        if (CompletionContextFinder.acceptTokenChains(ts, OBJECT_PROPERTY_TOKENCHAINS, tokenId != JsTokenId.OPERATOR_DOT)) {
            return CompletionContext.OBJECT_PROPERTY;
        }
        if (tokenId == JsTokenId.EOL && ts.movePrevious()) {
            token = ts.token();
            tokenId = (JsTokenId)token.id();
        }
        if (tokenId == JsTokenId.IDENTIFIER || WHITESPACES_TOKENS.contains((Object)tokenId)) {
            if (!ts.movePrevious()) {
                return CompletionContext.GLOBAL;
            }
            token = LexUtilities.findPrevious((TokenSequence<? extends JsTokenId>)ts, WHITESPACES_TOKENS);
        }
        if (CHANGE_CONTEXT_TOKENS.contains(token.id()) || WHITESPACES_TOKENS.contains(token.id()) && !ts.movePrevious()) {
            return CompletionContext.GLOBAL;
        }
        if (tokenId == JsTokenId.DOC_COMMENT) {
            return CompletionContext.DOCUMENTATION;
        }
        return CompletionContext.EXPRESSION;
    }

    private static boolean acceptTokenChains(TokenSequence tokenSequence, List<Object[]> tokenIdChains, boolean movePrevious) {
        for (Object[] tokenIDChain : tokenIdChains) {
            if (!CompletionContextFinder.acceptTokenChain(tokenSequence, tokenIDChain, movePrevious)) continue;
            return true;
        }
        return false;
    }

    private static boolean acceptTokenChain(TokenSequence tokenSequence, Object[] tokenIdChain, boolean movePrevious) {
        int orgTokenSequencePos = tokenSequence.offset();
        boolean accept = true;
        boolean moreTokens = movePrevious ? tokenSequence.movePrevious() : true;
        for (int i = tokenIdChain.length - 1; i >= 0; --i) {
            Object tokenID = tokenIdChain[i];
            if (!moreTokens) {
                accept = false;
                break;
            }
            if (tokenID instanceof JsTokenId) {
                if (tokenSequence.token().id() == tokenID) {
                    moreTokens = tokenSequence.movePrevious();
                    continue;
                }
                accept = false;
                break;
            }
            assert (false) : "Unsupported token type: " + tokenID.getClass().getName();
        }
        tokenSequence.move(orgTokenSequencePos);
        tokenSequence.moveNext();
        return accept;
    }

    public static enum CompletionContext {
        NONE,
        EXPRESSION,
        OBJECT_PROPERTY,
        OBJECT_MEMBERS,
        DOCUMENTATION,
        GLOBAL;

    }
}

