/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.overrides;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.EditorAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.overrides.AnnotationsHolder;
import org.netbeans.modules.cnd.navigation.overrides.BaseAnnotation;
import org.netbeans.modules.cnd.navigation.overrides.ComputeAnnotations;
import org.netbeans.modules.cnd.utils.ui.NamedOption;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class OverrideTaskFactory
extends EditorAwareCsmFileTaskFactory {
    private static final int TASK_DELAY = OverrideTaskFactory.getInt("cnd.overrides.delay", 500);
    private static final int RESCHEDULE_DELAY = OverrideTaskFactory.getInt("cnd.overrides.reschedule.delay", 500);

    private static boolean isEnabled() {
        return NamedOption.getAccessor().getBoolean("overrides-annotations");
    }

    protected CsmFileTaskFactory.PhaseRunner createTask(FileObject fo) {
        CsmFileTaskFactory.PhaseRunner pr = null;
        if (OverrideTaskFactory.isEnabled()) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                CsmFile file = CsmUtilities.getCsmFile((DataObject)dobj, (boolean)false, (boolean)false);
                StyledDocument doc = ec.getDocument();
                if (doc != null && file != null) {
                    pr = new PhaseRunnerImpl(dobj, file, doc);
                }
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace(System.err);
            }
        }
        return pr != null ? pr : OverrideTaskFactory.lazyRunner();
    }

    protected int taskDelay() {
        return TASK_DELAY;
    }

    protected int rescheduleDelay() {
        return RESCHEDULE_DELAY;
    }

    private static int getInt(String name, int result) {
        String text = System.getProperty(name);
        if (text != null) {
            try {
                result = Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private static final class PhaseRunnerImpl
    implements CsmFileTaskFactory.PhaseRunner {
        private final DataObject dobj;
        private final CsmFile file;
        private final WeakReference<StyledDocument> weakDoc;

        private PhaseRunnerImpl(DataObject dobj, CsmFile file, Document doc) {
            this.dobj = dobj;
            this.file = file;
            this.weakDoc = doc instanceof StyledDocument ? new WeakReference<StyledDocument>((StyledDocument)doc) : null;
        }

        public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
            if (!OverrideTaskFactory.isEnabled()) {
                AnnotationsHolder.clearIfNeed(this.dobj);
                return;
            }
            StyledDocument doc = this.getDocument();
            if (doc != null) {
                if (phase == CsmFileTaskFactory.PhaseRunner.Phase.PARSED || phase == CsmFileTaskFactory.PhaseRunner.Phase.INIT || phase == CsmFileTaskFactory.PhaseRunner.Phase.PROJECT_PARSED) {
                    this.addAnnotations(this.file, doc, this.dobj);
                } else if (phase == CsmFileTaskFactory.PhaseRunner.Phase.CLEANUP) {
                    this.clearAnnotations(doc, this.dobj);
                }
            }
        }

        protected StyledDocument getDocument() {
            return this.weakDoc != null ? (StyledDocument)this.weakDoc.get() : null;
        }

        private void addAnnotations(CsmFile file, StyledDocument doc, DataObject dobj) {
            ArrayList<BaseAnnotation> toAdd = new ArrayList<BaseAnnotation>();
            BaseAnnotation.LOGGER.log(Level.FINE, ">> Computing annotations for {0}", file);
            long time = System.currentTimeMillis();
            ComputeAnnotations.getInstance(file, doc, dobj).computeAnnotations(toAdd);
            time = System.currentTimeMillis() - time;
            BaseAnnotation.LOGGER.log(Level.FINE, "<< Computed sannotations for {0} in {1} ms", new Object[]{file, time});
            AnnotationsHolder.get(dobj).setNewAnnotations(toAdd);
        }

        private void clearAnnotations(StyledDocument doc, DataObject dobj) {
            AnnotationsHolder.clearIfNeed(dobj);
        }

        public boolean isValid() {
            return true;
        }

        public void cancel() {
        }

        public boolean isHighPriority() {
            return false;
        }

        public String toString() {
            if (this.file == null) {
                return "OverrideTaskFactory runner";
            }
            return "OverrideTaskFactory runner for " + this.file.getAbsolutePath();
        }
    }

    public static final class OverrideOptions
    extends NamedOption {
        private static final String NAME = "overrides-annotations";

        public String getName() {
            return NAME;
        }

        public NamedOption.OptionKind getKind() {
            return NamedOption.OptionKind.Boolean;
        }

        public Object getDefaultValue() {
            return true;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OverrideTaskFactory.class, (String)"Show-overrides-annotations");
        }

        public String getDescription() {
            return NbBundle.getMessage(OverrideTaskFactory.class, (String)"Show-overrides-annotations-AD");
        }
    }
}

