/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.macroview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.Document;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionTopComponent;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionViewUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MacroExpansionPanel
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    public static final String ICON_PATH = "org/netbeans/modules/cnd/navigation/macroview/resources/macroexpansion.png";
    private transient ExplorerManager explorerManager = new ExplorerManager();
    private JToggleButton autoRefresh;
    private JToggleButton fileContext;
    private JEditorPane jCodeExpansionEditorPane;
    private JScrollPane jCodeExpansionPane;
    private JPanel jPanel1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator4;
    private JLabel jStatusBar;
    private JToolBar jToolBar1;
    private JToggleButton localContext;
    private JButton nextMacro;
    private JButton prevMacro;

    public MacroExpansionPanel(boolean isView) {
        this.initComponents();
        this.jCodeExpansionEditorPane.putClientProperty("CND_EDITOR_COMPONENT", Boolean.TRUE);
        this.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_MacroExpansionTopComponent"));
        this.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"HINT_MacroExpansionTopComponent"));
    }

    public void setContextExpansionDocument(Document doc) {
        String mimeType = DocumentUtilities.getMimeType((Document)doc);
        if (mimeType == null) {
            mimeType = "text/x-c++";
        }
        this.jCodeExpansionEditorPane.setCaretPosition(0);
        this.jCodeExpansionEditorPane.setContentType(mimeType);
        this.jCodeExpansionEditorPane.setDocument(doc);
        doc.putProperty(JEditorPane.class, this.jCodeExpansionEditorPane);
    }

    public boolean isLocalContext() {
        return this.localContext.isSelected();
    }

    public void setLocalContext(boolean local) {
        Document doc = this.jCodeExpansionEditorPane.getDocument();
        if (doc == null) {
            return;
        }
        doc.putProperty("macro-expansion-sync-context", this.isSyncCaretAndContext() && local);
        this.localContext.setSelected(local);
        this.fileContext.setSelected(!local);
    }

    public boolean isSyncCaretAndContext() {
        return this.autoRefresh.isSelected();
    }

    public void setSyncCaretAndContext(boolean sync) {
        Document doc = this.jCodeExpansionEditorPane.getDocument();
        if (doc == null) {
            return;
        }
        doc.putProperty("macro-expansion-sync-caret", sync);
        doc.putProperty("macro-expansion-sync-context", sync && this.isLocalContext());
        this.autoRefresh.setSelected(sync);
    }

    public void setStatusBarText(String s) {
        this.jStatusBar.setText(s);
    }

    public void updateCaretPosition() {
        this.jCodeExpansionEditorPane.setCaretPosition(this.getCursorPositionFromMainDocument());
    }

    private int getCursorPositionFromMainDocument() {
        Document doc = this.jCodeExpansionEditorPane.getDocument();
        if (doc == null) {
            return 0;
        }
        Document doc2 = (Document)doc.getProperty(Document.class);
        if (doc2 == null) {
            return 0;
        }
        int docCarretPosition = MacroExpansionViewUtils.getDocumentOffset(doc, MacroExpansionViewUtils.getFileOffset(doc2, this.getMainDocumentCursorPosition()));
        if (docCarretPosition >= 0 && docCarretPosition < doc.getLength()) {
            return docCarretPosition;
        }
        return 0;
    }

    private int getMainDocumentCursorPosition() {
        JEditorPane ep;
        FileObject file2;
        Document doc = this.jCodeExpansionEditorPane.getDocument();
        if (doc == null) {
            return 0;
        }
        Document doc2 = (Document)doc.getProperty(Document.class);
        if (doc2 != null && (file2 = CsmUtilities.getFileObject((Document)doc2)) != null && (ep = MacroExpansionViewUtils.getEditor(doc2)) != null) {
            int doc2CarretPosition = ep.getCaretPosition();
            return doc2CarretPosition;
        }
        return 0;
    }

    private void update() {
        Document doc = this.jCodeExpansionEditorPane.getDocument();
        if (doc == null) {
            return;
        }
        Document mainDoc = (Document)doc.getProperty(Document.class);
        if (mainDoc == null) {
            return;
        }
        JEditorPane ep = MacroExpansionViewUtils.getEditor(doc);
        if (ep == null) {
            return;
        }
        int offset = MacroExpansionViewUtils.getDocumentOffset(mainDoc, MacroExpansionViewUtils.getFileOffset(doc, ep.getCaretPosition()));
        CsmMacroExpansion.showMacroExpansionView((Document)mainDoc, (int)offset);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jCodeExpansionPane = new JScrollPane();
        this.jCodeExpansionEditorPane = new JEditorPane();
        this.jStatusBar = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.autoRefresh = new JToggleButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.localContext = new JToggleButton();
        this.fileContext = new JToggleButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.prevMacro = new JButton();
        this.nextMacro = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanel1.setMaximumSize(new Dimension(100, 100));
        this.jPanel1.setMinimumSize(new Dimension(100, 100));
        this.jPanel1.setLayout(new BorderLayout());
        this.jCodeExpansionPane.setBorder(null);
        this.jCodeExpansionEditorPane.setBorder(null);
        this.jCodeExpansionPane.setViewportView(this.jCodeExpansionEditorPane);
        this.jPanel1.add((Component)this.jCodeExpansionPane, "Center");
        this.jStatusBar.setText(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.jStatusBar.text"));
        this.jPanel1.add((Component)this.jStatusBar, "Last");
        this.add((Component)this.jPanel1, "Center");
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMaximumSize(new Dimension(28, 240));
        this.jToolBar1.setPreferredSize(new Dimension(28, 240));
        this.autoRefresh.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/macroview/resources/sync.png")));
        this.autoRefresh.setToolTipText(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.autoRefresh.toolTipText"));
        this.autoRefresh.setFocusable(false);
        this.autoRefresh.setHorizontalTextPosition(0);
        this.autoRefresh.setMaximumSize(new Dimension(24, 24));
        this.autoRefresh.setMinimumSize(new Dimension(24, 24));
        this.autoRefresh.setPreferredSize(new Dimension(24, 24));
        this.autoRefresh.setVerticalTextPosition(3);
        this.autoRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroExpansionPanel.this.autoRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.autoRefresh);
        this.jSeparator1.setSeparatorSize(new Dimension(0, 4));
        this.jToolBar1.add(this.jSeparator1);
        this.localContext.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/macroview/resources/declscope.png")));
        this.localContext.setToolTipText(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.localContext.toolTipText"));
        this.localContext.setFocusable(false);
        this.localContext.setHorizontalTextPosition(0);
        this.localContext.setMaximumSize(new Dimension(24, 24));
        this.localContext.setMinimumSize(new Dimension(24, 24));
        this.localContext.setPreferredSize(new Dimension(24, 24));
        this.localContext.setVerticalTextPosition(3);
        this.localContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroExpansionPanel.this.localContextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.localContext);
        this.fileContext.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/macroview/resources/filescope.png")));
        this.fileContext.setToolTipText(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.fileContext.toolTipText"));
        this.fileContext.setFocusable(false);
        this.fileContext.setHorizontalTextPosition(0);
        this.fileContext.setMaximumSize(new Dimension(24, 24));
        this.fileContext.setMinimumSize(new Dimension(24, 24));
        this.fileContext.setPreferredSize(new Dimension(24, 24));
        this.fileContext.setVerticalTextPosition(3);
        this.fileContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroExpansionPanel.this.fileContextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.fileContext);
        this.fileContext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.localContext.AccessibleContext.accessibleDescription"));
        this.jSeparator4.setSeparatorSize(new Dimension(0, 4));
        this.jToolBar1.add(this.jSeparator4);
        this.prevMacro.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/macroview/resources/prevmacro.png")));
        this.prevMacro.setToolTipText(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.prevMacro.toolTipText"));
        this.prevMacro.setFocusable(false);
        this.prevMacro.setHorizontalTextPosition(0);
        this.prevMacro.setMaximumSize(new Dimension(24, 24));
        this.prevMacro.setMinimumSize(new Dimension(24, 24));
        this.prevMacro.setPreferredSize(new Dimension(24, 24));
        this.prevMacro.setVerticalTextPosition(3);
        this.prevMacro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroExpansionPanel.this.prevMacroActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.prevMacro);
        this.prevMacro.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.prevMacro.AccessibleContext.accessibleDescription"));
        this.nextMacro.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/macroview/resources/nextmacro.png")));
        this.nextMacro.setToolTipText(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.nextMacro.toolTipText"));
        this.nextMacro.setFocusable(false);
        this.nextMacro.setHorizontalTextPosition(0);
        this.nextMacro.setMaximumSize(new Dimension(24, 24));
        this.nextMacro.setMinimumSize(new Dimension(24, 24));
        this.nextMacro.setPreferredSize(new Dimension(24, 24));
        this.nextMacro.setVerticalTextPosition(3);
        this.nextMacro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroExpansionPanel.this.nextMacroActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.nextMacro);
        this.nextMacro.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MacroExpansionPanel.class, (String)"MacroExpansionPanel.nextMacro.AccessibleContext.accessibleDescription"));
        this.add((Component)this.jToolBar1, "Before");
    }

    private void nextMacroActionPerformed(ActionEvent evt) {
        Document doc = this.jCodeExpansionEditorPane.getDocument();
        if (doc == null) {
            return;
        }
        int offset = CsmMacroExpansion.getNextMacroExpansionStartOffset((Document)doc, (int)this.jCodeExpansionEditorPane.getCaretPosition());
        if (offset >= 0 && offset < doc.getLength()) {
            this.jCodeExpansionEditorPane.setCaretPosition(offset);
        }
    }

    private void prevMacroActionPerformed(ActionEvent evt) {
        Document doc = this.jCodeExpansionEditorPane.getDocument();
        if (doc == null) {
            return;
        }
        int offset = CsmMacroExpansion.getPrevMacroExpansionStartOffset((Document)doc, (int)this.jCodeExpansionEditorPane.getCaretPosition());
        if (offset >= 0 && offset < doc.getLength()) {
            this.jCodeExpansionEditorPane.setCaretPosition(offset);
        }
    }

    private void localContextActionPerformed(ActionEvent evt) {
        this.fileContext.setSelected(false);
        this.localContext.setSelected(true);
        MacroExpansionTopComponent.setLocalContext(true);
        this.update();
    }

    private void fileContextActionPerformed(ActionEvent evt) {
        this.fileContext.setSelected(true);
        this.localContext.setSelected(false);
        MacroExpansionTopComponent.setLocalContext(false);
        this.update();
    }

    private void autoRefreshActionPerformed(ActionEvent evt) {
        Document doc = this.jCodeExpansionEditorPane.getDocument();
        if (doc == null) {
            return;
        }
        if (this.isSyncCaretAndContext()) {
            doc.putProperty("macro-expansion-sync-caret", true);
            doc.putProperty("macro-expansion-sync-context", this.isLocalContext());
            this.update();
        } else {
            doc.putProperty("macro-expansion-sync-caret", false);
            doc.putProperty("macro-expansion-sync-context", false);
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.jCodeExpansionPane.requestFocusInWindow();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("MacroExpansionView");
    }
}

