/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.includeview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.navigation.includeview.IncludeNode;
import org.netbeans.modules.cnd.navigation.services.IncludedModel;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class IncludedChildren
extends Children.Keys<CsmFile> {
    private static Comparator<CsmFile> COMARATOR = new MyComparator();
    private CsmFile object;
    private IncludedChildren parent;
    private IncludedModel model;
    private boolean isInited = false;

    public IncludedChildren(CsmFile object, IncludedModel model, IncludedChildren parent) {
        this.object = object;
        this.parent = parent;
        this.model = model;
    }

    public void dispose() {
        if (this.isInited) {
            this.isInited = false;
            this.setKeys(new CsmFile[0]);
        }
    }

    private synchronized void resetKeys() {
        Set<CsmFile> set;
        if (this.object.isValid() && (set = this.model.getModel().get(this.object)) != null && set.size() > 0) {
            ArrayList<CsmFile> list = new ArrayList<CsmFile>(set);
            Collections.sort(list, COMARATOR);
            this.setKeys(list);
            return;
        }
        this.setKeys(new CsmFile[0]);
    }

    protected Node[] createNodes(CsmFile file) {
        Set<CsmFile> set = this.model.getModel().get(file);
        IncludeNode node = set == null || set.isEmpty() ? new IncludeNode(file, Children.LEAF, this.model, false) : (this.checkRecursion(file) ? new IncludeNode(file, Children.LEAF, this.model, true) : new IncludeNode(file, this.model, this));
        return new Node[]{node};
    }

    private boolean checkRecursion(CsmFile file) {
        if (file.equals(this.object)) {
            return true;
        }
        IncludedChildren arr = this.parent;
        while (arr != null) {
            if (file.equals(arr.object)) {
                return true;
            }
            arr = arr.parent;
        }
        return false;
    }

    protected void addNotify() {
        this.isInited = true;
        this.resetKeys();
        super.addNotify();
    }

    protected void removeNotify() {
        super.removeNotify();
        this.dispose();
    }

    private static class MyComparator
    implements Comparator<CsmFile> {
        private MyComparator() {
        }

        @Override
        public int compare(CsmFile o1, CsmFile o2) {
            String n1 = ((Object)o1.getName()).toString();
            String n2 = ((Object)o2.getName()).toString();
            return n1.compareTo(n2);
        }
    }
}

