/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.includeview;

import java.awt.Image;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.AbstractCsmNode;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.includeview.GoToFileAction;
import org.netbeans.modules.cnd.navigation.includeview.IncludedChildren;
import org.netbeans.modules.cnd.navigation.services.IncludedModel;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class IncludeNode
extends AbstractCsmNode {
    private CsmFile object;
    private IncludedModel model;
    private boolean isRoot = false;
    private static Image downBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/navigation/includeview/resources/down_20.png");
    private static Image upBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/navigation/includeview/resources/up_8.png");
    private static Image emptyBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/navigation/includeview/resources/empty_20.png");

    public IncludeNode(CsmFile element, IncludedModel model, IncludedChildren parent) {
        this(element, (Children)new IncludedChildren(element, model, parent), model, false);
        this.isRoot = parent == null;
    }

    public IncludeNode(CsmFile element, Children children, IncludedModel model, boolean recursion) {
        super(children);
        if (recursion) {
            this.setName(element.getName() + " " + this.getString("CTL_Recuesion"));
        } else {
            this.setName(((Object)element.getName()).toString());
        }
        this.model = model;
        this.object = element;
    }

    public CsmObject getCsmObject() {
        return this.object;
    }

    public Image getIcon(int param) {
        DataObject dataObject = CsmUtilities.getDataObject((CsmFile)this.object);
        Image image = dataObject != null ? dataObject.getNodeDelegate().getIcon(param) : super.getIcon(param);
        return this.mergeBadge(image);
    }

    private Image mergeBadge(Image original) {
        if (this.model.isDownDirection()) {
            return ImageUtilities.mergeImages((Image)original, (Image)downBadge, (int)0, (int)0);
        }
        if (this.isRoot) {
            return original;
        }
        Image res = ImageUtilities.mergeImages((Image)emptyBadge, (Image)original, (int)4, (int)0);
        return ImageUtilities.mergeImages((Image)res, (Image)upBadge, (int)0, (int)0);
    }

    public int compareTo(Object o) {
        if (o instanceof IncludeNode) {
            return this.getDisplayName().compareTo(((IncludeNode)((Object)o)).getDisplayName());
        }
        return 0;
    }

    public Action getPreferredAction() {
        if (this.object.isValid()) {
            Node parent = this.getParentNode();
            if (parent instanceof IncludeNode) {
                CsmFile find = ((IncludeNode)parent).object;
                for (CsmInclude inc : this.object.getIncludes()) {
                    if (find.equals(inc.getIncludeFile())) {
                        if (!CsmKindUtilities.isOffsetable((Object)inc)) break;
                        return new GoToFileAction((CsmObject)inc, this.model.getCloseWindowAction());
                    }
                    if (!this.object.equals(inc.getIncludeFile()) || !CsmKindUtilities.isOffsetable((Object)inc)) continue;
                    return new GoToFileAction((CsmObject)inc, this.model.getCloseWindowAction());
                }
            }
            return new GoToFileAction((CsmObject)this.object, this.model.getCloseWindowAction());
        }
        return null;
    }

    public Action[] getActions(boolean context) {
        Action action = this.getPreferredAction();
        if (action != null) {
            ArrayList<Action> list = new ArrayList<Action>();
            list.add(action);
            list.add(null);
            for (Action a : this.model.getDefaultActions()) {
                list.add(a);
            }
            return list.toArray(new Action[list.size()]);
        }
        return this.model.getDefaultActions();
    }

    private String getString(String key) {
        return NbBundle.getMessage(IncludeNode.class, (String)key);
    }

    public String getShortDescription() {
        if (this.object.isValid()) {
            return ((Object)this.object.getAbsolutePath()).toString();
        }
        return super.getShortDescription();
    }
}

