/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.includeview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.navigation.hierarchy.LoadingNode;
import org.netbeans.modules.cnd.navigation.includeview.IncludeNode;
import org.netbeans.modules.cnd.navigation.services.HierarchyFactory;
import org.netbeans.modules.cnd.navigation.services.IncludedModel;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class IncludeHierarchyPanel
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    public static final String ICON_PATH = "org/netbeans/modules/cnd/navigation/includeview/resources/tree.png";
    private static final RequestProcessor RP = new RequestProcessor("IncludeHierarchyWorker", 1);
    private AbstractNode root;
    private transient ExplorerManager explorerManager = new ExplorerManager();
    private CsmUID<CsmFile> object;
    private boolean recursive = true;
    private boolean plain = true;
    private boolean whoIncludes = true;
    private Action[] actions;
    private Action close;
    private AtomicBoolean menuAvaliable = new AtomicBoolean(false);
    private ButtonGroup buttonGroup1;
    private JToggleButton directOnlyButton;
    private JScrollPane hierarchyPane;
    private JPanel jPanel2;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JButton refreshButton;
    private JToolBar toolBar;
    private JToggleButton treeButton;
    private JToggleButton whoIncludesButton;
    private JToggleButton whoIsIncludedButton;
    private static final int WHO_INCLUDES = 1;
    private static final int WHO_IS_INCLUDED = 2;
    private static final int DIRECT_ONLY = 3;
    private static final int TREE = 4;

    public IncludeHierarchyPanel(boolean isView) {
        this.initComponents();
        if (!isView) {
            this.toolBar.remove(0);
            this.toolBar.remove(0);
            this.directOnlyButton.setFocusable(true);
            this.treeButton.setFocusable(true);
            this.whoIncludesButton.setFocusable(true);
            this.whoIsIncludedButton.setFocusable(true);
        }
        this.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_IncludeViewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"HINT_IncludeViewTopComponent"));
        this.getTreeView().setRootVisible(false);
        Children.SortedArray children = new Children.SortedArray();
        this.actions = isView ? new Action[]{new RefreshAction(), null, new WhoIncludesAction(), new WhoIsIncludedAction(), null, new DirectOnlyAction(), new TreeAction()} : new Action[]{new WhoIncludesAction(), new WhoIsIncludedAction(), null, new DirectOnlyAction(), new TreeAction()};
        this.root = new AbstractNode((Children)children){

            public Action[] getActions(boolean context) {
                return IncludeHierarchyPanel.this.actions;
            }
        };
        this.getExplorerManager().setRootContext((Node)this.root);
    }

    public void setClose() {
        this.close = new DialogClose();
        this.getTreeView().addCloseAction(this.close);
    }

    public void clearClose() {
        this.close = null;
        this.getTreeView().addCloseAction(this.close);
    }

    private MyBeanTreeView getTreeView() {
        return (MyBeanTreeView)((Object)this.hierarchyPane);
    }

    private Color getBorderColor() {
        return UIManager.getDefaults().getColor("SplitPane.shadow");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.refreshButton = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.whoIncludesButton = new JToggleButton();
        this.whoIsIncludedButton = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.directOnlyButton = new JToggleButton();
        this.treeButton = new JToggleButton();
        this.jPanel2 = new JPanel();
        this.hierarchyPane = new MyBeanTreeView();
        this.setLayout(new GridBagLayout());
        this.toolBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setMaximumSize(new Dimension(182, 26));
        this.toolBar.setMinimumSize(new Dimension(182, 26));
        this.toolBar.setOpaque(false);
        this.toolBar.setPreferredSize(new Dimension(182, 26));
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/includeview/resources/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.refreshButton.toolTipText"));
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setMaximumSize(new Dimension(24, 24));
        this.refreshButton.setMinimumSize(new Dimension(24, 24));
        this.refreshButton.setPreferredSize(new Dimension(24, 24));
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IncludeHierarchyPanel.this.refreshButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.refreshButton);
        this.toolBar.add(this.jSeparator1);
        this.buttonGroup1.add(this.whoIncludesButton);
        this.whoIncludesButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/includeview/resources/who_includes.png")));
        this.whoIncludesButton.setText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.whoIncludesButton.text"));
        this.whoIncludesButton.setToolTipText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.whoIncludesButton.toolTipText"));
        this.whoIncludesButton.setFocusable(false);
        this.whoIncludesButton.setHorizontalTextPosition(0);
        this.whoIncludesButton.setMaximumSize(new Dimension(24, 24));
        this.whoIncludesButton.setMinimumSize(new Dimension(24, 24));
        this.whoIncludesButton.setPreferredSize(new Dimension(24, 24));
        this.whoIncludesButton.setVerticalTextPosition(3);
        this.whoIncludesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IncludeHierarchyPanel.this.whoIncludesButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.whoIncludesButton);
        this.buttonGroup1.add(this.whoIsIncludedButton);
        this.whoIsIncludedButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/includeview/resources/who_is_included.png")));
        this.whoIsIncludedButton.setText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.whoIsIncludedButton.text"));
        this.whoIsIncludedButton.setToolTipText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.whoIsIncludedButton.toolTipText"));
        this.whoIsIncludedButton.setFocusable(false);
        this.whoIsIncludedButton.setHorizontalTextPosition(0);
        this.whoIsIncludedButton.setMaximumSize(new Dimension(24, 24));
        this.whoIsIncludedButton.setMinimumSize(new Dimension(24, 24));
        this.whoIsIncludedButton.setPreferredSize(new Dimension(24, 24));
        this.whoIsIncludedButton.setVerticalTextPosition(3);
        this.whoIsIncludedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IncludeHierarchyPanel.this.whoIsIncludedButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.whoIsIncludedButton);
        this.toolBar.add(this.jSeparator2);
        this.directOnlyButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/includeview/resources/direct_only.png")));
        this.directOnlyButton.setText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.directOnlyButton.text"));
        this.directOnlyButton.setToolTipText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.directOnlyButton.toolTipText"));
        this.directOnlyButton.setFocusable(false);
        this.directOnlyButton.setHorizontalTextPosition(0);
        this.directOnlyButton.setMaximumSize(new Dimension(24, 24));
        this.directOnlyButton.setMinimumSize(new Dimension(24, 24));
        this.directOnlyButton.setPreferredSize(new Dimension(24, 24));
        this.directOnlyButton.setVerticalTextPosition(3);
        this.directOnlyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IncludeHierarchyPanel.this.directOnlyButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.directOnlyButton);
        this.treeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/includeview/resources/tree.png")));
        this.treeButton.setText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.treeButton.text"));
        this.treeButton.setToolTipText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.treeButton.toolTipText"));
        this.treeButton.setFocusable(false);
        this.treeButton.setHorizontalTextPosition(0);
        this.treeButton.setMaximumSize(new Dimension(24, 24));
        this.treeButton.setMinimumSize(new Dimension(24, 24));
        this.treeButton.setPreferredSize(new Dimension(24, 24));
        this.treeButton.setVerticalTextPosition(3);
        this.treeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IncludeHierarchyPanel.this.treeButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.treeButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)this.toolBar, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createLineBorder(this.getBorderColor()));
        this.jPanel2.setFocusable(false);
        this.jPanel2.setMinimumSize(new Dimension(1, 1));
        this.jPanel2.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.hierarchyPane.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.hierarchyPane, gridBagConstraints);
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        CsmFile file;
        if (this.object != null && (file = (CsmFile)this.object.getObject()) != null) {
            this.update(file);
        }
    }

    private void whoIncludesButtonActionPerformed(ActionEvent evt) {
        this.setWhoIncludes(true);
    }

    private void whoIsIncludedButtonActionPerformed(ActionEvent evt) {
        this.setWhoIncludes(false);
    }

    private void directOnlyButtonActionPerformed(ActionEvent evt) {
        this.setRecursive(!this.directOnlyButton.isSelected());
    }

    private void treeButtonActionPerformed(ActionEvent evt) {
        this.setPlain(!this.treeButton.isSelected());
    }

    private void setRecursive(boolean isRecursive) {
        CsmFile file;
        if (this.object != null && (file = (CsmFile)this.object.getObject()) != null) {
            this.recursive = isRecursive;
            this.updateButtons();
            this.update(file);
        }
    }

    private void setPlain(boolean isPlain) {
        CsmFile file;
        if (this.object != null && (file = (CsmFile)this.object.getObject()) != null) {
            this.plain = isPlain;
            this.updateButtons();
            this.update(file);
        }
    }

    private void setWhoIncludes(boolean isWhoIncludes) {
        CsmFile file;
        if (this.object != null && (file = (CsmFile)this.object.getObject()) != null) {
            this.whoIncludes = isWhoIncludes;
            this.updateButtons();
            this.update(file);
        }
    }

    public void setFile(CsmFile file) {
        if (file != null) {
            this.object = UIDs.get((Object)file);
            if (file.isHeaderFile()) {
                this.recursive = false;
                this.plain = true;
                this.whoIncludes = true;
            } else {
                this.recursive = true;
                this.plain = false;
                this.whoIncludes = false;
            }
        }
        this.update(file);
    }

    public void setWaiting() {
        this.menuAvaliable.set(false);
        this.updateButtons();
        final Children children = this.root.getChildren();
        if (!Children.MUTEX.isReadAccess()) {
            Children.MUTEX.writeAccess(new Runnable(){

                @Override
                public void run() {
                    children.remove(children.getNodes());
                    children.add(new Node[]{new LoadingNode()});
                }
            });
        }
    }

    public void setEmpty() {
        this.menuAvaliable.set(false);
        this.updateButtons();
        final Children children = this.root.getChildren();
        if (!Children.MUTEX.isReadAccess()) {
            Children.MUTEX.writeAccess(new Runnable(){

                @Override
                public void run() {
                    children.remove(children.getNodes());
                }
            });
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.hierarchyPane.requestFocusInWindow();
    }

    private void updateButtons() {
        this.whoIncludesButton.setSelected(this.whoIncludes);
        this.whoIsIncludedButton.setSelected(!this.whoIncludes);
        this.directOnlyButton.setSelected(!this.recursive);
        this.treeButton.setSelected(!this.plain);
        this.refreshButton.setEnabled(this.menuAvaliable.get());
        this.whoIncludesButton.setEnabled(this.menuAvaliable.get());
        this.whoIsIncludedButton.setEnabled(this.menuAvaliable.get());
        this.directOnlyButton.setEnabled(this.menuAvaliable.get());
        this.treeButton.setEnabled(this.menuAvaliable.get());
    }

    private synchronized void update(CsmFile csmFile) {
        if (csmFile != null) {
            Node[] oldSelection = this.getExplorerManager().getSelectedNodes();
            Children children = this.root.getChildren();
            this.setWaiting();
            Updater updater = new Updater(csmFile, oldSelection, children);
            RP.post((Runnable)updater);
        } else {
            this.setEmpty();
        }
    }

    public final ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private ImageIcon getButtonIcon(int kind) {
        String path = null;
        switch (kind) {
            case 1: {
                path = "/org/netbeans/modules/cnd/navigation/includeview/resources/who_includes.png";
                break;
            }
            case 2: {
                path = "/org/netbeans/modules/cnd/navigation/includeview/resources/who_is_included.png";
                break;
            }
            case 3: {
                path = "/org/netbeans/modules/cnd/navigation/includeview/resources/direct_only.png";
                break;
            }
            case 4: {
                path = "/org/netbeans/modules/cnd/navigation/includeview/resources/tree.png";
            }
        }
        return new ImageIcon(this.getClass().getResource(path));
    }

    private String getButtonTooltip(int kind) {
        String path = null;
        switch (kind) {
            case 1: {
                path = "IncludeHierarchyPanel.whoIncludesButton.menuText";
                break;
            }
            case 2: {
                path = "IncludeHierarchyPanel.whoIsIncludedButton.menuText";
                break;
            }
            case 3: {
                path = "IncludeHierarchyPanel.directOnlyButton.menuText";
                break;
            }
            case 4: {
                path = "IncludeHierarchyPanel.treeButton.menuText";
            }
        }
        return NbBundle.getMessage(this.getClass(), (String)path);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("IncludeView");
    }

    private class Updater
    implements Runnable {
        private final CsmFile csmFile;
        private final Node[] oldSelection;
        private final Children children;
        private Node node;
        private IncludedModel model;

        private Updater(CsmFile csmFile, Node[] oldSelection, Children children) {
            this.csmFile = csmFile;
            this.oldSelection = oldSelection;
            this.children = children;
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                if (!Children.MUTEX.isReadAccess()) {
                    Children.MUTEX.writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            Updater.this.children.remove(Updater.this.children.getNodes());
                            Updater.this.children.add(new Node[]{Updater.this.node});
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    IncludeHierarchyPanel.this.menuAvaliable.set(true);
                                    IncludeHierarchyPanel.this.updateButtons();
                                    ((BeanTreeView)IncludeHierarchyPanel.this.hierarchyPane).expandNode(Updater.this.node);
                                    Node selected = Updater.this.findSelection();
                                    try {
                                        IncludeHierarchyPanel.this.getExplorerManager().setSelectedNodes(new Node[]{selected});
                                    }
                                    catch (PropertyVetoException propertyVetoException) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                    });
                }
            } else {
                this.model = HierarchyFactory.getInstance().buildIncludeHierarchyModel(this.csmFile, IncludeHierarchyPanel.this.actions, IncludeHierarchyPanel.this.whoIncludes, IncludeHierarchyPanel.this.plain, IncludeHierarchyPanel.this.recursive);
                this.model.setCloseWindowAction(IncludeHierarchyPanel.this.close);
                this.node = new IncludeNode(this.csmFile, this.model, null);
                SwingUtilities.invokeLater(this);
            }
        }

        private Node findSelection() {
            if (this.oldSelection != null && this.oldSelection.length == 1 && this.oldSelection[0] instanceof IncludeNode) {
                CsmFile what = (CsmFile)((IncludeNode)this.oldSelection[0]).getCsmObject();
                for (Node n : this.node.getChildren().getNodes()) {
                    if (!(n instanceof IncludeNode)) continue;
                    CsmFile f2 = (CsmFile)((IncludeNode)n).getCsmObject();
                    if (what == null || f2 == null || !what.getAbsolutePath().equals(f2.getAbsolutePath())) continue;
                    return n;
                }
                return this.findInModel(what);
            }
            return this.node;
        }

        private Node findInModel(CsmFile what) {
            ArrayList<CsmFile> path = new ArrayList<CsmFile>();
            HashSet<CsmFile> antiLoop = new HashSet<CsmFile>();
            Node n = this.node;
            if (this.findInModel(this.csmFile, what, path, 25, antiLoop)) {
                block0: for (int i = path.size() - 1; i >= 0; --i) {
                    CsmFile f1 = (CsmFile)path.get(i);
                    ((BeanTreeView)IncludeHierarchyPanel.this.hierarchyPane).expandNode(n);
                    for (Node c : n.getChildren().getNodes()) {
                        CsmFile f2 = (CsmFile)((IncludeNode)c).getCsmObject();
                        if (f1 == null || f2 == null || !f1.getAbsolutePath().equals(f2.getAbsolutePath())) continue;
                        n = c;
                        continue block0;
                    }
                }
            }
            return n;
        }

        private boolean findInModel(CsmFile root, CsmFile what, List<CsmFile> path, int level, Set<CsmFile> antiLoop) {
            if (level < 0 || antiLoop.contains(root)) {
                return false;
            }
            antiLoop.add(root);
            Set<CsmFile> set = this.model.getModel().get(root);
            if (set != null) {
                for (CsmFile f : set) {
                    if (!f.getAbsolutePath().equals(what.getAbsolutePath())) continue;
                    path.add(f);
                    return true;
                }
                for (CsmFile f : set) {
                    if (!this.findInModel(f, what, path, level - 1, antiLoop)) continue;
                    path.add(f);
                    return true;
                }
            }
            return false;
        }
    }

    private class DialogClose
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            for (Container p = IncludeHierarchyPanel.this; p != null; p = p.getParent()) {
                if (p instanceof TopComponent) {
                    ((TopComponent)p).close();
                    return;
                }
                if (!(p instanceof Window)) continue;
                ((Window)p).setVisible(false);
                return;
            }
        }
    }

    private static class MyBeanTreeView
    extends BeanTreeView {
        public void addCloseAction(final Action action) {
            this.tree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 27 && action != null) {
                        action.actionPerformed(null);
                        e.consume();
                    }
                    super.keyReleased(e);
                }
            });
        }
    }

    private class TreeAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public TreeAction() {
            this.putValue("Name", IncludeHierarchyPanel.this.getButtonTooltip(4));
            this.putValue("SmallIcon", IncludeHierarchyPanel.this.getButtonIcon(4));
            this.menuItem = new JCheckBoxMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IncludeHierarchyPanel.this.setPlain(!IncludeHierarchyPanel.this.plain);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!IncludeHierarchyPanel.this.plain);
            this.menuItem.setEnabled(IncludeHierarchyPanel.this.menuAvaliable.get());
            return this.menuItem;
        }
    }

    private class DirectOnlyAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public DirectOnlyAction() {
            this.putValue("Name", IncludeHierarchyPanel.this.getButtonTooltip(3));
            this.putValue("SmallIcon", IncludeHierarchyPanel.this.getButtonIcon(3));
            this.menuItem = new JCheckBoxMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IncludeHierarchyPanel.this.setRecursive(!IncludeHierarchyPanel.this.recursive);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!IncludeHierarchyPanel.this.recursive);
            this.menuItem.setEnabled(IncludeHierarchyPanel.this.menuAvaliable.get());
            return this.menuItem;
        }
    }

    private class WhoIsIncludedAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public WhoIsIncludedAction() {
            this.putValue("Name", IncludeHierarchyPanel.this.getButtonTooltip(2));
            this.putValue("SmallIcon", IncludeHierarchyPanel.this.getButtonIcon(2));
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IncludeHierarchyPanel.this.setWhoIncludes(false);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!IncludeHierarchyPanel.this.whoIncludes);
            this.menuItem.setEnabled(IncludeHierarchyPanel.this.menuAvaliable.get());
            return this.menuItem;
        }
    }

    private class WhoIncludesAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public WhoIncludesAction() {
            this.putValue("Name", IncludeHierarchyPanel.this.getButtonTooltip(1));
            this.putValue("SmallIcon", IncludeHierarchyPanel.this.getButtonIcon(1));
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IncludeHierarchyPanel.this.setWhoIncludes(true);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(IncludeHierarchyPanel.this.whoIncludes);
            this.menuItem.setEnabled(IncludeHierarchyPanel.this.menuAvaliable.get());
            return this.menuItem;
        }
    }

    private class RefreshAction
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;

        public RefreshAction() {
            this.putValue("Name", NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.refreshButton.menuText"));
            this.putValue("SmallIcon", IncludeHierarchyPanel.this.refreshButton.getIcon());
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IncludeHierarchyPanel.this.refreshButtonActionPerformed(e);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setEnabled(IncludeHierarchyPanel.this.menuAvaliable.get());
            return this.menuItem;
        }
    }
}

