/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.docview;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.model.tasks.CaretAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.docview.DocViewTopComponent;
import org.netbeans.modules.cnd.spi.model.services.CsmDocProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class DocViewCaretAwareFactory
extends CaretAwareCsmFileTaskFactory {
    protected CsmFileTaskFactory.PhaseRunner createTask(final FileObject fo) {
        return new CsmFileTaskFactory.PhaseRunner(){
            private final AtomicBoolean isCanceled = new AtomicBoolean(false);

            public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
                if (phase != CsmFileTaskFactory.PhaseRunner.Phase.PARSED) {
                    return;
                }
                this.isCanceled.set(false);
                if (!DocViewCaretAwareFactory.isDocViewActive()) {
                    return;
                }
                Document doc = CsmUtilities.getDocument((FileObject)fo);
                if (doc == null) {
                    return;
                }
                if (this.isCanceled.get()) {
                    return;
                }
                CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
                if (csmFile == null) {
                    return;
                }
                if (this.isCanceled.get()) {
                    return;
                }
                DocViewCaretAwareFactory.updateDoc(doc, fo, csmFile, this.isCanceled);
            }

            public boolean isValid() {
                return true;
            }

            public void cancel() {
                this.isCanceled.set(true);
            }

            public boolean isHighPriority() {
                return false;
            }

            public String toString() {
                return "DocViewCaretAwareFactory runner";
            }
        };
    }

    private static boolean isDocViewActive() {
        DocViewTopComponent instance = DocViewTopComponent.getInstance();
        return instance != null && instance.isActivated();
    }

    private static void updateDoc(Document doc, FileObject fo, CsmFile csmFile, AtomicBoolean isCanceled) {
        CsmReference ref = CsmReferenceResolver.getDefault().findReference(doc, CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)fo));
        if (ref == null) {
            return;
        }
        if (isCanceled.get()) {
            return;
        }
        CsmObject csmObject = ref.getReferencedObject();
        if (csmObject == null) {
            return;
        }
        if (isCanceled.get()) {
            return;
        }
        CsmDocProvider p = (CsmDocProvider)Lookup.getDefault().lookup(CsmDocProvider.class);
        if (p == null) {
            return;
        }
        CharSequence documentation = p.getDocumentation(csmObject, csmFile);
        if (documentation == null) {
            return;
        }
        if (isCanceled.get()) {
            return;
        }
        CharSequence selfDoc = CsmDisplayUtilities.getTooltipText((CsmObject)csmObject);
        if (selfDoc != null) {
            documentation = ((Object)selfDoc).toString() + ((Object)documentation).toString();
        }
        if (isCanceled.get()) {
            return;
        }
        final CharSequence toShow = documentation;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DocViewTopComponent topComponent = DocViewTopComponent.findInstance();
                if (topComponent != null && topComponent.isOpened()) {
                    topComponent.setDoc(toShow);
                }
            }
        });
    }

    protected int taskDelay() {
        return 500;
    }

    protected int rescheduleDelay() {
        return 500;
    }
}

