/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.classhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.navigation.classhierarchy.HierarchyNode;
import org.netbeans.modules.cnd.navigation.hierarchy.LoadingNode;
import org.netbeans.modules.cnd.navigation.services.HierarchyModel;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.CharSequences;
import org.openide.util.RequestProcessor;

public class HierarchyChildren
extends Children.Keys<CsmClass> {
    private static Comparator<CsmClass> COMARATOR = new MyComparator();
    private static final RequestProcessor RP = new RequestProcessor(HierarchyChildren.class.getName(), 1);
    private CsmClass object;
    private HierarchyModel model;
    private HierarchyChildren parent;
    private boolean isInited = false;

    public HierarchyChildren(CsmClass object, HierarchyModel model, HierarchyChildren parent) {
        this.object = object;
        this.model = model;
        this.parent = parent;
    }

    public void dispose() {
        if (this.isInited) {
            this.isInited = false;
            this.resetKeys(Collections.<CsmClass>emptyList());
        }
    }

    private synchronized void resetKeys(List<CsmClass> list) {
        if (list.size() > 1) {
            Collections.sort(list, COMARATOR);
        }
        this.setKeys(list);
    }

    protected Node[] createNodes(CsmClass cls) {
        Object node = cls instanceof DummyClass ? new LoadingNode() : (this.checkRecursion(cls) ? new HierarchyNode(cls, Children.LEAF, this.model, true) : new HierarchyNode(cls, this.model, this));
        return new Node[]{node};
    }

    private boolean checkRecursion(CsmClass cls) {
        if (cls.equals(this.object)) {
            return true;
        }
        HierarchyChildren arr = this.parent;
        while (arr != null) {
            if (cls.equals(arr.object)) {
                return true;
            }
            arr = arr.parent;
        }
        return false;
    }

    protected void addNotify() {
        this.isInited = true;
        if (!this.object.isValid()) {
            this.resetKeys(Collections.<CsmClass>emptyList());
        } else {
            this.resetKeys(Collections.singletonList(new DummyClass()));
            RP.post(new Runnable(){

                @Override
                public void run() {
                    Collection<CsmClass> set = HierarchyChildren.this.model.getHierarchy(HierarchyChildren.this.object);
                    if (set != null && set.size() > 0) {
                        ArrayList<CsmClass> list = new ArrayList<CsmClass>(set);
                        HierarchyChildren.this.resetKeys(list);
                    } else {
                        HierarchyChildren.this.resetKeys(Collections.emptyList());
                    }
                }
            });
        }
        super.addNotify();
    }

    protected void removeNotify() {
        super.removeNotify();
        this.dispose();
    }

    private static final class DummyClass
    implements CsmClass {
        private DummyClass() {
        }

        public Collection<CsmMember> getMembers() {
            throw new UnsupportedOperationException();
        }

        public Collection<CsmFriend> getFriends() {
            throw new UnsupportedOperationException();
        }

        public Collection<CsmInheritance> getBaseClasses() {
            throw new UnsupportedOperationException();
        }

        public int getLeftBracketOffset() {
            throw new UnsupportedOperationException();
        }

        public Collection<CsmTypedef> getEnclosingTypedefs() {
            throw new UnsupportedOperationException();
        }

        public Collection<CsmVariable> getEnclosingVariables() {
            throw new UnsupportedOperationException();
        }

        public CsmDeclaration.Kind getKind() {
            throw new UnsupportedOperationException();
        }

        public CharSequence getUniqueName() {
            throw new UnsupportedOperationException();
        }

        public CharSequence getQualifiedName() {
            throw new UnsupportedOperationException();
        }

        public CharSequence getName() {
            return CharSequences.empty();
        }

        public CsmScope getScope() {
            throw new UnsupportedOperationException();
        }

        public boolean isValid() {
            throw new UnsupportedOperationException();
        }

        public CsmFile getContainingFile() {
            throw new UnsupportedOperationException();
        }

        public int getStartOffset() {
            throw new UnsupportedOperationException();
        }

        public int getEndOffset() {
            throw new UnsupportedOperationException();
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException();
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException();
        }

        public CharSequence getText() {
            throw new UnsupportedOperationException();
        }

        public Collection<CsmScopeElement> getScopeElements() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MyComparator
    implements Comparator<CsmClass> {
        private MyComparator() {
        }

        @Override
        public int compare(CsmClass o1, CsmClass o2) {
            String n1 = ((Object)o1.getName()).toString();
            String n2 = ((Object)o2.getName()).toString();
            return n1.compareTo(n2);
        }
    }
}

