/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.classhierarchy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelutil.ui.ElementNode;
import org.netbeans.modules.cnd.navigation.classhierarchy.HierarchyNode;
import org.netbeans.modules.cnd.navigation.services.HierarchyFactory;
import org.netbeans.modules.cnd.navigation.services.HierarchyModel;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class ClassHierarchyPanel
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    public static final String ICON_PATH = "org/netbeans/modules/cnd/navigation/classhierarchy/resources/subtypehierarchy.gif";
    private AbstractNode root;
    private volatile CsmUID<CsmClass> object;
    private boolean subDirection = true;
    private boolean recursive = true;
    private boolean plain = false;
    private ExplorerManager explorerManager = new ExplorerManager();
    private Action[] actions;
    private Action close;
    private final RequestProcessor.Task refreshTask = new RequestProcessor("ClassHierarchyPanelUpdater").create((Runnable)new Updater());
    private AtomicBoolean menuAvaliable = new AtomicBoolean(false);
    private JToggleButton directOnlyButton;
    private ButtonGroup directionGroup;
    private JScrollPane hierarchyPane;
    private JPanel jPanel2;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JButton refreshButton;
    private JToggleButton subtypeButton;
    private JToggleButton supertypeButton;
    private JToolBar toolBar;
    private JToggleButton treeButton;
    private static final int SUB_TYPES = 1;
    private static final int SUPER_TYPES = 2;
    private static final int DIRECT_ONLY = 3;
    private static final int TREE = 4;

    public ClassHierarchyPanel(boolean isView) {
        this.initComponents();
        if (!isView) {
            this.toolBar.remove(0);
            this.toolBar.remove(0);
            this.directOnlyButton.setFocusable(true);
            this.subtypeButton.setFocusable(true);
            this.supertypeButton.setFocusable(true);
            this.treeButton.setFocusable(true);
        }
        this.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_ClassHierarchyTopComponent"));
        this.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"HINT_ClassHierarchyTopComponent"));
        this.getTreeView().setRootVisible(false);
        Children.SortedArray children = new Children.SortedArray();
        this.actions = isView ? new Action[]{new RefreshAction(), null, new SubTypeAction(), new SuperTypeAction(), null, new DirectOnlyAction(), new TreeAction()} : new Action[]{null, new SubTypeAction(), new SuperTypeAction(), null, new DirectOnlyAction(), new TreeAction()};
        this.root = new AbstractNode((Children)children){

            public Action[] getActions(boolean context) {
                return ClassHierarchyPanel.this.actions;
            }
        };
        this.getExplorerManager().setRootContext((Node)this.root);
    }

    public void setClose() {
        this.close = new DialogClose();
        this.getTreeView().addCloseAction(this.close);
    }

    public void clearClose() {
        this.close = null;
        this.getTreeView().addCloseAction(this.close);
    }

    private Color getBorderColor() {
        return UIManager.getDefaults().getColor("SplitPane.shadow");
    }

    private MyBeanTreeView getTreeView() {
        return (MyBeanTreeView)((Object)this.hierarchyPane);
    }

    private void initComponents() {
        this.directionGroup = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.refreshButton = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.subtypeButton = new JToggleButton();
        this.supertypeButton = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.directOnlyButton = new JToggleButton();
        this.treeButton = new JToggleButton();
        this.jPanel2 = new JPanel();
        this.hierarchyPane = new MyBeanTreeView();
        this.setLayout(new GridBagLayout());
        this.toolBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.toolBar.setFloatable(false);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setMaximumSize(new Dimension(74, 26));
        this.toolBar.setMinimumSize(new Dimension(74, 26));
        this.toolBar.setOpaque(false);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/classhierarchy/resources/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.refreshButton.toolTipText"));
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setMaximumSize(new Dimension(24, 24));
        this.refreshButton.setMinimumSize(new Dimension(24, 24));
        this.refreshButton.setPreferredSize(new Dimension(24, 24));
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassHierarchyPanel.this.refreshButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.refreshButton);
        this.toolBar.add(this.jSeparator1);
        this.directionGroup.add(this.subtypeButton);
        this.subtypeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/classhierarchy/resources/subtypehierarchy.gif")));
        this.subtypeButton.setSelected(true);
        this.subtypeButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.subtypeButton.toolTipText"));
        this.subtypeButton.setFocusable(false);
        this.subtypeButton.setHorizontalTextPosition(0);
        this.subtypeButton.setMaximumSize(new Dimension(24, 24));
        this.subtypeButton.setMinimumSize(new Dimension(24, 24));
        this.subtypeButton.setPreferredSize(new Dimension(24, 24));
        this.subtypeButton.setVerticalTextPosition(3);
        this.subtypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassHierarchyPanel.this.subtypeButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.subtypeButton);
        this.directionGroup.add(this.supertypeButton);
        this.supertypeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/classhierarchy/resources/supertypehierarchy.gif")));
        this.supertypeButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.supertypeButton.toolTipText"));
        this.supertypeButton.setFocusable(false);
        this.supertypeButton.setHorizontalTextPosition(0);
        this.supertypeButton.setMaximumSize(new Dimension(24, 24));
        this.supertypeButton.setMinimumSize(new Dimension(24, 24));
        this.supertypeButton.setPreferredSize(new Dimension(24, 24));
        this.supertypeButton.setVerticalTextPosition(3);
        this.supertypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassHierarchyPanel.this.supertypeButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.supertypeButton);
        this.toolBar.add(this.jSeparator2);
        this.directOnlyButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/classhierarchy/resources/direct_only.png")));
        this.directOnlyButton.setText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.directOnlyButton.text"));
        this.directOnlyButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.directOnlyButton.toolTipText"));
        this.directOnlyButton.setFocusable(false);
        this.directOnlyButton.setHorizontalTextPosition(0);
        this.directOnlyButton.setMaximumSize(new Dimension(24, 24));
        this.directOnlyButton.setMinimumSize(new Dimension(24, 24));
        this.directOnlyButton.setPreferredSize(new Dimension(24, 24));
        this.directOnlyButton.setVerticalTextPosition(3);
        this.directOnlyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassHierarchyPanel.this.directOnlyButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.directOnlyButton);
        this.treeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/classhierarchy/resources/tree.png")));
        this.treeButton.setText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.treeButton.text"));
        this.treeButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.treeButton.toolTipText"));
        this.treeButton.setFocusable(false);
        this.treeButton.setHorizontalTextPosition(0);
        this.treeButton.setMaximumSize(new Dimension(24, 24));
        this.treeButton.setMinimumSize(new Dimension(24, 24));
        this.treeButton.setPreferredSize(new Dimension(24, 24));
        this.treeButton.setVerticalTextPosition(3);
        this.treeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassHierarchyPanel.this.treeButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.treeButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)this.toolBar, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createLineBorder(this.getBorderColor()));
        this.jPanel2.setFocusable(false);
        this.jPanel2.setMinimumSize(new Dimension(1, 1));
        this.jPanel2.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.hierarchyPane.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.hierarchyPane, gridBagConstraints);
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        CsmClass cls;
        if (this.object != null && (cls = (CsmClass)this.object.getObject()) != null) {
            this.update(cls);
        }
    }

    private void subtypeButtonActionPerformed(ActionEvent evt) {
        if (this.subDirection == this.subtypeButton.isSelected()) {
            return;
        }
        this.setSubtypeHierarchy(true);
    }

    private void setSubtypeHierarchy(boolean isSub) {
        CsmClass cls;
        if (this.object != null && (cls = (CsmClass)this.object.getObject()) != null) {
            this.subDirection = isSub;
            this.updateButtons();
            this.update(cls);
        }
    }

    private void supertypeButtonActionPerformed(ActionEvent evt) {
        if (this.subDirection != this.supertypeButton.isSelected()) {
            return;
        }
        this.setSubtypeHierarchy(false);
    }

    private void directOnlyButtonActionPerformed(ActionEvent evt) {
        this.setRecursive(!this.directOnlyButton.isSelected());
    }

    private void treeButtonActionPerformed(ActionEvent evt) {
        this.setPlain(!this.treeButton.isSelected());
    }

    private void setRecursive(boolean isRecursive) {
        CsmClass cls;
        if (this.object != null && (cls = (CsmClass)this.object.getObject()) != null) {
            this.recursive = isRecursive;
            this.updateButtons();
            this.update(cls);
        }
    }

    private void setPlain(boolean isPlain) {
        CsmClass cls;
        if (this.object != null && (cls = (CsmClass)this.object.getObject()) != null) {
            this.plain = isPlain;
            this.updateButtons();
            this.update(cls);
        }
    }

    public void setClass(CsmClass cls) {
        if (cls != null) {
            this.object = UIDs.get((Object)cls);
        }
        this.subDirection = true;
        this.updateButtons();
        this.update(cls);
    }

    private void updateButtons() {
        this.subtypeButton.setSelected(this.subDirection);
        this.supertypeButton.setSelected(!this.subDirection);
        this.directOnlyButton.setSelected(!this.recursive);
        this.treeButton.setSelected(!this.plain);
        this.refreshButton.setEnabled(this.menuAvaliable.get());
        this.subtypeButton.setEnabled(this.menuAvaliable.get());
        this.supertypeButton.setEnabled(this.menuAvaliable.get());
        this.directOnlyButton.setEnabled(this.menuAvaliable.get());
        this.treeButton.setEnabled(this.menuAvaliable.get());
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.hierarchyPane.requestFocusInWindow();
    }

    public void setWaiting() {
        this.menuAvaliable.set(false);
        this.updateButtons();
        final Children children = this.root.getChildren();
        if (!Children.MUTEX.isReadAccess()) {
            Children.MUTEX.writeAccess(new Runnable(){

                @Override
                public void run() {
                    children.remove(children.getNodes());
                    children.add(new Node[]{ElementNode.getWaitNode((String)NbBundle.getMessage(ClassHierarchyPanel.class, (String)"PleaseWait"))});
                }
            });
        }
    }

    public void setEmpty() {
        this.menuAvaliable.set(false);
        this.updateButtons();
        final Children children = this.root.getChildren();
        if (!Children.MUTEX.isReadAccess()) {
            Children.MUTEX.writeAccess(new Runnable(){

                @Override
                public void run() {
                    children.remove(children.getNodes());
                    ClassHierarchyPanel.this.refreshTask.cancel();
                }
            });
        }
    }

    private synchronized void update(CsmClass csmClass) {
        if (csmClass != null) {
            this.setWaiting();
            this.refreshTask.schedule(10);
        } else {
            this.setEmpty();
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private ImageIcon getButtonIcon(int kind) {
        String path = null;
        switch (kind) {
            case 1: {
                path = "/org/netbeans/modules/cnd/navigation/classhierarchy/resources/subtypehierarchy.png";
                break;
            }
            case 2: {
                path = "/org/netbeans/modules/cnd/navigation/classhierarchy/resources/supertypehierarchy.png";
                break;
            }
            case 3: {
                path = "/org/netbeans/modules/cnd/navigation/classhierarchy/resources/direct_only.png";
                break;
            }
            case 4: {
                path = "/org/netbeans/modules/cnd/navigation/classhierarchy/resources/tree.png";
            }
        }
        return new ImageIcon(this.getClass().getResource(path));
    }

    private String getButtonTooltip(int kind) {
        String path = null;
        switch (kind) {
            case 1: {
                path = "ClassHierarchyPanel.subtypeButton.menuText";
                break;
            }
            case 2: {
                path = "ClassHierarchyPanel.supertypeButton.menuText";
                break;
            }
            case 3: {
                path = "ClassHierarchyPanel.directOnlyButton.menuText";
                break;
            }
            case 4: {
                path = "ClassHierarchyPanel.treeButton.menuText";
            }
        }
        return NbBundle.getMessage(this.getClass(), (String)path);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("TypeView");
    }

    private class Updater
    implements Runnable {
        HierarchyModel model;
        CsmClass csmClass;

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                final Children children = ClassHierarchyPanel.this.root.getChildren();
                if (!Children.MUTEX.isReadAccess()) {
                    Children.MUTEX.writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            children.remove(children.getNodes());
                            HierarchyModel curModel = Updater.this.model;
                            if (curModel != null) {
                                HierarchyNode node = new HierarchyNode(Updater.this.csmClass, curModel, null);
                                children.add(new Node[]{node});
                                try {
                                    ClassHierarchyPanel.this.getExplorerManager().setSelectedNodes(new Node[]{node});
                                }
                                catch (PropertyVetoException propertyVetoException) {
                                    // empty catch block
                                }
                                SwingUtilities.invokeLater(new Runnable((Node)node){
                                    final /* synthetic */ Node val$node;
                                    {
                                        this.val$node = node;
                                    }

                                    @Override
                                    public void run() {
                                        ClassHierarchyPanel.this.menuAvaliable.set(true);
                                        ClassHierarchyPanel.this.updateButtons();
                                        ((BeanTreeView)ClassHierarchyPanel.this.hierarchyPane).expandNode(this.val$node);
                                    }
                                });
                            }
                        }
                    });
                }
            } else {
                CsmUID uid = ClassHierarchyPanel.this.object;
                this.csmClass = uid == null ? null : (CsmClass)uid.getObject();
                HierarchyModel newModel = null;
                if (this.csmClass != null) {
                    newModel = HierarchyFactory.getInstance().buildTypeHierarchyModel(this.csmClass, ClassHierarchyPanel.this.actions, ClassHierarchyPanel.this.subDirection, ClassHierarchyPanel.this.plain, ClassHierarchyPanel.this.recursive);
                    newModel.setCloseWindowAction(ClassHierarchyPanel.this.close);
                }
                this.model = newModel;
                SwingUtilities.invokeLater(this);
            }
        }
    }

    private static class MyBeanTreeView
    extends BeanTreeView {
        public void addCloseAction(final Action action) {
            this.tree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 27 && action != null) {
                        action.actionPerformed(null);
                        e.consume();
                    }
                    super.keyReleased(e);
                }
            });
        }
    }

    private class DialogClose
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            for (Container p = ClassHierarchyPanel.this; p != null; p = p.getParent()) {
                if (p instanceof TopComponent) {
                    ((TopComponent)p).close();
                    return;
                }
                if (!(p instanceof Window)) continue;
                ((Window)p).setVisible(false);
                return;
            }
        }
    }

    private class TreeAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public TreeAction() {
            this.putValue("Name", ClassHierarchyPanel.this.getButtonTooltip(4));
            this.putValue("SmallIcon", ClassHierarchyPanel.this.getButtonIcon(4));
            this.menuItem = new JCheckBoxMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClassHierarchyPanel.this.setPlain(!ClassHierarchyPanel.this.plain);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!ClassHierarchyPanel.this.plain);
            this.menuItem.setEnabled(ClassHierarchyPanel.this.menuAvaliable.get());
            return this.menuItem;
        }
    }

    private class DirectOnlyAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public DirectOnlyAction() {
            this.putValue("Name", ClassHierarchyPanel.this.getButtonTooltip(3));
            this.putValue("SmallIcon", ClassHierarchyPanel.this.getButtonIcon(3));
            this.menuItem = new JCheckBoxMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClassHierarchyPanel.this.setRecursive(!ClassHierarchyPanel.this.recursive);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!ClassHierarchyPanel.this.recursive);
            this.menuItem.setEnabled(ClassHierarchyPanel.this.menuAvaliable.get());
            return this.menuItem;
        }
    }

    private class SuperTypeAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public SuperTypeAction() {
            this.putValue("Name", ClassHierarchyPanel.this.getButtonTooltip(2));
            this.putValue("SmallIcon", ClassHierarchyPanel.this.supertypeButton.getIcon());
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClassHierarchyPanel.this.setSubtypeHierarchy(false);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!ClassHierarchyPanel.this.subDirection);
            this.menuItem.setEnabled(ClassHierarchyPanel.this.menuAvaliable.get());
            return this.menuItem;
        }
    }

    private class SubTypeAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public SubTypeAction() {
            this.putValue("Name", ClassHierarchyPanel.this.getButtonTooltip(1));
            this.putValue("SmallIcon", ClassHierarchyPanel.this.subtypeButton.getIcon());
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClassHierarchyPanel.this.setSubtypeHierarchy(true);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(ClassHierarchyPanel.this.subDirection);
            this.menuItem.setEnabled(ClassHierarchyPanel.this.menuAvaliable.get());
            return this.menuItem;
        }
    }

    private class RefreshAction
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;

        public RefreshAction() {
            this.putValue("Name", NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.refreshButton.menuText"));
            this.putValue("SmallIcon", ClassHierarchyPanel.this.refreshButton.getIcon());
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClassHierarchyPanel.this.refreshButtonActionPerformed(e);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setEnabled(ClassHierarchyPanel.this.menuAvaliable.get());
            return this.menuItem;
        }
    }
}

