/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.callgraph;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.api.ui.CallGraphPreferences;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.callgraph.CallImpl;
import org.openide.util.NbBundle;

public class FunctionImpl
implements Function {
    private static final Map<CsmDeclaration.Kind, CsmDeclaration.Kind> preferredIcons = new HashMap<CsmDeclaration.Kind, CsmDeclaration.Kind>();
    private final CsmFunction function;
    private String htmlDisplayName = "";
    private String scopeName = null;
    private final CsmFunction cachedFunctionDefinition;
    private final CsmFunction cachedFunctionDeclaration;
    private final boolean isVirtual;
    private final Image icon;

    public FunctionImpl(CsmFunction function) {
        this.function = function;
        this.cachedFunctionDefinition = this.initDefinition();
        this.cachedFunctionDeclaration = this.initDeclaration();
        this.isVirtual = this.initVirtual();
        this.icon = this.initIcon();
    }

    public CsmFunction getDeclaration() {
        return this.cachedFunctionDeclaration;
    }

    private CsmFunction initDeclaration() {
        CsmFunction f;
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)this.function) && (f = ((CsmFunctionDefinition)this.function).getDeclaration()) != null) {
            return f;
        }
        return this.function;
    }

    public CsmFunction getDefinition() {
        return this.cachedFunctionDefinition;
    }

    private CsmFunction initDefinition() {
        CsmFunctionDefinition f;
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)this.function) && (f = this.function.getDefinition()) != null) {
            return f;
        }
        return this.function;
    }

    public String getName() {
        return ((Object)this.function.getName()).toString();
    }

    public String getScopeName() {
        if (this.scopeName == null) {
            this.scopeName = "";
            try {
                CsmClass cls;
                CsmFunction f = this.getDeclaration();
                if (CsmKindUtilities.isClassMember((CsmObject)f) && (cls = ((CsmMember)f).getContainingClass()) != null && cls.getName().length() > 0) {
                    this.scopeName = ((Object)cls.getName()).toString() + "::";
                }
            }
            catch (AssertionError ex) {
                ((Throwable)((Object)ex)).printStackTrace(System.err);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        return this.scopeName;
    }

    public String getHtmlDisplayName() {
        if (this.htmlDisplayName.length() == 0) {
            this.htmlDisplayName = this.createHtmlDisplayName();
        }
        return this.htmlDisplayName;
    }

    public boolean isVurtual() {
        return this.isVirtual;
    }

    private boolean initVirtual() {
        try {
            CsmClass cls;
            CsmFunction f = this.getDeclaration();
            if (CsmKindUtilities.isClassMember((CsmObject)f) && (cls = ((CsmMember)f).getContainingClass()) != null && cls.getName().length() > 0) {
                return CsmKindUtilities.isMethod((CsmObject)f) && CsmVirtualInfoQuery.getDefault().isVirtual((CsmMethod)f);
            }
        }
        catch (AssertionError ex) {
            ((Throwable)((Object)ex)).printStackTrace(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return false;
    }

    private String createHtmlDisplayName() {
        String displayName = CallGraphPreferences.isShowParameters() ? ((Object)this.function.getSignature()).toString() : ((Object)this.function.getName()).toString();
        displayName = displayName.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        if (this.scopeName == null) {
            this.scopeName = "";
        }
        try {
            CsmClass cls;
            CsmFunction f = this.getDeclaration();
            if (CsmKindUtilities.isClassMember((CsmObject)f) && (cls = ((CsmMember)f).getContainingClass()) != null && cls.getName().length() > 0) {
                String name = ((Object)cls.getName()).toString().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                String in = NbBundle.getMessage(CallImpl.class, (String)"LBL_inClass");
                if (this.isVurtual()) {
                    displayName = "<i>" + displayName + "</i>";
                }
                this.scopeName = ((Object)cls.getName()).toString() + "::";
                return displayName + "<font color='!controlShadow'>  " + in + " " + name;
            }
        }
        catch (AssertionError ex) {
            ((Throwable)((Object)ex)).printStackTrace(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return displayName;
    }

    public String getDescription() {
        String scope = this.getScopeName();
        return scope + ((Object)this.function.getSignature()).toString();
    }

    public Image getIcon() {
        return this.icon;
    }

    private Image initIcon() {
        try {
            return CsmImageLoader.getImage((CsmObject)this.getDefinition(), preferredIcons);
        }
        catch (AssertionError ex) {
            ((Throwable)((Object)ex)).printStackTrace(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return null;
    }

    public void open() {
        String taskName = "Open declaration";
        Runnable run = new Runnable(){

            @Override
            public void run() {
                CsmUtilities.openSource((CsmObject)FunctionImpl.this.getDefinition());
            }
        };
        CsmModelAccessor.getModel().enqueue(run, (CharSequence)"Open declaration");
    }

    public boolean equals(Object obj) {
        CsmFunction f = this.getDefinition();
        if (f != null && obj instanceof FunctionImpl) {
            return f.equals(((FunctionImpl)obj).getDefinition());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        CsmFunction f = this.getDefinition();
        if (f != null) {
            return f.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    static {
        preferredIcons.put(CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION);
        preferredIcons.put(CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_FRIEND);
        preferredIcons.put(CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION);
    }
}

