/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.source.bridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsAdapter;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.source.spi.CndSourcePropertiesProvider;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class DocumentLanguageFlavorProvider
implements CndSourcePropertiesProvider {
    public void addProperty(DataObject dob, StyledDocument doc) {
        Iterator i$;
        Language language;
        ListenerImpl old = (ListenerImpl)doc.getProperty(ListenerImpl.class);
        if (old != null) {
            old.unregister();
        }
        if ((language = (Language)doc.getProperty(Language.class)) != CppTokenId.languageCpp() && language != CppTokenId.languageC() && language != CppTokenId.languageHeader()) {
            return;
        }
        NativeFileItemSet nfis = (NativeFileItemSet)dob.getLookup().lookup(NativeFileItemSet.class);
        if (nfis != null && !nfis.isEmpty() && (i$ = nfis.getItems().iterator()).hasNext()) {
            NativeFileItem nativeFileItem = (NativeFileItem)i$.next();
            doc.putProperty(ListenerImpl.class, new ListenerImpl(doc, dob, nativeFileItem));
            DocumentLanguageFlavorProvider.setLanguage(nativeFileItem, doc);
            return;
        }
        FileObject primaryFile = dob.getPrimaryFile();
        if (primaryFile == null) {
            return;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)primaryFile);
        if (owner == null) {
            return;
        }
        NativeProject np = (NativeProject)owner.getLookup().lookup(NativeProject.class);
        if (np == null) {
            return;
        }
        NativeFileItem nfi = np.findFileItem(primaryFile);
        if (nfi == null) {
            return;
        }
        DocumentLanguageFlavorProvider.setLanguage(nfi, doc);
        doc.putProperty(ListenerImpl.class, new ListenerImpl(doc, dob, nfi));
    }

    private static void setLanguage(NativeFileItem nfi, StyledDocument doc) {
        Language language = null;
        Filter filter = null;
        switch (nfi.getLanguage()) {
            case C: {
                language = CppTokenId.languageC();
                filter = CndLexerUtilities.getGccCFilter();
                break;
            }
            case C_HEADER: {
                language = CppTokenId.languageHeader();
                if (nfi.getLanguageFlavor() == NativeFileItem.LanguageFlavor.CPP11) {
                    filter = CndLexerUtilities.getHeaderCpp11Filter();
                    break;
                }
                filter = CndLexerUtilities.getHeaderCppFilter();
                break;
            }
            case CPP: {
                language = CppTokenId.languageCpp();
                if (nfi.getLanguageFlavor() == NativeFileItem.LanguageFlavor.CPP11) {
                    filter = CndLexerUtilities.getGccCpp11Filter();
                    break;
                }
                filter = CndLexerUtilities.getGccCppFilter();
                break;
            }
            case FORTRAN: 
            case OTHER: {
                return;
            }
        }
        assert (language != null);
        assert (filter != null);
        doc.putProperty(Language.class, language);
        InputAttributes lexerAttrs = (InputAttributes)doc.getProperty(InputAttributes.class);
        lexerAttrs.setValue(language, (Object)"lexer-filter", (Object)filter, true);
    }

    private static final class ListenerImpl
    extends NativeProjectItemsAdapter
    implements PropertyChangeListener {
        private static final boolean TRACE = false;
        private final Reference<StyledDocument> docRef;
        private final String path;
        private final FileObject fo;
        private final Reference<NativeProject> prjRef;
        private NativeFileItem.LanguageFlavor languageFlavor;

        public ListenerImpl(StyledDocument doc, DataObject dob, NativeFileItem nativeFileItem) {
            this.docRef = new WeakReference<StyledDocument>(doc);
            this.fo = dob.getPrimaryFile();
            this.path = nativeFileItem.getAbsolutePath();
            NativeProject nativeProject = nativeFileItem.getNativeProject();
            this.prjRef = new WeakReference<NativeProject>(nativeProject);
            this.languageFlavor = nativeFileItem.getLanguageFlavor();
            if (nativeProject != null) {
                nativeProject.addProjectItemsListener((NativeProjectItemsListener)this);
            } else {
                System.err.println("no native project for " + nativeFileItem);
            }
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JTextComponent oldValue;
            StyledDocument doc = this.docRef.get();
            NativeProject project = this.prjRef.get();
            if (doc == null || project == null) {
                this.unregister();
                return;
            }
            if ("usedByCloneableEditor".equals(evt.getPropertyName())) {
                if (Boolean.FALSE.equals(evt.getNewValue())) {
                    this.unregister();
                }
            } else if ("componentRemoved".equals(evt.getPropertyName()) && (oldValue = (JTextComponent)evt.getOldValue()) != null && doc.equals(oldValue.getDocument())) {
                this.unregister();
            }
        }

        private void unregister() {
            StyledDocument doc;
            EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this);
            NativeProject nativeProject = this.prjRef.get();
            if (nativeProject != null) {
                nativeProject.removeProjectItemsListener((NativeProjectItemsListener)this);
            }
            if ((doc = this.docRef.get()) != null) {
                doc.putProperty(ListenerImpl.class, null);
            }
        }

        public void filesAdded(List<NativeFileItem> fileItems) {
            this.filesPropertiesChanged(fileItems);
        }

        private void filePropertiesChanged(NativeFileItem fileItem) {
            if (fileItem != null && this.path.equals(fileItem.getAbsolutePath())) {
                final StyledDocument doc = this.docRef.get();
                if (doc == null) {
                    this.unregister();
                    return;
                }
                NativeFileItem.LanguageFlavor newFlavor = fileItem.getLanguageFlavor();
                if (!this.languageFlavor.equals((Object)newFlavor)) {
                    DocumentLanguageFlavorProvider.setLanguage(fileItem, doc);
                    this.languageFlavor = newFlavor;
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            BaseDocument bdoc = (BaseDocument)doc;
                            try {
                                if (bdoc != null) {
                                    bdoc.extWriteLock();
                                }
                                MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                                mti.tokenHierarchyControl().rebuild();
                            }
                            finally {
                                if (bdoc != null) {
                                    bdoc.extWriteUnlock();
                                }
                            }
                        }
                    });
                }
            }
        }

        public void filesPropertiesChanged(List<NativeFileItem> fileItems) {
            for (NativeFileItem nativeFileItem : fileItems) {
                this.filePropertiesChanged(nativeFileItem);
            }
        }

        public void filesPropertiesChanged() {
            NativeProject nativeProject = this.prjRef.get();
            if (nativeProject != null) {
                NativeFileItem findFileItem = nativeProject.findFileItem(this.fo);
                this.filePropertiesChanged(findFileItem);
            } else {
                this.unregister();
            }
        }

        public void projectDeleted(NativeProject nativeProject) {
            this.unregister();
        }
    }
}

