/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.awt;

import com.sun.perseus.awt.ComponentEventDispatcher;
import com.sun.perseus.awt.Messages;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.model.CanvasUpdateListener;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.SMILSample;
import com.sun.perseus.model.SimpleCanvasManager;
import com.sun.perseus.model.Time;
import com.sun.perseus.util.RunnableQueue;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.microedition.m2g.SVGEventListener;

class SVGDocumentComponentSupport
implements CanvasUpdateListener,
RunnableQueue.RunnableHandler {
    public static final int STATE_STOPPED = 1;
    public static final int STATE_PLAYING = 2;
    public static final int STATE_PAUSED = 3;
    public static final int SMIL_ANIMATION_FRAME_LENGTH = 1000;
    protected int state = 1;
    protected SimpleCanvasManager canvasManager;
    protected DocumentNode documentNode;
    protected Component component;
    protected ComponentEventDispatcher dispatcher;
    protected boolean needRepaint = true;
    protected BufferedImage offscreen;
    protected RenderGraphics rg;
    protected SVGEventListener svgEventListener;
    protected static final AffineTransform IDENTITY = new AffineTransform();
    protected RunnableQueue updateQueue = null;
    protected SMILSample smilSample = null;
    protected SMILSample.DocumentWallClock clock = null;
    protected float timeIncrement = 0.1f;
    private int width;
    private int height;
    protected AWTListener awtEventListener = new AWTListener();
    protected float[] currentTranslate = new float[]{0.0f, 0.0f};
    protected float currentScale = 1.0f;
    protected boolean ignoreCanvasUpdate = false;

    public SVGDocumentComponentSupport(DocumentNode documentNode, Component component) {
        if (documentNode == null || component == null) {
            throw new NullPointerException();
        }
        if (!documentNode.isLoaded()) {
            throw new IllegalStateException();
        }
        this.documentNode = documentNode;
        this.component = component;
        this.dispatcher = new ComponentEventDispatcher(documentNode);
        this.updateQueue = RunnableQueue.getDefault();
        documentNode.setUpdateQueue(this.updateQueue);
        this.setDocumentSize(documentNode.getWidth(), documentNode.getHeight());
        this.buildOffscreen();
        if (this.rg != null) {
            this.rg.setTargetComponent(this.component);
        }
        this.canvasManager = new SimpleCanvasManager(this.rg, documentNode, this);
        documentNode.setRunnableHandler(this.canvasManager);
        this.clock = new SMILSample.DocumentWallClock(documentNode);
        this.smilSample = new SMILSample(documentNode, this.clock);
        documentNode.initializeTimingEngine();
        documentNode.sample(new Time(0L));
        documentNode.applyAnimations();
        component.addMouseListener(this.awtEventListener);
        component.addMouseMotionListener(this.awtEventListener);
        component.addKeyListener(this.awtEventListener);
        component.addComponentListener(this.awtEventListener);
    }

    public int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics g2d) {
        this.checkOffscreen();
        Object object = this.canvasManager.lock;
        synchronized (object) {
            ((Graphics2D)g2d).setComposite(AlphaComposite.Src);
            g2d.drawImage(this.offscreen, 0, 0, this.component);
            this.canvasManager.consume();
        }
    }

    void backgroundChange(Color background) {
        this.canvasManager.setClearPaint(new RGB(background.getRed(), background.getGreen(), background.getBlue()));
        this.component.repaint();
    }

    protected void checkOffscreen() {
        if (this.offscreen == null) {
            this.buildOffscreen();
        } else if (this.width > 0 && this.width != this.offscreen.getWidth(null) || this.height > 0 && this.height != this.offscreen.getHeight(null)) {
            this.buildOffscreen();
        }
    }

    protected void buildOffscreen() {
        this.offscreen = this.width > 0 && this.height > 0 ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.width, this.height, 1) : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(1, 1, 1);
        this.rg = new RenderGraphics(this.offscreen);
        if (this.canvasManager != null) {
            try {
                this.updateQueue.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = SVGDocumentComponentSupport.this.canvasManager.lock;
                        synchronized (object) {
                            SVGDocumentComponentSupport.this.documentNode.setSize(SVGDocumentComponentSupport.this.width, SVGDocumentComponentSupport.this.height);
                            SVGDocumentComponentSupport.this.canvasManager.setRenderGraphics(SVGDocumentComponentSupport.this.rg);
                            SVGDocumentComponentSupport.this.canvasManager.consume();
                        }
                        SVGDocumentComponentSupport.this.ignoreCanvasUpdate = true;
                        SVGDocumentComponentSupport.this.canvasManager.updateCanvas();
                        SVGDocumentComponentSupport.this.ignoreCanvasUpdate = false;
                    }
                }, null);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        } else {
            System.err.println(">>>>>>>> Filling w/ white");
            Graphics2D g = (Graphics2D)this.offscreen.getGraphics();
            g.setPaint(this.component.getBackground());
            g.fillRect(0, 0, this.offscreen.getWidth(null), this.offscreen.getHeight(null));
        }
    }

    void setBounds(int x, int y, final int w, final int h) {
        this.updateQueue.invokeLater(new Runnable(){

            public void run() {
                SVGDocumentComponentSupport.this.setDocumentSize(w, h);
            }
        }, this.canvasManager);
    }

    private void setDocumentSize(int w, int h) {
        int oldw = this.documentNode.getWidth();
        int oldh = this.documentNode.getHeight();
        this.width = w;
        this.height = h;
        this.documentNode.setSize(this.width, this.height);
    }

    Dimension getPreferredSize() {
        return new Dimension(this.documentNode.getWidth(), this.documentNode.getHeight());
    }

    public void updateComplete(Object canvasManager) {
        if (!this.ignoreCanvasUpdate) {
            this.component.repaint();
        }
    }

    public void initialLoadComplete(Exception e) {
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void setSVGEventListener(SVGEventListener svgEventListener) {
        this.svgEventListener = svgEventListener;
    }

    public SVGEventListener getSVGEventListener() {
        return this.svgEventListener;
    }

    public void setTimeIncrement(float timeIncrement) {
        if (timeIncrement <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.timeIncrement = timeIncrement;
        if (this.state == 2) {
            this.updateQueue.unschedule(this.smilSample);
            this.updateQueue.scheduleAtFixedRate(this.smilSample, this.canvasManager, (long)(1000.0f * timeIncrement));
        }
    }

    public float getTimeIncrement() {
        return this.timeIncrement;
    }

    public void play() {
        if (this.state == 2) {
            throw new IllegalStateException(Messages.formatMessage(Messages.ERROR_INVALID_STATE, new Object[]{this.getClass().getName(), this.stateToString(), "play()", "stopped, paused"}));
        }
        this.updateQueue.preemptLater(new Runnable(){

            public void run() {
                SVGDocumentComponentSupport.this.documentNode.setPlaying(true);
            }
        }, this.canvasManager);
        this.clock.start();
        this.updateQueue.scheduleAtFixedRate(this.smilSample, this.canvasManager, (long)(1000.0f * this.timeIncrement));
        this.state = 2;
    }

    public void pause() {
        if (this.state != 2) {
            throw new IllegalStateException(Messages.formatMessage(Messages.ERROR_INVALID_STATE, new Object[]{this.getClass().getName(), this.stateToString(), "pause()", "playing"}));
        }
        this.state = 3;
        this.updateQueue.preemptLater(new Runnable(){

            public void run() {
                SVGDocumentComponentSupport.this.documentNode.setPlaying(false);
            }
        }, this.canvasManager);
        this.updateQueue.unschedule(this.smilSample);
    }

    public void stop() {
        if (this.state == 1) {
            throw new IllegalStateException(Messages.formatMessage(Messages.ERROR_INVALID_STATE, new Object[]{this.getClass().getName(), this.stateToString(), "stop()", "paused, playing"}));
        }
        this.state = 1;
        this.updateQueue.unschedule(this.smilSample);
        this.documentNode.setPlaying(false);
        this.canvasManager.consume();
    }

    public void invokeAndWait(Runnable runnable) throws InterruptedException {
        if (runnable == null) {
            throw new NullPointerException();
        }
        if (this.state == 1) {
            throw new IllegalStateException(Messages.formatMessage(Messages.ERROR_INVALID_STATE, new Object[]{this.getClass().getName(), this.stateToString(), "invokeAndWait()", "paused, playing"}));
        }
        this.updateQueue.invokeAndWait(runnable, this.canvasManager);
    }

    public void invokeLater(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        if (this.state == 1) {
            throw new IllegalStateException(Messages.formatMessage(Messages.ERROR_INVALID_STATE, new Object[]{this.getClass().getName(), this.stateToString(), "invokeLater()", "paused, playing"}));
        }
        this.updateQueue.invokeLater(runnable, this.canvasManager);
    }

    String stateToString() {
        switch (this.state) {
            case 2: {
                return "playing";
            }
            case 3: {
                return "paused";
            }
        }
        return "stopped";
    }

    public void runnableInvoked(RunnableQueue rq, Runnable r) {
        if (this.component.isVisible() && this.canvasManager != null) {
            this.canvasManager.runnableInvoked(rq, r);
        }
    }

    private class AWTListener
    implements MouseListener,
    MouseMotionListener,
    KeyListener,
    ComponentListener {
        private AWTListener() {
        }

        void dispatchMouseEvent(final MouseEvent e) {
            if (SVGDocumentComponentSupport.this.documentNode != null) {
                try {
                    SVGDocumentComponentSupport.this.updateQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            SVGDocumentComponentSupport.this.dispatcher.dispatchMouseEvent(e);
                        }
                    }, SVGDocumentComponentSupport.this.canvasManager);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        void dispatchKeyEvent(final KeyEvent e) {
            if (SVGDocumentComponentSupport.this.documentNode != null) {
                SVGDocumentComponentSupport.this.updateQueue.invokeLater(new Runnable(){

                    public void run() {
                        SVGDocumentComponentSupport.this.dispatcher.dispatchKeyEvent(e);
                    }
                }, SVGDocumentComponentSupport.this.canvasManager);
            }
        }

        public void mouseClicked(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            if (SVGDocumentComponentSupport.this.svgEventListener != null) {
                SVGDocumentComponentSupport.this.svgEventListener.pointerPressed(e.getX(), e.getY());
            }
            this.dispatchMouseEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            if (SVGDocumentComponentSupport.this.svgEventListener != null) {
                SVGDocumentComponentSupport.this.svgEventListener.pointerReleased(e.getX(), e.getY());
            }
            this.dispatchMouseEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        public void mouseExited(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        public void keyPressed(KeyEvent e) {
            System.err.println(">>>>> keyPressed");
            if (SVGDocumentComponentSupport.this.svgEventListener != null) {
                SVGDocumentComponentSupport.this.svgEventListener.keyPressed(e.getKeyCode());
            }
            this.dispatchKeyEvent(e);
        }

        public void keyReleased(KeyEvent e) {
            if (SVGDocumentComponentSupport.this.svgEventListener != null) {
                SVGDocumentComponentSupport.this.svgEventListener.keyReleased(e.getKeyCode());
            }
            this.dispatchKeyEvent(e);
        }

        public void keyTyped(KeyEvent e) {
            this.dispatchKeyEvent(e);
        }

        public void componentResized(ComponentEvent e) {
            if (SVGDocumentComponentSupport.this.svgEventListener != null) {
                SVGDocumentComponentSupport.this.svgEventListener.sizeChanged(e.getComponent().getWidth(), e.getComponent().getHeight());
            }
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
            if (SVGDocumentComponentSupport.this.svgEventListener != null) {
                SVGDocumentComponentSupport.this.svgEventListener.showNotify();
            }
        }

        public void componentHidden(ComponentEvent e) {
            if (SVGDocumentComponentSupport.this.svgEventListener != null) {
                SVGDocumentComponentSupport.this.svgEventListener.hideNotify();
            }
        }
    }
}

