/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.api.ui;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class FileObjectBasedFile
extends File {
    private final ExecutionEnvironment env;
    private FileObject fo;
    private final String path;
    private File[] NO_CHILDREN = new File[0];
    private static final String PREFIX = "NATIVEEXECUTOR: ";
    private static final RequestProcessor processor = new RequestProcessor("NATIVEEXECUTOR: ", 50);

    public FileObjectBasedFile(ExecutionEnvironment env, String path) {
        super(path);
        RemoteLogger.assertTrue(path != null, "Path should not be null");
        this.fo = null;
        this.path = FileObjectBasedFile.toUnix(super.getPath());
        this.env = env;
    }

    public FileObjectBasedFile(ExecutionEnvironment env, FileObject fo) {
        super(fo == null || "".equals(fo.getPath()) ? "/" : fo.getPath());
        this.fo = fo;
        this.path = fo == null || "".equals(fo.getPath()) ? "/" : fo.getPath();
        this.env = env;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    @Override
    public boolean isDirectory() {
        return this.fo == null ? false : this.fo.isFolder();
    }

    @Override
    public boolean isAbsolute() {
        String p = this.getPath();
        if (p.length() != 0) {
            return p.charAt(0) == '/';
        }
        if (this.fo != null) {
            return this.fo.getParent() == null;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileObjectBasedFile other = (FileObjectBasedFile)obj;
        if (!(this.env == other.env || this.env != null && this.env.equals(other.env))) {
            return false;
        }
        if (!(this.fo == other.fo || this.fo != null && this.fo.equals(other.fo))) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (this.env != null ? this.env.hashCode() : 0);
        hash = 17 * hash + (this.fo != null ? this.fo.hashCode() : 0);
        hash = 17 * hash + (this.path != null ? this.path.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean exists() {
        return this.fo == null ? false : this.fo.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameTo(File dest) {
        boolean bl;
        if (this.fo == null) {
            this.fo = FileSystemProvider.getFileObject(this.env, this.path);
        }
        if (this.fo == null) {
            Future<Integer> result = FileObjectBasedFile.renameTo(this.env, this.getPath(), dest.getPath(), new StringWriter());
            try {
                return result.get() == 0;
            }
            catch (InterruptedException ex) {
            }
            catch (ExecutionException ex) {
                // empty catch block
            }
            return false;
        }
        String name = dest.getName();
        String ext = "";
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            ext = name.substring(pos + 1);
            name = name.substring(0, pos);
        }
        FileLock lock = this.fo.lock();
        try {
            this.fo.rename(lock, name, ext);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                lock.releaseLock();
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        lock.releaseLock();
        return bl;
    }

    @Override
    public boolean mkdirs() {
        if (this.fo == null) {
            try {
                this.fo = FileUtil.createFolder((FileObject)FileSystemProvider.getFileSystem(this.env).getRoot(), (String)this.path);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mkdir() {
        return this.mkdirs();
    }

    @Override
    public boolean canWrite() {
        return this.fo == null ? false : this.fo.canWrite();
    }

    @Override
    public boolean canRead() {
        return this.fo == null ? false : this.fo.canRead();
    }

    @Override
    public String getPath() {
        return this.fo == null ? this.path : this.fo.getPath();
    }

    @Override
    public File getParentFile() {
        if (this.fo == null) {
            String parentPath;
            String p = this.getPath();
            if (p != null && (parentPath = PathUtilities.getDirName((String)p)) != null && parentPath.length() > 0) {
                FileObject parentFO = FileSystemProvider.getFileObject(this.env, parentPath);
                if (parentFO == null) {
                    return new FileObjectBasedFile(this.env, parentPath);
                }
                return new FileObjectBasedFile(this.env, this.fo);
            }
            return null;
        }
        FileObject parent = this.fo.getParent();
        return parent == null ? null : new FileObjectBasedFile(this.env, parent);
    }

    @Override
    public String getName() {
        return this.fo == null ? PathUtilities.getBaseName((String)this.path) : this.fo.getNameExt();
    }

    @Override
    public boolean createNewFile() throws IOException {
        return super.createNewFile();
    }

    @Override
    public boolean delete() {
        if (this.fo == null) {
            this.fo = FileSystemProvider.getFileObject(this.env, this.path);
        }
        if (this.fo != null) {
            try {
                this.fo.delete();
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getParent() {
        int index = this.path.lastIndexOf(47);
        if (index < 0 || index == 0 && this.path.length() == 1) {
            return null;
        }
        return this.path.substring(0, index);
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public String getAbsolutePath() {
        if (this.fo != null) {
            return this.fo.getPath();
        }
        if (FileObjectBasedFile.isAbsolute(this.path)) {
            return this.path;
        }
        return FileObjectBasedFile.toUnix(super.getAbsolutePath());
    }

    private static boolean isAbsolute(String fileName) {
        return fileName.length() > 0 && fileName.charAt(0) == '/';
    }

    private static String toUnix(String path) {
        if (path != null && Utilities.isWindows()) {
            path = path.replace('\\', '/');
            while (path.startsWith("//")) {
                path = path.substring(1);
            }
        }
        return path;
    }

    @Override
    public File[] listFiles() {
        return this.listFiles((FilenameFilter)null);
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        if (this.fo == null) {
            return this.NO_CHILDREN;
        }
        FileObject[] children = this.fo.getChildren();
        ArrayList<FileObjectBasedFile> res = new ArrayList<FileObjectBasedFile>(children.length);
        for (FileObject child : children) {
            if (filter != null && !filter.accept(this, child.getNameExt())) continue;
            res.add(new FileObjectBasedFile(this.env, child));
        }
        return res.toArray(new File[res.size()]);
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this;
    }

    @Override
    public long length() {
        if (this.fo != null) {
            return this.fo.getSize();
        }
        return super.length();
    }

    @Override
    public long lastModified() {
        if (this.fo != null) {
            return this.fo.lastModified().getTime();
        }
        return super.lastModified();
    }

    public static Future<Integer> renameTo(final ExecutionEnvironment execEnv, final String sourceDir, final String destDir, final Writer error) {
        FutureTask<Integer> ftask = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ProcessUtils.ExitStatus result = ProcessUtils.execute((ExecutionEnvironment)execEnv, (String)"mv", (String[])new String[]{sourceDir, destDir});
                if (!result.isOK() && error != null) {
                    error.write(result.error);
                    error.flush();
                }
                return result.exitCode;
            }
        });
        processor.post(ftask);
        return ftask;
    }
}

