/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.project.ui.customizer.SourceRootsUi;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class FolderList
extends JPanel {
    public static final String PROP_FILES = "files";
    public static final String PROP_LAST_USED_DIR = "lastUsedDir";
    private static final Pattern TESTS_RE = Pattern.compile(".*test.*", 2);
    private String fcMessage;
    private File projectFolder;
    private File lastUsedFolder;
    private FolderList relatedFolderList;
    private FileFilter relatedFolderFilter;
    private JButton addButton;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JList roots;

    public FolderList(String label, char mnemonic, String accessibleDesc, String fcMessage, char addButtonMnemonic, String addButtonAccessibleDesc, char removeButtonMnemonic, String removeButtonAccessibleDesc) {
        this.fcMessage = fcMessage;
        this.initComponents();
        this.jLabel1.setText(label);
        this.jLabel1.setDisplayedMnemonic(mnemonic);
        this.roots.getAccessibleContext().setAccessibleName(accessibleDesc);
        this.roots.setCellRenderer(new Renderer());
        this.roots.setModel(new DefaultListModel());
        this.roots.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    FolderList.this.removeButton.setEnabled(FolderList.this.roots.getSelectedIndices().length != 0);
                }
            }
        });
        this.roots.setDragEnabled(true);
        this.roots.setDropMode(DropMode.INSERT);
        this.roots.setTransferHandler(new DNDHandle());
        this.addButton.getAccessibleContext().setAccessibleDescription(addButtonAccessibleDesc);
        this.addButton.setMnemonic(addButtonMnemonic);
        this.removeButton.getAccessibleContext().setAccessibleDescription(removeButtonAccessibleDesc);
        this.removeButton.setMnemonic(removeButtonMnemonic);
        this.removeButton.setEnabled(false);
    }

    public void setRelatedFolderList(FolderList relatedFolderList) {
        this.setRelatedFolderList(relatedFolderList, null);
    }

    public void setRelatedFolderList(FolderList relatedFolderList, FileFilter relatedFolderFilter) {
        this.relatedFolderList = relatedFolderList;
        this.relatedFolderFilter = relatedFolderFilter;
    }

    public File[] getFiles() {
        Object[] files = ((DefaultListModel)this.roots.getModel()).toArray();
        File[] result = new File[files.length];
        System.arraycopy(files, 0, result, 0, files.length);
        return result;
    }

    public void setProjectFolder(File projectFolder) {
        this.projectFolder = projectFolder;
    }

    public void setFiles(File[] files) {
        DefaultListModel model = (DefaultListModel)this.roots.getModel();
        model.clear();
        for (int i = 0; i < files.length; ++i) {
            model.addElement(files[i]);
        }
        if (files.length > 0) {
            this.roots.setSelectedIndex(0);
        }
    }

    public void setLastUsedDir(File lastUsedDir) {
        if (this.lastUsedFolder == null ? lastUsedDir != null : !this.lastUsedFolder.equals(lastUsedDir)) {
            File oldValue = this.lastUsedFolder;
            this.lastUsedFolder = lastUsedDir;
            this.firePropertyChange(PROP_LAST_USED_DIR, oldValue, this.lastUsedFolder);
        }
    }

    public File getLastUsedDir() {
        return this.lastUsedFolder;
    }

    @Override
    public void setEnabled(boolean active) {
        this.addButton.setEnabled(active);
        this.removeButton.setEnabled(active);
        this.jScrollPane1.setEnabled(active);
        this.roots.setEnabled(active);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.roots = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.roots);
        this.jLabel1.setText("jLabel1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FolderList.class, (String)"ACSD_NA"));
        this.jScrollPane1.setViewportView(this.roots);
        this.roots.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FolderList.class, (String)"ACSD_FolderList"));
        this.roots.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FolderList.class, (String)"ACSD_NA"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addButton.setText(NbBundle.getMessage(FolderList.class, (String)"CTL_AddFolder"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderList.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FolderList.class, (String)"ACSD_NA"));
        this.removeButton.setText(NbBundle.getMessage(FolderList.class, (String)"CTL_RemoveFolder"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderList.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FolderList.class, (String)"ACSD_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FolderList.class, (String)"ACSD_NA"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FolderList.class, (String)"ACSD_NA"));
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Object[] selection = this.roots.getSelectedValues();
        for (int i = 0; i < selection.length; ++i) {
            ((DefaultListModel)this.roots.getModel()).removeElement(selection[i]);
        }
        this.firePropertyChange(PROP_FILES, null, null);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(this.fcMessage);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(true);
        if (this.lastUsedFolder != null && this.lastUsedFolder.isDirectory()) {
            chooser.setCurrentDirectory(this.lastUsedFolder);
        } else if (this.projectFolder != null && this.projectFolder.isDirectory()) {
            chooser.setCurrentDirectory(this.projectFolder);
        }
        if (chooser.showOpenDialog(this) == 0) {
            File cd;
            final File[] files = FolderList.normalizeFiles(chooser.getSelectedFiles());
            final AtomicReference toAddRef = new AtomicReference();
            class ScanTask
            implements ProgressRunnable<Void>,
            Cancellable {
                private final AtomicBoolean cancel = new AtomicBoolean();

                ScanTask() {
                }

                public Void run(ProgressHandle handle) {
                    ArrayList<File> toAdd = new ArrayList<File>();
                    for (File file : files) {
                        if (this.cancel.get()) {
                            return null;
                        }
                        Set detectedRoots = JavadocAndSourceRootDetection.findSourceRoots((FileObject)FileUtil.toFileObject((File)file), (AtomicBoolean)this.cancel);
                        if (detectedRoots.isEmpty()) {
                            toAdd.add(file);
                            continue;
                        }
                        for (FileObject detectedRoot : detectedRoots) {
                            toAdd.add(FileUtil.toFile((FileObject)detectedRoot));
                        }
                    }
                    toAddRef.set(toAdd);
                    return null;
                }

                public boolean cancel() {
                    this.cancel.set(true);
                    return true;
                }
            }
            ScanTask task = new ScanTask();
            ProgressUtils.showProgressDialogAndRun((ProgressRunnable)task, (String)NbBundle.getMessage(FolderList.class, (String)"TXT_SearchingSourceRoots"), (boolean)false);
            List toAdd = (List)toAddRef.get();
            LinkedList<File> related = new LinkedList<File>();
            if (this.relatedFolderList != null && this.relatedFolderFilter != null && toAdd != null) {
                if (this.relatedFolderFilter instanceof ContextFileFilter) {
                    ((ContextFileFilter)this.relatedFolderFilter).setContext(files);
                }
                Iterator it = toAdd.iterator();
                while (it.hasNext()) {
                    File f = (File)it.next();
                    if (!this.relatedFolderFilter.accept(f)) continue;
                    it.remove();
                    related.add(f);
                }
            }
            File[] toAddArr = toAdd == null ? files : toAdd.toArray(new File[toAdd.size()]);
            HashSet invalidRoots = new HashSet();
            this.addFiles(toAddArr, invalidRoots);
            if (!related.isEmpty()) {
                this.relatedFolderList.addFiles(related.toArray(new File[related.size()]), invalidRoots);
            }
            if ((cd = chooser.getCurrentDirectory()) != null) {
                this.setLastUsedDir(FileUtil.normalizeFile((File)cd));
            }
            if (invalidRoots.size() > 0) {
                SourceRootsUi.showIllegalRootsDialog(invalidRoots);
            }
        }
    }

    private void addFiles(File[] toAddArr, Set<? super File> invalidRoots) {
        int[] indecesToSelect = new int[toAddArr.length];
        DefaultListModel model = (DefaultListModel)this.roots.getModel();
        File[] relatedFolders = this.relatedFolderList == null ? new File[]{} : this.relatedFolderList.getFiles();
        int index = model.size();
        for (int i = 0; i < toAddArr.length; ++i) {
            File normalizedFile = toAddArr[i];
            if (!FolderList.isValidRoot(normalizedFile, relatedFolders, this.projectFolder)) {
                invalidRoots.add(normalizedFile);
                continue;
            }
            int pos = model.indexOf(normalizedFile);
            if (pos == -1) {
                model.addElement(normalizedFile);
                indecesToSelect[i] = index;
            } else {
                indecesToSelect[i] = pos;
            }
            ++index;
        }
        this.roots.setSelectedIndices(indecesToSelect);
        this.firePropertyChange(PROP_FILES, null, null);
    }

    private static File[] normalizeFiles(File ... files) {
        for (int i = 0; i < files.length; ++i) {
            files[i] = FileUtil.normalizeFile((File)files[i]);
        }
        return files;
    }

    public static boolean isValidRoot(File file, File[] relatedRoots, File projectFolder) {
        Project p = FileOwnerQuery.getOwner((URI)Utilities.toURI((File)file));
        if (p != null && !file.getAbsolutePath().startsWith(projectFolder.getAbsolutePath() + File.separatorChar)) {
            Sources sources = (Sources)p.getLookup().lookup(Sources.class);
            if (sources == null) {
                return false;
            }
            SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
            SourceGroup[] javaGroups = sources.getSourceGroups("java");
            SourceGroup[] groups = new SourceGroup[sourceGroups.length + javaGroups.length];
            System.arraycopy(sourceGroups, 0, groups, 0, sourceGroups.length);
            System.arraycopy(javaGroups, 0, groups, sourceGroups.length, javaGroups.length);
            FileObject projectDirectory = p.getProjectDirectory();
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (projectDirectory == null || fileObject == null) {
                return false;
            }
            for (int i = 0; i < groups.length; ++i) {
                FileObject sgRoot = groups[i].getRootFolder();
                if (fileObject.equals(sgRoot)) {
                    return false;
                }
                if (projectDirectory.equals(sgRoot) || !FileUtil.isParentOf((FileObject)sgRoot, (FileObject)fileObject)) continue;
                return false;
            }
            return true;
        }
        return !FolderList.contains(file, relatedRoots);
    }

    public static FileFilter testRootsFilter() {
        return new ContextFileFilter(){
            private Set<File> selectedFiles;

            @Override
            public boolean accept(File pathname) {
                boolean pathCheck = this.selectedFiles != null && !this.selectedFiles.contains(pathname);
                do {
                    String toTest = pathname.getName();
                    if (TESTS_RE.matcher(toTest).matches()) {
                        return true;
                    }
                    pathname = pathname.getParentFile();
                } while (pathCheck && pathname != null && !this.selectedFiles.contains(pathname));
                return false;
            }

            @Override
            public void setContext(File[] selectedFiles) {
                this.selectedFiles = new HashSet<File>(Arrays.asList(selectedFiles));
            }
        };
    }

    private static boolean contains(File folder, File[] roots) {
        String path = folder.getAbsolutePath();
        for (int i = 0; i < roots.length; ++i) {
            String rootPath = roots[i].getAbsolutePath();
            if (!rootPath.equals(path) && !path.startsWith(rootPath + File.separatorChar)) continue;
            return true;
        }
        return false;
    }

    private static interface ContextFileFilter
    extends FileFilter {
        public void setContext(File[] var1);
    }

    private class DNDHandle
    extends TransferHandler {
        private int[] indices = new int[0];

        private DNDHandle() {
        }

        @Override
        public int getSourceActions(JComponent comp) {
            return 2;
        }

        @Override
        public Transferable createTransferable(JComponent comp) {
            JList list = (JList)comp;
            this.indices = list.getSelectedIndices();
            if (this.indices.length == 0) {
                return null;
            }
            return new FileListTransferable(this.safeCopy(list.getSelectedValues(), File.class));
        }

        private <T> List<? extends T> safeCopy(Object[] data, Class<T> clazz) {
            ArrayList<T> result = new ArrayList<T>(data.length);
            for (Object d : data) {
                result.add(clazz.cast(d));
            }
            return result;
        }

        @Override
        public void exportDone(JComponent comp, Transferable trans, int action) {
            if (action == 2) {
                JList from = (JList)comp;
                DefaultListModel model = (DefaultListModel)from.getModel();
                for (int i = this.indices.length - 1; i >= 0; --i) {
                    model.removeElementAt(this.indices[i]);
                }
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            boolean actionSupported;
            if (!support.isDrop()) {
                return false;
            }
            if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            boolean bl = actionSupported = (2 & support.getSourceDropActions()) == 2;
            if (!actionSupported) {
                return false;
            }
            support.setDropAction(2);
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            List data;
            if (!this.canImport(support)) {
                return false;
            }
            JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
            int index = Math.max(0, dl.getIndex());
            try {
                data = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            ArrayList<File> validRoots = new ArrayList<File>();
            HashSet<File> invalidRoots = new HashSet<File>();
            if (FolderList.this.relatedFolderList != null && FolderList.this.projectFolder != null) {
                File[] relatedFolders = support.getSourceDropActions() == 2 ? new File[]{} : FolderList.this.relatedFolderList.getFiles();
                for (File file : data) {
                    if (!FolderList.isValidRoot(file, relatedFolders, FolderList.this.projectFolder)) {
                        invalidRoots.add(file);
                        continue;
                    }
                    validRoots.add(file);
                }
            } else {
                validRoots.addAll(data);
            }
            JList list = (JList)support.getComponent();
            DefaultListModel model = (DefaultListModel)list.getModel();
            int[] indices = new int[validRoots.size()];
            int i = 0;
            while (i < validRoots.size()) {
                model.insertElementAt(validRoots.get(i), index);
                indices[i] = index;
                this.updateIndexes(index);
                ++i;
                ++index;
            }
            if (!validRoots.isEmpty()) {
                Rectangle rect = list.getCellBounds(indices[0], indices[indices.length - 1]);
                list.scrollRectToVisible(rect);
                list.setSelectedIndices(indices);
                list.requestFocusInWindow();
            }
            if (!invalidRoots.isEmpty()) {
                SourceRootsUi.showIllegalRootsDialog(invalidRoots);
            }
            return true;
        }

        private void updateIndexes(int index) {
            for (int i = 0; i < this.indices.length; ++i) {
                if (index >= this.indices[i]) continue;
                int n = i;
                this.indices[n] = this.indices[n] + 1;
            }
        }
    }

    private static class FileListTransferable
    implements Transferable {
        private final List<? extends File> data;

        public FileListTransferable(List<? extends File> data) {
            data.getClass();
            this.data = data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.javaFileListFlavor == flavor;
        }

        @Override
        public List<? extends File> getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.data;
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (" ".equals(value)) {
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
            File f = (File)value;
            String message = f.getAbsolutePath();
            Component result = super.getListCellRendererComponent((JList<?>)list, message, index, isSelected, cellHasFocus);
            return result;
        }
    }
}

