/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.awt.Image;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ActionFilterNode;
import org.netbeans.modules.java.api.common.project.ui.RemoveClassPathRootAction;
import org.netbeans.modules.java.api.common.project.ui.ShowJavadocAction;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class ProjectNode
extends AbstractNode {
    private static final String PROJECT_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/projectDependencies.gif";
    private final AntArtifact antArtifact;
    private final URI artifactLocation;
    private Image cachedIcon;

    public ProjectNode(AntArtifact antArtifact, URI artifactLocation, UpdateHelper helper, String classPathId, String entryId, String webModuleElementName, ClassPathSupport cs, ReferenceHelper rh) {
        super(Children.LEAF, ProjectNode.createLookup(antArtifact, artifactLocation, helper, classPathId, entryId, webModuleElementName, cs, rh));
        this.antArtifact = antArtifact;
        this.artifactLocation = artifactLocation;
    }

    public String getDisplayName() {
        ProjectInformation info = this.getProjectInformation();
        if (info != null) {
            return NbBundle.getMessage(ProjectNode.class, (String)"TXT_ProjectArtifactFormat", (Object[])new Object[]{info.getDisplayName(), this.artifactLocation.toString()});
        }
        return NbBundle.getMessage(ProjectNode.class, (String)"TXT_UnknownProjectName");
    }

    public String getName() {
        return this.getDisplayName();
    }

    public Image getIcon(int type) {
        if (this.cachedIcon == null) {
            ProjectInformation info = this.getProjectInformation();
            if (info != null) {
                Icon icon = info.getIcon();
                this.cachedIcon = ImageUtilities.icon2Image((Icon)icon);
            } else {
                this.cachedIcon = ImageUtilities.loadImage((String)PROJECT_ICON);
            }
        }
        return this.cachedIcon;
    }

    public String getShortDescription() {
        FileObject fo;
        Project p = this.antArtifact.getProject();
        if (p != null && (fo = p.getProjectDirectory()) != null) {
            return FileUtil.getFileDisplayName((FileObject)fo);
        }
        return super.getShortDescription();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(OpenProjectAction.class), SystemAction.get(ShowJavadocAction.class), SystemAction.get(RemoveClassPathRootAction.class)};
    }

    public Action getPreferredAction() {
        return this.getActions(false)[0];
    }

    private ProjectInformation getProjectInformation() {
        Project p = this.antArtifact.getProject();
        if (p != null) {
            return ProjectUtils.getInformation((Project)p);
        }
        return null;
    }

    private static Lookup createLookup(AntArtifact antArtifact, URI artifactLocation, UpdateHelper helper, String classPathId, String entryId, String webModuleElementName, ClassPathSupport cs, ReferenceHelper rh) {
        Object[] content;
        Project p = antArtifact.getProject();
        if (p == null) {
            content = new Object[1];
        } else {
            content = new Object[3];
            content[1] = new JavadocProvider(antArtifact, artifactLocation);
            content[2] = p;
        }
        content[0] = new ActionFilterNode.Removable(helper, classPathId, entryId, webModuleElementName, cs, rh);
        Lookup lkp = Lookups.fixed((Object[])content);
        return lkp;
    }

    private static class OpenProjectAction
    extends NodeAction {
        private OpenProjectAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            Project[] projects = new Project[activatedNodes.length];
            for (int i = 0; i < projects.length; ++i) {
                Project p = OpenProjectAction.getProject(activatedNodes[i]);
                if (p == null) {
                    return;
                }
                projects[i] = p;
            }
            OpenProjects.getDefault().open(projects, false);
        }

        protected boolean enable(Node[] activatedNodes) {
            List<Project> openedProjects = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
            for (int i = 0; i < activatedNodes.length; ++i) {
                Project p = OpenProjectAction.getProject(activatedNodes[i]);
                if (p == null) {
                    return false;
                }
                if (!openedProjects.contains(p)) continue;
                return false;
            }
            return true;
        }

        private static Project getProject(Node node) {
            FileObject projectRoot;
            assert (node != null);
            Project p = (Project)node.getLookup().lookup(Project.class);
            if (!(p == null || (projectRoot = p.getProjectDirectory()) != null && projectRoot.isValid())) {
                return null;
            }
            return p;
        }

        public String getName() {
            return NbBundle.getMessage(ProjectNode.class, (String)"CTL_OpenProject");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(OpenProjectAction.class);
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private final AntArtifact antArtifact;
        private final URI artifactLocation;

        JavadocProvider(AntArtifact antArtifact, URI artifactLocation) {
            this.antArtifact = antArtifact;
            this.artifactLocation = artifactLocation;
        }

        @Override
        public boolean hasJavadoc() {
            return this.findJavadoc().size() > 0;
        }

        @Override
        public void showJavadoc() {
            Set<URL> us = this.findJavadoc();
            URL[] urls = us.toArray(new URL[us.size()]);
            URL pageURL = ShowJavadocAction.findJavadoc("overview-summary.html", urls);
            if (pageURL == null) {
                pageURL = ShowJavadocAction.findJavadoc("index.html", urls);
            }
            ProjectInformation info = null;
            Project p = this.antArtifact.getProject();
            if (p != null) {
                info = ProjectUtils.getInformation((Project)p);
            }
            ShowJavadocAction.showJavaDoc(pageURL, info == null ? NbBundle.getMessage(ProjectNode.class, (String)"TXT_UnknownProjectName") : info.getDisplayName());
        }

        private Set<URL> findJavadoc() {
            File scriptLocation = this.antArtifact.getScriptLocation();
            HashSet<URL> urls = new HashSet<URL>();
            try {
                URL artifactURL = Utilities.toURI((File)scriptLocation).resolve(this.artifactLocation).normalize().toURL();
                if (FileUtil.isArchiveFile((URL)artifactURL)) {
                    artifactURL = FileUtil.getArchiveRoot((URL)artifactURL);
                }
                urls.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc((URL)artifactURL).getRoots()));
            }
            catch (MalformedURLException mue) {
                Exceptions.printStackTrace((Throwable)mue);
            }
            return urls;
        }
    }
}

