/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ActionFilterNode;
import org.netbeans.modules.java.api.common.project.ui.EditRootAction;
import org.netbeans.modules.java.api.common.project.ui.LibrariesNode;
import org.netbeans.modules.java.api.common.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.java.api.common.project.ui.ShowJavadocAction;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;

class PlatformNode
extends AbstractNode
implements ChangeListener {
    private static final String PLATFORM_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/platform.gif";
    private static final String ARCHIVE_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/jar.gif";
    private final PlatformProvider pp;

    private PlatformNode(PlatformProvider pp, ClassPathSupport cs) {
        super((Children)new PlatformContentChildren(cs), (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{new PlatformEditable(pp), new JavadocProvider(pp), new PathFinder()}), new PlatformFolderLookup(new InstanceContent(), pp)}));
        this.pp = pp;
        this.pp.addChangeListener(this);
        this.setIconBaseWithExtension(PLATFORM_ICON);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        String platformId;
        Object[] platHolder = this.pp.getPlatform();
        if (platHolder == null) {
            return NbBundle.getMessage(PlatformNode.class, (String)"TXT_UnknownPlatform");
        }
        String name = platHolder[1] != null ? ((JavaPlatform)platHolder[1]).getDisplayName() : ((platformId = (String)platHolder[0]) == null ? NbBundle.getMessage(PlatformNode.class, (String)"TXT_BrokenPlatform") : MessageFormat.format(NbBundle.getMessage(PlatformNode.class, (String)"FMT_BrokenPlatform"), platformId));
        return name;
    }

    public String getHtmlDisplayName() {
        Object[] platHolder = this.pp.getPlatform();
        if (platHolder == null) {
            return null;
        }
        if (platHolder[1] == null) {
            String displayName = this.getDisplayName();
            try {
                displayName = XMLUtil.toElementContent((String)displayName);
            }
            catch (CharConversionException ex) {
                return null;
            }
            return "<font color=\"#A40000\">" + displayName + "</font>";
        }
        return null;
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(ShowJavadocAction.class), SystemAction.get(EditRootAction.class)};
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        LibrariesNode.rp.post(new Runnable(){

            @Override
            public void run() {
                ((PlatformContentChildren)PlatformNode.this.getChildren()).addNotify();
            }
        });
    }

    public String getShortDescription() {
        Object[] platHolder = this.pp.getPlatform();
        if (platHolder != null && platHolder[1] != null && !((JavaPlatform)platHolder[1]).getInstallFolders().isEmpty()) {
            FileObject installFolder = (FileObject)((JavaPlatform)platHolder[1]).getInstallFolders().iterator().next();
            return FileUtil.getFileDisplayName((FileObject)installFolder);
        }
        return super.getShortDescription();
    }

    public static PlatformNode create(PropertyEvaluator eval, String platformPropName, ClassPathSupport cs) {
        PlatformProvider pp = new PlatformProvider(eval, platformPropName);
        return new PlatformNode(pp, cs);
    }

    private static final class PathFinder
    implements org.netbeans.spi.project.ui.PathFinder {
        PathFinder() {
        }

        public Node findPath(Node root, Object target) {
            Node node;
            org.netbeans.spi.project.ui.PathFinder pf;
            Node result = null;
            Node[] arr$ = root.getChildren().getNodes(true);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((pf = (org.netbeans.spi.project.ui.PathFinder)(node = arr$[i$]).getLookup().lookup(org.netbeans.spi.project.ui.PathFinder.class)) == null || (result = pf.findPath(node, target)) == null); ++i$) {
            }
            return result;
        }
    }

    private static class PlatformFolderLookup
    extends AbstractLookup {
        private final InstanceContent content;
        private final PlatformProvider platformProvider;

        PlatformFolderLookup(InstanceContent content, PlatformProvider platformProvider) {
            super((AbstractLookup.Content)content);
            this.content = content;
            this.platformProvider = platformProvider;
        }

        protected void beforeLookup(Lookup.Template<?> template) {
            super.beforeLookup(template);
            if (template.getType() == FileObject.class) {
                FileObject fo;
                Collection folders;
                ArrayList<DataObject> toAdd = new ArrayList<DataObject>(1);
                Object[] platHolder = this.platformProvider.getPlatform();
                if (platHolder != null && platHolder[1] != null && !(folders = ((JavaPlatform)platHolder[1]).getInstallFolders()).isEmpty() && (fo = (FileObject)folders.iterator().next()).isValid() && fo.isFolder()) {
                    try {
                        toAdd.add(DataFolder.find((FileObject)fo));
                    }
                    catch (DataObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
                this.content.set(toAdd, null);
            }
        }
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private final PlatformProvider platformProvider;

        private JavadocProvider(PlatformProvider platformProvider) {
            this.platformProvider = platformProvider;
        }

        @Override
        public boolean hasJavadoc() {
            Object[] platHolder = this.platformProvider.getPlatform();
            if (platHolder == null || platHolder[1] == null) {
                return false;
            }
            URL[] javadocRoots = JavadocProvider.getJavadocRoots((JavaPlatform)platHolder[1]);
            return javadocRoots.length > 0;
        }

        @Override
        public void showJavadoc() {
            Object[] platHolder = this.platformProvider.getPlatform();
            if (platHolder != null && platHolder[1] != null) {
                JavaPlatform platform = (JavaPlatform)platHolder[1];
                URL[] javadocRoots = JavadocProvider.getJavadocRoots(platform);
                URL pageURL = ShowJavadocAction.findJavadoc("overview-summary.html", javadocRoots);
                if (pageURL == null) {
                    pageURL = ShowJavadocAction.findJavadoc("index.html", javadocRoots);
                }
                ShowJavadocAction.showJavaDoc(pageURL, platform.getDisplayName());
            }
        }

        private static URL[] getJavadocRoots(JavaPlatform platform) {
            HashSet<URL> result = new HashSet<URL>();
            List l = platform.getBootstrapLibraries().entries();
            for (ClassPath.Entry e : l) {
                result.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc((URL)e.getURL()).getRoots()));
            }
            return result.toArray(new URL[result.size()]);
        }
    }

    private static class PlatformProvider
    implements PropertyChangeListener {
        private static final Object[] BUSY = new Object[0];
        private static final RequestProcessor RP = new RequestProcessor(PlatformProvider.class);
        private final PropertyEvaluator evaluator;
        private final String platformPropName;
        private final AtomicReference<Object[]> platformCache = new AtomicReference();
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public PlatformProvider(PropertyEvaluator evaluator, String platformPropName) {
            this.evaluator = evaluator;
            this.platformPropName = platformPropName;
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
        }

        @CheckForNull
        public Object[] getPlatform() {
            Object[] res;
            if (this.platformCache.compareAndSet(null, BUSY)) {
                RP.execute(new Runnable(){

                    @Override
                    public void run() {
                        String platformId = PlatformProvider.this.evaluator.getProperty(PlatformProvider.this.platformPropName);
                        JavaPlatform platform = CommonProjectUtils.getActivePlatform(platformId);
                        PlatformProvider.this.platformCache.set(new Object[]{platformId, platform});
                        PlatformProvider.this.changeSupport.fireChange();
                    }
                });
            }
            return (res = this.platformCache.get()) == BUSY ? null : res;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.platformPropName.equals(evt.getPropertyName())) {
                this.platformCache.set(null);
                this.getPlatform();
            }
        }
    }

    private static class PlatformEditable
    implements EditRootAction.Editable {
        private final PlatformProvider pp;

        private PlatformEditable(@NonNull PlatformProvider pp) {
            Parameters.notNull((CharSequence)"pp", (Object)pp);
            this.pp = pp;
        }

        @Override
        public boolean canEdit() {
            Object[] platHolder = this.pp.getPlatform();
            return platHolder != null && platHolder[1] != null;
        }

        @Override
        public void edit() {
            Object[] platHolder = this.pp.getPlatform();
            if (platHolder != null && platHolder[1] != null) {
                PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)platHolder[1]));
            }
        }
    }

    private static class PlatformContentChildren
    extends Children.Keys<SourceGroup> {
        PlatformContentChildren(ClassPathSupport cs) {
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(SourceGroup sg) {
            Node[] nodeArray;
            FilterNode afn = ActionFilterNode.forPackage(PackageView.createPackageView((SourceGroup)sg));
            if (afn == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = afn;
            }
            return nodeArray;
        }

        private List<SourceGroup> getKeys() {
            Object[] platHolder = ((PlatformNode)this.getNode()).pp.getPlatform();
            if (platHolder == null || platHolder[1] == null) {
                return Collections.emptyList();
            }
            FileObject[] roots = ((JavaPlatform)platHolder[1]).getBootstrapLibraries().getRoots();
            ArrayList<SourceGroup> result = new ArrayList<SourceGroup>(roots.length);
            for (int i = 0; i < roots.length; ++i) {
                ImageIcon icon;
                ImageIcon openedIcon;
                FileObject file;
                if ("jar".equals(roots[i].toURL().getProtocol())) {
                    file = FileUtil.getArchiveFile((FileObject)roots[i]);
                    icon = openedIcon = ImageUtilities.loadImageIcon((String)PlatformNode.ARCHIVE_ICON, (boolean)false);
                } else {
                    file = roots[i];
                    icon = null;
                    openedIcon = null;
                }
                if (!file.isValid()) continue;
                result.add(new LibrariesSourceGroup(roots[i], file.getNameExt(), icon, openedIcon));
            }
            return result;
        }
    }
}

