/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ProjectProperties;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class ClassPathSupport {
    public static final String ENDORSED = "classpath/endorsed";
    private static final String LIBRARY_PREFIX = "${libs.";
    private static final String LIBRARY_SUFFIX = ".classpath}";
    private static final String ANT_ARTIFACT_PREFIX = "${reference.";
    private PropertyEvaluator evaluator;
    private ReferenceHelper referenceHelper;
    private AntProjectHelper antProjectHelper;
    private UpdateHelper updateHelper;
    private static Set<String> wellKnownPaths;
    private static String antArtifactPrefix;
    private Callback callback;

    public ClassPathSupport(PropertyEvaluator evaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, UpdateHelper updateHelper, Callback callback) {
        assert (referenceHelper != null);
        this.evaluator = evaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
        this.updateHelper = updateHelper;
        this.callback = callback;
    }

    public Iterator<Item> itemsIterator(String propertyValue) {
        return this.itemsIterator(propertyValue, null);
    }

    public Iterator<Item> itemsIterator(String propertyValue, String projectXMLElement) {
        return this.itemsList(propertyValue, projectXMLElement).iterator();
    }

    public List<Item> itemsList(String propertyValue) {
        return this.itemsList(propertyValue, null);
    }

    public List<Item> itemsList(String propertyValue, String projectXMLElement) {
        String[] pe = PropertyUtils.tokenizePath((String)(propertyValue == null ? "" : propertyValue));
        ArrayList<Item> items = new ArrayList<Item>(pe.length);
        for (int i = 0; i < pe.length; ++i) {
            Item item;
            if (this.isWellKnownPath(pe[i])) {
                item = Item.create(pe[i]);
            } else if (ClassPathSupport.isLibrary(pe[i])) {
                String libraryName = ClassPathSupport.getLibraryNameFromReference(pe[i]);
                assert (libraryName != null) : "Not a library reference: " + pe[i];
                Library library = this.referenceHelper.findLibrary(libraryName);
                item = library == null ? Item.createBroken(1, pe[i]) : Item.create(library, pe[i]);
            } else if (this.isAntArtifact(pe[i])) {
                Object[] ret = this.referenceHelper.findArtifactAndLocation(pe[i]);
                if (ret[0] == null || ret[1] == null) {
                    item = Item.createBroken(2, pe[i]);
                } else {
                    File artifactFile;
                    AntArtifact artifact = (AntArtifact)ret[0];
                    URI uri = (URI)ret[1];
                    File usedFile = this.antProjectHelper.resolveFile(this.evaluator.evaluate(pe[i]));
                    item = usedFile.equals(artifactFile = Utilities.toFile((URI)Utilities.toURI((File)artifact.getScriptLocation()).resolve(uri).normalize())) ? Item.create(artifact, uri, pe[i]) : Item.createBroken(2, pe[i]);
                }
            } else {
                String eval = this.evaluator.evaluate(pe[i]);
                File f = null;
                if (eval != null) {
                    f = this.antProjectHelper.resolveFile(eval);
                }
                String propertyName = CommonProjectUtils.getAntPropertyName(pe[i]);
                String variableBaseProperty = this.antProjectHelper.getProperties("nbproject/project.properties").getProperty(propertyName);
                if (!ClassPathSupport.isVariableBasedReference(variableBaseProperty)) {
                    variableBaseProperty = null;
                }
                item = f == null || !f.exists() ? Item.createBroken(eval, FileUtil.toFile((FileObject)this.antProjectHelper.getProjectDirectory()), pe[i]) : Item.create(eval, FileUtil.toFile((FileObject)this.antProjectHelper.getProjectDirectory()), pe[i], variableBaseProperty);
                item.initSourceAndJavadoc(this.antProjectHelper);
            }
            items.add(item);
        }
        if (projectXMLElement != null) {
            this.callback.readAdditionalProperties(items, projectXMLElement);
        }
        return items;
    }

    public String[] encodeToStrings(List<Item> classpath) {
        return this.encodeToStrings(classpath, null);
    }

    public String[] encodeToStrings(List<Item> classpath, String projectXMLElement) {
        return this.encodeToStrings(classpath, projectXMLElement, "classpath");
    }

    public String[] encodeToStrings(List<Item> classpath, String projectXMLElement, String libraryVolumeType) {
        String[] arr;
        ArrayList<String> items = new ArrayList<String>();
        for (Item item : classpath) {
            String reference = null;
            switch (item.getType()) {
                case 0: {
                    reference = item.getReference();
                    if (item.isBroken()) break;
                    if (reference == null) {
                        reference = this.referenceHelper.createForeignFileReferenceAsIs(item.getFilePath(), null);
                        if (item.getVariableBasedProperty() != null) {
                            EditableProperties ep = this.antProjectHelper.getProperties("nbproject/project.properties");
                            ep.setProperty(CommonProjectUtils.getAntPropertyName(reference), item.getVariableBasedProperty());
                            this.antProjectHelper.putProperties("nbproject/project.properties", ep);
                        }
                        item.setReference(reference);
                    }
                    item.saveSourceAndJavadoc(this.referenceHelper, this.updateHelper);
                    break;
                }
                case 1: {
                    reference = item.getReference();
                    if (item.isBroken()) break;
                    Library library = item.getLibrary();
                    if (reference != null || library == null) break;
                    reference = this.getLibraryReference(item, libraryVolumeType);
                    item.setReference(reference);
                    break;
                }
                case 2: {
                    reference = item.getReference();
                    if (item.isBroken()) break;
                    AntArtifact artifact = item.getArtifact();
                    if (reference != null || artifact == null) break;
                    reference = this.referenceHelper.addReference(item.getArtifact(), item.getArtifactURI());
                    item.setReference(reference);
                    break;
                }
                case 3: {
                    reference = item.getReference();
                }
            }
            items.add(reference + ":");
        }
        if (projectXMLElement != null) {
            this.callback.storeAdditionalProperties(classpath, projectXMLElement);
        }
        if ((arr = items.toArray(new String[items.size()])).length != 0) {
            arr[arr.length - 1] = arr[arr.length - 1].substring(0, arr[arr.length - 1].length() - 1);
        }
        return arr;
    }

    public String getLibraryReference(Item item) {
        return this.getLibraryReference(item, "classpath");
    }

    public String getLibraryReference(Item item, String volumeType) {
        if (item.getType() != 1) {
            throw new IllegalArgumentException("Item must be of type LIBRARY");
        }
        return this.referenceHelper.createLibraryReference(item.getLibrary(), volumeType);
    }

    private boolean isWellKnownPath(String property) {
        return ClassPathSupport.getWellKnownPaths().contains(property);
    }

    private boolean isAntArtifact(String property) {
        return antArtifactPrefix == null ? false : property.startsWith(antArtifactPrefix);
    }

    private static boolean isLibrary(String property) {
        return property.startsWith(LIBRARY_PREFIX) && property.endsWith(LIBRARY_SUFFIX);
    }

    @NonNull
    private static synchronized Set<String> getWellKnownPaths() {
        if (wellKnownPaths == null) {
            wellKnownPaths = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ProjectProperties.WELL_KNOWN_PATHS)));
        }
        return wellKnownPaths;
    }

    public static boolean isVariableBasedReference(String ref) {
        return ref != null && ref.startsWith("${var.");
    }

    public static String getLibraryNameFromReference(String property) {
        if (!ClassPathSupport.isLibrary(property)) {
            return null;
        }
        return property.substring(LIBRARY_PREFIX.length(), property.lastIndexOf(46));
    }

    static {
        antArtifactPrefix = ANT_ARTIFACT_PREFIX;
    }

    public static interface Callback {
        public void readAdditionalProperties(List<Item> var1, String var2);

        public void storeAdditionalProperties(List<Item> var1, String var2);
    }

    private static final class RelativePath {
        private String filePath;
        private final File base;
        private final File resolvedFile;

        private RelativePath(@NonNull String filePath, @NonNull File base) {
            Parameters.notNull((CharSequence)"filePath", (Object)filePath);
            Parameters.notNull((CharSequence)"base", (Object)base);
            this.filePath = filePath;
            this.base = base;
            this.resolvedFile = PropertyUtils.resolveFile((File)base, (String)filePath);
        }

        public static RelativePath createRelativePath(String filePath, File base) {
            return new RelativePath(filePath, base);
        }

        public String getFilePath() {
            return this.filePath;
        }

        private void setFilePath(@NonNull String filePath) {
            Parameters.notNull((CharSequence)"filePath", (Object)filePath);
            this.filePath = filePath;
        }

        public File getResolvedFile() {
            return this.resolvedFile;
        }

        public int hashCode() {
            return this.filePath.hashCode() + this.base.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RelativePath)) {
                return false;
            }
            RelativePath other = (RelativePath)obj;
            return this.filePath.equals(other.filePath) && this.base.equals(other.base);
        }
    }

    public static class Item {
        public static final int TYPE_JAR = 0;
        public static final int TYPE_LIBRARY = 1;
        public static final int TYPE_ARTIFACT = 2;
        public static final int TYPE_CLASSPATH = 3;
        private static final String REF_START = "${file.reference.";
        private static final int REF_START_INDEX = "${file.reference.".length();
        private static final String JAVADOC_START = "${javadoc.reference.";
        private static final String SOURCE_START = "${source.reference.";
        private Object object;
        private URI artifactURI;
        private int type;
        private String property;
        private boolean broken;
        private String sourceFilePath;
        private String javadocFilePath;
        private String initialSourceFilePath;
        private String initialJavadocFilePath;
        private String libraryName;
        private String variableBasedProperty;
        private Map<String, String> additionalProperties = new HashMap<String, String>();

        private Item(int type, Object object, String property, boolean broken) {
            this.type = type;
            this.object = object;
            this.broken = broken;
            if (!(object == null || type == 3 || broken || type == 0 && object instanceof RelativePath || type == 2 && object instanceof AntArtifact || type == 1 && object instanceof Library)) {
                throw new IllegalArgumentException("invalid classpath item, type=" + type + " object type:" + object.getClass().getName());
            }
            this.property = property;
        }

        private Item(int type, Object object, URI artifactURI, String property) {
            this(type, object, property);
            this.artifactURI = artifactURI;
        }

        private Item(int type, Object object, String property) {
            this(type, object, property, false);
        }

        public String getAdditionalProperty(String key) {
            return this.additionalProperties.get(key);
        }

        public void setAdditionalProperty(String key, String value) {
            this.additionalProperties.put(key, value);
        }

        public static Item create(Library library, String property) {
            if (library == null) {
                throw new IllegalArgumentException("library must not be null");
            }
            String libraryName = library.getName();
            Item itm = new Item(1, library, property);
            itm.libraryName = libraryName;
            itm.reassignLibraryManager(library.getManager());
            return itm;
        }

        public static Item create(AntArtifact artifact, URI artifactURI, String property) {
            if (artifactURI == null) {
                throw new IllegalArgumentException("artifactURI must not be null");
            }
            if (artifact == null) {
                throw new IllegalArgumentException("artifact must not be null");
            }
            return new Item(2, (Object)artifact, artifactURI, property);
        }

        public static Item create(String filePath, File base, String property, String variableBasedProperty) {
            if (filePath == null) {
                throw new IllegalArgumentException("file path must not be null");
            }
            Item i = new Item(0, RelativePath.createRelativePath(filePath, base), property);
            i.variableBasedProperty = variableBasedProperty;
            return i;
        }

        public static Item create(String property) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(3, null, property);
        }

        public static Item createBroken(int type, String property) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            Item itm = new Item(type, null, property, true);
            if (type == 1) {
                Pattern LIBRARY_REFERENCE = Pattern.compile("\\$\\{libs\\.([^${}]+)\\.[^${}]+\\}");
                Matcher m = LIBRARY_REFERENCE.matcher(property);
                if (m.matches()) {
                    itm.libraryName = m.group(1);
                } else assert (false) : property;
            }
            return itm;
        }

        public static Item createBroken(String filePath, File base, String property) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(0, (Object)RelativePath.createRelativePath(filePath, base), property, true);
        }

        public int getType() {
            return this.type;
        }

        public Library getLibrary() {
            if (this.getType() != 1) {
                throw new IllegalArgumentException("Item is not of required type - LIBRARY");
            }
            if (this.isBroken()) {
                return null;
            }
            assert (this.object == null || this.object instanceof Library) : "Invalid object type: " + this.object.getClass().getName() + " instance: " + this.object.toString() + " expected type: Library";
            return (Library)this.object;
        }

        public File getResolvedFile() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            return ((RelativePath)this.object).getResolvedFile();
        }

        public String getFilePath() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            return ((RelativePath)this.object).getFilePath();
        }

        public String getVariableBasedProperty() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            return this.variableBasedProperty;
        }

        public AntArtifact getArtifact() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            if (this.isBroken()) {
                return null;
            }
            return (AntArtifact)this.object;
        }

        public URI getArtifactURI() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return this.artifactURI;
        }

        public void reassignLibraryManager(LibraryManager newManager) {
            if (this.getType() != 1) {
                throw new IllegalArgumentException(" reassigning only works for type - LIBRARY");
            }
            assert (this.libraryName != null);
            if (this.getLibrary() == null || newManager != this.getLibrary().getManager()) {
                Library lib = newManager.getLibrary(this.libraryName);
                if (lib == null) {
                    this.broken = true;
                    this.object = null;
                } else {
                    this.object = lib;
                    this.broken = false;
                }
            }
        }

        public String getReference() {
            return this.property;
        }

        public void setReference(String property) {
            this.property = property;
        }

        private String getSourceProperty() {
            if (this.property == null || !this.property.startsWith(REF_START)) {
                return null;
            }
            return CommonProjectUtils.getAntPropertyName(SOURCE_START + this.property.substring(REF_START_INDEX));
        }

        private String getJavadocProperty() {
            if (this.property == null || !this.property.startsWith(REF_START)) {
                return null;
            }
            return CommonProjectUtils.getAntPropertyName(JAVADOC_START + this.property.substring(REF_START_INDEX));
        }

        public boolean canEdit() {
            if (this.isBroken()) {
                return false;
            }
            if (this.getType() == 0) {
                if (this.property == null) {
                    return true;
                }
                return this.getSourceProperty() != null && this.getJavadocProperty() != null;
            }
            return this.getType() == 1;
        }

        public String getSourceFilePath() {
            return this.sourceFilePath;
        }

        public String getJavadocFilePath() {
            return this.javadocFilePath;
        }

        public void setJavadocFilePath(String javadoc) {
            this.javadocFilePath = javadoc;
        }

        public void setSourceFilePath(String source) {
            this.sourceFilePath = source;
        }

        private void setInitialSourceAndJavadoc(String source, String javadoc) {
            this.initialSourceFilePath = source;
            this.initialJavadocFilePath = javadoc;
            this.sourceFilePath = source;
            this.javadocFilePath = javadoc;
        }

        private boolean hasChangedSource() {
            if (this.initialSourceFilePath == null != (this.sourceFilePath == null)) {
                return true;
            }
            if (this.initialSourceFilePath != null && this.sourceFilePath != null) {
                return !this.initialSourceFilePath.equals(this.sourceFilePath);
            }
            return true;
        }

        private boolean hasChangedJavadoc() {
            if (this.initialJavadocFilePath == null != (this.javadocFilePath == null)) {
                return true;
            }
            if (this.initialJavadocFilePath != null && this.javadocFilePath != null) {
                return !this.initialJavadocFilePath.equals(this.javadocFilePath);
            }
            return true;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public void initSourceAndJavadoc(AntProjectHelper helper) {
            assert (this.getType() == 0) : this.getType();
            EditableProperties ep = helper.getProperties("nbproject/project.properties");
            String value = null;
            String ref = this.getSourceProperty();
            if (ref != null) {
                value = ep.getProperty(ref);
            }
            String value2 = null;
            ref = this.getJavadocProperty();
            if (ref != null) {
                value2 = ep.getProperty(ref);
            }
            this.setInitialSourceAndJavadoc(value, value2);
        }

        public void saveSourceAndJavadoc(ReferenceHelper referenceHelper, UpdateHelper updateHelper) {
            assert (this.getType() == 0) : this.getType();
            if (this.hasChangedSource()) {
                if (this.getSourceFilePath() != null) {
                    referenceHelper.createExtraForeignFileReferenceAsIs(this.getSourceFilePath(), this.getSourceProperty());
                } else {
                    this.removeSource(updateHelper);
                }
            }
            if (this.hasChangedJavadoc()) {
                if (this.getJavadocFilePath() != null) {
                    referenceHelper.createExtraForeignFileReferenceAsIs(this.getJavadocFilePath(), this.getJavadocProperty());
                } else {
                    this.removeJavadoc(updateHelper);
                }
            }
        }

        public void removeSourceAndJavadoc(UpdateHelper updateHelper) {
            assert (this.getType() == 0) : this.getType();
            this.removeSource(updateHelper);
            this.removeJavadoc(updateHelper);
        }

        private void removeSource(UpdateHelper updateHelper) {
            EditableProperties ep = updateHelper.getProperties("nbproject/project.properties");
            if (this.getSourceProperty() != null) {
                ep.remove((Object)this.getSourceProperty());
            }
            updateHelper.putProperties("nbproject/project.properties", ep);
        }

        private void removeJavadoc(UpdateHelper updateHelper) {
            EditableProperties ep = updateHelper.getProperties("nbproject/project.properties");
            if (this.getJavadocProperty() != null) {
                ep.remove((Object)this.getJavadocProperty());
            }
            updateHelper.putProperties("nbproject/project.properties", ep);
        }

        public void updateJarReference(AntProjectHelper helper) {
            String ref;
            assert (this.getType() == 0) : this.getType();
            EditableProperties ep = helper.getProperties("nbproject/project.properties");
            String value = ep.getProperty(CommonProjectUtils.getAntPropertyName(this.getReference()));
            if (value != null) {
                RelativePath rp = (RelativePath)this.object;
                rp.setFilePath(value);
            }
            if ((ref = this.getSourceProperty()) != null && (value = ep.getProperty(ref)) != null) {
                this.setSourceFilePath(value);
            }
            if ((ref = this.getJavadocProperty()) != null && (value = ep.getProperty(ref)) != null) {
                this.setJavadocFilePath(value);
            }
        }

        public int hashCode() {
            int hash = this.getType();
            if (this.broken) {
                return 42;
            }
            switch (this.getType()) {
                case 2: {
                    hash += this.getArtifact().getType().hashCode();
                    hash += this.getArtifact().getScriptLocation().hashCode();
                    hash += this.getArtifactURI().hashCode();
                    break;
                }
                case 3: {
                    hash += this.property.hashCode();
                    break;
                }
                default: {
                    hash += this.object.hashCode();
                }
            }
            return hash;
        }

        public boolean equals(Object itemObject) {
            if (!(itemObject instanceof Item)) {
                return false;
            }
            Item item = (Item)itemObject;
            if (this.getType() != item.getType()) {
                return false;
            }
            if (this.isBroken() != item.isBroken()) {
                return false;
            }
            if (this.isBroken()) {
                return this.getReference().equals(item.getReference());
            }
            switch (this.getType()) {
                case 2: {
                    if (!this.getArtifact().getType().equals(item.getArtifact().getType())) {
                        return false;
                    }
                    if (!this.getArtifact().getScriptLocation().equals(item.getArtifact().getScriptLocation())) {
                        return false;
                    }
                    return this.getArtifactURI().equals(item.getArtifactURI());
                }
                case 3: {
                    return this.property.equals(item.property);
                }
            }
            return this.object.equals(item.object);
        }

        public String toString() {
            return "artifactURI=" + this.artifactURI + ", type=" + this.type + ", property=" + this.property + ", object=" + this.object + ", broken=" + this.broken + ", additional=" + this.additionalProperties;
        }
    }
}

