/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.util;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;

public class RepositoryListenersManager {
    private static final RepositoryListenersManager instance = new RepositoryListenersManager();
    private RepositoryListener theListener = null;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    private RepositoryListenersManager() {
    }

    public static RepositoryListenersManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(RepositoryListener listener) {
        try {
            this.rwLock.writeLock().lock();
            this.theListener = listener;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(RepositoryListener listener) {
        try {
            this.rwLock.writeLock().lock();
            this.theListener = null;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireUnitOpenedEvent(int unitId, CharSequence unitName) {
        boolean toOpen = true;
        try {
            this.rwLock.readLock().lock();
            if (this.theListener != null) {
                toOpen = this.theListener.unitOpened(unitId, unitName);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return toOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUnitClosedEvent(int unitId, CharSequence unitName) {
        try {
            this.rwLock.readLock().lock();
            if (this.theListener != null) {
                this.theListener.unitClosed(unitId, unitName);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAnException(int unitId, CharSequence unitName, RepositoryException exception) {
        try {
            this.rwLock.readLock().lock();
            if (this.theListener != null) {
                this.theListener.anExceptionHappened(unitId, unitName, exception);
            } else if (exception.getCause() != null) {
                exception.getCause().printStackTrace(System.err);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }
}

