/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.repository.translator.IndexConverter;
import org.netbeans.modules.cnd.repository.translator.RepositoryTranslatorImpl;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

public final class IntToStringCache {
    private final List<CharSequence> cache;
    private final Exception creationStack;
    private final int version;
    private final long timestamp;
    private final transient CharSequence unitName;
    private final transient boolean dummy;
    private final Object oneItemCacheLock = new Lock();
    private CharSequence oneItemCacheString;
    private int oneItemCacheInt;

    public static IntToStringCache createEmpty(CharSequence unitName) {
        return new IntToStringCache(System.currentTimeMillis(), unitName, false);
    }

    public static IntToStringCache createDummy(long ts, CharSequence unitName) {
        return new IntToStringCache(ts, unitName, true);
    }

    public static IntToStringCache createFromStream(DataInput stream, CharSequence unitName) throws IOException {
        return new IntToStringCache(stream, unitName);
    }

    private IntToStringCache(long timestamp, CharSequence unitName, boolean dummy) {
        this.unitName = unitName;
        this.creationStack = Stats.TRACE_IZ_215449 ? new Exception("CREATED " + (dummy ? "INVALID for " : "for ") + unitName + " from Thread=" + Thread.currentThread().getName()) : null;
        this.cache = new ArrayList<CharSequence>();
        this.version = RepositoryTranslatorImpl.getVersion();
        this.timestamp = timestamp;
        this.dummy = dummy;
    }

    private void assertNotDummy() {
        if (this.isDummy() && CndUtils.isDebugMode() && !CndUtils.isUnitTestMode()) {
            new IllegalStateException("ACCESS INVALID cache for " + this.unitName + " Thread=" + Thread.currentThread().getName()).printStackTrace(System.err);
            if (this.creationStack != null) {
                this.creationStack.printStackTrace(System.err);
            }
        }
    }

    private IntToStringCache(DataInput stream, CharSequence unitName) throws IOException {
        this.dummy = false;
        this.unitName = unitName;
        Exception exception = this.creationStack = Stats.TRACE_IZ_215449 ? new Exception("DESERIALIZED for " + unitName + " Thread=" + Thread.currentThread().getName()) : null;
        assert (stream != null);
        this.cache = new ArrayList<CharSequence>();
        this.version = stream.readInt();
        this.timestamp = stream.readLong();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            String value = stream.readUTF();
            CharSequence v = value.equals("") ? null : FilePathCache.getManager().getString((CharSequence)value);
            this.cache.add(v);
        }
    }

    public void convert(IndexConverter converter) {
        this.assertNotDummy();
        for (int i = 0; i < this.cache.size(); ++i) {
            CharSequence v = this.cache.get(i);
            v = converter.convert(v);
            this.cache.set(i, v);
        }
    }

    public String toString() {
        return (this.dummy ? "INVALID " : "") + "IntToStringCache{" + "version=" + this.version + ", timestamp=" + this.timestamp + ", unitName=" + this.unitName + '}';
    }

    public void write(DataOutput stream) throws IOException {
        this.assertNotDummy();
        assert (this.cache != null);
        assert (stream != null);
        stream.writeInt(this.version);
        stream.writeLong(this.timestamp);
        int size = this.cache.size();
        stream.writeInt(size);
        for (int i = 0; i < size; ++i) {
            CharSequence value = this.cache.get(i);
            if (value == null) {
                stream.writeUTF("");
                continue;
            }
            stream.writeUTF(((Object)value).toString());
        }
    }

    public boolean isDummy() {
        return this.dummy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId(CharSequence value) {
        Object object;
        int prevInt;
        CharSequence prevString;
        this.assertNotDummy();
        Object object2 = this.oneItemCacheLock;
        synchronized (object2) {
            prevString = this.oneItemCacheString;
            prevInt = this.oneItemCacheInt;
        }
        if (value.equals(prevString)) {
            return prevInt;
        }
        int id = this.cache.indexOf(value);
        if (id == -1) {
            object = this.cache;
            synchronized (object) {
                id = this.cache.indexOf(value);
                if (id == -1) {
                    id = this.cache.size();
                    this.cache.add(value);
                }
            }
        }
        object = this.oneItemCacheLock;
        synchronized (object) {
            this.oneItemCacheString = value;
            this.oneItemCacheInt = id;
        }
        return id;
    }

    public CharSequence getValueById(int id) {
        this.assertNotDummy();
        return this.cache.get(id);
    }

    public boolean containsId(int id) {
        this.assertNotDummy();
        return 0 <= id && id < this.cache.size();
    }

    public int size() {
        this.assertNotDummy();
        return this.cache.size();
    }

    public int getVersion() {
        this.assertNotDummy();
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Exception getCreationStack() {
        return this.creationStack;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

