/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.translator;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.impl.BaseRepository;
import org.netbeans.modules.cnd.repository.relocate.api.UnitCodec;
import org.netbeans.modules.cnd.repository.translator.UnitsCache;
import org.netbeans.modules.cnd.repository.util.IntToStringCache;

public class RepositoryTranslatorImpl {
    private UnitsCache unitNamesCache = null;
    private final Object initLock = new Object();
    private volatile boolean loaded = false;
    private final StorageAllocator storageAllocator;
    private final BaseRepository repository;
    private static final int DEFAULT_VERSION_OF_PERSISTENCE_MECHANIZM = 0;
    private static int version = 0;

    public RepositoryTranslatorImpl(StorageAllocator storageAllocator, BaseRepository repository) {
        this.storageAllocator = storageAllocator;
        this.repository = repository;
    }

    public int getFileIdByName(int unitId, CharSequence fileName) {
        assert (fileName != null);
        unitId = this.repository.unmaskRepositoryID(unitId);
        IntToStringCache unitFileNames = this.getUnitFileNames(unitId);
        return unitFileNames.getId(fileName);
    }

    public CharSequence getFileNameById(int unitId, int fileId) {
        int size;
        IntToStringCache fileNames = this.getUnitFileNames(unitId = this.repository.unmaskRepositoryID(unitId));
        int n = size = fileNames.isDummy() ? -1 : fileNames.size();
        if (size <= fileId) {
            StringBuilder message = new StringBuilder();
            message.append("Unit: ").append(this.getUnitName(unitId));
            message.append(" FileIndex: ").append(fileId);
            message.append(" CacheSize: ").append(size);
            message.append(" Thread=").append(Thread.currentThread().getName());
            Exception cause = fileNames.getCreationStack();
            if (cause == null) {
                throw new IllegalArgumentException(message.toString());
            }
            throw new IllegalArgumentException(message.toString(), cause);
        }
        CharSequence fileName = fileNames.getValueById(fileId);
        return fileName;
    }

    public CharSequence getFileNameByIdSafe(int unitId, int fileId) {
        IntToStringCache fileNames = this.getUnitFileNames(unitId = this.repository.unmaskRepositoryID(unitId));
        String fileName = fileNames.containsId(fileId) ? fileNames.getValueById(fileId) : "?";
        return fileName;
    }

    public int getUnitId(CharSequence unitName) {
        if (!this.unitNamesCache.containsValue(unitName)) {
            this.storageAllocator.deleteUnitFiles(unitName, false);
        }
        int unitId = this.unitNamesCache.getId(unitName);
        unitId = this.repository.maskByRepositoryID(unitId);
        return unitId;
    }

    public CharSequence getUnitName(int unitId) {
        unitId = this.repository.unmaskRepositoryID(unitId);
        return this.unitNamesCache.getValueById(unitId);
    }

    public CharSequence getUnitNameSafe(int unitId) {
        return this.unitNamesCache.containsId(unitId = this.repository.unmaskRepositoryID(unitId)) ? this.unitNamesCache.getValueById(unitId) : "No Index " + unitId + " in " + this.unitNamesCache;
    }

    public static int getVersion() {
        return version;
    }

    public void closeUnit(CharSequence unitName, Set<CharSequence> requiredUnits) {
        if (requiredUnits != null) {
            this.unitNamesCache.updateReqUnitInfo(unitName, requiredUnits);
        }
        this.unitNamesCache.storeUnitIndex(unitName);
        this.unitNamesCache.removeFileNames(unitName);
        this.unitNamesCache.storeMasterIndex();
    }

    public void shutdown() {
        this.unitNamesCache.storeMasterIndex();
        this.unitNamesCache.shutdown();
        this.storageAllocator.purgeCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntToStringCache loadUnitIndex(int unitId, CharSequence unitName) {
        Object object = this.repository.getUnitLock(unitId);
        synchronized (object) {
            this.unitNamesCache.loadUnitIndex(unitName, new HashSet<CharSequence>());
            unitId = this.repository.unmaskRepositoryID(unitId);
            return this.unitNamesCache.getFileNames(unitId);
        }
    }

    public void removeUnit(CharSequence unitName) {
        this.unitNamesCache.removeUnit(unitName);
    }

    public void startup(int newVersion, UnitCodec unitCodec) {
        version = newVersion;
        this.init(unitCodec);
    }

    private IntToStringCache getUnitFileNames(int unitId) {
        IntToStringCache unitFileNames = this.unitNamesCache.getFileNames(unitId = this.repository.unmaskRepositoryID(unitId));
        if (unitFileNames.isDummy() && this.unitNamesCache.containsId(unitId)) {
            CharSequence unitName = this.unitNamesCache.getValueById(unitId);
            unitFileNames = this.loadUnitIndex(unitId, unitName);
        }
        return unitFileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(UnitCodec unitCodec) {
        boolean aLoaded = this.loaded;
        if (!aLoaded) {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.loaded) {
                    this.unitNamesCache = new UnitsCache(this.storageAllocator, unitCodec);
                    this.loaded = true;
                }
            }
        }
    }
}

