/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.translator;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

public class IndexConverter {
    private List<Rule> rules = new ArrayList<Rule>();

    IndexConverter(String oldPath, String newPath) {
        String option;
        if (!oldPath.endsWith(newPath)) {
            int newIdx;
            oldPath = oldPath.replace('\\', '/');
            newPath = newPath.replace('\\', '/');
            String[] oldParts = oldPath.split("/");
            String[] newParts = newPath.split("/");
            int oldIdx = oldParts.length - 1;
            for (newIdx = newParts.length - 1; newIdx > 0 && oldIdx > 0 && oldParts[oldIdx].equals(newParts[newIdx]); --oldIdx, --newIdx) {
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i <= oldIdx; ++i) {
                if (!this.endsWith(sb, '/')) {
                    sb.append('/');
                }
                sb.append(oldParts[i]);
            }
            String from = sb.toString();
            StringBuilder sb2 = new StringBuilder();
            for (int i = 0; i <= newIdx; ++i) {
                if (!this.endsWith(sb2, '/')) {
                    sb2.append('/');
                }
                sb2.append(newParts[i]);
            }
            String to = sb2.toString();
            this.rules.add(new Rule(from, to));
        }
        if ((option = System.getProperty("cnd.repository.translation")) != null) {
            String[] parts = option.split(":");
            if (parts.length > 0) {
                for (String pair : parts) {
                    String[] t = pair.split("=");
                    if (t.length != 2) {
                        System.err.printf("Incorrect option: %s\n", option);
                        return;
                    }
                    this.rules.add(new Rule(t[0], t[1]));
                }
            } else {
                System.err.printf("Incorrect option: %s\n", option);
            }
        }
    }

    private boolean endsWith(StringBuilder sb, char c) {
        if (sb != null && sb.length() > 0) {
            return sb.charAt(sb.length() - 1) == c;
        }
        return false;
    }

    public boolean needsConversion() {
        return !this.rules.isEmpty();
    }

    public CharSequence convert(CharSequence path) {
        if (path != null) {
            for (Rule pair : this.rules) {
                String toFind = pair.from;
                if (!CharSequenceUtils.startsWith((CharSequence)path, (CharSequence)toFind)) continue;
                String toReplace = pair.to;
                String subst = toReplace + path.subSequence(toFind.length(), path.length());
                return FilePathCache.getManager().getString((CharSequence)subst);
            }
        }
        return path;
    }

    private static class Rule {
        public final String from;
        public final String to;

        public Rule(String first, String second) {
            this.from = first.endsWith("/") ? first : first + "/";
            this.to = second.endsWith("/") ? second : second + "/";
        }
    }
}

