/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.repository.testbench.Stats;

public class WriteStatistics {
    private static final WriteStatistics instance = new WriteStatistics();
    private long writeStatIntervalStart = 0L;
    private int writeStatInterval = 1000;
    private int writeCount = 0;
    private long totalWriteCount = 0L;
    private final Object utfLock = new Object();
    private boolean utfHookSet = false;
    private Map<String, Integer> utfStacks = new HashMap<String, Integer>();
    private Map<String, Integer> utfPaths = new HashMap<String, Integer>();

    private WriteStatistics() {
    }

    public static final WriteStatistics instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOnWriteUTF(CharSequence str) {
        if (WriteStatistics.isFile(str)) {
            this.updateUTFStatistics(str);
            Object object = this.utfLock;
            synchronized (object) {
                if (!this.utfHookSet) {
                    this.utfHookSet = true;
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            WriteStatistics.this.printUTFStatistics();
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUTFStatistics(CharSequence str) {
        Object object = this.utfLock;
        synchronized (object) {
            String key;
            String key2 = ((Object)str).toString();
            Integer cnt = this.utfPaths.get(key2);
            this.utfPaths.put(key2, cnt == null ? 1 : cnt + 1);
            StringBuilder stackText = new StringBuilder();
            for (StackTraceElement stackEl : this.filterUTFStack(Thread.currentThread().getStackTrace())) {
                stackText.append(stackEl.getClassName()).append('.').append(stackEl.getMethodName());
                stackText.append('(').append(stackEl.getFileName()).append(':').append(stackEl.getLineNumber()).append(")\n");
            }
            Integer cnt2 = this.utfStacks.get(key = stackText.toString());
            this.utfStacks.put(key, cnt2 == null ? 1 : cnt2 + 1);
        }
    }

    private List<StackTraceElement> filterUTFStack(StackTraceElement[] stack) {
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        boolean wasFound = false;
        for (int i = 3; i < stack.length; ++i) {
            boolean isFound = stack[i].getClassName().contains(".cnd.modelimpl.");
            if (wasFound) {
                if (!isFound) break;
                result.add(stack[i]);
                continue;
            }
            result.add(stack[i]);
            wasFound = isFound;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printUTFStatistics() {
        Object object = this.utfLock;
        synchronized (object) {
            int cnt;
            ArrayList<Map.Entry<String, Integer>> entries = new ArrayList<Map.Entry<String, Integer>>(this.utfPaths.size());
            entries.addAll(this.utfPaths.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            System.out.printf("\n\nUTF/path start ===\n", new Object[0]);
            int total = 0;
            for (Map.Entry entry : entries) {
                cnt = (Integer)entry.getValue();
                System.out.printf("UTF/path %8d %s\n", cnt, entry.getKey());
                total += cnt;
            }
            System.out.printf("UTF/path %8d %s\n", total, "TOTAL");
            System.out.printf("\nUTF/path end ===\n\n", new Object[0]);
            entries = new ArrayList(this.utfStacks.size());
            entries.addAll(this.utfStacks.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            System.out.printf("\n\nUTF/stack start ===\n", new Object[0]);
            total = 0;
            for (Map.Entry entry : entries) {
                cnt = (Integer)entry.getValue();
                String stack = (String)entry.getKey();
                System.out.printf("\nUTF/stack %8d\n%s\n", cnt, stack);
                total += cnt;
            }
            System.out.printf("UTF/stack %8d\n%s\n", total, "TOTAL");
            System.out.printf("\nUTF/stack end ===\n\n", new Object[0]);
        }
    }

    private static boolean isFile(CharSequence str) {
        return str != null && str.length() > 0 && str.charAt(0) == '/';
    }

    public void update(int increment) {
        this.totalWriteCount += (long)increment;
        long currTime = System.currentTimeMillis();
        if (this.writeStatIntervalStart == 0L) {
            this.writeCount = increment;
            this.writeStatIntervalStart = System.currentTimeMillis();
        } else if (currTime - this.writeStatIntervalStart < (long)this.writeStatInterval) {
            this.writeCount += increment;
        } else {
            int currentWPS = (int)(1000L * (long)this.writeCount / (currTime - this.writeStatIntervalStart));
            this.writeStatIntervalStart = currTime;
            if (Stats.writeStatistics) {
                System.err.printf("\tcurrent writes: %4d current WPS: %4d  total writes: %8d \n", this.writeCount, currentWPS, this.totalWriteCount);
            }
            this.writeCount = increment;
        }
    }
}

