/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.netbeans.modules.cnd.repository.relocate.api.UnitCodec;
import org.netbeans.modules.cnd.repository.sfs.SharedStringBuffer;
import org.netbeans.modules.cnd.repository.sfs.UTF;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public class RepositoryRandomAccessFile
extends RandomAccessFile
implements RepositoryDataOutput,
RepositoryDataInput,
SharedStringBuffer {
    private final UnitCodec unitCodec;
    private static final int sharedArrySize = 1024;
    private final byte[] sharedByteArray = new byte[1024];
    private final char[] sharedCharArray = new char[1024];

    public RepositoryRandomAccessFile(File file, String mode, UnitCodec unitCodec) throws FileNotFoundException {
        super(file, mode);
        this.unitCodec = unitCodec;
    }

    public void writeCharSequenceUTF(CharSequence s) throws IOException {
        UTF.writeUTF(s, this);
    }

    public void writeUnitId(int unitId) throws IOException {
        this.writeInt(this.unitCodec.unmaskRepositoryID(unitId));
    }

    public CharSequence readCharSequenceUTF() throws IOException {
        return UTF.readCharSequenceUTF(this);
    }

    public int readUnitId() throws IOException {
        return this.unitCodec.maskByRepositoryID(this.readInt());
    }

    @Override
    public final byte[] getSharedByteArray() {
        return this.sharedByteArray;
    }

    @Override
    public final char[] getSharedCharArray() {
        return this.sharedCharArray;
    }

    @Override
    public final int getSharedArrayLehgth() {
        return 1024;
    }
}

