/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.cnd.repository.relocate.api.UnitCodec;
import org.netbeans.modules.cnd.repository.sfs.SharedStringBuffer;
import org.netbeans.modules.cnd.repository.sfs.UTF;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;

public class RepositoryDataInputStream
extends DataInputStream
implements RepositoryDataInput,
SharedStringBuffer {
    private final UnitCodec unitCodec;
    private static final int sharedArrySize = 1024;
    private final byte[] sharedByteArray = new byte[1024];
    private final char[] sharedCharArray = new char[1024];

    public RepositoryDataInputStream(InputStream in, UnitCodec unitCodec) {
        super(in);
        this.unitCodec = unitCodec;
    }

    public CharSequence readCharSequenceUTF() throws IOException {
        return UTF.readCharSequenceUTF(this);
    }

    public int readUnitId() throws IOException {
        return this.unitCodec.maskByRepositoryID(this.readInt());
    }

    @Override
    public final byte[] getSharedByteArray() {
        return this.sharedByteArray;
    }

    @Override
    public final char[] getSharedCharArray() {
        return this.sharedCharArray;
    }

    @Override
    public final int getSharedArrayLehgth() {
        return 1024;
    }
}

