/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.netbeans.modules.cnd.repository.relocate.api.UnitCodec;
import org.netbeans.modules.cnd.repository.sfs.BufferedRWAccess;
import org.netbeans.modules.cnd.repository.sfs.FileRWAccess;
import org.netbeans.modules.cnd.repository.sfs.FileStorage;
import org.netbeans.modules.cnd.repository.sfs.RepositoryDataInputStream;
import org.netbeans.modules.cnd.repository.sfs.RepositoryDataOutputStream;
import org.netbeans.modules.cnd.repository.sfs.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.sfs.index.CompactFileIndex;
import org.netbeans.modules.cnd.repository.sfs.index.FileIndex;
import org.netbeans.modules.cnd.repository.sfs.index.FileIndexFactory;
import org.netbeans.modules.cnd.repository.sfs.index.SimpleFileIndex;
import org.netbeans.modules.cnd.repository.sfs.statistics.FileStatistics;
import org.netbeans.modules.cnd.repository.sfs.statistics.RangeStatistics;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.testbench.Stats;

class IndexedStorageFile
extends FileStorage {
    private static final boolean TRACE = false;
    private final File dataFile;
    private final File indexFile;
    private final FileStatistics fileStatistics;
    private FileIndex index;
    private final FileRWAccess fileRWAccess;
    private final AtomicLong fileRWAccessSize;
    private long usedSize;
    private final Object writeLock = new Lock();
    private final UnitCodec unitCodec;

    public IndexedStorageFile(File basePath, String name, boolean create, UnitCodec unitCodec) throws IOException {
        boolean recreate;
        this.unitCodec = unitCodec;
        this.dataFile = new File(basePath, name + "-data");
        this.indexFile = new File(basePath, name + "-index");
        this.fileStatistics = new FileStatistics();
        boolean filesExists = this.dataFile.exists() && this.indexFile.exists();
        this.fileRWAccess = this.createFileRWAccess(this.dataFile, unitCodec);
        boolean bl = recreate = create || !filesExists;
        if (!recreate) {
            try {
                this.loadIndex();
                this.recalcUsedSize();
            }
            catch (IOException e) {
                recreate = true;
            }
            if (!this.indexFile.delete()) {
                System.err.println("Cannot delete repository index file " + this.indexFile.getAbsolutePath());
            }
            if (this.usedSize == 0L) {
                this.fileRWAccess.truncate(0L);
            }
        }
        if (recreate) {
            this.index = (FileIndex)(Stats.useCompactIndex ? new CompactFileIndex() : new SimpleFileIndex());
            this.fileRWAccess.truncate(0L);
            if (this.indexFile.exists() && !this.indexFile.delete()) {
                System.err.println("Cannot delete repository index file " + this.indexFile.getAbsolutePath());
            }
            this.usedSize = 0L;
        }
        this.fileRWAccessSize = new AtomicLong(this.fileRWAccess.size());
    }

    @Override
    public Persistent read(Key key) throws IOException {
        Persistent object = null;
        ChunkInfo chunkInfo = this.index.get(key);
        if (chunkInfo != null) {
            object = this.fileRWAccess.read(key.getPersistentFactory(), chunkInfo.getOffset(), chunkInfo.getSize());
            if (Stats.fileStatisticsLevel > 0) {
                this.fileStatistics.incrementReadCount(key);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Key key, Persistent object) throws IOException {
        Object object2 = this.writeLock;
        synchronized (object2) {
            long offset = this.getSize();
            int size = this.fileRWAccess.write(key.getPersistentFactory(), object, offset);
            this.fileRWAccessSize.addAndGet(size);
            int oldSize = this.index.put(key, offset, size);
            this.usedSize += (long)(size - oldSize);
            if (Stats.fileStatisticsLevel > 0) {
                this.fileStatistics.incrementWriteCount(key, oldSize, size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Key key) throws IOException {
        if (Stats.fileStatisticsLevel > 0) {
            this.fileStatistics.removeNotify(key);
        }
        Object object = this.writeLock;
        synchronized (object) {
            int oldSize = this.index.remove(key);
            if (oldSize != 0) {
                if (this.index.size() == 0) {
                    this.fileRWAccess.truncate(0L);
                    this.fileRWAccessSize.set(0L);
                    this.usedSize = 0L;
                } else {
                    this.usedSize -= (long)(-oldSize);
                }
            }
        }
    }

    @Override
    public int getObjectsCount() {
        return this.index.size();
    }

    @Override
    public long getSize() throws IOException {
        return this.fileRWAccessSize.get();
    }

    @Override
    public void close() throws IOException {
        if (Stats.dumoFileOnExit) {
            this.dump(System.out);
        } else if (Stats.fileStatisticsLevel > 0) {
            this.dumpSummary(System.out);
        }
        this.fileRWAccess.close();
        this.storeIndex();
    }

    @Override
    public int getFragmentationPercentage() throws IOException {
        long fileSize = this.getSize();
        float delta = fileSize - this.usedSize;
        float percentage = delta * 100.0f / (float)fileSize;
        return Math.round(percentage);
    }

    @Override
    public void dump(PrintStream ps) throws IOException {
        for (Key key : this.index.keySet()) {
            ChunkInfo chunk = this.index.get(key);
            this.print(ps, null, chunk, true);
        }
        ChunkInfo[] infos = this.sortedChunkInfos();
        for (int i = 0; i < infos.length; ++i) {
            this.print(ps, null, infos[i], true);
        }
        this.dumpSummary(ps, infos);
    }

    private long recalcUsedSize() {
        long calcUsedSize = 0L;
        for (Key key : this.index.keySet()) {
            ChunkInfo info = this.index.get(key);
            calcUsedSize += (long)info.getSize();
        }
        this.usedSize = calcUsedSize;
        return calcUsedSize;
    }

    @Override
    public void dumpSummary(PrintStream ps) throws IOException {
        this.dumpSummary(ps, null);
    }

    private void dumpSummary(PrintStream ps, ChunkInfo[] sortedInfos) throws IOException {
        RangeStatistics write = new RangeStatistics("Writes:", Stats.fileStatisticsLevel, Stats.fileStatisticsRanges);
        RangeStatistics read = new RangeStatistics("Reads: ", Stats.fileStatisticsLevel, Stats.fileStatisticsRanges);
        RangeStatistics size = new RangeStatistics("Sizes: ", Stats.fileStatisticsLevel, Stats.fileStatisticsRanges);
        for (Key key : this.index.keySet()) {
            ChunkInfo info = this.index.get(key);
            this.usedSize += (long)info.getSize();
            read.consume(this.fileStatistics.getReadCount(key));
            write.consume(this.fileStatistics.getWriteCount(key));
            size.consume(info.getSize());
        }
        if (sortedInfos == null) {
            sortedInfos = this.sortedChunkInfos();
        }
        long firstExtent = sortedInfos.length > 0 ? sortedInfos[0].getOffset() : 0L;
    }

    private void print(PrintStream ps, Key key, ChunkInfo chunk, boolean lf) {
    }

    private ChunkInfo[] sortedChunkInfos() {
        Object[] infos = new ChunkInfo[this.index.size()];
        int pos = 0;
        for (Key key : this.index.keySet()) {
            infos[pos++] = this.index.get(key);
        }
        Arrays.sort(infos);
        return infos;
    }

    String getTraceString() throws IOException {
        Formatter formatter = new Formatter();
        formatter.format("%s index size %d  file size %d  fragmentation %d%%", this.dataFile.getName(), this.index.size(), this.getSize(), this.getFragmentationPercentage());
        return formatter.toString();
    }

    Iterator<Key> getKeySetIterator() {
        return new IndexIterator();
    }

    ChunkInfo getChunkInfo(Key key) {
        return this.index.get(key);
    }

    String getDataFileName() {
        return this.dataFile.getName();
    }

    long getDataFileUsedSize() {
        return this.usedSize;
    }

    void moveDataFromOtherFile(FileRWAccess fileRW, long l, int size, long newOffset, Key key) throws IOException {
        this.fileRWAccess.move(fileRW, l, size, newOffset);
        this.fileRWAccessSize.set(this.fileRWAccess.size());
        this.index.put(key, newOffset, size);
        this.usedSize += (long)size;
    }

    FileRWAccess getDataFile() {
        return this.fileRWAccess;
    }

    private FileRWAccess createFileRWAccess(File file, UnitCodec unitCodec) throws IOException {
        BufferedRWAccess result;
        switch (Stats.fileRWAccess) {
            case 0: {
                result = new BufferedRWAccess(file, unitCodec);
                break;
            }
            default: {
                result = new BufferedRWAccess(file, unitCodec);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndex() throws IOException {
        FilterInputStream din = null;
        try {
            FileInputStream in = new FileInputStream(this.indexFile);
            BufferedInputStream bin = new BufferedInputStream(in);
            din = new RepositoryDataInputStream(bin, this.unitCodec);
            this.index = FileIndexFactory.getDefaultFactory().readIndex((RepositoryDataInput)din);
        }
        finally {
            if (din != null) {
                din.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeIndex() throws IOException {
        FilterOutputStream dos = null;
        try {
            FileOutputStream out = new FileOutputStream(this.indexFile);
            BufferedOutputStream bos = new BufferedOutputStream(out, 1024);
            dos = new RepositoryDataOutputStream(bos, this.unitCodec);
            FileIndexFactory.getDefaultFactory().writeIndex(this.index, (RepositoryDataOutput)dos);
        }
        finally {
            if (dos != null) {
                dos.close();
            }
        }
    }

    @Override
    public boolean defragment(long timeout) throws IOException {
        return false;
    }

    @Override
    public void debugDump(Key key) {
    }

    private class IndexIterator
    implements Iterator<Key> {
        private Iterator<Key> indexIterator;
        private Key currentKey;

        IndexIterator() {
            this.indexIterator = IndexedStorageFile.this.index.getKeySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.indexIterator.hasNext();
        }

        @Override
        public Key next() {
            this.currentKey = this.indexIterator.next();
            return this.currentKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            assert (this.currentKey != null);
            ChunkInfo chi = IndexedStorageFile.this.getChunkInfo(this.currentKey);
            this.indexIterator.remove();
            Object object = IndexedStorageFile.this.writeLock;
            synchronized (object) {
                if (IndexedStorageFile.this.index.size() == 0) {
                    try {
                        IndexedStorageFile.this.fileRWAccess.truncate(0L);
                        IndexedStorageFile.this.fileRWAccessSize.set(0L);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    IndexedStorageFile.this.usedSize = 0L;
                } else {
                    int size = chi.getSize();
                    IndexedStorageFile.this.usedSize -= size;
                }
            }
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

