/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.repository.api.CacheLocation;
import org.netbeans.modules.cnd.repository.api.DatabaseTable;
import org.netbeans.modules.cnd.repository.impl.BaseRepository;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;

public class HashMapRepository
extends BaseRepository {
    private final Map<Integer, Unit> units;
    private final Object unitsLock = new Lock();

    public void debugDistribution() {
    }

    public void debugDump(Key key) {
    }

    public DatabaseTable getDatabaseTable(Key unitKey, String tableID) {
        return null;
    }

    public HashMapRepository(int id, CacheLocation cacheLocation) {
        super(id, cacheLocation);
        this.units = new ConcurrentHashMap<Integer, Unit>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unit getUnit(Key key) {
        int id = key.getUnitId();
        CharSequence name = key.getUnit();
        assert (name != null);
        Unit unit = this.units.get(id);
        if (unit == null) {
            Object object = this.unitsLock;
            synchronized (object) {
                unit = this.units.get(id);
                if (unit == null) {
                    unit = new Unit(id, name);
                    this.units.put(id, unit);
                }
            }
        }
        return unit;
    }

    public void put(Key key, Persistent obj) {
        assert (obj != null);
        this.getUnit(key).put(key, obj);
    }

    public Persistent get(Key key) {
        return this.getUnit(key).get(key);
    }

    public Persistent tryGet(Key key) {
        return this.get(key);
    }

    public void remove(Key key) {
        this.getUnit(key).remove(key);
    }

    public void hang(Key key, Persistent obj) {
        this.put(key, obj);
    }

    public void debugClear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.unitsLock;
        synchronized (object) {
            this.units.clear();
        }
    }

    public void openUnit(int unitId, CharSequence unitName) {
    }

    public void closeUnit(int unitId, boolean cleanRepository, Set<Integer> requiredUnits) {
        this.removeUnit(unitId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeUnit(int unitId) {
        Iterator<Unit> iter = this.units.values().iterator();
        while (iter.hasNext()) {
            Unit unit = iter.next();
            if (unit.getId() != unitId) continue;
            Object object = this.unitsLock;
            synchronized (object) {
                iter.remove();
                return;
            }
        }
    }

    public void cleanCaches() {
    }

    public void registerRepositoryListener(RepositoryListener aListener) {
    }

    public void unregisterRepositoryListener(RepositoryListener aListener) {
    }

    public void startup(int persistMechanismVersion) {
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private static class Unit {
        private final Map<Key, Persistent> map = new ConcurrentHashMap<Key, Persistent>();
        private final CharSequence name;
        private final int id;

        public Unit(int id, CharSequence name) {
            this.id = id;
            this.name = name;
        }

        public void put(Key key, Persistent obj) {
            assert (key.getUnit().equals(this.name));
            this.map.put(key, obj);
        }

        public Persistent get(Key key) {
            assert (key.getUnit().equals(this.name));
            return this.map.get(key);
        }

        void remove(Key key) {
            assert (key.getUnit().equals(this.name));
            this.map.remove(key);
        }

        public int getId() {
            return this.id;
        }
    }
}

