/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.repository.api.CacheLocation;
import org.netbeans.modules.cnd.repository.api.DatabaseTable;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.disk.DiskRepositoryManager;
import org.netbeans.modules.cnd.repository.impl.BaseRepository;
import org.netbeans.modules.cnd.repository.impl.HashMapRepository;
import org.netbeans.modules.cnd.repository.impl.KeyValidatorRepository;
import org.netbeans.modules.cnd.repository.relocate.api.UnitCodec;
import org.netbeans.modules.cnd.repository.relocate.spi.RelocationSupportProvider;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.repository.translator.RepositoryTranslatorImpl;
import org.netbeans.modules.cnd.repository.util.RepositoryListenersManager;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Utilities;

public final class DelegateRepository
implements Repository,
RelocationSupportProvider {
    private final Object delegatesLock = new Object();
    private final ArrayList<BaseRepository> delegates;
    private final Map<CacheLocation, BaseRepository> cacheToDelegate = new HashMap<CacheLocation, BaseRepository>();
    private int persistMechanismVersion = -1;

    public DelegateRepository() {
        this.delegates = new ArrayList();
        this.delegates.add(new DummyRepository(0));
    }

    public void hang(Key key, Persistent obj) {
        this.getDelegate(key.getUnitId()).hang(key, obj);
    }

    public void put(Key key, Persistent obj) {
        this.getDelegate(key.getUnitId()).put(key, obj);
    }

    public Persistent get(Key key) {
        String keyClassName;
        BaseRepository delegate = this.getDelegate(key.getUnitId());
        Persistent result = delegate.get(key);
        if (result == null && Stats.useNullWorkaround && !(keyClassName = key.getClass().getName()).endsWith(".ProjectKey") && !keyClassName.endsWith(".OffsetableDeclarationKey")) {
            System.err.printf("NULL returned for key %s on attempt 1\n", key);
            result = delegate.get(key);
            System.err.printf("%s value returned for key %s on attempt 2\n", result == null ? "NULL" : "NON-NULL", key);
        }
        return result;
    }

    public Persistent tryGet(Key key) {
        return this.getDelegate(key.getUnitId()).tryGet(key);
    }

    public void remove(Key key) {
        this.getDelegate(key.getUnitId()).remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugClear() {
        Object object = this.delegatesLock;
        synchronized (object) {
            for (BaseRepository delegate : this.getDelegates()) {
                delegate.debugClear();
            }
        }
    }

    public void shutdown() {
        for (BaseRepository aDelegate : this.getDelegates()) {
            aDelegate.shutdown();
        }
    }

    public void openUnit(int unitId, CharSequence unitName) {
        this.getDelegate(unitId).openUnit(unitId, unitName);
    }

    public void closeUnit(int unitId, boolean cleanRepository, Set<Integer> requiredUnits) {
        this.getDelegate(unitId).closeUnit(unitId, cleanRepository, requiredUnits);
    }

    public void removeUnit(int unitId) {
        this.getDelegate(unitId).removeUnit(unitId);
    }

    public void cleanCaches() {
        for (BaseRepository delegate : this.getDelegates()) {
            delegate.cleanCaches();
        }
    }

    public void registerRepositoryListener(RepositoryListener aListener) {
        RepositoryListenersManager.getInstance().registerListener(aListener);
    }

    public void unregisterRepositoryListener(RepositoryListener aListener) {
        RepositoryListenersManager.getInstance().unregisterListener(aListener);
    }

    public void startup(int persistMechanismVersion) {
        this.persistMechanismVersion = persistMechanismVersion;
        for (BaseRepository delegate : this.getDelegates()) {
            delegate.startup(persistMechanismVersion);
        }
    }

    private BaseRepository createRepository(int id, CacheLocation cacheLocation) {
        BaseRepository delegate;
        if (CndUtils.getBoolean((String)"cnd.repository.validate.keys", (boolean)false)) {
            Stats.log("Testing keys using KeyValidatorRepository.");
            delegate = new KeyValidatorRepository(id, cacheLocation);
        } else if (CndUtils.getBoolean((String)"cnd.repository.hardrefs", (boolean)false)) {
            Stats.log("Using HashMapRepository.");
            delegate = new HashMapRepository(id, cacheLocation);
        } else {
            Stats.log("by default using HybridRepository.");
            delegate = new DiskRepositoryManager(id, cacheLocation);
        }
        delegate.getTranslation().startup(this.persistMechanismVersion, delegate);
        delegate.startup(this.persistMechanismVersion);
        return delegate;
    }

    public void debugDistribution() {
        for (BaseRepository delegate : this.getDelegates()) {
            delegate.debugDistribution();
        }
    }

    public void debugDump(Key key) {
        assert (key != null);
        BaseRepository delegate = this.getDelegate(key.getUnitId());
        if (delegate == null) {
            System.err.printf("=== Repository debug dump for key=%s. Delegate not found.", key);
        } else {
            delegate.debugDump(key);
        }
    }

    public DatabaseTable getDatabaseTable(Key unitKey, String tableID) {
        return this.getDelegate(unitKey.getUnitId()).getDatabaseTable(unitKey, tableID);
    }

    private BaseRepository getDelegate(int unitId) {
        int repoId = unitId / 100000;
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertions && repoId >= this.delegates.size()) {
            throw new IndexOutOfBoundsException("Index: " + repoId + ", Size: " + this.delegates.size());
        }
        return this.delegates.get(repoId);
    }

    public Iterable<BaseRepository> testGetDelegates() {
        return this.getDelegates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<BaseRepository> getDelegates() {
        Object object = this.delegatesLock;
        synchronized (object) {
            return new ArrayList<BaseRepository>(this.delegates);
        }
    }

    public RepositoryTranslatorImpl getTranslatorImpl(int unitId) {
        return this.getDelegate(unitId).getTranslation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseRepository getOrCreateRepository(CacheLocation cacheLocation) {
        BaseRepository repo;
        CndUtils.assertNotNull((Object)cacheLocation, (String)"null cache location");
        if (cacheLocation == null) {
            cacheLocation = CacheLocation.DEFAULT;
        }
        assert (cacheLocation != null);
        Object object = this.delegatesLock;
        synchronized (object) {
            repo = this.cacheToDelegate.get(cacheLocation);
            if (repo == null) {
                int newId = this.delegates.size();
                repo = this.createRepository(newId, cacheLocation);
                this.cacheToDelegate.put(cacheLocation, repo);
                this.delegates.add(repo);
            }
        }
        return repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnitId(CharSequence unitName, CacheLocation cacheLocation) {
        BaseRepository repo = this.getOrCreateRepository(cacheLocation);
        Object object = this.delegatesLock;
        synchronized (object) {
            int unitId = repo.getTranslation().getUnitId(unitName);
            return unitId;
        }
    }

    public UnitCodec getUnitCodec(CacheLocation cacheLocation) {
        BaseRepository repo = this.getOrCreateRepository(cacheLocation);
        return repo.getUnitCodec();
    }

    public CacheLocation getCacheLocation(int unitId) {
        return this.getDelegate(unitId).getCacheLocation();
    }

    private static class DummyRepository
    extends BaseRepository {
        private static final String exceptionText = "DummyRepository should never be accessed";

        public DummyRepository(int id) {
            super(id, new CacheLocation(new File(Utilities.isWindows() ? "nul" : "/dev/null")));
        }

        public void hang(Key key, Persistent obj) {
            throw new IllegalArgumentException(exceptionText);
        }

        public void put(Key key, Persistent obj) {
            throw new IllegalArgumentException(exceptionText);
        }

        public Persistent get(Key key) {
            throw new IllegalArgumentException(exceptionText);
        }

        public Persistent tryGet(Key key) {
            throw new IllegalArgumentException(exceptionText);
        }

        public void remove(Key key) {
            throw new IllegalArgumentException(exceptionText);
        }

        public void debugClear() {
        }

        public void debugDistribution() {
        }

        public void debugDump(Key key) {
        }

        public void startup(int persistMechanismVersion) {
        }

        public void shutdown() {
        }

        public void openUnit(int unitId, CharSequence unitName) {
            throw new IllegalArgumentException(exceptionText);
        }

        public void closeUnit(int unitId, boolean cleanRepository, Set<Integer> requiredUnits) {
            throw new IllegalArgumentException(exceptionText);
        }

        public void removeUnit(int unitId) {
            throw new IllegalArgumentException(exceptionText);
        }

        public void cleanCaches() {
        }

        public void registerRepositoryListener(RepositoryListener aListener) {
            throw new IllegalArgumentException(exceptionText);
        }

        public void unregisterRepositoryListener(RepositoryListener aListener) {
            throw new IllegalArgumentException(exceptionText);
        }

        public DatabaseTable getDatabaseTable(Key unitKey, String tableID) {
            throw new IllegalArgumentException(exceptionText);
        }
    }
}

