/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.impl;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.repository.api.CacheLocation;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.disk.FilesAccessStrategy;
import org.netbeans.modules.cnd.repository.disk.FilesAccessStrategyImpl;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.relocate.api.UnitCodec;
import org.netbeans.modules.cnd.repository.translator.RepositoryTranslatorImpl;

public abstract class BaseRepository
implements Repository,
UnitCodec {
    public static final int REPO_DENOM = 100000;
    private final UnitCodecImpl codec;
    private final CacheLocation cacheLocation;
    private final RepositoryTranslatorImpl translator;
    private final StorageAllocator storageAllocator;
    private final FilesAccessStrategy filesAccessStrategy;
    private final Map<Integer, Object> unitLocks = new HashMap<Integer, Object>();
    private final Object mainUnitLock = new UnitLock();

    protected BaseRepository(int id, CacheLocation cacheLocation) {
        this.codec = new UnitCodecImpl(id);
        this.cacheLocation = cacheLocation;
        this.storageAllocator = new StorageAllocator(cacheLocation);
        this.filesAccessStrategy = new FilesAccessStrategyImpl(this.storageAllocator, this);
        this.translator = new RepositoryTranslatorImpl(this.storageAllocator, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getUnitLock(int unitId) {
        Object object = this.mainUnitLock;
        synchronized (object) {
            Object lock = this.unitLocks.get(unitId);
            if (lock == null) {
                lock = new NamedLock("unitId=" + unitId);
                this.unitLocks.put(unitId, lock);
            }
            return lock;
        }
    }

    UnitCodec getUnitCodec() {
        return this.codec;
    }

    public int unmaskRepositoryID(int unitId) {
        return this.codec.unmaskRepositoryID(unitId);
    }

    public int maskByRepositoryID(int unitId) {
        return this.codec.maskByRepositoryID(unitId);
    }

    public final RepositoryTranslatorImpl getTranslation() {
        return this.translator;
    }

    public StorageAllocator getStorageAllocator() {
        return this.storageAllocator;
    }

    public FilesAccessStrategy getFilesAccessStrategy() {
        return this.filesAccessStrategy;
    }

    public CacheLocation getCacheLocation() {
        return this.cacheLocation;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.codec.id + ' ' + this.cacheLocation;
    }

    private static final class UnitCodecImpl
    implements UnitCodec {
        private final int id;

        public UnitCodecImpl(int repositoryID) {
            this.id = repositoryID;
        }

        public int unmaskRepositoryID(int clientUnitId) {
            return clientUnitId % 100000;
        }

        public int maskByRepositoryID(int internalUnitId) {
            return this.id * 100000 + internalUnitId % 100000;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + this.id;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnitCodecImpl other = (UnitCodecImpl)obj;
            return this.id == other.id;
        }

        public String toString() {
            return "UnitCodecImpl{id=" + this.id + '}';
        }
    }

    private static final class NamedLock {
        private final String name;

        public NamedLock(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NamedLock other = (NamedLock)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }

    private static final class UnitLock {
        private UnitLock() {
        }
    }
}

