/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.repository.api.DatabaseTable;
import org.netbeans.modules.cnd.repository.disk.MemoryCache;
import org.netbeans.modules.cnd.repository.disk.MultyFileStorage;
import org.netbeans.modules.cnd.repository.disk.Storage;
import org.netbeans.modules.cnd.repository.disk.Unit;
import org.netbeans.modules.cnd.repository.impl.BaseRepository;
import org.netbeans.modules.cnd.repository.sfs.FileStorage;
import org.netbeans.modules.cnd.repository.spi.DatabaseStorage;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.util.Pair;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Lookup;

public final class UnitImpl
implements Unit {
    private Storage singleFileStorage;
    private Storage multyFileStorage;
    private final Collection<DatabaseStorage> dbStorages = new ArrayList<DatabaseStorage>();
    private final CharSequence unitName;
    private final MemoryCache cache;
    private final BaseRepository repository;
    private final int id;
    private static final boolean TRACE_ARGS = CndUtils.getBoolean((String)"cnd.repository.trace.args", (boolean)false);

    public UnitImpl(int id, CharSequence unitName, BaseRepository repository) throws IOException {
        this.id = id;
        assert (unitName != null);
        this.unitName = unitName;
        assert (repository != null);
        this.repository = repository;
        File homeDir = new File(repository.getStorageAllocator().getUnitStorageName(unitName));
        this.singleFileStorage = FileStorage.create(homeDir, repository);
        this.multyFileStorage = new MultyFileStorage(repository.getFilesAccessStrategy(), this.getName());
        Collection providers = Lookup.getDefault().lookupAll(DatabaseStorage.Provider.class);
        for (DatabaseStorage.Provider provider : providers) {
            DatabaseStorage storage = provider.create(id, homeDir);
            if (storage == null) continue;
            this.dbStorages.add(storage);
        }
        this.cache = new MemoryCache();
    }

    @Override
    public int getId() {
        return this.id;
    }

    private Storage getDiskStorage(Key key) {
        assert (key != null);
        assert (this.getName().equals(key.getUnit()));
        if (key.getBehavior() == Key.Behavior.Default) {
            return this.singleFileStorage;
        }
        return this.multyFileStorage;
    }

    DatabaseTable getDatabaseTable(String storageID) {
        for (DatabaseStorage dbStorage : this.dbStorages) {
            DatabaseTable table = dbStorage.getTable(storageID);
            if (table == null) continue;
            return table;
        }
        return null;
    }

    public String toString() {
        return "UnitImpl{" + this.id + ' ' + this.unitName + '}';
    }

    @Override
    public Persistent get(Key key) throws IOException {
        Persistent prev;
        assert (key != null);
        Persistent data = this.cache.get(key);
        if (data == MemoryCache.REMOVED) {
            return null;
        }
        if (data == null && (data = this.getDiskStorage(key).read(key)) != null && (prev = this.cache.putIfAbsent(key, data)) != null) {
            data = prev;
        }
        return data;
    }

    @Override
    public void putToCache(Key key, Persistent obj) {
        assert (key != null);
        assert (this.getName().equals(key.getUnit()));
        this.cache.put(key, obj);
    }

    @Override
    public void hang(Key key, Persistent obj) {
        assert (key != null);
        assert (this.getName().equals(key.getUnit()));
        this.cache.hang(key, obj);
    }

    @Override
    public Persistent tryGet(Key key) {
        assert (key != null);
        assert (this.getName().equals(key.getUnit()));
        Persistent obj = this.cache.get(key);
        if (obj == MemoryCache.REMOVED) {
            obj = null;
        }
        return obj;
    }

    @Override
    public void removePhysically(Key key) throws IOException {
        assert (key != null);
        assert (this.getName().equals(key.getUnit()));
        this.getDiskStorage(key).remove(key);
        this.cache.removePhysically(key);
    }

    @Override
    public void removeFromCache(Key key) {
        assert (key != null);
        assert (this.getName().equals(key.getUnit()));
        this.cache.markRemoved(key);
    }

    @Override
    public void close() throws IOException {
        Collection<Pair<Key, Persistent>> hung = this.cache.clearHungObjects();
        for (Pair<Key, Persistent> pair : hung) {
            this.putPhysically((Key)pair.first, (Persistent)pair.second);
        }
        this.singleFileStorage.close();
        this.multyFileStorage.close();
        for (DatabaseStorage dbStorage : this.dbStorages) {
            dbStorage.close();
        }
    }

    @Override
    public void putPhysically(Key key, Persistent object) throws IOException {
        assert (key != null);
        assert (this.getName().equals(key.getUnit()));
        assert (object != null);
        this.getDiskStorage(key).write(key, object);
    }

    @Override
    public boolean maintenance(long timeout) throws IOException {
        return this.singleFileStorage.defragment(timeout);
    }

    @Override
    public int getMaintenanceWeight() throws IOException {
        return this.singleFileStorage.getFragmentationPercentage();
    }

    @Override
    public CharSequence getName() {
        return this.unitName;
    }

    @Override
    public void debugClear() {
        this.cache.clearSoftRefs();
    }

    @Override
    public void debugDistribution() {
        this.cache.printDistribution();
    }

    @Override
    public void debugDump(Key key) {
        assert (key != null);
        System.err.printf("\n== Unit debug dump for key %s. Unit name: \"%s\" unit id: %d  \n", key, this.unitName, this.id);
        this.getDiskStorage(key).debugDump(key);
    }

    private static void traceKey(String msg, Key key) {
        if (key.getDepth() == 3 && ("argc".contentEquals(key.getAt(2)) || "main".contentEquals(key.getAt(2)))) {
            System.err.println(msg + " at @" + System.identityHashCode(key) + " " + key);
        }
    }
}

