/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.api.CacheLocation;
import org.netbeans.modules.cnd.repository.api.RepositoryAccessor;
import org.netbeans.modules.cnd.repository.disk.FilesAccessStrategy;
import org.netbeans.modules.cnd.repository.disk.RepositoryCacheMap;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.impl.BaseRepository;
import org.netbeans.modules.cnd.repository.impl.DelegateRepository;
import org.netbeans.modules.cnd.repository.relocate.api.UnitCodec;
import org.netbeans.modules.cnd.repository.sfs.BufferedRWAccess;
import org.netbeans.modules.cnd.repository.sfs.statistics.BaseStatistics;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.repository.util.Filter;

public class FilesAccessStrategyImpl
implements FilesAccessStrategy {
    private final Object cacheLock = new Lock();
    private final RepositoryCacheMap<String, ConcurrentFileRWAccess> nameToFileCache;
    private final StorageAllocator storageAllocator;
    private static final int OPEN_FILES_LIMIT = Integer.getInteger("cnd.repository.files.cache", 20);
    private static final boolean TRACE_CONFLICTS = Boolean.getBoolean("cnd.repository.trace.conflicts");
    private int readCnt = 0;
    private int readHitCnt = 0;
    private int writeCnt = 0;
    private int writeHitCnt = 0;
    BaseStatistics<String> writeStatistics;
    BaseStatistics<String> readStatistics;
    private final UnitCodec unitCodec;
    private static final char SEPARATOR_CHAR = '-';

    public FilesAccessStrategyImpl(StorageAllocator storageAllocator, UnitCodec unitCodec) {
        this.unitCodec = unitCodec;
        this.storageAllocator = storageAllocator;
        this.nameToFileCache = new RepositoryCacheMap(OPEN_FILES_LIMIT);
        if (Stats.multyFileStatistics) {
            this.resetStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Persistent read(Key key) throws IOException {
        ++this.readCnt;
        if (Stats.multyFileStatistics) {
            this.readStatistics.consume(FilesAccessStrategyImpl.getBriefClassName(key), 1);
        }
        ConcurrentFileRWAccess fis = null;
        try {
            fis = this.getFile(key, true);
            if (fis != null) {
                PersistentFactory factory = key.getPersistentFactory();
                assert (factory != null);
                long size = fis.size();
                Persistent persistent = fis.read(factory, 0L, (int)size);
                return persistent;
            }
        }
        finally {
            if (fis != null) {
                fis.lock.readLock().unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Key key, Persistent object) throws IOException {
        ++this.writeCnt;
        if (Stats.multyFileStatistics) {
            this.writeStatistics.consume(FilesAccessStrategyImpl.getBriefClassName(key), 1);
        }
        ConcurrentFileRWAccess fos = null;
        try {
            fos = this.getFile(key, false);
            assert (fos != null);
            if (fos != null) {
                PersistentFactory factory = key.getPersistentFactory();
                assert (factory != null);
                int size = fos.write(factory, object, 0L);
                fos.truncate(size);
            }
        }
        finally {
            if (fos != null) {
                fos.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentFileRWAccess getFile(Key id, boolean readOnly) throws IOException {
        assert (id != null);
        String fileName = this.resolveFileName(id);
        assert (fileName != null);
        ConcurrentFileRWAccess aFile = null;
        boolean keepLocked = false;
        while (true) {
            Object object = this.cacheLock;
            synchronized (object) {
                aFile = this.nameToFileCache.get(fileName);
                if (aFile == null) {
                    String aDirName;
                    File aDir;
                    File fileToCreate = new File(fileName);
                    CharSequence unit = id.getUnit();
                    if (fileToCreate.exists()) {
                        aFile = new ConcurrentFileRWAccess(fileToCreate, unit);
                        this.putFile(fileName, aFile);
                    } else if (!readOnly && ((aDir = new File(aDirName = fileToCreate.getParent())).exists() || aDir.mkdirs())) {
                        aFile = new ConcurrentFileRWAccess(fileToCreate, unit);
                        this.putFile(fileName, aFile);
                    }
                } else if (readOnly) {
                    ++this.readHitCnt;
                } else {
                    ++this.writeHitCnt;
                }
            }
            if (aFile == null) break;
            try {
                if (readOnly) {
                    aFile.lock.readLock().lock();
                } else {
                    aFile.lock.writeLock().lock();
                }
                if (aFile.isValid()) {
                    keepLocked = true;
                    break;
                }
                if (!TRACE_CONFLICTS) continue;
                System.out.printf("invalid file descriptir when %s %s\n", readOnly ? "reading" : "writing", fileName);
                continue;
            }
            finally {
                if (keepLocked) continue;
                if (readOnly) {
                    aFile.lock.readLock().unlock();
                    continue;
                }
                aFile.lock.writeLock().unlock();
                continue;
            }
            break;
        }
        return aFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFile(String fileName, ConcurrentFileRWAccess aFile) throws IOException {
        ConcurrentFileRWAccess removedFile;
        Object object = this.cacheLock;
        synchronized (object) {
            removedFile = this.nameToFileCache.put(fileName, aFile);
        }
        if (removedFile != null) {
            try {
                removedFile.lock.writeLock().lock();
                if (removedFile.isValid()) {
                    removedFile.close();
                }
            }
            finally {
                removedFile.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Key id) throws IOException {
        ConcurrentFileRWAccess removedFile;
        String fileName = this.resolveFileName(id);
        assert (fileName != null);
        Object object = this.cacheLock;
        synchronized (object) {
            removedFile = this.nameToFileCache.remove(fileName);
        }
        if (removedFile != null) {
            try {
                removedFile.lock.writeLock().lock();
                if (removedFile.isValid()) {
                    removedFile.close();
                }
            }
            finally {
                removedFile.lock.writeLock().unlock();
            }
        }
        File toDelete = new File(fileName);
        toDelete.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeUnit(final CharSequence unitName) throws IOException {
        Collection<ConcurrentFileRWAccess> removedFiles;
        Filter<ConcurrentFileRWAccess> filter = new Filter<ConcurrentFileRWAccess>(){

            @Override
            public boolean accept(ConcurrentFileRWAccess value) {
                return value.unit.equals(unitName);
            }
        };
        Object object = this.cacheLock;
        synchronized (object) {
            removedFiles = this.nameToFileCache.remove(filter);
        }
        if (removedFiles != null) {
            for (ConcurrentFileRWAccess fileToRemove : removedFiles) {
                try {
                    fileToRemove.lock.writeLock().lock();
                    if (!fileToRemove.isValid()) continue;
                    fileToRemove.close();
                }
                finally {
                    fileToRemove.lock.writeLock().unlock();
                }
            }
        }
        if (Stats.multyFileStatistics) {
            this.printStatistics();
            this.resetStatistics();
        }
    }

    void printStatistics() {
        System.out.printf("\nFileAccessStrategy statistics: reads %d hits %d (%d%%) writes %d hits %d (%d%%)\n", this.readCnt, this.readHitCnt, FilesAccessStrategyImpl.percentage(this.readHitCnt, this.readCnt), this.writeCnt, this.writeHitCnt, FilesAccessStrategyImpl.percentage(this.writeHitCnt, this.writeCnt));
        if (this.writeStatistics != null) {
            this.readStatistics.print(System.out);
        }
        if (this.writeStatistics != null) {
            this.writeStatistics.print(System.out);
        }
    }

    private static int percentage(int numerator, int denominator) {
        return denominator == 0 ? 0 : numerator * 100 / denominator;
    }

    private void resetStatistics() {
        this.writeStatistics = new BaseStatistics("Writes", 2);
        this.readStatistics = new BaseStatistics("Reads", 2);
        this.writeHitCnt = 0;
        this.writeCnt = 0;
        this.readHitCnt = 0;
        this.readCnt = 0;
    }

    private String resolveFileName(Key id) throws IOException {
        assert (id != null);
        int size = id.getDepth();
        StringBuilder nameBuffer = new StringBuilder("");
        for (int j = 0; j < id.getSecondaryDepth(); ++j) {
            nameBuffer.append(id.getSecondaryAt(j)).append('-');
        }
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                nameBuffer.append(id.getAt(i)).append('-');
            }
        }
        String fileName = nameBuffer.toString();
        fileName = URLEncoder.encode(fileName, Stats.ENCODING);
        fileName = this.storageAllocator.getUnitStorageName(id.getUnit()) + this.storageAllocator.reduceString(fileName);
        return fileName;
    }

    private static String getBriefClassName(Object o) {
        if (o == null) {
            return "null";
        }
        String name = o.getClass().getName();
        int pos = name.lastIndexOf(46);
        return pos < 0 ? name : name.substring(pos + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<String> testGetCacheFileNames() {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.nameToFileCache.keys();
        }
    }

    public static FilesAccessStrategyImpl testGetStrategy(CacheLocation cacheLocation) {
        DelegateRepository repository = (DelegateRepository)RepositoryAccessor.getRepository();
        for (BaseRepository delegate : repository.testGetDelegates()) {
            if (!cacheLocation.equals((Object)delegate.getCacheLocation())) continue;
            return (FilesAccessStrategyImpl)delegate.getFilesAccessStrategy();
        }
        return null;
    }

    int getReadHitCnt() {
        return this.readHitCnt;
    }

    int getReadHitPercentage() {
        return FilesAccessStrategyImpl.percentage(this.readHitCnt, this.readCnt);
    }

    int getWriteHitCnt() {
        return this.writeHitCnt;
    }

    int getWriteHitPercentage() {
        return FilesAccessStrategyImpl.percentage(this.writeHitCnt, this.writeCnt);
    }

    int getCacheSize() {
        return this.nameToFileCache.size();
    }

    @Override
    public void debugDump(Key key) {
        assert (key != null);
        try {
            String fileName = this.resolveFileName(key);
            this.ls(new File(fileName));
        }
        catch (IOException ex) {
            System.err.printf("Exception when dumping by key %s\n", key);
            ex.printStackTrace(System.err);
        }
    }

    private void ls(File file) {
        System.err.printf("\tFile: %s\n\tExists: %b\n\tLength: %d\n\tModified: %s\n\n", file.getAbsolutePath(), file.exists(), file.length(), new Date(file.lastModified()));
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private class ConcurrentFileRWAccess
    extends BufferedRWAccess {
        public final ReentrantReadWriteLock lock;
        public final CharSequence unit;

        public ConcurrentFileRWAccess(File file, CharSequence unit) throws IOException {
            super(file, FilesAccessStrategyImpl.this.unitCodec);
            this.lock = new ReentrantReadWriteLock(true);
            this.unit = unit;
        }
    }
}

