/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.repository.api.CacheLocation;
import org.netbeans.modules.cnd.repository.api.DatabaseTable;
import org.netbeans.modules.cnd.repository.api.RepositoryAccessor;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.disk.Unit;
import org.netbeans.modules.cnd.repository.disk.UnitImpl;
import org.netbeans.modules.cnd.repository.impl.BaseRepository;
import org.netbeans.modules.cnd.repository.queue.KeyValueQueue;
import org.netbeans.modules.cnd.repository.queue.RepositoryQueue;
import org.netbeans.modules.cnd.repository.queue.RepositoryThreadManager;
import org.netbeans.modules.cnd.repository.queue.RepositoryWriter;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;
import org.netbeans.modules.cnd.repository.util.RepositoryListenersManager;
import org.netbeans.modules.cnd.utils.CndUtils;

public class DiskRepositoryManager
extends BaseRepository
implements RepositoryWriter {
    private static final Logger LOG = Logger.getLogger(DiskRepositoryManager.class.getName());
    private final Map<Integer, Unit> units;
    private final RepositoryQueue queue;
    private final RepositoryThreadManager threadManager;
    private final Persistent removedObject = new RemovedPersistent();
    private final ReadWriteLock queueLock = new ReentrantReadWriteLock(true);

    public DiskRepositoryManager(int id, CacheLocation cacheLocation) {
        super(id, cacheLocation);
        this.threadManager = new RepositoryThreadManager(this, this.queueLock);
        this.queue = this.threadManager.getQueue();
        this.units = new ConcurrentHashMap<Integer, Unit>();
    }

    public DatabaseTable getDatabaseTable(Key unitKey, String tableID) {
        try {
            UnitImpl impl = (UnitImpl)this.getCreateUnit(unitKey);
            return impl.getDatabaseTable(tableID);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(unitKey.getUnitId(), this.getUnitNameSafe(unitKey), new RepositoryException(ex));
            return null;
        }
    }

    private Unit getCreateUnit(Key key) throws IOException {
        assert (key != null);
        Unit unit = this.units.get(key.getUnitId());
        if (unit != null) {
            return unit;
        }
        return this.getCreateUnit(key.getUnitId(), key.getUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unit getCreateUnit(int unitId, CharSequence unitName) throws IOException {
        assert (unitName != null);
        Unit unit = this.units.get(unitId);
        if (unit == null) {
            unit = null;
            Object object = this.getUnitLock(unitId);
            synchronized (object) {
                unit = this.units.get(unitId);
                if (unit == null && RepositoryListenersManager.getInstance().fireUnitOpenedEvent(unitId, unitName)) {
                    this.getTranslation().loadUnitIndex(unitId, unitName);
                    unit = new UnitImpl(unitId, unitName, this);
                    this.units.put(unitId, unit);
                }
            }
        }
        return unit;
    }

    public void put(Key key, Persistent obj) {
        try {
            this.getCreateUnit(key).putToCache(key, obj);
            this.queue.addLast(key, obj);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(key.getUnitId(), this.getUnitNameSafe(key), new RepositoryException(ex));
        }
    }

    public void hang(Key key, Persistent obj) {
        try {
            this.getCreateUnit(key).hang(key, obj);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(key.getUnitId(), this.getUnitNameSafe(key), new RepositoryException(ex));
        }
    }

    @Override
    public void write(Key key, Persistent object) {
        try {
            Unit diskRep = this.getCreateUnit(key);
            if (object instanceof RemovedPersistent) {
                diskRep.removePhysically(key);
            } else {
                diskRep.putPhysically(key, object);
            }
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(key.getUnitId(), this.getUnitNameSafe(key), new RepositoryException(ex));
        }
    }

    public Persistent get(Key key) {
        try {
            return this.getCreateUnit(key).get(key);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(key.getUnitId(), this.getUnitNameSafe(key), new RepositoryException(ex));
            return null;
        }
    }

    public Persistent tryGet(Key key) {
        try {
            return this.getCreateUnit(key).tryGet(key);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(key.getUnitId(), this.getUnitNameSafe(key), new RepositoryException(ex));
            return null;
        }
    }

    public void remove(Key key) {
        try {
            this.getCreateUnit(key).removeFromCache(key);
            this.queue.addLast(key, this.removedObject);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(key.getUnitId(), this.getUnitNameSafe(key), new RepositoryException(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.threadManager != null) {
            this.threadManager.shutdown();
        }
        ArrayList<Map.Entry<Integer, Unit>> entries = new ArrayList<Map.Entry<Integer, Unit>>(this.units.entrySet());
        for (Map.Entry entry : entries) {
            this.closeUnit((Integer)entry.getKey(), true, null);
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.log(Level.INFO, "Closing unit{0} done.", ((Unit)entry.getValue()).getName());
        }
        try {
            this.queueLock.writeLock().lock();
            this.cleanAndWriteQueue();
            if (!this.units.isEmpty() && LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Not empty unit list after closing: {0}", this.units.toString());
            }
            this.units.clear();
        }
        finally {
            this.queueLock.writeLock().unlock();
        }
        this.getTranslation().shutdown();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.INFO, "Repository shutdown done.");
        }
    }

    @Override
    public boolean maintenance(long timeout) {
        if (this.units.isEmpty()) {
            return false;
        }
        Collection<Unit> values = this.units.values();
        Unit[] unitList = values.toArray(new Unit[values.size()]);
        Arrays.sort(unitList, new MaintenanceComparator());
        boolean needMoreTime = false;
        long start = System.currentTimeMillis();
        for (int i = 0; i < unitList.length; ++i) {
            if (timeout <= 0L) {
                needMoreTime = true;
                break;
            }
            try {
                if (unitList[i].maintenance(timeout)) {
                    needMoreTime = true;
                }
            }
            catch (IOException ex) {
                RepositoryListenersManager.getInstance().fireAnException(unitList[i].getId(), unitList[i].getName(), new RepositoryException((Throwable)ex));
            }
            timeout -= System.currentTimeMillis() - start;
        }
        return needMoreTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openUnit(int unitId, CharSequence unitName) {
        try {
            Object object = this.getUnitLock(unitId);
            synchronized (object) {
                this.getCreateUnit(unitId, unitName);
            }
        }
        catch (Throwable exc) {
            RepositoryListenersManager.getInstance().fireAnException(unitId, unitName, new RepositoryException(exc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeUnit(int unitId, boolean cleanRepository, Set<Integer> requiredUnits) {
        CharSequence unitName = RepositoryAccessor.getTranslator().getUnitName(unitId);
        LinkedHashSet<CharSequence> requiredUnitNames = null;
        if (requiredUnits != null) {
            requiredUnitNames = new LinkedHashSet<CharSequence>(requiredUnits.size());
            for (Integer integer : requiredUnits) {
                requiredUnitNames.add(this.getTranslation().getUnitName(unitId));
            }
        }
        Object object = this.getUnitLock(unitId);
        synchronized (object) {
            this.closeUnit2(unitId, unitName, cleanRepository, requiredUnitNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnit2(int unitId, CharSequence unitName, boolean cleanRepository, Set<CharSequence> requiredUnits) {
        Collection<KeyValueQueue.Entry<Key, Persistent>> clearQueue;
        assert (Thread.holdsLock(this.getUnitLock(unitId)));
        try {
            Unit unit;
            this.queueLock.writeLock().lock();
            Collection<KeyValueQueue.Entry<Key, Persistent>> removedEntries = this.queue.clearQueue(new UnitFilter(unitId));
            if (!cleanRepository) {
                for (KeyValueQueue.Entry<Key, Persistent> entry : removedEntries) {
                    this.write(entry.getKey(), entry.getValue());
                }
            }
            if ((unit = this.units.remove(unitId)) != null) {
                try {
                    unit.close();
                }
                catch (Throwable exc) {
                    RepositoryListenersManager.getInstance().fireAnException(unitId, unitName, new RepositoryException(exc));
                }
            }
        }
        finally {
            this.queueLock.writeLock().unlock();
        }
        if (CndUtils.isDebugMode() && !(clearQueue = this.queue.clearQueue(new UnitFilter(unitId))).isEmpty() && LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "UNSAVED ENTRIES FOR {0}", unitName);
            for (KeyValueQueue.Entry<Key, Persistent> entry : clearQueue) {
                LOG.log(Level.INFO, "\t{0}\n\t{1}", new Object[]{entry.getKey(), entry.getValue()});
            }
        }
        StorageAllocator allocator = this.getStorageAllocator();
        if (cleanRepository) {
            allocator.deleteUnitFiles(unitName, true);
        }
        allocator.closeUnit(unitName);
        this.getTranslation().closeUnit(unitName, requiredUnits);
        RepositoryListenersManager.getInstance().fireUnitClosedEvent(unitId, unitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnit(int unitId) {
        CharSequence unitName = RepositoryAccessor.getTranslator().getUnitName(unitId);
        Object object = this.getUnitLock(unitId);
        synchronized (object) {
            this.closeUnit2(unitId, unitName, true, Collections.<CharSequence>emptySet());
            this.getTranslation().removeUnit(unitName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugClear() {
        ArrayList<Map.Entry<Integer, Unit>> entries = new ArrayList<Map.Entry<Integer, Unit>>(this.units.entrySet());
        for (Map.Entry entry : entries) {
            ((Unit)entry.getValue()).debugClear();
        }
        try {
            this.queueLock.writeLock().lock();
            this.cleanAndWriteQueue();
        }
        finally {
            this.queueLock.writeLock().unlock();
        }
    }

    private void cleanAndWriteQueue() {
        Collection<KeyValueQueue.Entry<Key, Persistent>> removedEntries = this.queue.clearQueue(new AllFilter());
        for (KeyValueQueue.Entry<Key, Persistent> entry : removedEntries) {
            this.write(entry.getKey(), entry.getValue());
        }
    }

    public void cleanCaches() {
        this.getStorageAllocator().cleanRepositoryCaches();
    }

    public void registerRepositoryListener(RepositoryListener aListener) {
    }

    public void unregisterRepositoryListener(RepositoryListener aListener) {
    }

    public void startup(int persistMechanismVersion) {
        this.threadManager.startup();
    }

    public void debugDistribution() {
        for (Unit unit : this.units.values()) {
            System.err.println("UNIT " + unit.getName());
            unit.debugDistribution();
        }
    }

    public void debugDump(Key key) {
        assert (key != null);
        Unit unit = this.units.get(key.getUnitId());
        if (unit == null) {
            System.err.printf("=== Repository debug dump for key=%s. Unit not found.", key);
        } else {
            unit.debugDump(key);
        }
    }

    private static int getMaintenanceWeight(Unit unit) {
        try {
            return unit.getMaintenanceWeight();
        }
        catch (IOException ex) {
            RepositoryListenersManager.getInstance().fireAnException(unit.getId(), unit.getName(), new RepositoryException((Throwable)ex));
            return 0;
        }
    }

    private CharSequence getUnitNameSafe(Key key) {
        return this.getTranslation().getUnitNameSafe(key.getUnitId());
    }

    private static class MaintenanceComparator
    implements Comparator<Unit>,
    Serializable {
        private static final long serialVersionUID = 7249069246763182397L;

        private MaintenanceComparator() {
        }

        @Override
        public int compare(Unit o1, Unit o2) {
            return DiskRepositoryManager.getMaintenanceWeight(o2) - DiskRepositoryManager.getMaintenanceWeight(o1);
        }
    }

    private static class AllFilter
    implements RepositoryQueue.Filter {
        private AllFilter() {
        }

        @Override
        public boolean accept(Key key, Persistent value) {
            return true;
        }
    }

    private static class UnitFilter
    implements RepositoryQueue.Filter {
        private int unitId;

        public UnitFilter(int unitId) {
            this.unitId = unitId;
        }

        @Override
        public boolean accept(Key key, Persistent value) {
            return key.getUnitId() == this.unitId;
        }
    }

    private static class RemovedPersistent
    implements Persistent {
        private RemovedPersistent() {
        }
    }
}

