/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.coverage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.CoverageType;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MavenCoverageProvider
implements CoverageProvider {
    private static final String GROUP_COBERTURA = "org.codehaus.mojo";
    private static final String ARTIFACT_COBERTURA = "cobertura-maven-plugin";
    private static final String GROUP_JOCOCO = "org.jacoco";
    private static final String ARTIFACT_JOCOCO = "jacoco-maven-plugin";
    private static final Logger LOG = Logger.getLogger(MavenCoverageProvider.class.getName());
    private final Project p;
    @NullAllowed
    private org.w3c.dom.Document report;
    private FileChangeListener listener;

    public MavenCoverageProvider(Project p) {
        this.p = p;
    }

    public boolean supportsHitCounts() {
        return true;
    }

    public boolean supportsAggregation() {
        return false;
    }

    private boolean hasPlugin(String groupId, String artifactId) {
        NbMavenProject prj = (NbMavenProject)this.p.getLookup().lookup(NbMavenProject.class);
        if (prj == null) {
            return false;
        }
        MavenProject mp = prj.getMavenProject();
        if (PluginPropertyUtils.getReportPluginVersion((MavenProject)mp, (String)groupId, (String)artifactId) != null) {
            return true;
        }
        return PluginPropertyUtils.getPluginVersion((MavenProject)mp, (String)groupId, (String)artifactId) != null;
    }

    public boolean isEnabled() {
        return this.hasPlugin(GROUP_COBERTURA, ARTIFACT_COBERTURA) || this.hasPlugin(GROUP_JOCOCO, ARTIFACT_JOCOCO);
    }

    public boolean isAggregating() {
        throw new UnsupportedOperationException();
    }

    public void setAggregating(boolean aggregating) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getMimeTypes() {
        return Collections.singleton("text/x-java");
    }

    public void setEnabled(boolean enabled) {
    }

    @CheckForNull
    private File report() {
        if (this.hasPlugin(GROUP_JOCOCO, ARTIFACT_JOCOCO)) {
            String outputDirectory = PluginPropertyUtils.getReportPluginProperty((Project)this.p, (String)GROUP_JOCOCO, (String)ARTIFACT_JOCOCO, (String)"outputDirectory", null);
            if (outputDirectory == null) {
                outputDirectory = PluginPropertyUtils.getPluginProperty((Project)this.p, (String)GROUP_JOCOCO, (String)ARTIFACT_JOCOCO, (String)"outputDirectory", null, null);
            }
            if (outputDirectory == null) {
                try {
                    outputDirectory = (String)PluginPropertyUtils.createEvaluator((Project)this.p).evaluate("${project.reporting.outputDirectory}/jacoco");
                }
                catch (ExpressionEvaluationException x) {
                    LOG.log(Level.WARNING, null, x);
                    return null;
                }
            }
            return FileUtil.normalizeFile((File)new File(outputDirectory, "jacoco.xml"));
        }
        String outputDirectory = PluginPropertyUtils.getReportPluginProperty((Project)this.p, (String)GROUP_COBERTURA, (String)ARTIFACT_COBERTURA, (String)"outputDirectory", null);
        if (outputDirectory == null) {
            outputDirectory = PluginPropertyUtils.getPluginProperty((Project)this.p, (String)GROUP_COBERTURA, (String)ARTIFACT_COBERTURA, (String)"outputDirectory", null, null);
        }
        if (outputDirectory == null) {
            try {
                outputDirectory = (String)PluginPropertyUtils.createEvaluator((Project)this.p).evaluate("${project.reporting.outputDirectory}/cobertura");
            }
            catch (ExpressionEvaluationException x) {
                LOG.log(Level.WARNING, null, x);
                return null;
            }
        }
        return FileUtil.normalizeFile((File)new File(outputDirectory, "coverage.xml"));
    }

    public synchronized void clear() {
        File r = this.report();
        if (r != null && r.isFile() && r.delete()) {
            this.report = null;
            CoverageManager.INSTANCE.resultsUpdated(this.p, (CoverageProvider)this);
        }
    }

    @CheckForNull
    private synchronized org.w3c.dom.Document parse() {
        if (this.report != null) {
            LOG.fine("cached report");
            return (org.w3c.dom.Document)this.report.cloneNode(true);
        }
        File r = this.report();
        if (r == null) {
            LOG.fine("undefined report location");
            return null;
        }
        CoverageManager.INSTANCE.setEnabled(this.p, true);
        if (this.listener == null) {
            this.listener = new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    this.fire();
                }

                public void fileDataCreated(FileEvent fe) {
                    this.fire();
                }

                public void fileDeleted(FileEvent fe) {
                    this.fire();
                }

                private void fire() {
                    MavenCoverageProvider.this.report = null;
                    CoverageManager.INSTANCE.resultsUpdated(MavenCoverageProvider.this.p, (CoverageProvider)MavenCoverageProvider.this);
                }
            };
            FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)r);
        }
        if (!r.isFile()) {
            LOG.log(Level.FINE, "missing {0}", r);
            return null;
        }
        if (r.length() == 0L) {
            LOG.log(Level.FINE, "empty {0}", r);
            return null;
        }
        try {
            this.report = XMLUtil.parse((InputSource)new InputSource(r.toURI().toString()), (boolean)true, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), (EntityResolver)new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.equals("http://cobertura.sourceforge.net/xml/coverage-04.dtd")) {
                        return new InputSource(MavenCoverageProvider.class.getResourceAsStream("coverage-04.dtd"));
                    }
                    if (publicId.equals("-//JACOCO//DTD Report 1.0//EN")) {
                        return new InputSource(MavenCoverageProvider.class.getResourceAsStream("jacoco-1.0.dtd"));
                    }
                    return null;
                }
            });
            LOG.log(Level.FINE, "parsed {0}", r);
            return (org.w3c.dom.Document)this.report.cloneNode(true);
        }
        catch (Exception x) {
            LOG.log(Level.INFO, "Could not parse " + r, x);
            return null;
        }
    }

    @CheckForNull
    private FileObject src() {
        return this.p.getProjectDirectory().getFileObject("src/main/java");
    }

    public FileCoverageDetails getDetails(final FileObject fo, final Document doc) {
        org.w3c.dom.Document r = this.parse();
        if (r == null) {
            return null;
        }
        FileObject src = this.src();
        if (src == null) {
            return null;
        }
        String path = FileUtil.getRelativePath((FileObject)src, (FileObject)fo);
        if (path == null) {
            return null;
        }
        final boolean jacoco = this.hasPlugin(GROUP_JOCOCO, ARTIFACT_JOCOCO);
        final ArrayList<Element> lines = new ArrayList<Element>();
        String name = null;
        NodeList nl = r.getElementsByTagName(jacoco ? "sourcefile" : "class");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element clazz = (Element)nl.item(i);
            if (jacoco) {
                if (!(((Element)clazz.getParentNode()).getAttribute("name") + '/' + clazz.getAttribute("name")).equals(path)) continue;
                for (Element line : XMLUtil.findSubElements((Element)clazz)) {
                    if (!line.getTagName().equals("line")) continue;
                    lines.add(line);
                }
                if (name != null) continue;
                name = path.replaceFirst("[.]java$", "").replace('/', '.');
                continue;
            }
            if (!clazz.getAttribute("filename").equals(path)) continue;
            Element linesE = XMLUtil.findElement((Element)clazz, (String)"lines", null);
            if (linesE != null) {
                lines.addAll(XMLUtil.findSubElements((Element)linesE));
            }
            if (name != null) continue;
            name = clazz.getAttribute("name");
        }
        if (name == null) {
            return null;
        }
        final String _name = name;
        return new FileCoverageDetails(){

            public FileObject getFile() {
                return fo;
            }

            public int getLineCount() {
                return doc.getDefaultRootElement().getElementCount();
            }

            public boolean hasHitCounts() {
                return true;
            }

            public long lastUpdated() {
                File r = MavenCoverageProvider.this.report();
                return r != null ? r.lastModified() : 0L;
            }

            public FileCoverageSummary getSummary() {
                return MavenCoverageProvider.this.summaryOf(fo, _name, lines, jacoco);
            }

            private Integer find(int lineNo) {
                for (Element line : lines) {
                    if (!line.getAttribute(jacoco ? "nr" : "number").equals(String.valueOf(lineNo + 1))) continue;
                    return Integer.valueOf(line.getAttribute(jacoco ? "ci" : "hits"));
                }
                return null;
            }

            public CoverageType getType(int lineNo) {
                Integer count = this.find(lineNo);
                return count == null ? CoverageType.INFERRED : (count == 0 ? CoverageType.NOT_COVERED : CoverageType.COVERED);
            }

            public int getHitCount(int lineNo) {
                Integer count = this.find(lineNo);
                return count == null ? 0 : count;
            }
        };
    }

    public List<FileCoverageSummary> getResults() {
        org.w3c.dom.Document r = this.parse();
        if (r == null) {
            return null;
        }
        FileObject src = this.src();
        if (src == null) {
            return null;
        }
        ArrayList<FileCoverageSummary> summs = new ArrayList<FileCoverageSummary>();
        boolean jacoco = this.hasPlugin(GROUP_JOCOCO, ARTIFACT_JOCOCO);
        NodeList nl = r.getElementsByTagName(jacoco ? "sourcefile" : "class");
        for (int i = 0; i < nl.getLength(); ++i) {
            String name;
            ArrayList<Element> lines;
            String filename;
            Element clazz = (Element)nl.item(i);
            if (jacoco) {
                filename = ((Element)clazz.getParentNode()).getAttribute("name") + '/' + clazz.getAttribute("name");
                lines = new ArrayList<Element>();
                for (Element line : XMLUtil.findSubElements((Element)clazz)) {
                    if (!line.getTagName().equals("line")) continue;
                    lines.add(line);
                }
                name = filename.replaceFirst("[.]java$", "").replace('/', '.');
            } else {
                filename = clazz.getAttribute("filename");
                Element linesE = XMLUtil.findElement((Element)clazz, (String)"lines", null);
                lines = linesE != null ? XMLUtil.findSubElements((Element)linesE) : Collections.emptyList();
                name = clazz.getAttribute("name").replace('$', '.');
            }
            FileObject java = src.getFileObject(filename);
            if (java == null) continue;
            summs.add(this.summaryOf(java, name, lines, jacoco));
        }
        return summs;
    }

    private FileCoverageSummary summaryOf(FileObject java, String name, List<Element> lines, boolean jacoco) {
        int lineCount = 0;
        int executedLineCount = 0;
        for (Element line : lines) {
            ++lineCount;
            if (line.getAttribute(jacoco ? "ci" : "hits").equals("0")) continue;
            ++executedLineCount;
        }
        return new FileCoverageSummary(java, name, lineCount, executedLineCount, 0, 0);
    }

    public String getTestAllAction() {
        return this.hasPlugin(GROUP_JOCOCO, ARTIFACT_JOCOCO) ? "jacoco" : "cobertura";
    }
}

