/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.web;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.projectimport.eclipse.core.spi.Facets;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectFactorySupport;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectImportModel;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeFactory;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeUpdater;
import org.netbeans.modules.projectimport.eclipse.web.ServerSelectionWizardPanel;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.api.WebProjectUtilities;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebProjectFactory
implements ProjectTypeUpdater {
    private static final Logger LOG = Logger.getLogger(WebProjectFactory.class.getName());
    private static final String WEB_NATURE = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    private static final Icon WEB_PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/project/ui/resources/webProjectIcon.gif", (boolean)false);
    private static final String MYECLIPSE_WEB_NATURE = "com.genuitec.eclipse.j2eedt.core.webnature";

    public boolean canHandle(ProjectTypeFactory.ProjectDescriptor descriptor) {
        if (descriptor.getFacets() != null) {
            return descriptor.getFacets().hasInstalledFacet("jst.web");
        }
        if (descriptor.getNatures().contains(WEB_NATURE)) {
            return true;
        }
        return descriptor.getNatures().contains(MYECLIPSE_WEB_NATURE);
    }

    private ServerSelectionWizardPanel findWizardPanel(ProjectImportModel model) {
        assert (model.getExtraWizardPanels() != null);
        for (WizardDescriptor.Panel panel : model.getExtraWizardPanels()) {
            if (!(panel instanceof ServerSelectionWizardPanel)) continue;
            return (ServerSelectionWizardPanel)panel;
        }
        return null;
    }

    public Project createProject(ProjectImportModel model, List<String> importProblems) throws IOException {
        Facets.Facet f;
        String serverID;
        File nbProjectDir = model.getNetBeansProjectLocation();
        if (ProjectFactorySupport.areSourceRootsOwned((ProjectImportModel)model, (File)nbProjectDir, importProblems)) {
            return null;
        }
        WebContentData webData = WebProjectFactory.parseWebContent(model.getEclipseProjectFolder());
        if (webData == null || webData.webRoot == null) {
            importProblems.add(NbBundle.getMessage(WebProjectFactory.class, (String)"MSG_MissingExtraWebFiles"));
            return null;
        }
        if (model.getExtraWizardPanels() != null && this.findWizardPanel(model) != null) {
            ServerSelectionWizardPanel wizard = this.findWizardPanel(model);
            assert (wizard != null);
            serverID = wizard.getServerID();
        } else {
            if (Deployment.getDefault().getServerInstanceIDs().length == 0) {
                importProblems.add(NbBundle.getMessage(WebProjectFactory.class, (String)"MSG_NoJ2EEServer"));
                return null;
            }
            serverID = Deployment.getDefault().getServerInstanceIDs()[0];
        }
        WebProjectCreateData createData = new WebProjectCreateData();
        createData.setProjectDir(nbProjectDir);
        createData.setName(model.getProjectName());
        createData.setServerInstanceID(serverID);
        String j2eeSpecVersion = null;
        if (model.getFacets() != null && (f = model.getFacets().getFacet("jst.web")) != null) {
            String servletAPIVersion = f.getVersion();
            if ("2.5".equals(servletAPIVersion)) {
                j2eeSpecVersion = "1.5";
            } else if ("2.4".equals(servletAPIVersion)) {
                j2eeSpecVersion = "1.4";
            } else if ("2.3".equals(servletAPIVersion)) {
                j2eeSpecVersion = "1.3";
            }
        }
        if (j2eeSpecVersion == null && webData.j2eeSpecVersion != null) {
            j2eeSpecVersion = webData.j2eeSpecVersion;
        }
        if (j2eeSpecVersion == null) {
            j2eeSpecVersion = "1.5";
        }
        createData.setJavaEEVersion(j2eeSpecVersion);
        createData.setSourceLevel(model.getSourceLevel());
        if (model.getJavaPlatform() != null) {
            createData.setJavaPlatformName(model.getJavaPlatform().getDisplayName());
        }
        createData.setServerLibraryName(null);
        FileObject root = FileUtil.toFileObject((File)model.getEclipseProjectFolder());
        if (root.getFileObject(webData.webRoot) == null) {
            importProblems.add(NbBundle.getMessage(WebProjectFactory.class, (String)"MSG_MissingDocRoot", (Object)webData.webRoot));
            return null;
        }
        createData.setWebModuleFO(root);
        createData.setSourceFolders(model.getEclipseSourceRootsAsFileArray());
        createData.setTestFolders(model.getEclipseTestSourceRootsAsFileArray());
        createData.setContextPath(webData.contextRoot);
        createData.setDocBase(root.getFileObject(webData.webRoot));
        createData.setLibFolder(root.getFileObject(webData.webRoot + "/WEB-INF/lib"));
        createData.setWebInfFolder(root.getFileObject(webData.webRoot + "/WEB-INF"));
        createData.setLibrariesDefinition(null);
        if (nbProjectDir.exists() && new File(nbProjectDir, "build.xml").exists()) {
            createData.setBuildfile("nb-build.xml");
        } else {
            createData.setBuildfile("build.xml");
        }
        AntProjectHelper helper = WebProjectUtilities.importProject((WebProjectCreateData)createData);
        WebProject nbProject = (WebProject)ProjectManager.getDefault().findProject(helper.getProjectDirectory());
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        boolean changed = false;
        if (new File(nbProjectDir, "dist").exists()) {
            ep.setProperty("dist.dir", "nbdist");
            changed = true;
        }
        if (new File(nbProjectDir, "build").exists()) {
            ep.setProperty("build.dir", "nbbuild");
            changed = true;
        }
        if (changed) {
            helper.putProperties("nbproject/project.properties", ep);
        }
        ProjectFactorySupport.updateSourceRootLabels((List)model.getEclipseSourceRoots(), (SourceRoots)nbProject.getSourceRoots());
        ProjectFactorySupport.updateSourceRootLabels((List)model.getEclipseTestSourceRoots(), (SourceRoots)nbProject.getTestSourceRoots());
        ProjectFactorySupport.setupSourceExcludes((AntProjectHelper)helper, (ProjectImportModel)model, importProblems);
        this.setupCompilerProperties(helper, model);
        ProjectFactorySupport.updateProjectClassPath((AntProjectHelper)helper, (ReferenceHelper)nbProject.getReferenceHelper(), (ProjectImportModel)model, importProblems);
        ProjectManager.getDefault().saveProject((Project)nbProject);
        return nbProject;
    }

    private static WebContentData parseWebContent(File eclipseProject) throws IOException {
        File f = new File(eclipseProject, ".settings/org.eclipse.wst.common.component");
        if (!f.exists()) {
            f = new File(eclipseProject, ".settings/.component");
        }
        if (f.exists()) {
            Document webContent;
            try {
                webContent = XMLUtil.parse((InputSource)new InputSource(f.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
            }
            catch (SAXException e) {
                IOException ioe = (IOException)new IOException(f + ": " + e.toString()).initCause(e);
                throw ioe;
            }
            Element modulesEl = webContent.getDocumentElement();
            if (!"project-modules".equals(modulesEl.getLocalName())) {
                return null;
            }
            WebContentData data = new WebContentData();
            Element moduleEl = XMLUtil.findElement((Element)modulesEl, (String)"wb-module", null);
            if (moduleEl != null) {
                for (Element el : XMLUtil.findSubElements((Element)moduleEl)) {
                    if ("wb-resource".equals(el.getNodeName()) && "/".equals(el.getAttribute("deploy-path"))) {
                        data.webRoot = el.getAttribute("source-path");
                    }
                    if (!"property".equals(el.getNodeName()) || !"context-root".equals(el.getAttribute("name"))) continue;
                    data.contextRoot = el.getAttribute("value");
                }
            }
            return data;
        }
        f = new File(eclipseProject, ".mymetadata");
        if (f.exists()) {
            Element attrsEl;
            Document webContent;
            try {
                webContent = XMLUtil.parse((InputSource)new InputSource(f.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
            }
            catch (SAXException e) {
                IOException ioe = (IOException)new IOException(f + ": " + e.toString()).initCause(e);
                throw ioe;
            }
            Element modulesEl = webContent.getDocumentElement();
            if (!"project-module".equals(modulesEl.getLocalName())) {
                return null;
            }
            WebContentData data = new WebContentData();
            data.contextRoot = modulesEl.getAttribute("context-root");
            String specVer = modulesEl.getAttribute("j2ee-spec");
            if ("5.0".equals(specVer)) {
                specVer = "1.5";
            }
            if ((attrsEl = XMLUtil.findElement((Element)modulesEl, (String)"attributes", null)) != null) {
                for (Element el : XMLUtil.findSubElements((Element)attrsEl)) {
                    if (!"attribute".equals(el.getNodeName()) || !"webrootdir".equals(el.getAttribute("name"))) continue;
                    data.webRoot = el.getAttribute("value");
                    break;
                }
            }
            return data;
        }
        return null;
    }

    public String calculateKey(ProjectImportModel model) {
        WebContentData webData;
        try {
            webData = WebProjectFactory.parseWebContent(model.getEclipseProjectFolder());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            webData = new WebContentData();
            webData.contextRoot = "??";
            webData.webRoot = "??";
        }
        return ProjectFactorySupport.calculateKey((ProjectImportModel)model) + "web=" + webData.webRoot + ";" + "context=" + webData.contextRoot + ";";
    }

    public String update(Project project, ProjectImportModel model, String oldKey, List<String> importProblems) throws IOException {
        if (!(project instanceof WebProject)) {
            throw new IOException("is not web project: " + project.getClass().getName());
        }
        String newKey = this.calculateKey(model);
        String actualKey = ProjectFactorySupport.synchronizeProjectClassPath((Project)project, (AntProjectHelper)((WebProject)project).getAntProjectHelper(), (ReferenceHelper)((WebProject)project).getReferenceHelper(), (ProjectImportModel)model, (String)oldKey, (String)newKey, importProblems);
        this.setupCompilerProperties(((WebProject)project).getAntProjectHelper(), model);
        ProjectManager.getDefault().saveProject(project);
        return actualKey;
    }

    public Icon getProjectTypeIcon() {
        return WEB_PROJECT_ICON;
    }

    public String getProjectTypeName() {
        return NbBundle.getMessage(WebProjectFactory.class, (String)"LABEL_Web_Application");
    }

    public List<WizardDescriptor.Panel<WizardDescriptor>> getAdditionalImportWizardPanels() {
        return Collections.singletonList(new ServerSelectionWizardPanel());
    }

    private void setupCompilerProperties(AntProjectHelper helper, ProjectImportModel model) {
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        ep.setProperty("javac.source", model.getSourceLevel());
        ep.setProperty("javac.target", model.getTargetLevel());
        ep.setProperty("javac.deprecation", Boolean.toString(model.isDeprecation()));
        ep.setProperty("javac.compilerargs", model.getCompilerArgs());
        ep.setProperty("source.encoding", model.getEncoding());
        helper.putProperties("nbproject/project.properties", ep);
        ep = helper.getProperties("nbproject/private/private.properties");
        ep.setProperty("javac.debug", Boolean.toString(model.isDebug()));
        helper.putProperties("nbproject/private/private.properties", ep);
    }

    public File getProjectFileLocation(ProjectTypeFactory.ProjectDescriptor descriptor, String token) {
        File f;
        WebContentData data;
        if (!token.equals("webinf")) {
            return null;
        }
        try {
            data = WebProjectFactory.parseWebContent(descriptor.getEclipseProjectFolder());
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "cannot parse webmodule data", ex);
            return null;
        }
        if (data != null && (f = new File(descriptor.getEclipseProjectFolder(), data.webRoot + File.separatorChar + "WEB-INF" + File.separator)).exists()) {
            return f;
        }
        return null;
    }

    private static class WebContentData {
        private String contextRoot;
        private String webRoot;
        private String j2eeSpecVersion;

        private WebContentData() {
        }

        public String toString() {
            return "WebContentData[contextRoot=" + this.contextRoot + ", webRoot=" + this.webRoot + "]";
        }
    }
}

