/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.tasks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Parameters;

public final class OpenedEditors {
    public static final String CND_EDITOR_COMPONENT = "CND_EDITOR_COMPONENT";
    private List<JTextComponent> visibleEditors = new ArrayList<JTextComponent>();
    private Map<JTextComponent, FileObject> visibleEditors2Files = new HashMap<JTextComponent, FileObject>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final PropertyChangeListener componentListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            OpenedEditors.this.propertyChange(evt);
        }
    };
    static final boolean SHOW_TIME = Boolean.getBoolean("cnd.model.tasks.time");
    private static final boolean TRACE_FILES = Boolean.getBoolean("cnd.model.tasks.files");
    private static final List<String> mimeTypesList = Arrays.asList("text/x-c++", "text/x-c", "text/x-h");
    private static OpenedEditors DEFAULT = new OpenedEditors();

    private OpenedEditors() {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OpenedEditors.this.stateChanged(evt);
            }
        });
        this.stateChanged(null);
    }

    public void fireStateChanged() {
        this.stateChanged(null);
    }

    public static OpenedEditors getDefault() {
        return DEFAULT;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        if (SHOW_TIME) {
            System.err.println("OpenedEditors.fireChangeEvent()");
        }
        ChangeEvent e = new ChangeEvent(this);
        ArrayList<ChangeListener> listenersCopy = null;
        OpenedEditors openedEditors = this;
        synchronized (openedEditors) {
            listenersCopy = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : listenersCopy) {
            l.stateChanged(e);
        }
    }

    public synchronized List<JTextComponent> getVisibleEditors() {
        return new ArrayList<JTextComponent>(this.visibleEditors);
    }

    public synchronized Collection<FileObject> getVisibleEditorsFiles() {
        return new ArrayList<FileObject>(this.visibleEditors2Files.values());
    }

    private synchronized void stateChanged(PropertyChangeEvent evt) {
        FileObject fo;
        String propName;
        String string = propName = evt == null ? null : evt.getPropertyName();
        if (!(propName == null || "componentRemoved".equals(propName) || "focusedDocument".equals(propName) || "focusGained".equals(propName) || "lastFocusedRemoved".equals(propName))) {
            if (SHOW_TIME || TRACE_FILES) {
                System.err.println("in OpenedEditors.stateChanged() skip event " + propName);
            }
            return;
        }
        if (SHOW_TIME || TRACE_FILES) {
            System.err.println("OpenedEditors.stateChanged() with event " + propName);
        }
        for (JTextComponent c : this.visibleEditors) {
            c.removePropertyChangeListener(this.componentListener);
            this.visibleEditors2Files.remove(c);
        }
        this.visibleEditors.clear();
        for (JTextComponent editor : EditorRegistry.componentList()) {
            if (this.isHandledEditor(editor)) {
                fo = OpenedEditors.getFileObject(editor);
                if (OpenedEditors.isSupported(fo)) {
                    boolean valid = true;
                    if (TRACE_FILES) {
                        System.err.printf("\tfile: %s valid: %b\n", fo.toString(), valid);
                    }
                    if (!valid) continue;
                    this.visibleEditors.add(editor);
                    continue;
                }
                if (!SHOW_TIME && !TRACE_FILES) continue;
                System.err.println("OpenedEditors.stateChanged() skip FO " + fo);
                continue;
            }
            if (!SHOW_TIME && !TRACE_FILES) continue;
            System.err.println("OpenedEditors.stateChanged() skip editor " + editor);
        }
        for (JTextComponent c : this.visibleEditors) {
            fo = OpenedEditors.getFileObject(c);
            if (fo == null || !fo.isValid()) continue;
            c.addPropertyChangeListener(this.componentListener);
            this.visibleEditors2Files.put(c, fo);
        }
        this.fireChangeEvent();
    }

    private synchronized void propertyChange(PropertyChangeEvent evt) {
        if (SHOW_TIME) {
            System.err.println("OpenedEditors.propertyChange() " + (evt == null ? "null" : evt.getPropertyName()));
        }
        JTextComponent c = (JTextComponent)evt.getSource();
        FileObject originalFile = this.visibleEditors2Files.get(c);
        FileObject newFile = OpenedEditors.getFileObject(c);
        if (originalFile != null && originalFile != newFile) {
            if (SHOW_TIME) {
                System.err.println("OpenedEditord: new files found: " + newFile.getNameExt());
            }
            if (newFile != null) {
                this.visibleEditors2Files.put(c, newFile);
            } else {
                this.visibleEditors2Files.remove(c);
                c.removePropertyChangeListener(this.componentListener);
            }
            this.fireChangeEvent();
        }
    }

    static FileObject getFileObject(JTextComponent pane) {
        Object source = pane.getDocument().getProperty("stream");
        if (!(source instanceof DataObject)) {
            return null;
        }
        return ((DataObject)source).getPrimaryFile();
    }

    private static boolean isSupported(FileObject file) throws NullPointerException {
        if (file == null) {
            return false;
        }
        return !OpenedEditors.filterSupportedFiles(Collections.singletonList(file)).isEmpty();
    }

    static List<FileObject> filterSupportedFiles(Collection<FileObject> files) throws NullPointerException {
        Parameters.notNull((CharSequence)"files", files);
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        block0: for (FileObject f : files) {
            int plus;
            int slash;
            String fileMimeType = FileUtil.getMIMEType((FileObject)f);
            if (fileMimeType == null) continue;
            if (mimeTypesList.contains(fileMimeType)) {
                result.add(f);
                continue;
            }
            String shorterMimeType = fileMimeType;
            while ((slash = shorterMimeType.indexOf(47)) != -1 && (plus = shorterMimeType.indexOf(43, slash)) != -1) {
                if (!mimeTypesList.contains(shorterMimeType = shorterMimeType.substring(0, slash + 1) + shorterMimeType.substring(plus + 1))) continue;
                result.add(f);
                continue block0;
            }
        }
        return result;
    }

    private boolean isHandledEditor(JTextComponent editor) {
        if (editor == null) {
            return false;
        }
        if (editor.getClientProperty(CND_EDITOR_COMPONENT) != null) {
            return true;
        }
        return editor.getClass().getName().equals("org.openide.text.QuietEditorPane");
    }
}

