/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactoryManager;
import org.netbeans.modules.cnd.model.tasks.OpenedEditors;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public abstract class CsmFileTaskFactory {
    private static final boolean TRACE_TASKS = false;
    private final Map<FileObject, TaskData> fobj2task = new ConcurrentHashMap<FileObject, TaskData>();
    private final ProgressListener progressListener = new ProgressListener();
    private final ModelListener modelListener = new ModelListener();
    private final Object fileTaskFactoryLock = new FileTaskFactoryLock();
    private static final int IMMEDIATELY = 0;
    private static final RequestProcessor WORKER = new RequestProcessor("CsmFileTaskFactory", 1);
    private static final RequestProcessor HIGH_PRIORITY_WORKER = new RequestProcessor("CsmHighPriorityFileTaskFactory", 1);
    private static final RequestProcessor DECISION_WORKER = new RequestProcessor("CsmDecisionFileTaskFactory", 1);
    public static final String USE_OWN_CARET_POSITION = "use-own-caret-position";

    protected CsmFileTaskFactory() {
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this.progressListener);
        CsmListeners.getDefault().addModelListener((CsmModelListener)this.modelListener);
    }

    protected abstract PhaseRunner createTask(FileObject var1);

    protected abstract Collection<FileObject> getFileObjects();

    protected abstract int taskDelay();

    protected abstract int rescheduleDelay();

    protected final void fileObjectsChanged() {
        final HashSet<FileObject> currentFiles = new HashSet<FileObject>(this.getFileObjects());
        final long id = Math.round(100.0 * Math.random());
        final String name = this.getClass().getName();
        if (OpenedEditors.SHOW_TIME) {
            System.err.println("CsmFileTaskFactory: POST worker " + id);
        }
        DECISION_WORKER.post(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                if (OpenedEditors.SHOW_TIME) {
                    System.err.println("CsmFileTaskFactory: RUN worker " + id + " [" + name + "]");
                }
                CsmFileTaskFactory.this.stateChangedImpl(currentFiles);
                if (OpenedEditors.SHOW_TIME) {
                    System.err.println("CsmFileTaskFactory: DONE worker " + id + " after " + (System.currentTimeMillis() - start) + "ms.");
                }
            }
        });
    }

    public final void reschedule(final FileObject file) throws IllegalArgumentException {
        this.postDecision(new Runnable(){

            @Override
            public void run() {
                CsmFileTaskFactory.this.runTask(file, PhaseRunner.Phase.PARSED, CsmFileTaskFactory.this.rescheduleDelay());
            }
        });
    }

    private void postDecision(Runnable runnable) {
        DECISION_WORKER.post(runnable);
    }

    private boolean checkMimeType(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        String mimeType = fileObject.getMIMEType();
        return MIMENames.isHeaderOrCppOrC((String)mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChangedImpl(Collection<FileObject> currentFiles) {
        CsmFile csmFile;
        HashMap<FileObject, TaskData> toRemove = new HashMap<FileObject, TaskData>();
        HashMap<FileObject, TaskData> toAdd = new HashMap<FileObject, TaskData>();
        Object object = this.fileTaskFactoryLock;
        synchronized (object) {
            CsmFile csmFile2;
            ArrayList<FileObject> addedFiles = new ArrayList<FileObject>(currentFiles);
            ArrayList<FileObject> removedFiles = new ArrayList<FileObject>(this.fobj2task.keySet());
            addedFiles.removeAll(this.fobj2task.keySet());
            removedFiles.removeAll(currentFiles);
            for (FileObject r : removedFiles) {
                toRemove.put(r, this.fobj2task.remove(r));
            }
            ArrayList<FileObject> verifiedFiles = new ArrayList<FileObject>(this.fobj2task.keySet());
            for (FileObject v : verifiedFiles) {
                TaskData oldTaskData;
                if (v == null || !v.isValid() || !this.checkMimeType(v) || (csmFile2 = CsmFileTaskFactory.getCsmFile(v, true)) == null || (oldTaskData = this.fobj2task.get(v)) != null && csmFile2.equals(oldTaskData.file)) continue;
                if (oldTaskData != null) {
                    toRemove.put(v, this.fobj2task.remove(v));
                }
                PhaseRunner task = this.createTask(v);
                TaskData data = new TaskData(task, csmFile2);
                toAdd.put(v, data);
                this.fobj2task.put(v, data);
            }
            for (FileObject fileObject : addedFiles) {
                if (fileObject == null || !fileObject.isValid() || !this.checkMimeType(fileObject) || (csmFile2 = CsmFileTaskFactory.getCsmFile(fileObject, true)) == null) continue;
                PhaseRunner task = this.createTask(fileObject);
                TaskData data = new TaskData(task, csmFile2);
                toAdd.put(fileObject, data);
                this.fobj2task.put(fileObject, data);
            }
        }
        for (Map.Entry e : toRemove.entrySet()) {
            csmFile = CsmFileTaskFactory.getCsmFile((FileObject)e.getKey(), false);
            if (csmFile != null && OpenedEditors.SHOW_TIME) {
                System.err.println("CFTF: removing " + csmFile.getAbsolutePath());
            }
            if (e != null && e.getValue() != null) {
                PhaseRunner runner = ((TaskData)e.getValue()).runner;
                RequestProcessor.Task task = ((TaskData)e.getValue()).task;
                runner.cancel();
                if (task != null) {
                    task.cancel();
                }
                this.post((TaskData)e.getValue(), (FileObject)e.getKey(), PhaseRunner.Phase.CLEANUP, 0);
            }
            if (csmFile == null) continue;
            CsmStandaloneFileProvider.getDefault().notifyClosed(csmFile);
        }
        for (Map.Entry e : toAdd.entrySet()) {
            csmFile = CsmFileTaskFactory.getCsmFile((FileObject)e.getKey(), false);
            if (csmFile == null) continue;
            if (OpenedEditors.SHOW_TIME) {
                System.err.println("CFTF: adding " + (Object)((Object)(csmFile.isParsed() ? PhaseRunner.Phase.PARSED : PhaseRunner.Phase.INIT)) + " " + ((TaskData)e.getValue()).runner.toString() + " " + csmFile.getAbsolutePath());
            }
            this.post((TaskData)e.getValue(), (FileObject)e.getKey(), csmFile.isParsed() ? PhaseRunner.Phase.PARSED : PhaseRunner.Phase.INIT, this.taskDelay());
        }
    }

    private static CsmFile getCsmFile(FileObject fo, boolean allowStandalone) {
        CsmFile csmFile = null;
        if (fo != null) {
            Document doc = CsmUtilities.getDocument((FileObject)fo);
            if (doc != null) {
                csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
            }
            if (csmFile == null) {
                csmFile = CsmUtilities.getCsmFile((FileObject)fo, (boolean)false, (boolean)false);
            }
            if (allowStandalone && csmFile == null) {
                csmFile = CsmStandaloneFileProvider.getDefault().getCsmFile(fo);
            }
        }
        return csmFile;
    }

    private void runAllTasks(PhaseRunner.Phase phase, int delay) {
        for (FileObject fo : this.fobj2task.keySet()) {
            this.runTask(fo, phase, delay);
        }
    }

    private void runTask(CsmFile eventCsm, PhaseRunner.Phase phase, int delay) {
        if (this.fobj2task.isEmpty()) {
            return;
        }
        FileObject fobj = null;
        TaskData pr = null;
        for (Map.Entry<FileObject, TaskData> entry : this.fobj2task.entrySet()) {
            if (!eventCsm.equals(entry.getValue().file)) continue;
            fobj = entry.getKey();
            pr = entry.getValue();
            break;
        }
        if (pr == null) {
            return;
        }
        this._runTask(pr, fobj, phase, delay);
    }

    private void runTask(FileObject eventFobj, PhaseRunner.Phase phase, int delay) {
        TaskData pr = this.fobj2task.get(eventFobj);
        if (pr == null) {
            return;
        }
        this._runTask(pr, eventFobj, phase, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _runTask(TaskData pr, FileObject fobj, PhaseRunner.Phase phase, int delay) {
        FileObject fobj2;
        Document doc2;
        Document doc;
        pr.runner.cancel();
        if (pr.task != null) {
            pr.task.cancel();
        }
        if (!pr.runner.isValid()) {
            PhaseRunner runner = this.createTask(fobj);
            assert (runner.isValid());
            pr = new TaskData(runner, CsmFileTaskFactory.getCsmFile(fobj, false));
            Object object = this.fileTaskFactoryLock;
            synchronized (object) {
                this.fobj2task.put(fobj, pr);
            }
        }
        if ((doc = CsmUtilities.getDocument((FileObject)fobj)) != null && (doc2 = (Document)doc.getProperty(Document.class)) != null && (fobj2 = CsmUtilities.getFileObject((Document)doc2)) != null) {
            PhaseRunner task = this.createTask(fobj2);
            TaskData data = new TaskData(task, CsmFileTaskFactory.getCsmFile(fobj2, false));
            doc2.putProperty(USE_OWN_CARET_POSITION, false);
            doc.putProperty(USE_OWN_CARET_POSITION, true);
            if (data != null) {
                this.post(data, fobj2, phase, delay);
            }
        }
        this.post(pr, fobj, phase, delay);
    }

    private void post(TaskData pr, FileObject fo, PhaseRunner.Phase phase, int delay) {
        if (pr.runner.isHighPriority()) {
            pr.task = CsmFileTaskFactory.HIGH_PRIORITY_WORKER.post((Runnable)new CsmSafeRunnable(CsmFileTaskFactory.getRunnable(pr.runner, phase), fo), delay, 5);
        } else {
            pr.task = CsmFileTaskFactory.WORKER.post((Runnable)new CsmSafeRunnable(CsmFileTaskFactory.getRunnable(pr.runner, phase), fo), delay);
        }
    }

    protected static PhaseRunner lazyRunner() {
        return new PhaseRunner(){

            @Override
            public void run(PhaseRunner.Phase phase) {
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public void cancel() {
            }

            @Override
            public boolean isHighPriority() {
                return false;
            }

            public String toString() {
                return "Lazy runner";
            }
        };
    }

    private static Runnable getRunnable(final PhaseRunner pr, final PhaseRunner.Phase phase) {
        return new Runnable(){

            @Override
            public void run() {
                pr.run(phase);
            }
        };
    }

    static {
        CsmFileTaskFactoryManager.ACCESSOR = new CsmFileTaskFactoryManager.Accessor(){

            @Override
            public void fireChangeEvent(CsmFileTaskFactory f) {
                f.fileObjectsChanged();
            }
        };
    }

    private static final class CsmSafeRunnable
    implements Runnable {
        private FileObject fileObject;
        private Runnable run;

        public CsmSafeRunnable(Runnable run, FileObject fileObject) {
            this.run = run;
            this.fileObject = fileObject;
        }

        @Override
        public void run() {
            CsmFile file = CsmFileTaskFactory.getCsmFile(this.fileObject, false);
            if (file != null && file.isValid()) {
                this.run.run();
            }
        }
    }

    private static final class TaskData {
        private final PhaseRunner runner;
        private final CsmFile file;
        private RequestProcessor.Task task;

        private TaskData(PhaseRunner runner, CsmFile file) {
            this.runner = runner;
            this.file = file;
        }
    }

    public static interface PhaseRunner {
        public void run(Phase var1);

        public boolean isValid();

        public void cancel();

        public boolean isHighPriority();

        public static enum Phase {
            INIT,
            PARSING_STARTED,
            PARSED,
            PROJECT_PARSED,
            CLEANUP;

        }
    }

    private class ModelListener
    implements CsmModelListener {
        private ModelListener() {
        }

        public void projectOpened(CsmProject project) {
        }

        public void projectClosed(CsmProject project) {
        }

        public void modelChanged(final CsmChangeEvent e) {
            if (!e.getRemovedFiles().isEmpty()) {
                CsmFileTaskFactory.this.postDecision(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        for (CsmFile f : e.getRemovedFiles()) {
                            Document doc;
                            FileObject fobj = CsmUtilities.getFileObject((CsmFile)f);
                            if (fobj == null || CsmFileTaskFactory.this.fobj2task.get(fobj) == null || (doc = CsmUtilities.getDocument((FileObject)fobj)) == null) continue;
                            Object object = CsmFileTaskFactory.this.fileTaskFactoryLock;
                            synchronized (object) {
                                CsmFileTaskFactory.this.runTask(fobj, PhaseRunner.Phase.CLEANUP, 0);
                                CsmFileTaskFactory.this.fobj2task.put(fobj, new TaskData(CsmFileTaskFactory.lazyRunner(), CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false)));
                            }
                        }
                    }
                });
            }
            if (!e.getNewFiles().isEmpty()) {
                CsmFileTaskFactory.this.fileObjectsChanged();
            }
        }
    }

    private class ProgressListener
    extends CsmProgressAdapter {
        private ProgressListener() {
        }

        public void fileParsingFinished(final CsmFile file) {
            CsmFileTaskFactory.this.postDecision(new Runnable(){

                @Override
                public void run() {
                    CsmFileTaskFactory.this.runTask(file, PhaseRunner.Phase.PARSED, 0);
                }
            });
        }

        public void fileParsingStarted(final CsmFile file) {
            CsmFileTaskFactory.this.postDecision(new Runnable(){

                @Override
                public void run() {
                    CsmFileTaskFactory.this.runTask(file, PhaseRunner.Phase.PARSING_STARTED, 0);
                }
            });
        }

        public void projectParsingFinished(CsmProject project) {
            CsmFileTaskFactory.this.postDecision(new Runnable(){

                @Override
                public void run() {
                    CsmFileTaskFactory.this.runAllTasks(PhaseRunner.Phase.PROJECT_PARSED, 0);
                }
            });
        }
    }

    private static final class FileTaskFactoryLock {
        private FileTaskFactoryLock() {
        }
    }
}

