/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmFriendResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.AntiLoop;

public final class CsmInheritanceUtilities {
    private static final int PRIVATE = 1;
    private static final int PROTECTED = 2;
    private static final int PUBLIC = 4;
    private static final int NONE = 8;
    public static final CsmVisibility MAX_VISIBILITY = CsmVisibility.PRIVATE;

    private CsmInheritanceUtilities() {
    }

    private static int visToInt(CsmVisibility vis) {
        if (vis == CsmVisibility.NONE) {
            return 8;
        }
        if (vis == CsmVisibility.PRIVATE) {
            return 1;
        }
        if (vis == CsmVisibility.PROTECTED) {
            return 2;
        }
        assert (vis == CsmVisibility.PUBLIC);
        return 4;
    }

    private static CsmVisibility intToVis(int visInt) {
        switch (visInt) {
            case 8: {
                return CsmVisibility.NONE;
            }
            case 1: {
                return CsmVisibility.PRIVATE;
            }
            case 2: {
                return CsmVisibility.PROTECTED;
            }
        }
        assert (visInt == 4);
        return CsmVisibility.PUBLIC;
    }

    public static boolean matchVisibility(CsmMember member, CsmVisibility minVisibility) {
        assert (member.getVisibility() != null) : "can't be null visibility";
        return CsmInheritanceUtilities.matchVisibility(member.getVisibility(), minVisibility);
    }

    private static boolean matchVisibility(CsmVisibility toCheck, CsmVisibility minVisibility) {
        assert (toCheck != null && minVisibility != null);
        if (minVisibility == CsmVisibility.NONE) {
            return false;
        }
        int memberVis = CsmInheritanceUtilities.visToInt(toCheck);
        int minVis = CsmInheritanceUtilities.visToInt(minVisibility);
        return minVis <= memberVis;
    }

    private static CsmVisibility getInheritanceVisibility(CsmVisibility inheritBA) {
        return CsmVisibility.PROTECTED;
    }

    private static CsmVisibility getExtInheritanceVisibility(CsmVisibility inheritBA) {
        if (inheritBA == CsmVisibility.PUBLIC) {
            return CsmVisibility.PUBLIC;
        }
        return CsmVisibility.NONE;
    }

    private static CsmVisibility getChildInheritanceVisibility(CsmVisibility inheritBA) {
        if (inheritBA == CsmVisibility.PUBLIC || inheritBA == CsmVisibility.PROTECTED) {
            return CsmVisibility.PROTECTED;
        }
        return CsmVisibility.NONE;
    }

    public static CsmVisibility mergeInheritedVisibility(CsmVisibility curVisibility, CsmVisibility inherVisibility) {
        return CsmInheritanceUtilities.getMinVisibility(curVisibility, CsmInheritanceUtilities.getInheritanceVisibility(inherVisibility));
    }

    public static CsmVisibility mergeExtInheritedVisibility(CsmVisibility curVisibility, CsmVisibility inherVisibility) {
        return CsmInheritanceUtilities.getMinVisibility(curVisibility, CsmInheritanceUtilities.getExtInheritanceVisibility(inherVisibility));
    }

    public static CsmVisibility mergeChildInheritanceVisibility(CsmVisibility curVisibility, CsmVisibility inheritBA) {
        return CsmInheritanceUtilities.getMinVisibility(curVisibility, CsmInheritanceUtilities.getChildInheritanceVisibility(inheritBA));
    }

    private static CsmVisibility getMinVisibility(CsmVisibility vis1, CsmVisibility vis2) {
        assert (vis1 != null && vis2 != null);
        int visInt1 = CsmInheritanceUtilities.visToInt(vis1);
        int visInt2 = CsmInheritanceUtilities.visToInt(vis2);
        int newMinVis = Math.max(visInt1, visInt2);
        return CsmInheritanceUtilities.intToVis(newMinVis);
    }

    private static CsmVisibility getMaxVisibility(CsmVisibility vis1, CsmVisibility vis2) {
        assert (vis1 != null && vis2 != null);
        int visInt1 = CsmInheritanceUtilities.visToInt(vis1);
        int visInt2 = CsmInheritanceUtilities.visToInt(vis2);
        int newMaxVis = Math.min(visInt1, visInt2);
        return CsmInheritanceUtilities.intToVis(newMaxVis);
    }

    public static CsmVisibility getContextVisibility(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration) {
        return CsmInheritanceUtilities.getContextVisibility(clazz, contextDeclaration, CsmVisibility.PUBLIC, false);
    }

    public static CsmVisibility getContextVisibility(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, CsmVisibility defVisibilityValue, boolean checkInheritance) {
        return CsmInheritanceUtilities.getContextVisibilityInfo((CsmClass)clazz, (CsmOffsetableDeclaration)contextDeclaration, (CsmVisibility)defVisibilityValue, (boolean)checkInheritance).visibility;
    }

    public static ContextVisibilityInfo getContextVisibilityInfo(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, CsmVisibility defVisibilityValue, boolean checkInheritance) {
        assert (clazz != null);
        CsmClass contextClass = CsmBaseUtilities.getContextClass((CsmOffsetableDeclaration)contextDeclaration);
        if (CsmInheritanceUtilities.areEqualClasses(clazz, contextClass)) {
            return new ContextVisibilityInfo(MAX_VISIBILITY, false);
        }
        if (CsmFriendResolver.getDefault().isFriend(contextDeclaration, clazz)) {
            return new ContextVisibilityInfo(MAX_VISIBILITY, true);
        }
        if (CsmInheritanceUtilities.isNestedClass(contextClass, clazz)) {
            return new ContextVisibilityInfo(MAX_VISIBILITY, false);
        }
        if (contextClass == null || !checkInheritance) {
            return new ContextVisibilityInfo(defVisibilityValue, false);
        }
        List<CsmInheritance> chain = CsmInheritanceUtilities.findInheritanceChain(contextClass, clazz);
        if (chain != null) {
            assert (chain.size() > 0);
            CsmVisibility mergedVisibility = CsmVisibility.PROTECTED;
            for (int i = 0; i < chain.size(); ++i) {
                CsmInheritance inherit = chain.get(i);
                mergedVisibility = i == 0 ? CsmInheritanceUtilities.mergeInheritedVisibility(mergedVisibility, inherit.getVisibility()) : CsmInheritanceUtilities.mergeChildInheritanceVisibility(mergedVisibility, inherit.getVisibility());
            }
            return new ContextVisibilityInfo(mergedVisibility, false);
        }
        return new ContextVisibilityInfo(defVisibilityValue, false);
    }

    private static List<CsmInheritance> findInheritanceChain(CsmClass child, CsmClass parent) {
        ArrayList<CsmInheritance> res = new ArrayList<CsmInheritance>();
        AntiLoop handledClasses = new AntiLoop();
        if (CsmInheritanceUtilities.findInheritanceChain(child, parent, res, handledClasses)) {
            return res;
        }
        return null;
    }

    public static boolean isAssignableFrom(CsmClass child, CsmClass parent) {
        CsmInstantiation parentInstantiation;
        CsmOffsetableDeclaration parentTemplateDeclaration;
        Collection<CsmOffsetableDeclaration> baseTemplates;
        assert (parent != null);
        if (CsmInheritanceUtilities.areEqualClasses(parent, child)) {
            return true;
        }
        if (CsmKindUtilities.isTemplate((CsmObject)child) && CsmKindUtilities.isTemplateInstantiation((CsmObject)parent) && (baseTemplates = CsmInstantiationProvider.getDefault().getBaseTemplate((CsmDeclaration)child)).contains(parentTemplateDeclaration = (parentInstantiation = (CsmInstantiation)parent).getTemplateDeclaration())) {
            return true;
        }
        List<CsmInheritance> chain = CsmInheritanceUtilities.findInheritanceChain(child, parent);
        return chain != null;
    }

    private static boolean findInheritanceChain(CsmClass child, CsmClass parent, List<CsmInheritance> res, AntiLoop handledClasses) {
        if (child == null || !handledClasses.add((CsmClassifier)child)) {
            return false;
        }
        Collection base = child.getBaseClasses();
        if (base == null || base.size() == 0) {
            return false;
        }
        CsmInheritance inh = CsmInheritanceUtilities.findDirectInheritance(child, parent);
        if (inh != null) {
            res.add(inh);
            return true;
        }
        ArrayList<CsmInheritance> bestChain = null;
        CsmInheritance bestInh = null;
        for (CsmInheritance curInh : base) {
            ArrayList<CsmInheritance> curInhRes = new ArrayList<CsmInheritance>();
            if (!CsmInheritanceUtilities.findInheritanceChain(CsmInheritanceUtilities.getCsmClass(curInh), parent, curInhRes, handledClasses)) continue;
            bestChain = curInhRes;
            bestInh = curInh;
            break;
        }
        if (bestChain != null) {
            assert (bestChain.size() > 0);
            res.add(bestInh);
            res.addAll((Collection<CsmInheritance>)bestChain);
            return true;
        }
        return false;
    }

    public static CsmClass getCsmClass(CsmInheritance inh) {
        CsmClassifier classifier = inh.getClassifier();
        if (CsmKindUtilities.isClass((CsmObject)(classifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)classifier, (CsmFile)inh.getContainingFile())))) {
            return (CsmClass)classifier;
        }
        return null;
    }

    private static CsmInheritance findDirectInheritance(CsmClass child, CsmClass parent) {
        assert (parent != null);
        Collection base = child.getBaseClasses();
        if (base != null && base.size() > 0) {
            for (CsmInheritance curInh : base) {
                if (!CsmInheritanceUtilities.areEqualClasses(parent, CsmInheritanceUtilities.getCsmClass(curInh))) continue;
                return curInh;
            }
        }
        return null;
    }

    private static boolean areEqualClasses(CsmClass clazz, CsmClass contextClass) {
        assert (clazz != null);
        if (clazz.equals(contextClass)) {
            return true;
        }
        if (contextClass != null && (CsmKindUtilities.isTemplate((CsmObject)clazz) || CsmKindUtilities.isTemplateInstantiation((CsmObject)clazz))) {
            return clazz.getUniqueName().equals(contextClass.getUniqueName());
        }
        return false;
    }

    private static boolean isNestedClass(CsmClass inner, CsmClass outer) {
        return inner != null && outer != null && CharSequenceUtilities.startsWith((CharSequence)inner.getQualifiedName(), (CharSequence)outer.getQualifiedName());
    }

    public static final class ContextVisibilityInfo {
        public final CsmVisibility visibility;
        public final boolean friend;

        public ContextVisibilityInfo(CsmVisibility visibility, boolean friend) {
            this.visibility = visibility;
            this.friend = friend;
        }
    }
}

