/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.apache.maven.model.DependencyManagement;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class OverrideDependencyManagementError
implements POMErrorFixProvider {
    private Configuration configuration = new Configuration("OverrideDependencyManagementError", NbBundle.getMessage(OverrideDependencyManagementError.class, (String)"TIT_OverrideDependencyManagementError"), NbBundle.getMessage(OverrideDependencyManagementError.class, (String)"DESC_OverrideDependencyManagementError"), true, Configuration.HintSeverity.WARNING);

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj) {
        assert (model != null);
        ArrayList<ErrorDescription> toRet = new ArrayList<ErrorDescription>();
        if (prj == null) {
            return toRet;
        }
        Map<String, String> managed = this.collectManaged(prj);
        if (managed.isEmpty()) {
            return toRet;
        }
        this.checkDependencyList(model.getProject().getDependencies(), model, toRet, managed);
        List profiles = model.getProject().getProfiles();
        if (profiles != null) {
            for (Profile prof : profiles) {
                this.checkDependencyList(prof.getDependencies(), model, toRet, managed);
            }
        }
        return toRet;
    }

    private void checkDependencyList(List<Dependency> deps, POMModel model, List<ErrorDescription> toRet, Map<String, String> managed) {
        if (deps != null) {
            for (Dependency dep : deps) {
                String ver = dep.getVersion();
                if (ver == null) continue;
                String art = dep.getArtifactId();
                String gr = dep.getGroupId();
                String key = gr + ":" + art;
                if (!managed.keySet().contains(key)) continue;
                int position = dep.findChildElementPosition(model.getPOMQNames().VERSION.getQName());
                Line line = NbEditorUtilities.getLine((Document)model.getBaseDocument(), (int)position, (boolean)false);
                String managedver = managed.get(key);
                toRet.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.configuration.getSeverity(this.configuration.getPreferences()).toEditorSeverity(), (String)NbBundle.getMessage(OverrideDependencyManagementError.class, (String)"TXT_OverrideDependencyManagementError", (Object)managedver), Collections.singletonList(new OverrideFix(dep)), (Document)model.getBaseDocument(), (int)(line.getLineNumber() + 1)));
            }
        }
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private Map<String, String> collectManaged(Project prj) {
        NbMavenProject project = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        HashMap<String, String> toRet = new HashMap<String, String>();
        if (project == null) {
            return toRet;
        }
        DependencyManagement dm = project.getMavenProject().getDependencyManagement();
        if (dm != null) {
            List plugins = dm.getDependencies();
            for (org.apache.maven.model.Dependency dep : plugins) {
                toRet.put(dep.getGroupId() + ":" + dep.getArtifactId(), dep.getVersion());
            }
        }
        return toRet;
    }

    private static class OverrideFix
    implements Fix,
    Runnable {
        private Dependency dependency;

        OverrideFix(Dependency dep) {
            this.dependency = dep;
        }

        public String getText() {
            return NbBundle.getMessage(OverrideDependencyManagementError.class, (String)"TEXT_OverrideDependencyFix");
        }

        @Override
        public void run() {
            this.dependency.setVersion(null);
        }

        public ChangeInfo implement() throws Exception {
            ChangeInfo info = new ChangeInfo();
            POMModel mdl = this.dependency.getModel();
            if (!mdl.getState().equals((Object)Model.State.VALID)) {
                return info;
            }
            PomModelUtils.implementInTransaction((Model)mdl, this);
            return info;
        }
    }
}

