/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPlugin;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class BuildConfig {
    public static final String BUILD_CONFIG_PLUGINS = BuildConfig.class.getName() + ".plugins";
    private static final Logger LOGGER = Logger.getLogger(BuildConfig.class.getName());
    private final GrailsProject project;
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private Object buildSettingsInstance;
    private File projectRoot;
    private List<GrailsPlugin> localPlugins;
    private File projectPluginsDir;
    private File globalPluginsDir;

    public BuildConfig(GrailsProject project) {
        this.project = project;
        this.projectRoot = FileUtil.toFile((FileObject)project.getProjectDirectory());
        this.loadLocalPluginsDefault();
        this.loadProjectPluginsDirDefault();
        this.loadGlobalPluginsDirDefault();
    }

    private boolean isFilePresent() {
        FileObject root = this.project.getProjectDirectory();
        return root.getFileObject("grails-app/conf/BuildConfig.groovy") != null;
    }

    private synchronized void loadProjectPluginsDirDefault() {
        GrailsProjectConfig config;
        File cached;
        this.projectPluginsDir = GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0 ? ((cached = (config = GrailsProjectConfig.forProject((Project)this.project)).getProjectPluginsDir()) != null && this.isFilePresent() ? FileUtil.normalizeFile((File)cached) : this.getProjectPluginsDirDefault11()) : this.getProjectPluginsDir10();
    }

    private File getProjectPluginsDirDefault11() {
        File pluginsDirFile;
        GrailsPlatform platform = GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform();
        String strPluginsDir = System.getProperty("grails.project.plugins.dir");
        if (strPluginsDir == null) {
            File projectWorkDirFile;
            String projectWorkDir = System.getProperty("grails.project.work.dir");
            if (projectWorkDir == null) {
                File workDirFile;
                String workDir = System.getProperty("grails.work.dir");
                if (workDir == null) {
                    workDir = System.getProperty("user.home");
                    workDir = workDir + File.separator + ".grails" + File.separator + platform.getVersion();
                    workDirFile = new File(workDir);
                } else {
                    workDirFile = new File(workDir);
                    if (!workDirFile.isAbsolute()) {
                        workDirFile = new File(this.projectRoot, workDir);
                    }
                }
                projectWorkDirFile = new File(workDirFile, "projects" + File.separator + this.projectRoot.getName());
            } else {
                projectWorkDirFile = new File(projectWorkDir);
                if (!projectWorkDirFile.isAbsolute()) {
                    projectWorkDirFile = new File(this.projectRoot, projectWorkDir);
                }
            }
            pluginsDirFile = new File(projectWorkDirFile, "plugins");
        } else {
            pluginsDirFile = new File(strPluginsDir);
            if (!pluginsDirFile.isAbsolute()) {
                pluginsDirFile = new File(this.projectRoot, strPluginsDir);
            }
        }
        return FileUtil.normalizeFile((File)pluginsDirFile);
    }

    private synchronized void loadGlobalPluginsDirDefault() {
        GrailsProjectConfig config;
        File cached;
        this.globalPluginsDir = GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0 ? ((cached = (config = GrailsProjectConfig.forProject((Project)this.project)).getGlobalPluginsDir()) != null && this.isFilePresent() ? FileUtil.normalizeFile((File)cached) : this.getGlobalPluginsDirDefault11()) : this.getGlobalPluginsDir10();
    }

    private File getGlobalPluginsDirDefault11() {
        File pluginsDirFile;
        GrailsPlatform platform = GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform();
        String strPluginsDir = System.getProperty("grails.global.plugins.dir");
        if (strPluginsDir == null) {
            File workDirFile;
            String workDir = System.getProperty("grails.work.dir");
            if (workDir == null) {
                workDir = System.getProperty("user.home");
                workDir = workDir + File.separator + ".grails" + File.separator + platform.getVersion();
                workDirFile = new File(workDir);
            } else {
                workDirFile = new File(workDir);
                if (!workDirFile.isAbsolute()) {
                    workDirFile = new File(this.projectRoot, workDir);
                }
            }
            pluginsDirFile = new File(workDirFile, "global-plugins");
        } else {
            pluginsDirFile = new File(strPluginsDir);
            if (!pluginsDirFile.isAbsolute()) {
                pluginsDirFile = new File(this.projectRoot, strPluginsDir);
            }
        }
        return pluginsDirFile;
    }

    private synchronized void loadLocalPluginsDefault() {
        if (GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0) {
            GrailsProjectConfig config = GrailsProjectConfig.forProject((Project)this.project);
            Map cached = config.getLocalPlugins();
            if (cached != null && this.isFilePresent()) {
                this.localPlugins = new ArrayList<GrailsPlugin>();
                for (Map.Entry entry : cached.entrySet()) {
                    this.localPlugins.add(new GrailsPlugin((String)entry.getKey(), null, null, (File)entry.getValue()));
                }
            } else {
                this.localPlugins = Collections.emptyList();
            }
        } else {
            this.localPlugins = Collections.emptyList();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        GrailsProjectConfig config;
        File currentGlobalPluginsDir;
        File currentProjectPluginsDir;
        List<GrailsPlugin> currentLocalPlugins;
        long start = System.currentTimeMillis();
        BuildConfig buildConfig = this;
        synchronized (buildConfig) {
            File newProjectRoot = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            assert (newProjectRoot != null);
            if (!newProjectRoot.equals(this.projectRoot)) {
                this.projectRoot = newProjectRoot;
            }
            this.buildSettingsInstance = this.loadBuildSettings();
            LOGGER.log(Level.FINE, "Took {0} ms to load BuildSettings for {1}", new Object[]{System.currentTimeMillis() - start, this.project.getProjectDirectory().getNameExt()});
            currentLocalPlugins = this.loadLocalPlugins();
            currentProjectPluginsDir = this.loadProjectPluginsDir();
            currentGlobalPluginsDir = this.loadGlobalPluginsDir();
        }
        if (GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0 && (config = (GrailsProjectConfig)this.project.getLookup().lookup(GrailsProjectConfig.class)) != null) {
            ProjectConfigListener listener = new ProjectConfigListener();
            config.addPropertyChangeListener((PropertyChangeListener)listener);
            try {
                config.setProjectPluginsDir(FileUtil.normalizeFile((File)currentProjectPluginsDir));
                config.setGlobalPluginsDir(FileUtil.normalizeFile((File)currentGlobalPluginsDir));
                HashMap<String, File> prepared = new HashMap<String, File>();
                for (GrailsPlugin plugin : currentLocalPlugins) {
                    prepared.put(plugin.getName(), plugin.getPath());
                }
                config.setLocalPlugins(prepared);
            }
            finally {
                config.removePropertyChangeListener((PropertyChangeListener)listener);
            }
            if (listener.isChanged()) {
                this.propertySupport.firePropertyChange(BUILD_CONFIG_PLUGINS, null, null);
            }
        }
    }

    public synchronized File getProjectPluginsDir() {
        return this.projectPluginsDir;
    }

    private synchronized File loadProjectPluginsDir() {
        this.projectPluginsDir = GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0 ? this.getProjectPluginsDir11() : this.getProjectPluginsDir10();
        return this.projectPluginsDir;
    }

    public synchronized List<File> getCompileDependencies() {
        try {
            if (this.buildSettingsInstance != null) {
                Method getCompileDependenciesMethod = this.buildSettingsInstance.getClass().getMethod("getCompileDependencies", new Class[0]);
                return (List)getCompileDependenciesMethod.invoke(this.buildSettingsInstance, new Object[0]);
            }
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        return Collections.emptyList();
    }

    private File getProjectPluginsDir10() {
        assert (Thread.holdsLock(this));
        return FileUtil.normalizeFile((File)new File(this.projectRoot, "plugins"));
    }

    private File getProjectPluginsDir11() {
        assert (Thread.holdsLock(this));
        try {
            Method getProjectPluginsDirMethod;
            Object value;
            if (this.buildSettingsInstance != null && (value = (getProjectPluginsDirMethod = this.buildSettingsInstance.getClass().getMethod("getProjectPluginsDir", new Class[0])).invoke(this.buildSettingsInstance, new Object[0])) instanceof File) {
                File file = (File)value;
                if (!file.isAbsolute()) {
                    file = new File(this.projectRoot, file.getPath());
                }
                return FileUtil.normalizeFile((File)file);
            }
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        GrailsProjectConfig config = GrailsProjectConfig.forProject((Project)this.project);
        GrailsPlatform platform = config.getGrailsPlatform();
        if (platform.isConfigured()) {
            return FileUtil.normalizeFile((File)new File(System.getProperty("user.home"), ".grails" + File.separator + config.getGrailsPlatform().getVersion().toString() + File.separator + "projects" + File.separator + this.projectRoot.getName() + File.separator + "plugins"));
        }
        return null;
    }

    public synchronized File getGlobalPluginsDir() {
        return this.globalPluginsDir;
    }

    private synchronized File loadGlobalPluginsDir() {
        this.globalPluginsDir = GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0 ? this.getGlobalPluginsDir11() : this.getGlobalPluginsDir10();
        return this.globalPluginsDir;
    }

    private File getGlobalPluginsDir10() {
        assert (Thread.holdsLock(this));
        return null;
    }

    private File getGlobalPluginsDir11() {
        assert (Thread.holdsLock(this));
        try {
            Method getGlobalPluginsDirMethod;
            Object value;
            if (this.buildSettingsInstance != null && (value = (getGlobalPluginsDirMethod = this.buildSettingsInstance.getClass().getMethod("getGlobalPluginsDir", new Class[0])).invoke(this.buildSettingsInstance, new Object[0])) instanceof File) {
                File file = (File)value;
                if (!file.isAbsolute()) {
                    file = new File(this.projectRoot, file.getPath());
                }
                return FileUtil.normalizeFile((File)file);
            }
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        GrailsProjectConfig config = GrailsProjectConfig.forProject((Project)this.project);
        GrailsPlatform platform = config.getGrailsPlatform();
        if (platform.isConfigured()) {
            return FileUtil.normalizeFile((File)new File(System.getProperty("user.home"), ".grails" + File.separator + config.getGrailsPlatform().getVersion().toString() + File.separator + "global-plugins"));
        }
        return null;
    }

    public synchronized List<GrailsPlugin> getLocalPlugins() {
        return Collections.unmodifiableList(this.localPlugins);
    }

    private synchronized List<GrailsPlugin> loadLocalPlugins() {
        this.localPlugins = GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0 ? this.getLocalPlugins11() : this.getLocalPlugins10();
        return this.localPlugins;
    }

    private List<GrailsPlugin> getLocalPlugins10() {
        assert (Thread.holdsLock(this));
        return Collections.emptyList();
    }

    private List<GrailsPlugin> getLocalPlugins11() {
        assert (Thread.holdsLock(this));
        try {
            Method getConfigMethod;
            Object configValue;
            Method toPropertiesMethod;
            Object converted;
            if (this.buildSettingsInstance != null && (converted = (toPropertiesMethod = (configValue = (getConfigMethod = this.buildSettingsInstance.getClass().getMethod("getConfig", new Class[0])).invoke(this.buildSettingsInstance, new Object[0])).getClass().getMethod("toProperties", new Class[0])).invoke(configValue, new Object[0])) instanceof Properties) {
                Properties properties = (Properties)converted;
                ArrayList<GrailsPlugin> plugins = new ArrayList<GrailsPlugin>();
                Enumeration<?> e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!key.startsWith("grails.plugin.location.")) continue;
                    String value = properties.getProperty(key);
                    key = key.substring("grails.plugin.location.".length());
                    File file = new File(value);
                    if (!file.isAbsolute()) {
                        file = new File(this.projectRoot, value);
                    }
                    plugins.add(new GrailsPlugin(key, null, null, file));
                }
                return plugins;
            }
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        return Collections.emptyList();
    }

    private Object loadBuildSettings() {
        assert (Thread.holdsLock(this));
        GrailsPlatform platform = GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform();
        if (!platform.isConfigured()) {
            return null;
        }
        ClassLoader loader = platform.getClassPath().getClassLoader(true);
        URLClassLoader urlLoader = loader instanceof URLClassLoader ? (URLClassLoader)loader : new URLClassLoader(new URL[0], loader);
        try {
            Class<?> clazz = urlLoader.loadClass("grails.util.BuildSettings");
            Constructor<?> contructor = clazz.getConstructor(File.class, File.class);
            Object instance = contructor.newInstance(platform.getGrailsHome(), this.projectRoot);
            Method setRootLoaderMethod = clazz.getMethod("setRootLoader", URLClassLoader.class);
            setRootLoaderMethod.invoke(instance, urlLoader);
            Method loadConfigMethod = clazz.getMethod("loadConfig", new Class[0]);
            loadConfigMethod.invoke(instance, new Object[0]);
            return instance;
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (InstantiationException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        return null;
    }

    private static class ProjectConfigListener
    implements PropertyChangeListener {
        private boolean changed = false;

        private ProjectConfigListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("grails.project.plugins.dir".equals(evt.getPropertyName()) || "grails.global.plugins.dir".equals(evt.getPropertyName()) || "grails.local.plugins".equals(evt.getPropertyName())) {
                ProjectConfigListener projectConfigListener = this;
                synchronized (projectConfigListener) {
                    this.changed = true;
                }
            }
        }

        public synchronized boolean isChanged() {
            return this.changed;
        }
    }
}

