/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.commands;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.extexecution.input.LineProcessors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.GrailsServerState;
import org.netbeans.modules.groovy.grailsproject.actions.RefreshProjectRunnable;
import org.netbeans.modules.groovy.grailsproject.commands.GrailsCommand;
import org.netbeans.modules.groovy.grailsproject.config.BuildConfig;
import org.netbeans.modules.groovy.grailsproject.debug.GrailsDebugger;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;
import org.openide.windows.InputOutput;

public final class GrailsCommandSupport {
    private static final ExecutionDescriptor GRAILS_DESCRIPTOR = new ExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).showProgress(true).optionsPath("Advanced/org-netbeans-modules-groovy-support-api-GroovySettings");
    private static final ExecutionDescriptor RUN_DESCRIPTOR = GRAILS_DESCRIPTOR.showSuspended(true);
    private static final ExecutionDescriptor.InputProcessorFactory ANSI_STRIPPING = new AnsiStrippingInputProcessorFactory();
    private static final Logger LOGGER = Logger.getLogger(GrailsCommandSupport.class.getName());
    private static final String WEB_APP_DIR = "web-app";
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private final GrailsProject project;
    private List<GrailsCommand> commands;
    private BuildConfigListener buildConfigListener;
    private ProjectConfigListener projectConfigListener;

    public GrailsCommandSupport(GrailsProject project) {
        this.project = project;
    }

    public synchronized List<GrailsCommand> getGrailsCommands() {
        return this.commands;
    }

    public ExecutionDescriptor getRunDescriptor(boolean debug) {
        return this.getDescriptor("run-app", debug);
    }

    public ExecutionDescriptor getDescriptor(String command) {
        return this.getDescriptor(command, false);
    }

    public ExecutionDescriptor getDescriptor(String command, boolean debug) {
        return this.getDescriptor(command, null, debug);
    }

    public ExecutionDescriptor getDescriptor(String command, ExecutionDescriptor.InputProcessorFactory outFactory) {
        return this.getDescriptor(command, outFactory, false);
    }

    public ExecutionDescriptor getDescriptor(String command, ExecutionDescriptor.InputProcessorFactory outFactory, final boolean debug) {
        if ("run-app".equals(command)) {
            ExecutionDescriptor descriptor = RUN_DESCRIPTOR;
            ExecutionDescriptor.InputProcessorFactory urlFactory = new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                    ServerOutputProcessor lineProcessor = null;
                    lineProcessor = debug ? LineProcessors.proxy((LineProcessor[])new LineProcessor[]{new ServerOutputProcessor(GrailsCommandSupport.this.project, debug), new DebugOutputProcessor(GrailsCommandSupport.this.project)}) : new ServerOutputProcessor(GrailsCommandSupport.this.project, debug);
                    return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{defaultProcessor, InputProcessors.bridge((LineProcessor)lineProcessor)});
                }
            };
            descriptor = descriptor.outProcessorFactory(this.createInputProcessorFactory(urlFactory, outFactory));
            return descriptor;
        }
        ExecutionDescriptor.InputProcessorFactory debugFactory = null;
        if (debug) {
            debugFactory = new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                    return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{defaultProcessor, InputProcessors.bridge((LineProcessor)new DebugOutputProcessor(GrailsCommandSupport.this.project))});
                }
            };
        }
        if ("shell".equals(command)) {
            ExecutionDescriptor descriptor = RUN_DESCRIPTOR.postExecution((Runnable)new RefreshProjectRunnable(this.project)).errProcessorFactory(ANSI_STRIPPING);
            descriptor = descriptor.outProcessorFactory(this.createInputProcessorFactory(ANSI_STRIPPING, outFactory, debugFactory));
            return descriptor;
        }
        ExecutionDescriptor descriptor = GRAILS_DESCRIPTOR.postExecution((Runnable)new RefreshProjectRunnable(this.project)).errProcessorFactory(ANSI_STRIPPING);
        descriptor = descriptor.outProcessorFactory(this.createInputProcessorFactory(ANSI_STRIPPING, outFactory, debugFactory));
        return descriptor;
    }

    private ExecutionDescriptor.InputProcessorFactory createInputProcessorFactory(ExecutionDescriptor.InputProcessorFactory ... factories) {
        ArrayList<ExecutionDescriptor.InputProcessorFactory> real = new ArrayList<ExecutionDescriptor.InputProcessorFactory>(3);
        for (ExecutionDescriptor.InputProcessorFactory factory : factories) {
            if (factory == null) continue;
            real.add(factory);
        }
        if (real.isEmpty()) {
            return null;
        }
        if (real.size() == 1) {
            return (ExecutionDescriptor.InputProcessorFactory)real.get(0);
        }
        return new ProxyInputProcessorFactory(real.toArray(new ExecutionDescriptor.InputProcessorFactory[real.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshGrailsCommands() {
        Callable callable = ExecutionSupport.getInstance().createSimpleCommand("help", GrailsProjectConfig.forProject((Project)this.project), new String[0]);
        final HelpLineProcessor lineProcessor = new HelpLineProcessor();
        ExecutionDescriptor descriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.bridge((LineProcessor)lineProcessor);
            }
        });
        List freshCommands = Collections.emptyList();
        ExecutionService service = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)descriptor, (String)"help");
        Future task = service.run();
        try {
            if ((Integer)task.get() == 0) {
                freshCommands = new ArrayList();
                for (String command : lineProcessor.getCommands()) {
                    freshCommands.add(new GrailsCommand(command, null, command));
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        GrailsCommandSupport grailsCommandSupport = this;
        synchronized (grailsCommandSupport) {
            GrailsProjectConfig projectConfig;
            if (this.buildConfigListener == null) {
                BuildConfig buildConfig = this.project.getBuildConfig();
                this.buildConfigListener = new BuildConfigListener();
                this.buildConfigListener.attachListeners(buildConfig);
                buildConfig.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.buildConfigListener, (Object)buildConfig));
            }
            if (this.projectConfigListener == null && (projectConfig = (GrailsProjectConfig)this.project.getLookup().lookup(GrailsProjectConfig.class)) != null) {
                this.projectConfigListener = new ProjectConfigListener();
                projectConfig.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.projectConfigListener, (Object)projectConfig));
            }
            this.commands = freshCommands;
        }
    }

    public void refreshGrailsCommandsLater(final Runnable post) {
        EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                GrailsCommandSupport.this.refreshGrailsCommands();
                if (post != null) {
                    post.run();
                }
            }
        });
    }

    public static final void showURL(URL url, boolean debug, GrailsProject project) {
        if (!debug) {
            if (GrailsProjectConfig.forProject((Project)project).getDisplayBrowser()) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
        } else {
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
    }

    private class PluginListener
    implements FileChangeListener {
        private PluginListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            this.changed();
        }

        public void fileDataCreated(FileEvent fe) {
            this.changed();
        }

        public void fileDeleted(FileEvent fe) {
            this.changed();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.changed();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.changed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changed() {
            GrailsCommandSupport grailsCommandSupport = GrailsCommandSupport.this;
            synchronized (grailsCommandSupport) {
                GrailsCommandSupport.this.commands = null;
            }
        }
    }

    private class BuildConfigListener
    implements PropertyChangeListener {
        private final PluginListener pluginListener;
        private File globalPluginsDir;
        private File projectPluginsDir;

        private BuildConfigListener() {
            this.pluginListener = new PluginListener();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (BuildConfig.BUILD_CONFIG_PLUGINS.equals(evt.getPropertyName())) {
                GrailsCommandSupport grailsCommandSupport = GrailsCommandSupport.this;
                synchronized (grailsCommandSupport) {
                    this.attachListeners((BuildConfig)evt.getSource());
                    GrailsCommandSupport.this.commands = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachListeners(BuildConfig config) {
            GrailsCommandSupport grailsCommandSupport = GrailsCommandSupport.this;
            synchronized (grailsCommandSupport) {
                File currentGlobalPluginsDir = config.getGlobalPluginsDir();
                this.updateListener(this.pluginListener, this.globalPluginsDir, currentGlobalPluginsDir);
                this.globalPluginsDir = currentGlobalPluginsDir;
                File currentProjectPluginsDir = config.getProjectPluginsDir();
                if (currentGlobalPluginsDir == null && currentGlobalPluginsDir == currentProjectPluginsDir || currentGlobalPluginsDir.equals(currentProjectPluginsDir)) {
                    if (this.projectPluginsDir != null) {
                        FileUtil.removeFileChangeListener((FileChangeListener)this.pluginListener, (File)this.projectPluginsDir);
                    }
                    this.projectPluginsDir = null;
                    return;
                }
                this.updateListener(this.pluginListener, this.projectPluginsDir, currentProjectPluginsDir);
                this.projectPluginsDir = currentProjectPluginsDir;
            }
        }

        private void updateListener(FileChangeListener listener, File oldDir, File newDir) {
            if (oldDir == null || !oldDir.equals(newDir)) {
                if (oldDir != null) {
                    FileUtil.removeFileChangeListener((FileChangeListener)listener, (File)oldDir);
                }
                if (newDir != null) {
                    FileUtil.addFileChangeListener((FileChangeListener)listener, (File)newDir);
                }
            }
        }
    }

    private class ProjectConfigListener
    implements PropertyChangeListener {
        private ProjectConfigListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("grails.platform".equals(evt.getPropertyName())) {
                GrailsCommandSupport grailsCommandSupport = GrailsCommandSupport.this;
                synchronized (grailsCommandSupport) {
                    GrailsCommandSupport.this.commands = null;
                }
            }
        }
    }

    private static class ProxyInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private final List<ExecutionDescriptor.InputProcessorFactory> factories = new ArrayList<ExecutionDescriptor.InputProcessorFactory>();

        public ProxyInputProcessorFactory(ExecutionDescriptor.InputProcessorFactory ... proxied) {
            for (ExecutionDescriptor.InputProcessorFactory factory : proxied) {
                if (factory == null) continue;
                this.factories.add(factory);
            }
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            InputProcessor[] processors = new InputProcessor[this.factories.size()];
            for (int i = 0; i < processors.length; ++i) {
                processors[i] = this.factories.get(i).newInputProcessor(defaultProcessor);
            }
            return InputProcessors.proxy((InputProcessor[])processors);
        }
    }

    private static class ServerOutputProcessor
    implements LineProcessor {
        private final GrailsProject project;
        private final boolean debug;
        private boolean running;

        public ServerOutputProcessor(GrailsProject project, boolean debug) {
            this.project = project;
            this.debug = debug;
        }

        public void processLine(String line) {
            if (!this.running && line.contains("Browse to http://")) {
                URL url;
                this.running = true;
                String urlString = line.substring(line.indexOf("http://"));
                try {
                    url = new URL(urlString);
                }
                catch (MalformedURLException ex) {
                    LOGGER.log(Level.WARNING, "Could not start browser", ex);
                    return;
                }
                GrailsServerState state = (GrailsServerState)this.project.getLookup().lookup(GrailsServerState.class);
                if (state != null) {
                    state.setRunningUrl(url);
                }
                GrailsCommandSupport.showURL(url, this.debug, this.project);
            }
        }

        public void reset() {
        }

        public void close() {
        }
    }

    private static class DebugOutputProcessor
    implements LineProcessor {
        private static final Pattern DEBUGGER_PATTERN = Pattern.compile("Listening\\s+for\\s+transport\\s+(\\w+)\\s+at\\s+address:\\s+([0-9]+).*");
        private final GrailsProject project;
        private boolean debugging;

        public DebugOutputProcessor(GrailsProject project) {
            this.project = project;
        }

        public void processLine(String line) {
            Matcher matcher = DEBUGGER_PATTERN.matcher(line);
            if (!this.debugging && matcher.matches()) {
                this.debugging = true;
                try {
                    String name = ((ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName();
                    GrailsDebugger debuger = (GrailsDebugger)this.project.getLookup().lookup(GrailsDebugger.class);
                    if (debuger != null) {
                        debuger.attachDebugger(name, matcher.group(1), "localhost", matcher.group(2));
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        public void reset() {
        }

        public void close() {
        }
    }

    private static class AnsiStrippingInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private AnsiStrippingInputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return InputProcessors.ansiStripping((InputProcessor)defaultProcessor);
        }
    }

    private static class HelpLineProcessor
    implements LineProcessor {
        private static final Pattern COMMAND_PATTERN = Pattern.compile("grails\\s(.*)");
        private static final Pattern EXCLUDE_PATTERN = Pattern.compile("Usage.*|Examples.*");
        private List<String> commands = Collections.synchronizedList(new ArrayList());
        private boolean excluded;

        private HelpLineProcessor() {
        }

        public void processLine(String line) {
            Matcher matcher = COMMAND_PATTERN.matcher(line);
            if (matcher.matches()) {
                if (!this.excluded) {
                    this.commands.add(matcher.group(1));
                }
            } else {
                this.excluded = EXCLUDE_PATTERN.matcher(line).matches();
            }
        }

        public List<String> getCommands() {
            return this.commands;
        }

        public void close() {
        }

        public void reset() {
        }
    }
}

