/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.actions.clipboardhistory;

import org.netbeans.modules.editor.impl.actions.clipboardhistory.ClipboardHistory;

public class ClipboardHistoryElement {
    private final String content;
    private static final int MAXSIZE = 30;
    private static final String ENDING = "...";

    ClipboardHistoryElement(String text) {
        this.content = text;
    }

    public String getShortenText() {
        String output = this.content.trim();
        if (this.isShorten()) {
            if (output.length() < 30) {
                return output + ENDING;
            }
            return output.substring(0, 30) + ENDING;
        }
        return output;
    }

    public String getFullText() {
        return this.content;
    }

    public boolean isShorten() {
        return this.content.length() > 30 || this.content.trim().isEmpty();
    }

    public String getNumber() {
        return "" + (ClipboardHistory.getInstance().getPosition(this) + 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClipboardHistoryElement) {
            return this.content.equals(((ClipboardHistoryElement)obj).content);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.content != null ? this.content.hashCode() : 0);
        return hash;
    }
}

