/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.api.EncapsulateFieldsRefactoring;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.Utilities;
import org.netbeans.modules.cnd.refactoring.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.DeclarationGenerator;
import org.netbeans.modules.cnd.refactoring.support.GeneratorUtils;
import org.netbeans.modules.cnd.refactoring.support.MemberInfo;
import org.netbeans.modules.cnd.refactoring.ui.UIUtilities;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class EncapsulateFieldPanel
extends JPanel
implements CustomRefactoringPanel {
    private boolean EXPERIMENTAL = CsmRefactoringUtils.REFACTORING_EXTRA;
    private DefaultTableModel model;
    private final CsmObject selectedObject;
    private CsmClass csmClassContainer;
    private ChangeListener parent;
    private String classname;
    private boolean isUpperCase;
    private boolean hasOutOfClassMemberDefinitions = false;
    private static boolean ALWAYS_USE_ACCESSORS = false;
    private static int FIELD_ACCESS_INDEX = 2;
    private static int METHOD_ACCESS_INDEX = 0;
    private static final String[] modifierNames = new String[]{"public", "protected", "<default>", "private"};
    private static final String[] columnNames = new String[]{EncapsulateFieldPanel.getString("LBL_ColField"), "    ", EncapsulateFieldPanel.getString("LBL_ColGetter"), "    ", EncapsulateFieldPanel.getString("LBL_ColSetter")};
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_DEFAULT_INDEX = 2;
    private static final int MOD_PRIVATE_INDEX = 3;
    private static final Class<?>[] columnTypes = new Class[]{CsmField.class, Boolean.class, AccessorInfo.class, Boolean.class, AccessorInfo.class};
    private boolean initialized = false;
    private JButton jButtonSelectAll;
    private JButton jButtonSelectGetters;
    private JButton jButtonSelectNone;
    private JButton jButtonSelectSetters;
    private JCheckBox jCheckAccess;
    private JComboBox jComboAccess;
    private JComboBox jComboField;
    private JComboBox jComboInsertPoint;
    private JComboBox jComboJavadoc;
    private JComboBox jComboSort;
    private JCheckBox jInlineMethods;
    private JLabel jLblAccessVis;
    private JLabel jLblFieldVis;
    private JLabel jLblInsertPoint;
    private JLabel jLblJavadoc;
    private JLabel jLblSort;
    private JLabel jLblTitle;
    private JScrollPane jScrollField;
    private JTable jTableFields;

    public EncapsulateFieldPanel(CsmObject selectedObject, CsmContext editorContext, ChangeListener parent) {
        String title = EncapsulateFieldPanel.getString("LBL_TitleEncapsulateFields");
        this.selectedObject = selectedObject == null ? Utilities.extractEnclosingClass(editorContext) : selectedObject;
        this.parent = parent;
        this.model = new TabM(columnNames, 0);
        this.initComponents();
        this.setName(title);
        this.jCheckAccess.setSelected(ALWAYS_USE_ACCESSORS);
        this.jCheckAccess.setEnabled(false);
        this.jComboAccess.setSelectedIndex(METHOD_ACCESS_INDEX);
        this.jComboAccess.setEnabled(false);
        this.jComboField.setSelectedIndex(FIELD_ACCESS_INDEX);
        this.jComboField.setEnabled(false);
        this.jTableFields.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.jTableFields.setDefaultRenderer(CsmField.class, new EncapsulateCsmFieldTableCellRenderer());
        this.jTableFields.setDefaultRenderer(AccessorInfo.class, new AccessorInfoRenderer());
        this.jTableFields.setDefaultEditor(AccessorInfo.class, new AccessorInfoTableEditor());
        this.jScrollField.setBackground(this.jTableFields.getBackground());
        this.jScrollField.getViewport().setBackground(this.jTableFields.getBackground());
        this.jTableFields.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.jTableFields.setGridColor(UIManager.getColor("control"));
        }
        EncapsulateFieldPanel.initEnumCombo(this.jComboSort, SortBy.DEFAULT);
        this.jComboSort.setEnabled(false);
        EncapsulateFieldPanel.initEnumCombo(this.jComboJavadoc, Documentation.NONE);
        this.jComboJavadoc.setEnabled(false);
    }

    public Component getComponent() {
        return this;
    }

    public final void initialize() {
        if (this.initialized) {
            return;
        }
        CsmObject selectedResolvedObject = CsmRefactoringUtils.getReferencedElement(this.selectedObject);
        int tableSelection = 0;
        for (CsmField field : this.initFields(selectedResolvedObject)) {
            boolean createGetter = field.equals(selectedResolvedObject);
            boolean createSetter = createGetter && !EncapsulateFieldPanel.isConstant(field);
            String getName = GeneratorUtils.computeGetterName(field, this.isUpperCase);
            String setName = GeneratorUtils.computeSetterName(field, this.isUpperCase);
            this.model.addRow(new Object[]{MemberInfo.create(field), createGetter ? Boolean.TRUE : Boolean.FALSE, AccessorInfo.createGetter(field, getName), createSetter ? Boolean.TRUE : Boolean.FALSE, AccessorInfo.createSetter(field, setName)});
            if (!createGetter) continue;
            tableSelection = this.model.getRowCount() - 1;
        }
        this.packRows(this.jTableFields);
        this.setColumnWidth(1);
        this.setColumnWidth(3);
        this.jTableFields.changeSelection(tableSelection, 0, false, false);
        this.jTableFields.invalidate();
        this.jTableFields.repaint();
        this.model.addTableModelListener(new TableModelListener(){
            boolean isUpdating = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tableChanged(TableModelEvent e) {
                if (this.isUpdating) {
                    return;
                }
                int col = e.getColumn();
                int row = e.getFirstRow();
                if (col == 1 || col == 3) {
                    AccessorInfo ai;
                    Boolean value = (Boolean)EncapsulateFieldPanel.this.model.getValueAt(row, col);
                    if (value.booleanValue() && (ai = (AccessorInfo)EncapsulateFieldPanel.this.model.getValueAt(row, col + 1)) != null) {
                        ai.reset();
                    }
                    try {
                        this.isUpdating = true;
                        EncapsulateFieldPanel.this.model.fireTableCellUpdated(row, col + 1);
                    }
                    finally {
                        this.isUpdating = false;
                    }
                }
                AccessorInfo value = (AccessorInfo)EncapsulateFieldPanel.this.model.getValueAt(row, col);
                if (!(this.isUpdating || value != null && value.name != null && value.name.length() != 0)) {
                    try {
                        this.isUpdating = true;
                        EncapsulateFieldPanel.this.model.setValueAt(Boolean.FALSE, row, col - 1);
                    }
                    finally {
                        this.isUpdating = false;
                    }
                }
                EncapsulateFieldPanel.this.parent.stateChanged(null);
            }
        });
        this.initInsertPoints();
        this.initialized = true;
    }

    private void setColumnWidth(int a) {
        TableColumn col = this.jTableFields.getColumnModel().getColumn(a);
        JCheckBox box = new JCheckBox();
        int width = (int)box.getPreferredSize().getWidth();
        col.setPreferredWidth(width);
        col.setMinWidth(width);
        col.setMaxWidth(width);
        col.setResizable(false);
    }

    private int getMinimumRowHeight(JTable table, int rowIndex) {
        int height = table.getRowHeight();
        for (int c = 0; c < table.getColumnCount(); ++c) {
            TableCellRenderer renderer = table.getCellRenderer(rowIndex, c);
            Component comp = table.prepareRenderer(renderer, rowIndex, c);
            int h = comp.getMinimumSize().height;
            height = Math.max(height, h);
        }
        return height;
    }

    private void packRows(JTable table) {
        int max = 0;
        for (int r = 0; r < table.getRowCount(); ++r) {
            int h = this.getMinimumRowHeight(table, r);
            if (h <= max) continue;
            max = h;
        }
        table.setRowHeight(max);
        table.getTableHeader().setPreferredSize(new Dimension(table.getTableHeader().getPreferredSize().width, max));
    }

    protected DefaultTableModel getTableModel() {
        return this.model;
    }

    private void initComponents() {
        this.jLblTitle = new JLabel();
        this.jButtonSelectAll = new JButton();
        this.jButtonSelectNone = new JButton();
        this.jButtonSelectGetters = new JButton();
        this.jButtonSelectSetters = new JButton();
        this.jLblInsertPoint = new JLabel();
        this.jComboInsertPoint = new JComboBox();
        this.jLblSort = new JLabel();
        this.jComboSort = new JComboBox();
        this.jLblJavadoc = new JLabel();
        this.jComboJavadoc = new JComboBox();
        this.jLblFieldVis = new JLabel();
        this.jComboField = new JComboBox();
        this.jLblAccessVis = new JLabel();
        this.jComboAccess = new JComboBox();
        this.jCheckAccess = new JCheckBox();
        this.jScrollField = new JScrollPane();
        this.jTableFields = new JTable();
        this.jInlineMethods = new JCheckBox();
        this.jLblTitle.setLabelFor(this.jTableFields);
        Mnemonics.setLocalizedText((JLabel)this.jLblTitle, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_FieldList"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectAll, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectAll.text"));
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EncapsulateFieldPanel.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectNone, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectNone.text"));
        this.jButtonSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EncapsulateFieldPanel.this.jButtonSelectNoneActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectGetters, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectGetters.text"));
        this.jButtonSelectGetters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EncapsulateFieldPanel.this.jButtonSelectGettersActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectSetters, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectSetters.text"));
        this.jButtonSelectSetters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EncapsulateFieldPanel.this.jButtonSelectSettersActionPerformed(evt);
            }
        });
        this.jLblInsertPoint.setLabelFor(this.jComboInsertPoint);
        Mnemonics.setLocalizedText((JLabel)this.jLblInsertPoint, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jLblInsertPoint.text"));
        this.jLblSort.setLabelFor(this.jComboSort);
        Mnemonics.setLocalizedText((JLabel)this.jLblSort, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jLblSort.text"));
        this.jLblJavadoc.setLabelFor(this.jComboJavadoc);
        Mnemonics.setLocalizedText((JLabel)this.jLblJavadoc, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jLblJavadoc.text"));
        this.jLblFieldVis.setLabelFor(this.jComboField);
        Mnemonics.setLocalizedText((JLabel)this.jLblFieldVis, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_FieldVis"));
        this.jComboField.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.jLblAccessVis.setLabelFor(this.jComboAccess);
        Mnemonics.setLocalizedText((JLabel)this.jLblAccessVis, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_AccessVis"));
        this.jComboAccess.setModel(new DefaultComboBoxModel<String>(modifierNames));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckAccess, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_AccessorsEven"));
        this.jTableFields.setModel(this.model);
        this.jTableFields.setCellSelectionEnabled(true);
        this.jTableFields.setSelectionMode(0);
        this.jTableFields.getTableHeader().setReorderingAllowed(false);
        this.jScrollField.setViewportView(this.jTableFields);
        this.jTableFields.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_jTableFields"));
        Mnemonics.setLocalizedText((AbstractButton)this.jInlineMethods, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jInlineMethods.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckAccess).addComponent(this.jInlineMethods).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblAccessVis).addComponent(this.jLblFieldVis).addComponent(this.jLblInsertPoint).addComponent(this.jLblSort).addComponent(this.jLblJavadoc)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboInsertPoint, -2, -1, -2).addComponent(this.jComboSort, -2, -1, -2).addComponent(this.jComboJavadoc, -2, -1, -2).addComponent(this.jComboField, -2, -1, -2).addComponent(this.jComboAccess, -2, -1, -2)).addGap(125, 125, 125)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollField, -1, 575, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSelectAll).addComponent(this.jButtonSelectNone).addComponent(this.jButtonSelectGetters).addComponent(this.jButtonSelectSetters)).addGap(12, 12, 12)).addComponent(this.jLblTitle)).addContainerGap()));
        layout.linkSize(0, this.jButtonSelectAll, this.jButtonSelectGetters, this.jButtonSelectNone, this.jButtonSelectSetters);
        layout.linkSize(0, this.jComboAccess, this.jComboField, this.jComboInsertPoint, this.jComboJavadoc, this.jComboSort);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonSelectAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectNone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectGetters).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectSetters)).addComponent(this.jScrollField, 0, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblInsertPoint).addComponent(this.jComboInsertPoint, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblSort).addComponent(this.jComboSort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblJavadoc).addComponent(this.jComboJavadoc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblFieldVis).addComponent(this.jComboField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblAccessVis).addComponent(this.jComboAccess, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jInlineMethods).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckAccess).addContainerGap()));
        layout.linkSize(1, this.jComboAccess, this.jComboField, this.jComboInsertPoint, this.jComboJavadoc, this.jComboSort);
        layout.linkSize(1, this.jButtonSelectAll, this.jButtonSelectGetters, this.jButtonSelectNone, this.jButtonSelectSetters);
        this.jButtonSelectAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectAll.acsd"));
        this.jButtonSelectNone.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectNone.acsd"));
        this.jButtonSelectGetters.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectGetters.acsd"));
        this.jButtonSelectSetters.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectSetters.acsd"));
        this.jComboInsertPoint.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jComboInsertPoint.acsd"));
        this.jComboSort.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jComboSort.acsd"));
        this.jComboJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jComboJavadoc.acsd"));
        this.jComboField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_fieldModifiers"));
        this.jComboAccess.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_methodAcc"));
        this.jCheckAccess.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_useAccessors"));
        this.jInlineMethods.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_inlineMethods"));
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.makeSelection(true, 1, 3);
    }

    private void jButtonSelectNoneActionPerformed(ActionEvent evt) {
        this.makeSelection(false, 1, 3);
    }

    private void jButtonSelectGettersActionPerformed(ActionEvent evt) {
        this.makeSelection(true, 1);
    }

    private void jButtonSelectSettersActionPerformed(ActionEvent evt) {
        this.makeSelection(true, 3);
    }

    private static String getString(String key) {
        return NbBundle.getMessage(EncapsulateFieldPanel.class, (String)key);
    }

    private static <E extends Enum<E>> void initEnumCombo(JComboBox combo, E defValue) {
        ArrayList enumList = new ArrayList(EnumSet.allOf(defValue.getClass()));
        Collections.sort(enumList, (Comparator)((Object)defValue));
        combo.setModel(new DefaultComboBoxModel<Object>(enumList.toArray()));
        combo.setSelectedItem(defValue);
    }

    private void makeSelection(boolean state, int ... columns) {
        for (int row = 0; row < this.model.getRowCount(); ++row) {
            for (int col : columns) {
                boolean value = (Boolean)this.model.getValueAt(row, col);
                if (state == value) continue;
                this.model.setValueAt(state, row, col);
            }
        }
    }

    private List<CsmField> initFields(CsmObject selectedObject) {
        CsmObject selectedResolvedObject = CsmRefactoringUtils.getReferencedElement(selectedObject);
        assert (selectedResolvedObject != null) : "why unresolved element was used?";
        if (CsmKindUtilities.isClass((CsmObject)selectedResolvedObject)) {
            this.csmClassContainer = (CsmClass)selectedResolvedObject;
        } else {
            assert (CsmKindUtilities.isField((CsmObject)selectedResolvedObject)) : "should be field";
            this.csmClassContainer = ((CsmField)selectedResolvedObject).getContainingClass();
        }
        ArrayList<CsmField> result = new ArrayList<CsmField>();
        Boolean anIsUpperCase = null;
        for (CsmMember member : this.csmClassContainer.getMembers()) {
            if (CsmKindUtilities.isField((CsmObject)member)) {
                result.add((CsmField)member);
                continue;
            }
            if (anIsUpperCase != null || !CsmKindUtilities.isMethod((CsmObject)member)) continue;
            anIsUpperCase = GeneratorUtils.checkStartWithUpperCase((CsmMethod)member);
        }
        this.isUpperCase = anIsUpperCase != null ? anIsUpperCase : true;
        this.classname = ((Object)this.csmClassContainer.getQualifiedName()).toString();
        String title = " - " + this.classname;
        this.setName(this.getName() + title);
        return result;
    }

    private void initInsertPoints() {
        CsmClass encloser = this.csmClassContainer;
        ArrayList<InsertPoint> result = new ArrayList<InsertPoint>();
        int idx = 0;
        this.hasOutOfClassMemberDefinitions = false;
        for (CsmMember member : encloser.getMembers()) {
            if (CsmKindUtilities.isMethod((CsmObject)member)) {
                CsmMethod method = (CsmMethod)member;
                CsmFunctionDefinition definition = method.getDefinition();
                InsertPoint ip = new InsertPoint(encloser, (CsmOffsetable)method, (CsmOffsetable)definition, idx + 1, NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"MSG_EncapsulateFieldInsertPointMethod", (Object)MemberInfo.create(method).getHtmlText()));
                if (definition != null && definition != method) {
                    this.hasOutOfClassMemberDefinitions = true;
                }
                result.add(ip);
            }
            ++idx;
        }
        this.jComboInsertPoint.addItem(InsertPoint.DEFAULT);
        if (!result.isEmpty()) {
            InsertPoint first = new InsertPoint(encloser, null, null, Integer.MIN_VALUE, EncapsulateFieldPanel.getString("EncapsulateFieldPanel.jComboInsertPoint.first"));
            InsertPoint last = new InsertPoint(encloser, null, null, Integer.MAX_VALUE, EncapsulateFieldPanel.getString("EncapsulateFieldPanel.jComboInsertPoint.last"));
            this.jComboInsertPoint.addItem(first);
            this.jComboInsertPoint.addItem(last);
            for (InsertPoint ip : result) {
                this.jComboInsertPoint.addItem(ip);
            }
        }
        this.jComboInsertPoint.setSelectedItem(InsertPoint.DEFAULT);
        if (this.hasOutOfClassMemberDefinitions) {
            this.jInlineMethods.setSelected(NbPreferences.forModule(DeclarationGenerator.class).getBoolean("inline_method", false));
            this.jInlineMethods.setEnabled(true);
        } else {
            this.jInlineMethods.setSelected(true);
            this.jInlineMethods.setEnabled(false);
        }
    }

    public final Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> getAllFields() {
        ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> result = new ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo>();
        Vector<Vector> rows = this.model.getDataVector();
        for (List list : rows) {
            String setterName;
            String getterName = (Boolean)list.get(1) != false ? ((AccessorInfo)list.get((int)2)).name : null;
            String string = setterName = (Boolean)list.get(3) != false ? ((AccessorInfo)list.get((int)4)).name : null;
            if (getterName == null && setterName == null) continue;
            MemberInfo mi = (MemberInfo)list.get(0);
            CsmMethod defaultGetter = null;
            if (((AccessorInfo)list.get((int)2)).defaultAccessor != null) {
                defaultGetter = (CsmMethod)((AccessorInfo)list.get((int)2)).defaultAccessor.getElementHandle();
            }
            CsmMethod defaultSetter = null;
            if (((AccessorInfo)list.get((int)4)).defaultAccessor != null) {
                defaultSetter = (CsmMethod)((AccessorInfo)list.get((int)4)).defaultAccessor.getElementHandle();
            }
            result.add(new EncapsulateFieldsRefactoring.EncapsulateFieldInfo((CsmField)mi.getElementHandle(), "".equals(getterName) ? null : getterName, "".equals(setterName) ? null : setterName, defaultGetter, defaultSetter));
        }
        return result;
    }

    public boolean isMethodInline() {
        boolean inline = this.jInlineMethods.isSelected();
        if (this.hasOutOfClassMemberDefinitions) {
            NbPreferences.forModule(DeclarationGenerator.class).putBoolean("inline_method", inline);
        }
        return inline;
    }

    public boolean isCheckAccess() {
        ALWAYS_USE_ACCESSORS = this.jCheckAccess.isSelected();
        return ALWAYS_USE_ACCESSORS;
    }

    public Set<CsmVisibility> getFieldModifiers() {
        FIELD_ACCESS_INDEX = this.jComboField.getSelectedIndex();
        CsmVisibility mod = this.getModifier(FIELD_ACCESS_INDEX);
        if (mod == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(mod);
    }

    public Set<CsmVisibility> getMethodModifiers() {
        METHOD_ACCESS_INDEX = this.jComboAccess.getSelectedIndex();
        CsmVisibility mod = this.getModifier(METHOD_ACCESS_INDEX);
        if (mod == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(mod);
    }

    private CsmVisibility getModifier(int index) {
        switch (index) {
            case 3: {
                return CsmVisibility.PRIVATE;
            }
            case 2: {
                return CsmVisibility.NONE;
            }
            case 1: {
                return CsmVisibility.PROTECTED;
            }
            case 0: {
                return CsmVisibility.PUBLIC;
            }
        }
        throw new IllegalStateException("unexpected index:" + index);
    }

    public InsertPoint getInsertPoint() {
        return (InsertPoint)this.jComboInsertPoint.getSelectedItem();
    }

    public SortBy getSortBy() {
        return (SortBy)this.jComboSort.getSelectedItem();
    }

    public Documentation getDocumentation() {
        return (Documentation)this.jComboJavadoc.getSelectedItem();
    }

    String getClassname() {
        return this.classname;
    }

    private static boolean isConstant(Object value) {
        if (CsmKindUtilities.isCsmObject((Object)value) && CsmKindUtilities.isVariable((CsmObject)((CsmObject)value))) {
            return GeneratorUtils.isConstant((CsmVariable)value);
        }
        return false;
    }

    private static final class AccessorInfoTableEditor
    extends DefaultCellEditor {
        private AccessorInfo ai;

        public AccessorInfoTableEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.ai = (AccessorInfo)value;
            if (this.ai == null) {
                throw new IllegalStateException();
            }
            String cellEditorValue = this.ai.name;
            return super.getTableCellEditorComponent(table, cellEditorValue, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            AccessorInfo retVal;
            String cellEditorValue = (String)super.getCellEditorValue();
            if (cellEditorValue == null || cellEditorValue.length() == 0) {
                if (this.ai != null) {
                    this.ai.name = null;
                    this.ai.accessor = null;
                    this.ai.accessorToolTip = null;
                }
                retVal = this.ai;
            } else {
                if (!cellEditorValue.equals(this.ai.name)) {
                    this.computeNewValue();
                }
                retVal = this.ai;
            }
            return retVal;
        }

        private void computeNewValue() {
            AccessorInfo desc = this.ai;
            assert (desc != null);
            desc.setName(((String)super.getCellEditorValue()).trim());
        }
    }

    private static final class AccessorInfoRenderer
    extends UIUtilities.CsmElementTableCellRenderer {
        private AccessorInfoRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object o;
            AccessorInfo ai = (AccessorInfo)value;
            String newValue = ai == null ? null : (ai.accessor == null ? ai.name : ai.accessor);
            Component renderer = super.getTableCellRendererComponent(table, newValue, isSelected, hasFocus, row, column);
            String toolTip = ai != null && table.isCellEditable(row, column) ? ai.accessorToolTip : null;
            boolean isEnabled = (Boolean)table.getModel().getValueAt(row, column - 1);
            this.setEnabled(isEnabled);
            if (isEnabled && ai != null && !ai.isGetter && EncapsulateFieldPanel.isConstant(table.getValueAt(row, 0)) && (o = UIManager.getDefaults().get("nb.errorForeground")) instanceof Color) {
                this.setBorder(BorderFactory.createLineBorder((Color)o));
                String warning = NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"MSG_EncapsulateFieldFinalFieldWarning");
                toolTip = toolTip == null ? warning : String.format("<html>%s<br>%s</html>", warning, toolTip);
            }
            this.setToolTipText(toolTip);
            return renderer;
        }
    }

    private static final class EncapsulateCsmFieldTableCellRenderer
    extends UIUtilities.CsmElementTableCellRenderer {
        private EncapsulateCsmFieldTableCellRenderer() {
        }

        @Override
        protected String extractText(Object value) {
            String s = super.extractText(value);
            if (s != null && EncapsulateFieldPanel.isConstant(value)) {
                s = s + " : const";
            }
            return s;
        }
    }

    public static final class InsertPoint {
        public static final InsertPoint DEFAULT = new InsertPoint(null, null, null, Integer.MIN_VALUE, EncapsulateFieldPanel.access$1000("EncapsulateFieldPanel.jComboInsertPoint.default"));
        private final int index;
        private final String description;
        private final CsmOffsetable elemDecl;
        private final CsmOffsetable elemDef;
        private final CsmClass clazz;

        private InsertPoint(CsmClass clazz, CsmOffsetable elemDecl, CsmOffsetable elemDef, int index, String description) {
            this.index = index;
            this.description = description;
            this.elemDecl = elemDecl;
            this.elemDef = elemDef;
            this.clazz = clazz;
        }

        public CsmClass getContainerClass() {
            return this.clazz;
        }

        public CsmOffsetable getElementDeclaration() {
            return this.elemDecl;
        }

        public CsmOffsetable getElementDefinition() {
            return this.elemDef;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum Documentation implements Comparator<Documentation>
    {
        DEFAULT("EncapsulateFieldPanel.jComboJavadoc.createDefault"),
        NONE("EncapsulateFieldPanel.jComboJavadoc.none"),
        COPY("EncapsulateFieldPanel.jComboJavadoc.copy");

        private final String displayName;

        private Documentation(String key) {
            this.displayName = EncapsulateFieldPanel.getString(key);
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compare(Documentation o1, Documentation o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    public static enum SortBy implements Comparator<SortBy>
    {
        DEFAULT("EncapsulateFieldPanel.jComboSort.default"),
        PAIRS("EncapsulateFieldPanel.jComboSort.pairs"),
        ALPHABETICALLY("EncapsulateFieldPanel.jComboSort.alphabetically"),
        GETTERS_FIRST("EncapsulateFieldPanel.jComboSort.gettersFirst");

        private final String displayName;

        private SortBy(String key) {
            this.displayName = EncapsulateFieldPanel.getString(key);
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compare(SortBy o1, SortBy o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    private static final class AccessorInfo {
        String defaultName;
        MemberInfo<? extends CsmMember> defaultAccessor;
        String name;
        String accessorToolTip;
        String defaultAccessorToolTip;
        MemberInfo<? extends CsmMember> accessor;
        private CsmField fieldHandle;
        private boolean isGetter;

        private AccessorInfo() {
        }

        public static AccessorInfo createGetter(CsmField field, String proposedName) {
            CsmMethod getter = EncapsulateFieldRefactoringPlugin.findMethod(field.getContainingClass(), proposedName, Collections.emptyList(), true);
            return AccessorInfo.create(field, getter, proposedName, true);
        }

        public static AccessorInfo createSetter(CsmField field, String proposedName) {
            CsmMethod setter = EncapsulateFieldRefactoringPlugin.findMethod(field.getContainingClass(), proposedName, Collections.singletonList(field), true);
            return AccessorInfo.create(field, setter, proposedName, false);
        }

        private static AccessorInfo create(CsmField field, CsmMethod method, String proposedName, boolean isGetter) {
            AccessorInfo ai = new AccessorInfo();
            ai.name = ai.defaultName = proposedName;
            ai.defaultAccessor = method != null ? MemberInfo.create(method) : null;
            ai.accessor = ai.defaultAccessor;
            ai.defaultAccessorToolTip = method != null ? NbBundle.getMessage(EncapsulateFieldPanel.class, (String)(isGetter ? "MSG_EncapsulateFieldDeclaredGetter" : "MSG_EncapsulateFieldDeclaredSetter"), (Object)((Object)method.getName()).toString()) : null;
            ai.accessorToolTip = ai.defaultAccessorToolTip;
            ai.isGetter = isGetter;
            ai.fieldHandle = field;
            return ai;
        }

        public void reset() {
            this.name = this.defaultName;
            this.accessor = this.defaultAccessor;
            this.accessorToolTip = this.defaultAccessorToolTip;
        }

        public void setName(String s) {
            this.name = s;
            CsmField field = this.fieldHandle;
            CsmMethod method = null;
            method = this.isGetter ? EncapsulateFieldRefactoringPlugin.findMethod(field.getContainingClass(), s, Collections.emptyList(), true) : EncapsulateFieldRefactoringPlugin.findMethod(field.getContainingClass(), s, Collections.singletonList(field), true);
            MemberInfo<CsmMethod> memberInfo = this.accessor = method != null ? MemberInfo.create(method) : null;
            this.accessorToolTip = method != null ? NbBundle.getMessage(EncapsulateFieldPanel.class, (String)(this.isGetter ? "MSG_EncapsulateFieldDeclaredGetter" : "MSG_EncapsulateFieldDeclaredSetter"), (Object)((Object)method.getName()).toString()) : null;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class TabM
    extends DefaultTableModel {
        public TabM(Object[] columnNames, int rowCount) {
            super(columnNames, rowCount);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 0) {
                return false;
            }
            if (column == 1 || column == 3) {
                return true;
            }
            return (Boolean)this.getValueAt(row, column - 1);
        }
    }
}

