/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.cnd.refactoring.api.EncapsulateFieldsRefactoring;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.Utilities;
import org.netbeans.modules.cnd.refactoring.plugins.CsmModificationRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.GeneratorUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.cnd.refactoring.ui.EncapsulateFieldPanel;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.openide.util.NbBundle;

public final class EncapsulateFieldsPlugin
extends CsmModificationRefactoringPlugin {
    private static final int FAST_CHECK_PARAMETERS = 1;
    private static final int CHECK_PARAMETERS = 2;
    private List<EncapsulateFieldRefactoringPlugin> refactorings;
    private final EncapsulateFieldsRefactoring refactoring;
    private Collection<CsmField> referencedFields = new ArrayList<CsmField>();
    private CsmClass enclosingClass;
    private ProgressListener listener = new ProgressListener(){

        public void start(ProgressEvent event) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStart(event.getOperationType(), event.getCount());
        }

        public void step(ProgressEvent event) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStep();
        }

        public void stop(ProgressEvent event) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStop();
        }
    };

    public EncapsulateFieldsPlugin(EncapsulateFieldsRefactoring refactoring) {
        super(refactoring);
        this.refactoring = refactoring;
    }

    @Override
    public Problem checkParameters() {
        return this.validation(2);
    }

    @Override
    public Problem fastCheckParameters() {
        Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> fields = this.refactoring.getRefactorFields();
        if (fields.isEmpty()) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"ERR_EncapsulateNothingSelected"));
        }
        this.initRefactorings(fields, this.refactoring.getMethodModifiers(), this.refactoring.getFieldModifiers(), this.refactoring.isAlwaysUseAccessors(), this.refactoring.isMethodInline());
        return this.validation(1);
    }

    private CsmObject getRefactoredCsmElement() {
        CsmContext editorContext;
        CsmObject out = this.getStartReferenceObject();
        if (out == null && (editorContext = this.getEditorContext()) != null && !CsmKindUtilities.isField((CsmObject)(out = editorContext.getObjectUnderOffset()))) {
            out = Utilities.extractEnclosingClass(this.getEditorContext());
        }
        return out;
    }

    @Override
    public Problem preCheck() {
        Problem preCheckProblem = null;
        this.fireProgressListenerStart(1, 4);
        Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> fieldsInfo = this.refactoring.getRefactorFields();
        CsmObject refactoredElement = this.getRefactoredCsmElement();
        preCheckProblem = fieldsInfo.isEmpty() ? this.isResovledElement(refactoredElement) : null;
        this.fireProgressListenerStep();
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        CsmObject directReferencedObject = CsmRefactoringUtils.getReferencedElement(refactoredElement);
        this.initReferencedObjects(directReferencedObject, fieldsInfo);
        this.fireProgressListenerStep();
        if (this.enclosingClass == null) {
            preCheckProblem = EncapsulateFieldsPlugin.createProblem(preCheckProblem, true, EncapsulateFieldsPlugin.getString("ERR_EncapsulateWrongType"));
            return preCheckProblem;
        }
        preCheckProblem = this.checkIfModificationPossible(preCheckProblem, (CsmObject)this.enclosingClass);
        this.fireProgressListenerStop();
        if (fieldsInfo.isEmpty()) {
            for (CsmMember csmMember : this.enclosingClass.getMembers()) {
                if (!CsmKindUtilities.isField((CsmObject)csmMember)) continue;
                return null;
            }
            return new Problem(true, EncapsulateFieldsPlugin.getString("ERR_EncapsulateNoFields", ((Object)this.enclosingClass.getQualifiedName()).toString()));
        }
        return preCheckProblem;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)key);
    }

    private static String getString(String key, String param) {
        return NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)key, (Object)param);
    }

    private void initRefactorings(Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> refactorFields, Set<CsmVisibility> methodModifier, Set<CsmVisibility> fieldModifier, boolean alwaysUseAccessors, boolean methodInline) {
        this.refactorings = new ArrayList<EncapsulateFieldRefactoringPlugin>(refactorFields.size());
        CsmFile[] declDefFiles = null;
        for (EncapsulateFieldsRefactoring.EncapsulateFieldInfo info : refactorFields) {
            if (declDefFiles == null) {
                declDefFiles = GeneratorUtils.getDeclarationDefinitionFiles(info.getField().getContainingClass());
            }
            EncapsulateFieldRefactoring ref = new EncapsulateFieldRefactoring(info.getField(), declDefFiles[0], declDefFiles[1]);
            ref.setGetterName(info.getGetterName());
            ref.setSetterName(info.getSetterName());
            ref.setMethodModifiers(methodModifier);
            ref.setFieldModifiers(fieldModifier);
            ref.setAlwaysUseAccessors(alwaysUseAccessors);
            ref.setMethodInline(methodInline);
            ref.setDefaultGetter(info.getDefaultGetter());
            ref.setDefaultSetter(info.getDefaultSetter());
            ref.getContext().add(this.refactoring.getContext().lookup(EncapsulateFieldPanel.InsertPoint.class));
            ref.getContext().add(this.refactoring.getContext().lookup(EncapsulateFieldPanel.Documentation.class));
            ref.getContext().add(this.refactoring.getContext().lookup(EncapsulateFieldPanel.SortBy.class));
            this.refactorings.add(new EncapsulateFieldRefactoringPlugin(ref));
        }
    }

    private Problem validation(int phase) {
        Problem result = null;
        for (EncapsulateFieldRefactoringPlugin ref : this.refactorings) {
            Problem lastresult = null;
            switch (phase) {
                case 1: {
                    lastresult = ref.fastCheckParameters();
                    break;
                }
                case 2: {
                    lastresult = ref.preCheck();
                    result = EncapsulateFieldsPlugin.chainProblems(result, lastresult);
                    if (result != null && result.isFatal()) {
                        return result;
                    }
                    lastresult = ref.checkParameters();
                    ref.addProgressListener(this.listener);
                }
            }
            if ((result = EncapsulateFieldsPlugin.chainProblems(result, lastresult)) == null || !result.isFatal()) continue;
            return result;
        }
        return result;
    }

    private static Problem chainProblems(Problem oldp, Problem newp) {
        if (oldp == null) {
            return newp;
        }
        if (newp == null) {
            return oldp;
        }
        if (newp.isFatal()) {
            newp.setNext(oldp);
            return newp;
        }
        Problem p = oldp;
        while (p.getNext() != null) {
            p = p.getNext();
        }
        p.setNext(newp);
        return oldp;
    }

    @Override
    protected Collection<CsmFile> getRefactoredFiles() {
        if (this.enclosingClass == null) {
            return Collections.emptySet();
        }
        HashSet<CsmFile> files = new HashSet<CsmFile>();
        CsmFile startFile = CsmRefactoringUtils.getCsmFile((CsmObject)this.enclosingClass);
        if (this.refactoring.isAlwaysUseAccessors()) {
            Collection<CsmProject> prjs = CsmRefactoringUtils.getRelatedCsmProjects((CsmObject)this.enclosingClass, null);
            CsmProject[] ar = prjs.toArray(new CsmProject[prjs.size()]);
            this.refactoring.getContext().add((Object)ar);
            files.addAll(this.getRelevantFiles(startFile, (CsmObject)this.enclosingClass, this.refactoring));
        } else {
            files.add(startFile);
            if (!this.refactoring.isMethodInline()) {
                Collection<CsmFunction> extDefs = GeneratorUtils.getAllOutOfClassMethodDefinitions(this.enclosingClass);
                for (CsmFunction extDef : extDefs) {
                    CsmFile defFile = CsmRefactoringUtils.getCsmFile((CsmObject)extDef);
                    if (defFile == null) continue;
                    files.add(defFile);
                }
            }
        }
        return files;
    }

    private void initReferencedObjects(CsmObject referencedObject, Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> fieldsInfo) {
        this.referencedFields = new ArrayList<CsmField>(fieldsInfo.size());
        if (!fieldsInfo.isEmpty()) {
            for (EncapsulateFieldsRefactoring.EncapsulateFieldInfo info : fieldsInfo) {
                CsmField field = info.getField();
                this.referencedFields.add(field);
                if (this.enclosingClass != null) continue;
                this.enclosingClass = field.getContainingClass();
            }
        } else if (referencedObject != null) {
            if (CsmKindUtilities.isClass((CsmObject)referencedObject)) {
                this.enclosingClass = (CsmClass)referencedObject;
            } else if (CsmKindUtilities.isField((CsmObject)referencedObject)) {
                this.enclosingClass = ((CsmField)referencedObject).getContainingClass();
            }
        }
    }

    @Override
    protected void processFile(CsmFile csmFile, ModificationResult mr, AtomicReference<Problem> outProblem) {
        for (EncapsulateFieldRefactoringPlugin ref : this.refactorings) {
            ref.processFile(csmFile, mr, outProblem);
        }
    }
}

