/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.api.FormattingSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.cnd.refactoring.plugins.CsmModificationRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.DeclarationGenerator;
import org.netbeans.modules.cnd.refactoring.support.GeneratorUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.cnd.refactoring.ui.EncapsulateFieldPanel;
import org.netbeans.modules.refactoring.api.Problem;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class EncapsulateFieldRefactoringPlugin
extends CsmModificationRefactoringPlugin {
    private static final Logger LOG = Logger.getLogger(EncapsulateFieldRefactoringPlugin.class.getName());
    private Collection<CsmObject> referencedObjects;
    private CsmClass fieldEncloser;
    private CsmVisibility fieldEncloserAccessibility = CsmVisibility.PUBLIC;
    private CsmVisibility fieldAccessibility;
    private CsmMethod currentGetter;
    private CsmMethod currentSetter;
    private static Set<CsmVisibility> accessModifiers = EnumSet.of(CsmVisibility.PRIVATE, CsmVisibility.PROTECTED, CsmVisibility.PUBLIC);
    private static List<CsmVisibility> MODIFIERS = Arrays.asList(CsmVisibility.PRIVATE, null, CsmVisibility.PROTECTED, CsmVisibility.PUBLIC);
    private final EncapsulateFieldRefactoring refactoring;
    public static final String CLASS_FIELD_PREFIX = "_";
    private CsmObject sourceType;

    public EncapsulateFieldRefactoringPlugin(EncapsulateFieldRefactoring refactoring) {
        super(refactoring);
        this.refactoring = refactoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 2);
        try {
            CsmField field = this.refactoring.getSourceField();
            Problem result = this.checkIfModificationPossible(null, (CsmObject)field);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            this.fireProgressListenerStep();
            this.fieldEncloser = field.getContainingClass();
            this.fieldAccessibility = field.getVisibility();
            Problem problem = result;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    public Problem fastCheckParameters() {
        return this.fastCheckParameters(this.refactoring.getGetterName(), this.refactoring.getSetterName());
    }

    @Override
    public Problem checkParameters() {
        Problem p = null;
        CsmField field = this.refactoring.getSourceField();
        CsmClass clazz = field.getContainingClass();
        String getname = this.refactoring.getGetterName();
        String setname = this.refactoring.getSetterName();
        CsmMethod getter = null;
        CsmMethod setter = null;
        if (getname != null) {
            getter = EncapsulateFieldRefactoringPlugin.findMethod(clazz, getname, Collections.emptyList(), true);
        }
        if (getter != null) {
            if (!GeneratorUtils.isSameType(field.getType(), getter.getReturnType())) {
                String msg = NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateWrongGetter", (Object)getname, (Object)getter.getReturnType().getCanonicalText());
                p = EncapsulateFieldRefactoringPlugin.createProblem(p, false, msg);
            }
            if (clazz.equals(getter.getContainingClass())) {
                this.currentGetter = getter;
            }
        }
        if (setname != null) {
            setter = EncapsulateFieldRefactoringPlugin.findMethod(clazz, setname, Collections.singletonList(field), true);
        }
        if (setter != null) {
            if (GeneratorUtils.getTypeKind(setter.getReturnType()) != GeneratorUtils.TypeKind.VOID) {
                p = EncapsulateFieldRefactoringPlugin.createProblem(p, false, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateWrongSetter", (Object)setname, (Object)setter.getReturnType().getCanonicalText()));
            }
            if (clazz.equals(setter.getContainingClass())) {
                this.currentSetter = setter;
            }
        }
        return p;
    }

    private void addDiff(GeneratorUtils.InsertInfo declInsert, DeclarationGenerator.Kind kind, CharSequence text, String mtdName, String bundle, ModificationResult mr, FileObject fo) throws MissingResourceException {
        CharSequence declText = FormattingSupport.getFormattedText((Document)CsmUtilities.openDocument((CloneableEditorSupport)declInsert.ces), (int)declInsert.dot, (CharSequence)text);
        String descr = NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)bundle, (Object)mtdName);
        String prefix = "\n";
        if (kind == DeclarationGenerator.Kind.EXTERNAL_DEFINITION || kind == DeclarationGenerator.Kind.INLINE_DEFINITION || kind == DeclarationGenerator.Kind.INLINE_DEFINITION_MAKRED_INLINE) {
            prefix = "\n\n";
        }
        ModificationResult.Difference declDiff = new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, declInsert.start, declInsert.end, bundle, prefix + declText, descr);
        mr.addDifference(fo, declDiff);
    }

    private Problem fastCheckParameters(String getter, String setter) {
        if (getter != null && !CndLexerUtilities.isCppIdentifier((CharSequence)getter) || setter != null && !CndLexerUtilities.isCppIdentifier((CharSequence)setter) || getter == null && setter == null) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateMethods"));
        }
        return null;
    }

    private FieldAccessInfo prepareFieldAccessInfo(final CsmReference ref, final Document doc) {
        final FieldAccessTokenProcessor tp = new FieldAccessTokenProcessor(ref.getStartOffset(), doc);
        if (doc != null) {
            doc.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        int start = CndTokenUtilities.getLastCommandSeparator((Document)doc, (int)ref.getStartOffset());
                        CndTokenUtilities.processTokens((CndTokenProcessor)tp, (Document)doc, (int)start, (int)doc.getLength());
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        return tp.getFieldAccessInfo();
    }

    public static CsmMethod findMethod(CsmClass clazz, String name, Collection<? extends CsmVariable> params, boolean includeSupertypes) {
        if (name == null || name.length() == 0) {
            return null;
        }
        CsmClass c = clazz;
        for (CsmMember elm : c.getMembers()) {
            CsmMethod m;
            if (!CsmKindUtilities.isMethod((CsmObject)elm) || !name.contentEquals((m = (CsmMethod)elm).getName()) || !EncapsulateFieldRefactoringPlugin.compareParams(params, m.getParameters())) continue;
            return m;
        }
        return null;
    }

    private static boolean compareParams(Collection<? extends CsmVariable> params1, Collection<? extends CsmVariable> params2) {
        if (params1.size() == params2.size()) {
            Iterator<? extends CsmVariable> it1 = params1.iterator();
            for (CsmVariable csmVariable : params2) {
                CsmVariable ve1 = it1.next();
                CsmType type2 = csmVariable.getType();
                CsmType type1 = ve1.getType();
                if ((type2 != null || type1 != null) && GeneratorUtils.isSameType(type2, type1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected Collection<CsmFile> getRefactoredFiles() {
        return Collections.emptySet();
    }

    @Override
    protected void processFile(CsmFile csmFile, ModificationResult mr, AtomicReference<Problem> outProblem) {
        EncapsulateFieldPanel.InsertPoint insPt = (EncapsulateFieldPanel.InsertPoint)this.refactoring.getContext().lookup(EncapsulateFieldPanel.InsertPoint.class);
        CsmField field = this.refactoring.getSourceField();
        CsmFile classDeclarationFile = this.refactoring.getClassDeclarationFile();
        CsmFile classDefinitionFile = this.refactoring.getClassDefinitionFile();
        CloneableEditorSupport ces = null;
        FileObject fo = null;
        String getterName = this.refactoring.getGetterName();
        String setterName = this.refactoring.getSetterName();
        if ((getterName != null && this.refactoring.getDefaultGetter() == null || setterName != null && this.refactoring.getDefaultSetter() == null) && (csmFile.equals(classDeclarationFile) || csmFile.equals(classDefinitionFile))) {
            String text;
            fo = CsmUtilities.getFileObject((CsmFile)csmFile);
            CsmClass enclosing = this.refactoring.getEnclosingClass();
            GeneratorUtils.InsertInfo[] insertPositons = GeneratorUtils.getInsertPositons(null, enclosing, insPt);
            if (csmFile.equals(classDeclarationFile)) {
                DeclarationGenerator.Kind declKind;
                if (this.refactoring.isMethodInline()) {
                    declKind = DeclarationGenerator.Kind.INLINE_DEFINITION;
                    if (CodeStyle.getDefault((CodeStyle.Language)CodeStyle.Language.CPP).getUseInlineKeyword()) {
                        declKind = DeclarationGenerator.Kind.INLINE_DEFINITION_MAKRED_INLINE;
                    }
                } else {
                    declKind = DeclarationGenerator.Kind.DECLARATION;
                }
                GeneratorUtils.InsertInfo declInsert = insertPositons[0];
                if (getterName != null && this.refactoring.getDefaultGetter() == null) {
                    text = DeclarationGenerator.createGetter(field, getterName, declKind);
                    this.addDiff(declInsert, declKind, text, getterName, this.refactoring.isMethodInline() ? "EncapsulateFieldInlineDefinition" : "EncapsulateFieldInsertDeclartion", mr, fo);
                }
                if (setterName != null && this.refactoring.getDefaultSetter() == null) {
                    text = DeclarationGenerator.createSetter(field, setterName, declKind);
                    this.addDiff(declInsert, declKind, text, setterName, this.refactoring.isMethodInline() ? "EncapsulateFieldInlineDefinition" : "EncapsulateFieldInsertDeclartion", mr, fo);
                }
            }
            if (!this.refactoring.isMethodInline() && csmFile.equals(classDefinitionFile)) {
                DeclarationGenerator.Kind defKind = DeclarationGenerator.Kind.EXTERNAL_DEFINITION;
                GeneratorUtils.InsertInfo defInsert = insertPositons[1];
                if (getterName != null && this.refactoring.getDefaultGetter() == null) {
                    text = DeclarationGenerator.createGetter(field, getterName, defKind);
                    this.addDiff(defInsert, defKind, text, getterName, "EncapsulateFieldInsertDefinition", mr, fo);
                }
                if (setterName != null && this.refactoring.getDefaultSetter() == null) {
                    text = DeclarationGenerator.createSetter(field, setterName, defKind);
                    this.addDiff(defInsert, defKind, text, setterName, "EncapsulateFieldInsertDefinition", mr, fo);
                }
            }
        }
        if (this.refactoring.isAlwaysUseAccessors()) {
            fo = fo != null ? fo : CsmUtilities.getFileObject((CsmFile)csmFile);
            ces = ces != null ? ces : CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
            Collection refs = CsmReferenceRepository.getDefault().getReferences((CsmObject)field, csmFile, CsmReferenceKind.ALL, null);
            if (refs.size() > 0) {
                ArrayList<CsmReference> sortedRefs = new ArrayList<CsmReference>(refs);
                Collections.sort(sortedRefs, new Comparator<CsmReference>(){

                    @Override
                    public int compare(CsmReference o1, CsmReference o2) {
                        return o1.getStartOffset() - o2.getStartOffset();
                    }
                });
                this.processRefactoredReferences(sortedRefs, fo, ces, mr, outProblem);
            }
        }
    }

    private void processRefactoredReferences(List<CsmReference> sortedRefs, FileObject fo, CloneableEditorSupport ces, ModificationResult mr, AtomicReference<Problem> outProblem) {
        for (CsmReference curRef : sortedRefs) {
            CsmObject encl = CsmRefactoringUtils.getEnclosingElement((CsmObject)curRef);
            if (CsmKindUtilities.isFunction((CsmObject)encl) && !CsmKindUtilities.isConstructor((CsmObject)encl) && CsmKindUtilities.isDestructor((CsmObject)encl) && !encl.equals(this.refactoring.getDefaultGetter()) && encl.equals(this.refactoring.getDefaultSetter())) continue;
        }
    }

    private static final class FieldAccessTokenProcessor
    implements CndTokenProcessor<Token<TokenId>> {
        private State state = State.START;
        private BlockConsumer blockConsumer;
        private final int refStartPos;
        private final FieldAccessInfo fldInfo = new FieldAccessInfo();
        private final Document doc;
        private Boolean inPP = null;
        private int curParamStartOffset = -1;

        private FieldAccessTokenProcessor(int refStartPos, Document doc) {
            this.doc = doc;
            this.refStartPos = refStartPos;
        }

        public boolean isStopped() {
            return this.state == State.END;
        }

        public FieldAccessInfo getFieldAccessInfo() {
            return this.fldInfo;
        }

        public boolean token(Token<TokenId> token, int tokenOffset) {
            if (this.blockConsumer != null) {
                if (this.blockConsumer.isLastToken(token)) {
                    this.blockConsumer = null;
                }
                return false;
            }
            if (this.inPP == null) {
                if (token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                    this.inPP = Boolean.TRUE;
                    return true;
                }
                this.inPP = Boolean.FALSE;
            } else if (this.inPP == Boolean.FALSE && token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                return false;
            }
            switch (this.state) {
                case START: {
                    if (tokenOffset != this.refStartPos) break;
                    this.state = State.AFTER_FIELD_ACCESS;
                    this.fldInfo.startOffset = tokenOffset;
                    this.fldInfo.origParamsText = token.text();
                    break;
                }
                case AFTER_FIELD_ACCESS: {
                    this.afterFieldAccess(token, tokenOffset);
                }
            }
            return false;
        }

        private void afterFieldAccess(Token<TokenId> token, int offset) {
            TokenId tokenID;
            if (!this.isWS(token) && (tokenID = token.id()) instanceof CppTokenId) {
                switch ((CppTokenId)tokenID) {
                    case LPAREN: {
                        this.blockConsumer = new BlockConsumer(CppTokenId.LT, CppTokenId.GT);
                        break;
                    }
                    case SEMICOLON: 
                    case RPAREN: {
                        this.state = State.END;
                        break;
                    }
                    case EQ: {
                        this.state = State.LVALUE;
                    }
                }
            }
        }

        private boolean isWS(Token<TokenId> t) {
            TokenId tokenID = t.id();
            if (tokenID instanceof CppTokenId) {
                switch ((CppTokenId)tokenID) {
                    case WHITESPACE: 
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: 
                    case LINE_COMMENT: 
                    case ESCAPED_LINE: 
                    case ESCAPED_WHITESPACE: {
                        return true;
                    }
                }
            }
            return false;
        }

        public void start(int startOffset, int firstTokenOffset, int lastOffset) {
        }

        public void end(int offset, int lastTokenOffset) {
            if (this.fldInfo.startOffset != this.fldInfo.endOffset) {
                try {
                    this.fldInfo.origParamsText = this.doc.getText(this.fldInfo.startOffset, this.fldInfo.endOffset - this.fldInfo.startOffset);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private static class BlockConsumer {
            private final CppTokenId openBracket;
            private final CppTokenId closeBracket;
            private int depth;

            public BlockConsumer(CppTokenId openBracket, CppTokenId closeBracket) {
                this.openBracket = openBracket;
                this.closeBracket = closeBracket;
                this.depth = 0;
            }

            public boolean isLastToken(Token<TokenId> token) {
                boolean stop = false;
                if (token.id() == this.openBracket) {
                    ++this.depth;
                } else if (token.id() == this.closeBracket) {
                    --this.depth;
                    stop = this.depth <= 0;
                }
                return stop;
            }
        }

        static enum State {
            START,
            AFTER_FIELD_ACCESS,
            LVALUE,
            END;

        }
    }

    private static final class FieldAccessInfo {
        private int startOffset = -1;
        private int endOffset = -1;
        private CharSequence origParamsText = "";
        private List<CharSequence> paramText = new ArrayList<CharSequence>();

        private FieldAccessInfo() {
        }

        public CharSequence getOriginalParamsText() {
            return this.origParamsText;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public List<CharSequence> getParametersText() {
            return this.paramText;
        }

        private void addParam(String param) {
            this.paramText.add(param);
        }

        public void setStartOffsetIfNeeded(int startOffset) {
            if (this.startOffset < 0) {
                this.startOffset = startOffset;
                this.endOffset = startOffset;
            }
        }

        private boolean hasParam(int index) {
            return index < this.paramText.size();
        }

        private CharSequence getParameter(int index) {
            return this.paramText.get(index);
        }

        private boolean isValid() {
            return this.endOffset > this.startOffset;
        }

        private void setEndOffset(int offset) {
            this.endOffset = offset;
        }

        public String toString() {
            return this.origParamsText + "[" + this.startOffset + "-" + this.endOffset + "] params:" + this.paramText;
        }
    }
}

